import { DownloadInfo, YasrPlugin } from '../../../models/yasr-plugin';
import { Yasr } from "../../../models/yasgui/yasr";
export interface PluginConfig {
  width: string;
  height: string;
}
export interface ChartsPersistentConfig {
  chartState: any;
  chartOptions: any;
}
export declare class ChartsPlugin implements YasrPlugin {
  private config;
  private yasr;
  private translationService;
  private readonly currentLanguage;
  private chartEditor;
  private wrapper;
  private chartEditorOkHandler;
  protected persistentConfig: ChartsPersistentConfig;
  helpReference: string;
  static readonly PLUGIN_NAME = "charts";
  label: string;
  priority: number;
  static defaults: PluginConfig;
  constructor(yasr: Yasr);
  canHandleResults(): boolean;
  initialize(): Promise<void>;
  draw(_persistentConfig: any, _runtimeConfig?: any): Promise<void> | void;
  download(_filename?: string): DownloadInfo | undefined;
  private exportSvg;
  private exportCsv;
  getIcon(): Element | undefined;
  destroy(): void;
  private drawChart;
  private buildModel;
  private getContainerId;
  private createChartContainer;
  private redrawChart;
  private initEditor;
  private addChartConfigButton;
  private static getGoogleTypeForBinding;
  private getGoogleTypeForBindings;
  private static castGoogleType;
  private static uriToPrefixed;
  private static parseXmlSchemaDate;
}
export declare class TypesMappingError {
  msg: string;
  constructor(msg: string);
}
