import { EventEmitter } from "../stencil-public-runtime";
import { InternalEvent } from '../models/internal-events/internal-event';
import { InternalEventTypes } from '../models/internal-events/internal-event-types';
/**
 * The purpose of this service is to mitigate the issue where the stencil builtin Event decorator
 * doesn't work properly when injected in a service. The issue is similar to this
 * https://github.com/ionic-team/stencil/issues/2563 and even there are many mentions of the exactly
 * the same behavior we stumbled upon.
 *
 * This service is intended to be used in other services in order to help firing events which then
 * is expected to be caught by the stencil yasgui component.
 * The way we workaround the issue above to dispatch native DOM events instead of events through the
 * builtin EventEmitter in the stencil. This is kind of awkward approach, because we now have two
 * separate event systems in place.
 */
export declare class EventService implements EventEmitter {
  private _hostElement;
  /**
   * Emits an <code>internalEvent</code> wrapped in a native CustomEvent.
   *
   * @param internalEvent The event {@link InternalEvent}.
   */
  emit(internalEvent: InternalEvent): CustomEvent;
  emitEvent(element: HTMLElement, type: InternalEventTypes, payload?: any): CustomEvent;
  static emitFromInnerElement(element: HTMLElement, type: InternalEventTypes, payload?: any): CustomEvent;
  private static emitInternalEvent;
  private static toInnerEvent;
  get hostElement(): HTMLElement;
  set hostElement(value: HTMLElement);
}
