import { PivotTableRenderer } from '../../models/plugins/pivot-table/pivot-table-renderer';
import { TranslationService } from '../translation.service';
import { PivotTableAggregator } from '../../models/plugins/pivot-table/pivot-table-aggregator';
export declare class PivotTableService {
  static readonly RENDERER_NAME_PREFIX = "yasr.plugin_control.plugin.pivot-table-plugin.renderer.type_";
  static readonly AGGREGATOR_NAME_PREFIX = "yasr.plugin_control.plugin.pivot-table-plugin.aggregator.type_";
  private readonly translationService;
  private renderers;
  private aggregators;
  constructor(translationService: TranslationService);
  /**
   * Retrieves an instance of {@link PivotTableRenderer} based on the specified <code>type</code>.
   *
   * @param {string} type - renderer type, the value must be one of {@link PivotTableRendererType} values.
   * @returns {PivotTableRenderer} An instance of {@link PivotTableRenderer} corresponding to the specified type.
   */
  getPivotRendererByType(type: string): PivotTableRenderer;
  /**
   * Retrieves an instance of {@link PivotTableRenderer} based on the specified <code>name</code>.
   *
   * @param {string} name - The renderer name. The value is language-dependent.
   * @returns {PivotTableRenderer} An instance of {@link PivotTableRenderer} corresponding to the specified name.
   */
  getPivotRendererByName(name: string): PivotTableRenderer;
  /**
   * Fetches the name of a renderer with the specified <code>type</code>.
   *
   * @param {string} type - The renderer type. The value must be one of {@link PivotTableRendererType} values.
   * @param {string} language - The locale. For instance, "en", "fr", etc.
   * @return {string} The translated name of the renderer with the specified <code>type</code>.
   */
  getPivotTableRenderName(type: string, language?: string): string;
  getPivotTableRenderersCompareByNameFunction(): (name1: string, name2: string) => number;
  /**
   * Retrieves an instance of {@link PivotTableAggregator} based on the specified <code>type</code>.
   *
   * @param {string} type - aggregator type, the value must be one of {@link PivotTableAggregatorType} values.
   * @returns {PivotTableAggregator} An instance of {@link PivotTableAggregator} corresponding to the specified type.
   */
  getPivotTableAggregatorByType(type: string): PivotTableAggregator;
  /**
   * Retrieves an instance of {@link PivotTableAggregator} based on the specified <code>name</code>.
   *
   * @param {string} name - The aggregator name. The value is language-dependent.
   * @returns {PivotTableAggregator} An instance of {@link PivotTableAggregator} corresponding to the specified name.
   */
  getPivotTableAggregatorByName(name: string): PivotTableAggregator;
  /**
   * Fetches the name of an aggregator with the specified <code>type</code>.
   *
   * @param {string} type - The aggregator type. The value must be one of {@link PivotTableAggregatorType} values.
   * @param {string} language - The locale. For instance, "en", "fr", etc.
   * @return {string} The translated name of the aggregator with the specified <code>type</code>.
   */
  getPivotTableAggregatorName(type: string, language?: string): string;
  getPivotTableAggregatorsCompareByNameFunction(): (name1: string, name2: string) => number;
  /**
   * Initializes renderers. A renderer is an object that contains a mapping between a name and a type. The type is hardcoded and is
   * described in the {@link PivotTableRendererType}. The name depends on the language. During initialization, the names are translated
   * via the {@link TranslationService}.
   */
  private initRenderers;
  /**
   * Initializes aggregators. An aggregator is an object that contains a mapping between a name and a type. The type is hardcoded and is
   * described in the {@link PivotTableAggregatorType} enum. The name depends on the language. During initialization, the names are translated
   * via the {@link TranslationService}.
   */
  private initAggregators;
}
