import { EventService } from './event-service';
/**
 * The purpose of this @{see ServiceFactory} is to manage all other services used into the "ontotext-yasgui-web-component" components.
 * It takes care for:
 * <ul>
 *   <li>building of service</li>
 *   <li>every service to have only one instance (Singleton)</li>
 */
export declare class ServiceFactory {
  private readonly hostElement;
  constructor(hostElement: HTMLElement);
  private instances;
  get<T>(type: {
    new (serviceFactory: ServiceFactory): T;
  }): T;
  getEventService(): EventService;
}
