export declare class TooltipService {
  /**
   * Wrap <code>element</code> with {@see OntotextTooltipWebComponent} and sets tooltip attributes <code>tooltip</code>, <code>placement</code> and <code>showOnclick</code>.
   * If element has a parent it will be detached of it and created tooltip wrapper element will be attached to the element parent.
   * @param element - the element that will be wrapped with {@see OntotextTooltipWebComponent}.
   * @param tooltip - the tooltip.
   * @param placement - placement of tooltip.
   * @param showOnclick - if tooltip have to be shown on click event.
   */
  static addTooltip(element: HTMLElement, tooltip?: string, placement?: string, showOnclick?: boolean): HTMLElement;
  static updateTooltip(element: HTMLElement, tooltip?: string, placement?: string): void;
  private static updateTooltipData;
  private static updatePlacement;
}
