import { RenderingMode } from "../../models/yasgui-configuration";
export declare class HtmlElementsUtil {
  /**
   * Fetches the yasgui html element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getOntotextYasgui(hostElement: HTMLElement): HTMLElement;
  static getRenderModeButton(hostElement: HTMLElement, mode: RenderingMode): HTMLElement;
  /**
   * Fetches the orientation button.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getOrientationButton(hostElement: HTMLElement): HTMLElement;
  /**
   * Fetches the toolbar element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getToolbar(hostElement: HTMLElement): HTMLElement;
  /**
   * Fetches the toolbar element.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   */
  static getControlBar(hostElement: HTMLElement): HTMLElement;
  static toggleHiddenByCondition(hostElement: HTMLElement, elementSelectors: string[], haveToExist: () => boolean): void;
  static toggleClassByCondition(hostElement: HTMLElement, elementSelectors: string[], className: string, haveToExist: () => boolean): void;
  static createAutocompleteHintElement(text: string): HTMLElement;
}
