export declare class HtmlUtil {
  static escapeHTMLEntities(text: string): string;
  static decodeHTMLEntities(text: string): string;
  static loadJavaScript(url: string, onLoadHandler?: () => void | undefined, async?: boolean): void;
  static loadCss(url: string): void;
  static downloadStringAsFile(content: any, filename: any, contentType: any): void;
  /**
   * Setter for the document body overflow property.
   *
   * @param newOverflow - the new overflow value.
   *
   * @return the old overflow value.
   */
  static setDocumentBodyOverflow(newOverflow: string): string;
  /**
   * Hides the document body overflow.
   *
   * @return the value of overflow before set it to hidden.
   */
  static hideDocumentBodyOverflow(): string;
  /**
   * Focuses the next element within a specified parent element based on the <code>activeElementSelector</code>, that selects all elements to be focused.
   *
   * @param parentElement - The parent element containing the focusable elements.
   * @param activeElementSelector - The CSS selector for identifying focusable elements.
   */
  static focusNextElement(parentElement: HTMLElement, activeElementSelector?: string): void;
  /**
   * Focuses the previous element within a specified parent element based on the <code>activeElementSelector</code>, that selects all elements to be focused.
   *
   * @param parentElement - The parent element containing the focusable elements.
   * @param activeElementSelector - The CSS selector for identifying focusable elements.
   */
  static focusPreviousElement(parentElement: HTMLElement, activeElementSelector?: string): void;
  static preventLeavingDialog(hostElement: HTMLElement, ev: KeyboardEvent): void;
}
