import { ServiceFactory } from '../service-factory';
import { TranslationService } from '../translation.service';
export declare class TimeFormattingService {
  static readonly ONE_MINUTE_iN_SECONDS = 60;
  static readonly TEN_MINUTES_IN_SECONDS = 600;
  static readonly ONE_HOUR_IN_MILLISECONDS = 3600000;
  static readonly ONE_DAY_IN_SECONDS = 86400;
  static readonly ONE_SECOND_IN_MILLISECONDS = 1000;
  static readonly ONE_DAY_IN_MILLISECONDS = 86400000;
  static readonly ONE_MINUTE_IN_MILLISECONDS = 60000;
  translationService: TranslationService;
  constructor(serviceFactory: ServiceFactory);
  getHumanReadableSeconds(millisecondsAgo: number, preciseSeconds?: boolean): string;
  getHumanReadableTimestamp(time: number): string;
  private toHumanReadableSeconds;
  /**
   * Normalizes passed <code>secondsAgo</code>. Seconds can be passed with fraction.
   * If <code>preciseSeconds</code> is true and <code>secondsAgo</code> < 10 will use fractional seconds rounded to one decimal place,
   * elsewhere it will be rounded up to an integer.
   * @param secondsAgo - the seconds to be normalized.
   * @param preciseSeconds - if true and sec
   */
  private normalizeSeconds;
  private toTimeParameters;
  private normalize;
}
