import { Orientation, RenderingMode } from '../../models/yasgui-configuration';
export declare class VisualisationUtils {
  /**
   * Calculates the maximum height which the yasqe could have given the resolution and accounting the
   * space taken by some interface components around it. The calculated height is then set as a css
   * style property only if the rendering mode is yasqe or orientation is horizontal. In both cases
   * yasqe needs to span the entire possible height. If the mode and orientation is different by
   * these described above, then the height css is removed to allow the yasqe size itself based on
   * the minimum configured height allowing the yasr to go below.
   *
   * Both operations described above are executed in a timeout in order to ensure that the yasqe is
   * actually rendered before trying out to find it.
   * @param mode
   * @param orientation
   * @param editorHeight if the mode is YASGUI, this height will be set for the yasqe.
   */
  static setYasqeFullHeight(mode: RenderingMode, orientation: Orientation, editorHeight: number): void;
  /**
   * Changes the rendering mode of the yasgui component.
   * @param hostElement
   * @param newMode
   * @param isVerticalOrientation
   * @param editorHeight
   */
  static changeRenderMode(hostElement: HTMLElement, newMode: RenderingMode, isVerticalOrientation: boolean, editorHeight?: number): void;
  static toggleLayoutOrientationButton(hostElement: HTMLElement, newOrientation: Orientation): void;
  static toggleLayoutOrientation(hostElement: HTMLElement, isVerticalOrientation: boolean, mode: RenderingMode, editorHeight?: number): void;
  static resolveOrientation(isVerticalOrientation: boolean): Orientation;
  /**
   * Removes selection class from all buttons.
   * @param hostElement - the host element of "ontotext-yasgui-web-component".
   * @private
   */
  private static unselectAllToolbarButtons;
}
