import { YasguiConfiguration } from '../../models/yasgui-configuration';
import { OntotextYasgui } from '../../models/ontotext-yasgui';
/**
 * A builder for Yasgui and its wrapper OntotextYasgui instance. It creates an instance of yasgui
 * and applies patches to created instance. Then the instance is wrapped in a OntotextYasgui adapter
 * instance.
 */
export declare class YasguiBuilder {
  private instance;
  /**
   * Builds an instance of Yasgui and wraps it in an OntotextYasgui adapter instance.
   *
   * @param hostElement - parent element of yasgui instance.
   * @param yasguiConfiguration - the yasgui configuration merged with the external one.
   */
  build(hostElement: HTMLElement, yasguiConfiguration: YasguiConfiguration): OntotextYasgui;
  /**
   * Returns the OntotextYasgui instance if created or undefined otherwise.
   */
  getInstance(): OntotextYasgui | undefined;
  private createYasguiInstance;
}
