import { ExternalYasguiConfiguration } from '../../models/external-yasgui-configuration';
import { YasrPlugin } from '../../models/yasr-plugin';
export declare class YasrService {
  static readonly SHACL_GRAPH_URL = "http:%2F%2Frdf4j.org%2Fschema%2Frdf4j%23SHACLShapeGraph";
  static readonly SHACL_GRAPH_URL_CONTEXT_PARAMETER: '&context=http%3A%2F%2Frdf4j.org%2Fschema%2Frdf4j%23SHACLShapeGraph"';
  static readonly XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema#";
  static readonly XML_SCHEMA_NS_STRING: string;
  /**
   * Escaped <<
   */
  static readonly ESCAPED_HTML_DOUBLE_LOWER = "&lt;&lt;";
  /**
   * Escaped >>
   *
   */
  static readonly ESCAPED_HTML_DOUBLE_GREATER = "&gt;&gt";
  static registerPlugin(name: string, plugin: YasrPlugin, enable?: boolean): void;
  static getPluginsConfigurations(externalConfiguration: ExternalYasguiConfiguration): Map<string, any>;
  private static addTableConfiguration;
  private static addExtendedTableConfiguration;
  private static getCellContent;
  private static toCellContent;
  private static getUriCellContent;
  private static getHref;
  private static getTripleCellContent;
  private static replaceSingleQuote;
  private static getValueAsString;
  private static getLiteralCellContent;
  private static getLiteralAsString;
  private static isExplainResponse;
  private static getExplainPlanQueryResponse;
  private static addWorldBreakTagAfterSpecialCharacters;
  private static addWorldBreakTagBeforeSpecialCharacters;
  private static addWordBreakToIRIs;
  private static addWordBreakToLiterals;
  private static getLang;
}
