"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ajvErrorsToValidatorError = exports.augmentAjvErrors = exports.ContentType = void 0;
class ContentType {
    constructor(contentType) {
        var _a;
        this.contentType = null;
        this.mediaType = null;
        this.charSet = null;
        this.withoutBoundary = null;
        this.contentType = contentType;
        if (contentType) {
            this.withoutBoundary = contentType.replace(/;\s{0,}boundary.*/, '').toLowerCase();
            this.mediaType = this.withoutBoundary.split(';')[0].toLowerCase().trim();
            this.charSet = (_a = this.withoutBoundary.split(';')[1]) === null || _a === void 0 ? void 0 : _a.toLowerCase();
            this.isWildCard = RegExp(/^[a-z]+\/\*$/).test(this.contentType);
            if (this.charSet) {
                this.charSet = this.charSet.toLowerCase().trim();
            }
        }
    }
    static fromString(contentType) {
        return new ContentType(contentType);
    }
    static from(req) {
        var _a;
        return new ContentType((_a = req.headers) === null || _a === void 0 ? void 0 : _a['content-type']);
    }
    equivalents() {
        if (!this.withoutBoundary) {
            return [];
        }
        if (this.charSet) {
            return [this.mediaType, `${this.mediaType}; ${this.charSet}`];
        }
        return [this.withoutBoundary, `${this.mediaType}; charset=utf-8`];
    }
}
exports.ContentType = ContentType;
/**
 * (side-effecting) modifies the errors object
 * TODO - do this some other way
 * @param errors
 */
function augmentAjvErrors(errors = []) {
    errors.forEach(e => {
        if (e.keyword === 'enum') {
            const params = e.params;
            const allowedEnumValues = params === null || params === void 0 ? void 0 : params.allowedValues;
            e.message = allowedEnumValues
                ? `${e.message}: ${allowedEnumValues.join(', ')}`
                : e.message;
        }
    });
    return errors;
}
exports.augmentAjvErrors = augmentAjvErrors;
function ajvErrorsToValidatorError(errors) {
    return errors.map(e => {
        var _a, _b, _c;
        const params = e.params;
        const required = (params === null || params === void 0 ? void 0 : params.missingProperty) && `${e.instancePath}.${params.missingProperty}`;
        const additionalProperty = (params === null || params === void 0 ? void 0 : params.additionalProperty) && `${e.instancePath}.${params.additionalProperty}`;
        const path = (_b = (_a = required !== null && required !== void 0 ? required : additionalProperty) !== null && _a !== void 0 ? _a : e.instancePath) !== null && _b !== void 0 ? _b : e.schemaPath;
        const originalPath = (_c = e.instancePath) !== null && _c !== void 0 ? _c : e.schemaPath;
        let fullMessage = `request${path} ${e.message}`;
        if (additionalProperty) {
            fullMessage = `request${originalPath} must NOT have additional property: '${params.additionalProperty}'`;
        }
        else if (required) {
            fullMessage = `missing required property request${path}`;
        }
        return {
            path,
            message: e.message,
            fullMessage
        };
    });
}
exports.ajvErrorsToValidatorError = ajvErrorsToValidatorError;
