"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AjvOptions = void 0;
class AjvOptions {
    constructor(options) {
        this.options = options;
    }
    get preprocessor() {
        return this.baseOptions();
    }
    get request() {
        const { allowUnknownQueryParameters, removeAdditional } = this.options.validateRequests;
        return {
            ...this.baseOptions(),
            allowUnknownQueryParameters,
            removeAdditional
        };
    }
    baseOptions() {
        const { serDes } = this.options;
        const serDesMap = {};
        for (const serDesObject of serDes) {
            if (!serDesMap[serDesObject.format]) {
                serDesMap[serDesObject.format] = serDesObject;
            }
            else {
                if (serDesObject.serialize) {
                    serDesMap[serDesObject.format].serialize = serDesObject.serialize;
                }
                if (serDesObject.deserialize) {
                    serDesMap[serDesObject.format].deserialize = serDesObject.deserialize;
                }
            }
        }
        return {
            validateSchema: false,
            useDefaults: true,
            removeAdditional: false,
            validateFormats: false,
            serDesMap: serDesMap
        };
    }
}
exports.AjvOptions = AjvOptions;
