"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BodySchemaParser = void 0;
class BodySchemaParser {
    parse(path, pathSchema, contentType) {
        // The schema.preprocessor will have dereferenced the RequestBodyObject
        // thus we can assume a RequestBodyObject, not a ReferenceObject
        const requestBody = pathSchema.requestBody;
        if (Object.hasOwnProperty.call(requestBody || {}, 'content')) {
            return this.toSchema(path, contentType, requestBody);
        }
        return {};
    }
    toSchema(path, contentType, requestBody) {
        var _a, _b;
        if (!(requestBody === null || requestBody === void 0 ? void 0 : requestBody.content)) {
            return {};
        }
        let content = null;
        for (const type of contentType.equivalents()) {
            content = requestBody.content[type];
            if (content) {
                return (_a = content.schema) !== null && _a !== void 0 ? _a : {};
            }
        }
        for (const requestContentType of Object.keys(requestBody.content).sort().reverse()) {
            if (requestContentType === '*/*') {
                content = requestBody.content[requestContentType];
                break;
            }
            // not a wildcard of type application/*
            if (!new RegExp(/^[a-z]+\/\*$/).test(requestContentType)) {
                continue;
            }
            const [type] = requestContentType.split('/', 1);
            if (new RegExp(`^${type}/.+$`).test(contentType.contentType)) {
                content = requestBody.content[requestContentType];
                break;
            }
        }
        if (!content) {
            content = Object.values(requestBody.content)[0];
        }
        return (_b = content === null || content === void 0 ? void 0 : content.schema) !== null && _b !== void 0 ? _b : {};
    }
}
exports.BodySchemaParser = BodySchemaParser;
