import { ErrorObject } from 'ajv';
import { OpenApiRequest, ValidationErrorItem } from '../framework/types';
export declare class ContentType {
    readonly contentType: string;
    readonly mediaType: string;
    readonly charSet: string;
    readonly withoutBoundary: string;
    readonly isWildCard: boolean;
    private constructor();
    static fromString(contentType: string): ContentType;
    static from(req: OpenApiRequest): ContentType;
    equivalents(): string[];
}
/**
 * (side-effecting) modifies the errors object
 * TODO - do this some other way
 * @param errors
 */
export declare function augmentAjvErrors(errors?: ErrorObject[]): ErrorObject[];
export declare function ajvErrorsToValidatorError(errors: ErrorObject[]): ValidationErrorItem[];
