"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRequestAjv = void 0;
const ajv_1 = require("ajv");
const ajv_formats_1 = require("ajv-formats");
function createRequestAjv(openApiSpec, options = {}) {
    var _a;
    const ajv = new ajv_1.default({
        strictTypes: false,
        discriminator: true,
        allErrors: true,
        jsPropertySyntax: true,
        coerceTypes: 'array',
        ...options,
        logger: {
            log(...args) { console.log(...args); },
            warn(...args) {
                var _a;
                if (!((_a = args[0]) === null || _a === void 0 ? void 0 : _a.match('jsPropertySyntax'))) {
                    console.warn(...args);
                }
            },
            error(...args) { console.error(...args); }
        }
    });
    (0, ajv_formats_1.default)(ajv);
    ajv.removeKeyword('propertyNames');
    ajv.removeKeyword('contains');
    ajv.removeKeyword('const');
    ajv.addKeyword({ keyword: 'paths' });
    ajv.addKeyword({ keyword: 'components' });
    ajv.addKeyword({ keyword: 'example' });
    if ((_a = openApiSpec.components) === null || _a === void 0 ? void 0 : _a.schemas) {
        Object.entries(openApiSpec.components.schemas).forEach(([id, schema]) => {
            ajv.addSchema(schema, `#/components/schemas/${id}`);
        });
    }
    return ajv;
}
exports.createRequestAjv = createRequestAjv;
