"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BadRequest = exports.SerDesSingleton = void 0;
class SerDesSingleton {
    constructor(param) {
        this.format = param.format;
        this.serialize = param.serialize;
        this.deserialize = param.deserialize;
        this.deserializer = {
            format: param.format,
            deserialize: param.deserialize
        };
        this.serializer = {
            format: param.format,
            serialize: param.serialize
        };
    }
}
exports.SerDesSingleton = SerDesSingleton;
class BadRequest extends Error {
    constructor(err) {
        super('Bad Request');
        this.status = 400;
        this.name = 'Bad Request';
        this.path = err.path;
        this.message = err.message;
        this.errors = err.errors;
    }
}
exports.BadRequest = BadRequest;
