import { html } from 'lit';
import { unsafeHTML } from 'lit/directives/unsafe-html.js';
import Prism from 'prismjs';
import { copyToClipboard } from '../utils/common-utils';
import { getI18nText } from '../languages';
/* eslint-disable indent */

export default function codeSamplesTemplate(xCodeSamples) {
  return html` <section class="table-title top-gap"> CODE SAMPLES  <div class="tab-panel col" @click="${e => {
    if (!e.target.classList.contains('tab-btn')) {
      return;
    }

    const clickedTab = e.target.dataset.tab;
    const tabButtons = [...e.currentTarget.querySelectorAll('.tab-btn')];
    const tabContents = [...e.currentTarget.querySelectorAll('.tab-content')];
    tabButtons.forEach(tabBtnEl => tabBtnEl.classList[tabBtnEl.dataset.tab === clickedTab ? 'add' : 'remove']('active'));
    tabContents.forEach(tabBodyEl => {
      tabBodyEl.style.display = tabBodyEl.dataset.tab === clickedTab ? 'block' : 'none';
    });
  }}"> <div class="tab-buttons row" style="width:100"> ${xCodeSamples.map((v, i) => html`<button class="tab-btn ${i === 0 ? 'active' : ''}" data-tab="${v.lang}${i}"> ${v.label || v.lang} </button>`)} </div> ${xCodeSamples.map((v, i) => {
    var _v$lang, _v$lang2, _v$lang3;

    const paddingToRemove = Math.min(...v.source.split('\n').slice(1).map(l => {
      var _l$match;

      return (_l$match = l.match(/^(\s+).*$/)) === null || _l$match === void 0 ? void 0 : _l$match[1].length;
    }).filter(l => typeof l !== 'undefined'));
    const sanitizedSource = v.source.split('\n').map(s => s.substring(0, paddingToRemove).match(/^\s+$/) ? s.substring(paddingToRemove) : s);
    const fullSource = sanitizedSource.join('\n');
    return html` <div class="tab-content m-markdown code-sample-wrapper" style="display:${i === 0 ? 'block' : 'none'}" data-tab="${v.lang}${i}"> <button class="m-btn outline-primary toolbar-copy-btn" @click="${e => {
      copyToClipboard(v.source, e);
    }}">${getI18nText('operations.copy')}</button> <pre><code>${Prism.languages[(_v$lang = v.lang) === null || _v$lang === void 0 ? void 0 : _v$lang.toLowerCase()] ? unsafeHTML(Prism.highlight(fullSource, Prism.languages[(_v$lang2 = v.lang) === null || _v$lang2 === void 0 ? void 0 : _v$lang2.toLowerCase()], (_v$lang3 = v.lang) === null || _v$lang3 === void 0 ? void 0 : _v$lang3.toLowerCase())) : fullSource}
          </code></pre> </div>`;
  })} </div></section>`;
}
/* eslint-enable indent */