"use strict";

exports.__esModule = true;
exports.default = endpointTemplate;
exports.expandCollapseAll = expandCollapseAll;

var _lit = require("lit");

var _unsafeHtml = require("lit/directives/unsafe-html.js");

var _marked = require("marked");

require("../components/api-request");

require("../components/api-response");

var _codeSamplesTemplate = _interopRequireDefault(require("./code-samples-template"));

var _callbackTemplate = _interopRequireDefault(require("./callback-template"));

var _securitySchemeTemplate = require("./security-scheme-template");

var _commonUtils = require("../utils/common-utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function toggleExpand(path) {
  if (path.expanded) {
    path.expanded = false; // collapse

    (0, _commonUtils.replaceState)(null);
  } else {
    path.expanded = true; // Expand

    if (path.elementId !== (0, _commonUtils.getCurrentElement)()) {
      (0, _commonUtils.replaceState)(path.elementId);
    }
  }

  this.requestUpdate();
}

function toggleTag(tagElement, tagId) {
  const sectionTag = tagElement.target.closest('.section-tag');
  const tag = this.resolvedSpec.tags.find(t => t.elementId === tagId);
  tag.expanded = !tag.expanded;

  if (tag.expanded) {
    sectionTag.classList.remove('collapsed');
    sectionTag.classList.add('expanded');
  } else {
    sectionTag.classList.remove('expanded');
    sectionTag.classList.add('collapsed');
  }

  this.requestUpdate();
}

function expandCollapseAll(currentElement, action = 'expand-all') {
  const operationsRootEl = currentElement.target.closest('.operations-root');
  const elList = [...operationsRootEl.querySelectorAll('.section-tag')];
  const expand = action === 'expand-all';
  this.resolvedSpec.tags.forEach(t => t.expanded = expand);
  elList.map(el => {
    if (expand) {
      el.classList.remove('collapsed');
      el.classList.add('expanded');
    } else {
      el.classList.remove('expanded');
      el.classList.add('collapsed');
    }
  });
}
/* eslint-disable indent */


function endpointHeadTemplate(path) {
  return (0, _lit.html)` <summary @click="${e => {
    toggleExpand.call(this, path, e);
  }}" class="endpoint-head ${path.method} ${path.expanded ? 'expanded' : 'collapsed'}"> <div class="method ${path.method}"> ${path.method} </div> <div class="path"> ${path.path} ${path.isWebhook ? (0, _lit.html)`<span style="color:var(--primary-color)"> (Webhook) </span>` : ''} </div> ${path.deprecated ? (0, _lit.html)` <span style="font-size:var(--font-size-small);text-transform:uppercase;font-weight:700;color:var(--red);margin:2px 0 0 5px"> deprecated </span>` : ''} <div class="only-large-screen" style="min-width:60px;flex:1"></div> <div class="descr">${path.summary || path.shortSummary} </div> </summary> `;
}

function endpointBodyTemplate(path) {
  var _path$servers, _path$servers$, _this$selectedServer;

  const acceptContentTypes = new Set();

  for (const respStatus in path.responses) {
    for (const acceptContentType in path.responses[respStatus] && path.responses[respStatus].content) {
      acceptContentTypes.add(acceptContentType.trim());
    }
  }

  const accept = [...acceptContentTypes].join(', '); // Filter API Keys that are non-empty and are applicable to the the path

  const nonEmptyApiKeys = this.resolvedSpec.securitySchemes.filter(v => v.finalKeyValue && path.security && path.security.some(ps => ps[v.apiKeyId])) || [];
  const codeSampleTabPanel = path.xCodeSamples ? (0, _codeSamplesTemplate.default)(path.xCodeSamples) : '';
  return (0, _lit.html)` <div class="endpoint-body ${path.method}"> <div class="summary"> ${path.summary ? (0, _lit.html)`<div class="title">${path.summary}<div></div></div>` : path.shortSummary !== path.description ? (0, _lit.html)`<div class="title">${path.shortSummary}</div>` : ''} ${path.description ? (0, _lit.html)`<div class="m-markdown"> ${(0, _unsafeHtml.unsafeHTML)((0, _marked.marked)(path.description))}</div>` : ''} <slot name="${path.elementId}"></slot> ${_securitySchemeTemplate.pathSecurityTemplate.call(this, path.security)} ${codeSampleTabPanel} </div> <div class="req-resp-container"> <div style="display:flex;flex-direction:column" class="request"> <api-request class="request-panel" style="width:100%" method="${path.method}" , path="${path.path}" element-id="${path.elementId}" .parameters="${path.parameters}" .request_body="${path.requestBody}" .api_keys="${nonEmptyApiKeys}" .servers="${path.servers}" server-url="${((_path$servers = path.servers) === null || _path$servers === void 0 ? void 0 : (_path$servers$ = _path$servers[0]) === null || _path$servers$ === void 0 ? void 0 : _path$servers$.url) || ((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl)}" active-schema-tab="${this.defaultSchemaTab}" fill-defaults="${this.fillRequestWithDefault}" display-nulls="${!!this.includeNulls}" enable-console="${this.allowTry}" accept="${accept}" render-style="${this.renderStyle}" schema-style="${this.displaySchemaAsTable ? 'table' : 'tree'}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-read-only="${this.schemaHideReadOnly}" fetch-credentials="${this.fetchCredentials}" exportparts="btn btn-fill btn-outline btn-try"> </api-request> </div> ${path.callbacks ? _callbackTemplate.default.call(this, path.callbacks) : ''} <api-response class="request response" .responses="${path.responses}" display-nulls="${!!this.includeNulls}" active-schema-tab="${this.defaultSchemaTab}" render-style="${this.renderStyle}" schema-style="${this.displaySchemaAsTable ? 'table' : 'tree'}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-write-only="${this.schemaHideWriteOnly}" selected-status="${Object.keys(path.responses || {})[0] || ''}" exportparts="btn--resp btn-fill--resp btn-outline--resp"> </api-response> </div> </div>`;
}

function endpointTemplate() {
  return (0, _lit.html)` <div style="display:flex;justify-content:flex-end;padding-right:1rem;font-size:14px;margin-top:16px"> <span @click="${e => expandCollapseAll.call(this, e, 'expand-all')}" style="color:var(--primary-color);cursor:pointer">Expand</span> &nbsp;|&nbsp; <span @click="${e => expandCollapseAll.call(this, e, 'collapse-all')}" style="color:var(--primary-color);cursor:pointer">Collapse</span> </div> ${(this.resolvedSpec && this.resolvedSpec.tags || []).map(tag => (0, _lit.html)` <div class="regular-font method-section-gap section-tag ${tag.expanded ? 'expanded' : 'collapsed'}"> <div class="section-tag-header" @click="${e => toggleTag.call(this, e, tag.elementId)}"> <div id="${tag.elementId}" class="sub-title tag" style="color:var(--primary-color)">${tag.name}</div> </div> <div class="section-tag-body"> <slot name="${tag.elementId}"></slot> ${tag.description ? (0, _lit.html)` <div class="regular-font regular-font-size m-markdown description" style="padding-bottom:12px"> ${(0, _unsafeHtml.unsafeHTML)((0, _marked.marked)(tag.description || ''))} </div>` : ''} ${tag.paths.filter(v => (0, _commonUtils.pathIsInSearch)(this.matchPaths, v)).map(path => (0, _lit.html)` <section id="${path.elementId}" class="m-endpoint regular-font ${path.method} ${path.expanded ? 'expanded' : 'collapsed'}"> ${endpointHeadTemplate.call(this, path)} ${path.expanded ? endpointBodyTemplate.call(this, path) : ''} </section>`)} </div> </div> `)}`;
}
/* eslint-enable indent */