"use strict";

exports.__esModule = true;
exports.default = componentsTemplate;

var _schemaUtils = require("../utils/schema-utils");

var _lit = require("lit");

var _unsafeHtml = require("lit/directives/unsafe-html.js");

var _marked = require("marked");

require("../components/json-tree");

require("../components/schema-tree");

/* eslint-disable no-console */
function componentBodyTemplate(sComponent) {
  const formdataPartSchema = (0, _schemaUtils.schemaInObjectNotation)(sComponent.component, {
    includeNulls: this.includeNulls
  });
  return (0, _lit.html)` <div class="expanded-endpoint-body observe-me ${sComponent.name}" id="cmp--${sComponent.id}"> <h2>${sComponent.name}</h2> <div class="mono-font regular-font-size" style="padding:8px 0;color:var(--fg2)"> ${this.displaySchemaAsTable ? (0, _lit.html)`<schema-table .data="${formdataPartSchema}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-read-only="false" schema-hide-write-only="false"> </schema-table>` : (0, _lit.html)`<schema-tree .data="${formdataPartSchema}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-read-only="false" schema-hide-write-only="false"> </schema-tree>`} </div> </div> `;
}

function componentsTemplate() {
  return (0, _lit.html)` ${this.resolvedSpec.components.map(component => (0, _lit.html)` <div id="cmp--${component.name.toLowerCase()}" class="regular-font section-gap--focused-mode observe-me" style="padding-bottom:0"> <div class="title tag">${component.name}</div> <div class="regular-font-size"> ${(0, _unsafeHtml.unsafeHTML)(`<div class='m-markdown regular-font'>${(0, _marked.marked)(component.description ? component.description : '')}</div>`)} </div> </div> <div class="regular-font section-gap--focused-mode" style="padding-top:0"> ${component.subComponents.filter(c => c.expanded).map(sComponent => componentBodyTemplate.call(this, sComponent))} </div> `)} `;
}
/* eslint-enable indent */