"use strict";

exports.__esModule = true;
exports.default = focusedEndpointTemplate;

var _lit = require("lit");

var _expandedEndpointTemplate = require("./expanded-endpoint-template");

require("../components/api-request");

require("../components/api-response");

var _componentsTemplate = _interopRequireDefault(require("./components-template"));

var _overviewTemplate = _interopRequireDefault(require("./overview-template"));

var _serverTemplate = _interopRequireDefault(require("./server-template"));

var _securitySchemeTemplate = _interopRequireDefault(require("./security-scheme-template"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function wrapFocusedTemplate(templateToWrap) {
  return (0, _lit.html)` <div class="regular-font section-gap--focused-mode" part="section-operations-in-tag"> ${templateToWrap} </div>`;
}

function defaultContentTemplate() {
  // In focused mode default content is overview or first path
  if (this.showInfo === 'true') {
    return _overviewTemplate.default.call(this);
  }

  const selectedTagObj = this.resolvedSpec.tags[0];
  const selectedPathObj = selectedTagObj === null || selectedTagObj === void 0 ? void 0 : selectedTagObj.paths[0];
  return selectedPathObj ? wrapFocusedTemplate(_expandedEndpointTemplate.expandedEndpointBodyTemplate.call(this, selectedPathObj, selectedTagObj.name)) : wrapFocusedTemplate('');
}

function focusedEndpointTemplate() {
  if (!this.explorerLocation || !this.resolvedSpec) {
    return undefined;
  }

  const focusElId = this.explorerLocation;
  let selectedPathObj = null;
  let selectedTagObj = null;
  let focusedTemplate;
  let i = 0;

  if (focusElId.startsWith('overview') && this.showInfo === 'true') {
    focusedTemplate = _overviewTemplate.default.call(this);
  } else if (focusElId === 'auth' && this.allowAuthentication === 'true') {
    focusedTemplate = _securitySchemeTemplate.default.call(this);
  } else if (focusElId === 'servers' && this.allowServerSelection === 'true') {
    focusedTemplate = _serverTemplate.default.call(this);
  } else if (focusElId.startsWith('section')) {
    focusedTemplate = (0, _lit.html)` <section id="section" class="observe-me"> <slot name="custom-section"></slot> </section>`;
  } else if (focusElId.startsWith('cmp--') && !this.hideComponents) {
    focusedTemplate = _componentsTemplate.default.call(this);
  } else if (focusElId.startsWith('tag--')) {
    const idToFocus = focusElId.indexOf('--', 4) > 0 ? focusElId.substring(0, focusElId.indexOf('--', 5)) : focusElId;
    selectedTagObj = this.resolvedSpec.tags.find(v => v.elementId === idToFocus);

    if (selectedTagObj) {
      focusedTemplate = _expandedEndpointTemplate.expandedTagTemplate.call(this, idToFocus, focusElId);
    } else {
      focusedTemplate = defaultContentTemplate.call(this);
    }
  } else {
    for (i = 0; i < this.resolvedSpec.tags.length; i += 1) {
      selectedTagObj = this.resolvedSpec.tags[i];
      selectedPathObj = this.resolvedSpec.tags[i].paths.find(v => `${v.elementId}` === focusElId);

      if (selectedPathObj) {
        break;
      }
    }

    if (selectedPathObj) {
      focusedTemplate = wrapFocusedTemplate.call(this, _expandedEndpointTemplate.expandedEndpointBodyTemplate.call(this, selectedPathObj, selectedTagObj.name));
    } else {
      // if explorerLocation is not found then show the default content (overview or first-path)
      focusedTemplate = defaultContentTemplate.call(this);
    }
  }

  return focusedTemplate;
}
/* eslint-enable indent */