"use strict";

exports.__esModule = true;
exports.default = mainBodyTemplate;

var _lit = require("lit");

var _focusedEndpointTemplate = _interopRequireDefault(require("./focused-endpoint-template"));

var _overviewTemplate = _interopRequireDefault(require("./overview-template"));

var _endpointTemplate = _interopRequireDefault(require("./endpoint-template"));

var _serverTemplate = _interopRequireDefault(require("./server-template"));

var _securitySchemeTemplate = _interopRequireDefault(require("./security-scheme-template"));

var _navbarTemplate = _interopRequireDefault(require("./navbar-template"));

var _advanceSearchTemplate = _interopRequireDefault(require("./advance-search-template"));

var _theme = _interopRequireDefault(require("../utils/theme"));

var _colorUtils = _interopRequireDefault(require("../utils/color-utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Templates
function mainBodyTemplate() {
  const newTheme = {
    bg1: _colorUtils.default.isValidHexColor(this.bgColor) ? this.bgColor : '',
    bg2: _colorUtils.default.isValidHexColor(this.bgHeaderColor) ? this.bgHeaderColor : '',
    fg1: _colorUtils.default.isValidHexColor(this.textColor) ? this.textColor : '',
    primaryColor: _colorUtils.default.isValidHexColor(this.primaryColor) ? this.primaryColor : '#3E6077',
    secondaryColor: _colorUtils.default.isValidHexColor(this.secondaryColor) ? this.secondaryColor : '#FBAF0B',
    headerColor: _colorUtils.default.isValidHexColor(this.headerColor) ? this.headerColor : '',
    navBgColor: _colorUtils.default.isValidHexColor(this.navBgColor) ? this.navBgColor : '',
    navTextColor: _colorUtils.default.isValidHexColor(this.navTextColor) ? this.navTextColor : '',
    navHoverBgColor: _colorUtils.default.isValidHexColor(this.navHoverBgColor) ? this.navHoverBgColor : '',
    navHoverTextColor: _colorUtils.default.isValidHexColor(this.navHoverTextColor) ? this.navHoverTextColor : ''
  };
  /* eslint-disable indent */

  return (0, _lit.html)` ${_theme.default.call(this, newTheme)} ${this.allowAdvancedSearch === 'false' ? '' : _advanceSearchTemplate.default.call(this)} <div id="the-main-body" class="body"> ${this.renderStyle === 'focused' && this.resolvedSpec ? _navbarTemplate.default.call(this) : ''} ${this.loading === true ? (0, _lit.html)`<slot name="loader"><div class="loader"></div></slot>` : (0, _lit.html)` <main class="main-content regular-font" part="section-main-content"> <slot></slot> <div id="operations-root" class="main-content-inner"> ${this.loadFailed === true ? (0, _lit.html)`<div style="text-align:center;margin:16px">Unable to load the Spec${this.specUrl ? ': ' : ''}<strong>${this.specUrl}</strong></div>` : (0, _lit.html)` <div class="operations-root" @click="${e => {
    this.handleHref(e);
  }}"> ${this.renderStyle === 'focused' ? (0, _lit.html)`${_focusedEndpointTemplate.default.call(this)}` : (0, _lit.html)` ${this.showInfo === 'true' ? _overviewTemplate.default.call(this) : ''} ${this.allowServerSelection === 'true' ? _serverTemplate.default.call(this) : ''} ${this.allowAuthentication === 'true' ? _securitySchemeTemplate.default.call(this) : ''} <section id="section" class="observe-me ${this.renderStyle === 'focused' ? 'section-gap--focused-mode' : 'section-gap'}"> <slot name="custom-section"></slot> </section> ${_endpointTemplate.default.call(this)}`} </div> `}</div></main>`} </div> <slot name="footer"></slot> `;
}
/* eslint-enable indent */