"use strict";

exports.__esModule = true;
exports.default = overviewTemplate;

var _lit = require("lit");

var _unsafeHtml = require("lit/directives/unsafe-html.js");

var _marked = require("marked");

var _languages = require("../languages");

/* eslint-disable indent */
function overviewTemplate() {
  return (0, _lit.html)` <section id="overview" part="section-overview" class="observe-me ${this.renderStyle === 'focused' ? 'section-gap--focused-mode' : 'section-gap'}"> ${this.resolvedSpec && this.resolvedSpec.info ? (0, _lit.html)` <slot name="overview"> <div id="api-title" part="label-overview-title" style="font-size:32px" class="section-padding"> ${this.resolvedSpec.info.title} ${!this.resolvedSpec.info.version ? '' : (0, _lit.html)` <span style="font-size:var(--font-size-small);font-weight:700"> ${this.resolvedSpec.info.version} </span>`} </div> <div id="api-info" style="font-size:calc(var(--font-size-regular) - 1px);margin-top:8px" class="section-padding"> ${this.resolvedSpec.info.contact && this.resolvedSpec.info.contact.email ? (0, _lit.html)`<span>${this.resolvedSpec.info.contact.name || (0, _languages.getI18nText)('overview.email')}: <a href="mailto:${this.resolvedSpec.info.contact.email}" part="anchor anchor-overview">${this.resolvedSpec.info.contact.email}</a> </span>` : ''} ${this.resolvedSpec.info.contact && this.resolvedSpec.info.contact.url ? (0, _lit.html)`<span>URL: <a href="${this.resolvedSpec.info.contact.url}" part="anchor anchor-overview">${this.resolvedSpec.info.contact.url}</a></span>` : ''} ${this.resolvedSpec.info.license ? (0, _lit.html)`<span>License: ${this.resolvedSpec.info.license.url ? (0, _lit.html)`<a href="${this.resolvedSpec.info.license.url}" part="anchor anchor-overview">${this.resolvedSpec.info.license.name}</a>` : this.resolvedSpec.info.license.name} </span>` : ''} ${this.resolvedSpec.info.termsOfService ? (0, _lit.html)`<span><a href="${this.resolvedSpec.info.termsOfService}" part="anchor anchor-overview">${(0, _languages.getI18nText)('overview.terms-of-service')}</a></span>` : ''} </div> </slot> <slot name="overview-api-description"> ${this.resolvedSpec.info.description ? (0, _lit.html)`${(0, _unsafeHtml.unsafeHTML)(`<div class="m-markdown regular-font section-padding">${(0, _marked.marked)(this.resolvedSpec.info.description)}</div>`)}` : ''} </slot> ` : ''} </section> `;
}
/* eslint-enable indent */