"use strict";

exports.__esModule = true;
exports.getI18nText = getI18nText;
exports.initI18n = initI18n;
var _i18next = _interopRequireDefault(require("i18next"));
var _en = _interopRequireDefault(require("./en.js"));
var _fr = _interopRequireDefault(require("./fr.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
async function initI18n(resolvedSpecLanguage) {
  const initLang = (resolvedSpecLanguage || window.navigator.language).substring(0, 2);
  await _i18next.default.init({
    lng: initLang,
    fallbackLng: 'en',
    debug: false,
    ns: ['translation'],
    defaultNS: 'translation',
    resources: {
      en: _en.default,
      fr: _fr.default
    }
  });
}
function getI18nText(key) {
  return _i18next.default.t(key);
}