"use strict";

exports.__esModule = true;
exports.default = endpointTemplate;
exports.expandCollapseAll = expandCollapseAll;
exports.expandCollapseComponent = expandCollapseComponent;
var _lit = require("lit");
var _unsafeHtml = require("lit/directives/unsafe-html.js");
require("../components/api-request.js");
require("../components/api-response.js");
var _codeSamplesTemplate = _interopRequireDefault(require("./code-samples-template.js"));
var _callbackTemplate = _interopRequireDefault(require("./callback-template.js"));
var _securitySchemeTemplate = require("./security-scheme-template.js");
var _commonUtils = require("../utils/common-utils.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function toggleExpand(path) {
  if (path.expanded) {
    path.expanded = false;
    (0, _commonUtils.replaceState)(null);
  } else {
    path.expanded = true;
    this.emitOperationChangedEvent(path.elementId);

    // Toggle all the other ones off
    this.resolvedSpec.tags.forEach(t => t.paths.filter(p => p.elementId !== path.elementId).forEach(p => p.expanded = false));
    if (path.elementId !== (0, _commonUtils.getCurrentElement)()) {
      (0, _commonUtils.replaceState)(path.elementId);
    }
  }
  this.requestUpdate();
}
function toggleTag(tagElement, tagId) {
  const tag = this.resolvedSpec.tags.find(t => t.elementId === tagId);
  tag.expanded = !tag.expanded;
  this.requestUpdate();
}
function expandCollapseAll(currentElement, expand) {
  this.resolvedSpec.tags.forEach(t => t.expanded = expand);
  this.requestUpdate();
}
function expandCollapseComponent(component) {
  component.expanded = !component.expanded;
  this.requestUpdate();
}

/* eslint-disable indent */
function endpointHeadTemplate(path) {
  return (0, _lit.html)` <summary @click="${e => {
    toggleExpand.call(this, path, e);
  }}" class="endpoint-head ${path.method} ${path.expanded ? 'expanded' : 'collapsed'}"> <div class="method ${path.method}"><span style="line-height:1">${path.method}</span></div> <div style="${path.deprecated ? 'text-decoration: line-through;' : ''}"> ${this.usePathInNavBar ? (0, _lit.html)`<div class="path">${path.path.split('/').filter(t => t.trim()).map(t => (0, _lit.html)`<span>/${t}</span>`)}</div>` : (0, _lit.html)`<div class="">${path.summary || path.shortSummary}</div>`} ${path.isWebhook ? (0, _lit.html)`<span style="color:var(--primary-color)"> (Webhook) </span>` : ''} </div> </summary> `;
}
function endpointBodyTemplate(path) {
  var _path$servers, _path$servers$, _this$selectedServer;
  // Filter API Keys that are non-empty and are applicable to the the path
  const nonEmptyApiKeys = this.resolvedSpec.securitySchemes.filter(v => {
    var _path$security;
    return v.finalKeyValue && ((_path$security = path.security) === null || _path$security === void 0 ? void 0 : _path$security.some(ps => ps[v.apiKeyId]));
  }) || [];
  const codeSampleTabPanel = path.xCodeSamples ? (0, _codeSamplesTemplate.default)(path.xCodeSamples) : '';
  return (0, _lit.html)` <div class="endpoint-body ${path.method}"> <div class="summary"> ${this.usePathInNavBar ? path.summary ? (0, _lit.html)`<div class="title">${path.summary}<div></div></div>` : path.shortSummary !== path.description ? (0, _lit.html)`<div class="title">${path.shortSummary}</div>` : '' : (0, _lit.html)` <div class="title mono-font regular-font-size" part="section-operation-url" style="display:flex;flex-wrap:wrap;color:var(--fg3)"> ${path.isWebhook ? (0, _lit.html)`<span style="color:var(--primary-color)"> WEBHOOK </span>` : ''} <span part="label-operation-method" class="regular-font upper method-fg bold-text ${path.method}">${path.method}&nbsp;</span> <span style="display:flex;flex-wrap:wrap" part="label-operation-path">${path.path.split('/').filter(t => t.trim()).map(t => (0, _lit.html)`<span>/${t}</span>`)}</span> </div>`} ${path.description ? (0, _lit.html)`<div class="m-markdown"> ${(0, _unsafeHtml.unsafeHTML)((0, _commonUtils.toMarkdown)(path.description))}</div>` : ''} <slot name="${path.elementId}"></slot> <slot name="path-details" data-method="${path.method}" data-path="${path.path}"></slot> ${_securitySchemeTemplate.pathSecurityTemplate.call(this, path.security)} ${codeSampleTabPanel} </div> <div class="req-resp-container"> <div style="display:flex;flex-direction:column" class="request"> <api-request class="request-panel" style="width:100%" method="${path.method}" , path="${path.path}" element-id="${path.elementId}" .parameters="${path.parameters}" .request_body="${path.requestBody}" .api_keys="${nonEmptyApiKeys}" .servers="${path.servers}" server-url="${((_path$servers = path.servers) === null || _path$servers === void 0 ? void 0 : (_path$servers$ = _path$servers[0]) === null || _path$servers$ === void 0 ? void 0 : _path$servers$.url) || ((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl)}" active-schema-tab="${this.defaultSchemaTab}" fill-defaults="${!this.hideDefaults}" display-nulls="${!!this.includeNulls}" enable-console="${!this.hideExecution}" render-style="${this.renderStyle}" schema-style="${this.displaySchemaAsTree ? 'tree' : 'table'}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-read-only="${this.schemaHideReadOnly}" fetch-credentials="${this.fetchCredentials}" @scrollToSchemaComponentByName="${v => this.scrollToSchemaComponentByName(v)}" exportparts="btn, btn-fill, btn-outline, btn-try, schema-key, schema-type, schema-description, schema-table-header"> </api-request> </div> ${path.callbacks ? _callbackTemplate.default.call(this, path.callbacks) : ''} <api-response class="request response" .responses="${path.responses}" display-nulls="${!!this.includeNulls}" active-schema-tab="${this.defaultSchemaTab}" render-style="${this.renderStyle}" schema-style="${this.displaySchemaAsTree ? 'tree' : 'table'}" schema-expand-level="${this.schemaExpandLevel}" schema-hide-write-only="${this.schemaHideWriteOnly}" selected-status="${Object.keys(path.responses || {})[0] || ''}" @scrollToSchemaComponentByName="${v => this.scrollToSchemaComponentByName(v)}" exportparts="btn--resp, btn-fill--resp, btn-outline--resp, schema-key, schema-type, schema-description, schema-table-header"> </api-response> </div> </div>`;
}
function endpointTemplate() {
  return (0, _lit.html)` <div style="display:flex;justify-content:flex-end;padding-right:1rem;font-size:14px;margin-top:16px"> <span @click="${e => expandCollapseAll.call(this, e, true)}" style="color:var(--primary-color);cursor:pointer">Expand</span> &nbsp;|&nbsp; <span @click="${e => expandCollapseAll.call(this, e, false)}" style="color:var(--primary-color);cursor:pointer">Collapse</span> </div> ${(this.resolvedSpec && this.resolvedSpec.tags || []).map(tag => (0, _lit.html)` <div class="regular-font method-section-gap section-tag ${tag.expanded ? 'expanded' : 'collapsed'}"> <div class="section-tag-header" @click="${e => toggleTag.call(this, e, tag.elementId)}"> <div id="${tag.elementId}" class="sub-title tag" style="color:var(--primary-color)">${tag.name}</div> </div> <div class="section-tag-body"> <slot name="${tag.elementId}"></slot> ${tag.description ? (0, _lit.html)` <div class="regular-font regular-font-size m-markdown description" style="padding-bottom:12px"> ${(0, _unsafeHtml.unsafeHTML)((0, _commonUtils.toMarkdown)(tag.description || ''))} </div>` : ''} ${tag.paths.filter(v => (0, _commonUtils.pathIsInSearch)(this.matchPaths, v)).map(path => (0, _lit.html)` <section id="${path.elementId}" class="m-endpoint regular-font ${path.method} ${path.expanded ? 'expanded' : 'collapsed'}"> ${endpointHeadTemplate.call(this, path)} ${path.expanded ? endpointBodyTemplate.call(this, path) : ''} </section>`)} </div> </div> `)}`;
}
/* eslint-enable indent */