"use strict";

exports.__esModule = true;
exports.default = mainBodyTemplate;
var _lit = require("lit");
var _focusedEndpointTemplate = _interopRequireDefault(require("./focused-endpoint-template.js"));
var _overviewTemplate = _interopRequireDefault(require("./overview-template.js"));
var _endpointTemplate = _interopRequireDefault(require("./endpoint-template.js"));
var _serverTemplate = _interopRequireDefault(require("./server-template.js"));
var _securitySchemeTemplate = _interopRequireDefault(require("./security-scheme-template.js"));
var _navbarTemplate = _interopRequireDefault(require("./navbar-template.js"));
var _advanceSearchTemplate = _interopRequireDefault(require("./advance-search-template.js"));
var _theme = _interopRequireDefault(require("../utils/theme.js"));
var _colorUtils = _interopRequireDefault(require("../utils/color-utils.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// Templates

function mainBodyTemplate() {
  const newTheme = {
    bg1: _colorUtils.default.isValidHexColor(this.bgColor) ? this.bgColor : '',
    bg2: _colorUtils.default.isValidHexColor(this.bgHeaderColor) ? this.bgHeaderColor : '',
    fg1: _colorUtils.default.isValidHexColor(this.textColor) ? this.textColor : '',
    primaryColor: _colorUtils.default.isValidHexColor(this.primaryColor) ? this.primaryColor : '#3E6077',
    secondaryColor: _colorUtils.default.isValidHexColor(this.secondaryColor) ? this.secondaryColor : '#FBAF0B',
    headerColor: _colorUtils.default.isValidHexColor(this.headerColor) ? this.headerColor : '',
    navBgColor: _colorUtils.default.isValidHexColor(this.navBgColor) ? this.navBgColor : '',
    navTextColor: _colorUtils.default.isValidHexColor(this.navTextColor) ? this.navTextColor : '',
    navHoverBgColor: _colorUtils.default.isValidHexColor(this.navHoverBgColor) ? this.navHoverBgColor : '',
    navHoverTextColor: _colorUtils.default.isValidHexColor(this.navHoverTextColor) ? this.navHoverTextColor : ''
  };

  /* eslint-disable indent */
  return (0, _lit.html)` ${_theme.default.call(this, newTheme)} ${this.hideSearch ? '' : _advanceSearchTemplate.default.call(this)} <div id="the-main-body" class="body"> ${this.renderStyle === 'focused' && this.resolvedSpec ? _navbarTemplate.default.call(this) : ''} ${this.loading === true ? (0, _lit.html)`<slot name="loader"><div class="loader"></div></slot>` : (0, _lit.html)` <main class="main-content regular-font" part="section-main-content"> <div id="operations-root" class="main-content-inner"> ${this.loadingFailedError ? (0, _lit.html)` <div style="text-align:center;margin:16px"> Unable to load the Spec${this.specUrl ? ': ' : ''} <strong>${this.specUrl}</strong> <br><br> <div> ${this.loadingFailedError} </div> </div>` : (0, _lit.html)` <div class="operations-root" @click="${e => {
    this.handleHref(e);
  }}"> ${this.renderStyle === 'focused' ? (0, _lit.html)`${_focusedEndpointTemplate.default.call(this)}` : (0, _lit.html)` ${!this.hideInfo ? _overviewTemplate.default.call(this) : ''} ${!this.hideServerSelection ? _serverTemplate.default.call(this) : ''} ${!this.hideAuthentication ? _securitySchemeTemplate.default.call(this) : ''} <section id="section" class="observe-me ${this.renderStyle === 'focused' ? 'section-gap--focused-mode' : 'section-gap'}"> <slot name="custom-section"></slot> </section> ${_endpointTemplate.default.call(this)}`} </div>`} </div> </main>`} </div> `;
}
/* eslint-enable indent */