"use strict";

exports.__esModule = true;
exports.default = serverTemplate;
var _lit = require("lit");
var _commonUtils = require("../utils/common-utils.js");
var _unsafeHtml = require("lit/directives/unsafe-html.js");
var _index = require("../languages/index.js");
function onApiServerChange(e, server) {
  if (e && e.target.checked) {
    this.selectedServer = server;
    this.requestUpdate();
  }
}
function onApiServerVarChange(e, serverObj) {
  const inputEls = [...e.currentTarget.closest('table').querySelectorAll('input, select')];
  let tempUrl = serverObj.url;
  inputEls.forEach(v => {
    const regex = new RegExp(`{${v.dataset.var}}`, 'g');
    tempUrl = tempUrl.replace(regex, v.value);
  });
  serverObj.computedUrl = tempUrl;
  this.requestUpdate();
}

/* eslint-disable indent */
function serverVarsTemplate() {
  var _this$selectedServer;
  return Object.keys(((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.variables) || {}).length ? (0, _lit.html)` <div class="table-title">${(0, _index.getI18nText)('api-servers.server-variables')}</div> <table role="presentation" class="m-table"> ${Object.entries(this.selectedServer.variables).map(kv => (0, _lit.html)` <tr> <td colspan="1" style="vertical-align:middle">${kv[0]}</td> <td colspan="2"> ${kv[1].enum ? (0, _lit.html)` <select data-var="${kv[0]}" @input="${e => {
    onApiServerVarChange.call(this, e, this.selectedServer);
  }}"> ${Object.entries(kv[1].enum).map(e => kv[1].default === e[1] ? (0, _lit.html)` <option selected="selected" label="${e[1]}" value="${e[1]}">` : (0, _lit.html)` <option label="${e[1]}" value="${e[1]}">`)} </select>` : (0, _lit.html)` <input type="text" part="textbox textbox-server-var" spellcheck="false" data-var="${kv[0]}" value="${kv[1].default}" @input="${e => {
    onApiServerVarChange.call(this, e, this.selectedServer);
  }}">`} </td> </tr> ${kv[1].description ? (0, _lit.html)`<tr><td colspan="2" style="border:none"><span class="m-markdown-small"> ${(0, _unsafeHtml.unsafeHTML)((0, _commonUtils.toMarkdown)(kv[1].description))} </span></td></tr>` : ''} `)} </table> ` : '';
}
function serverTemplate() {
  var _this$selectedServer2;
  if (!this.resolvedSpec) {
    return undefined;
  }
  return (0, _lit.html)` <section id="servers" part="section-servers" style="margin-top:24px;margin-bottom:24px" class="regular-font observe-me section-padding ${this.renderStyle === 'read' ? 'section-gap--read-mode' : this.renderStyle === 'focused' ? 'section-gap--focused-mode' : 'section-gap'}"> <div class="sub-title">${(0, _index.getI18nText)('headers.api-servers')}</div> <div class="mono-font" style="margin:12px 0;font-size:calc(var(--font-size-small) + 1px)"> ${!this.resolvedSpec.servers || !this.resolvedSpec.servers.length ? '' : (0, _lit.html)` ${this.resolvedSpec.servers.map((server, i) => (0, _lit.html)` <input type="radio" name="api_server" id="srvr-opt-${i}" value="${server.url}" @change="${e => {
    onApiServerChange.call(this, e, server);
  }}" .checked="${this.selectedServer.url === server.url}" style="margin:4px 0;cursor:pointer"> <label style="cursor:pointer" for="srvr-opt-${i}"> ${server.url} ${server.description ? (0, _lit.html)`- <span class="regular-font">${server.description} </span>` : ''} </label> <br> `)} `} <div class="table-title primary-text" part="label-selected-server"> ${(0, _index.getI18nText)('api-servers.selected')}: ${((_this$selectedServer2 = this.selectedServer) === null || _this$selectedServer2 === void 0 ? void 0 : _this$selectedServer2.computedUrl) || 'none'}</div> </div> <slot name="servers"></slot> ${serverVarsTemplate.call(this)} </section>`;
}
/* eslint-enable indent */