"use strict";

exports.__esModule = true;
exports.default = void 0;

var _ref = _interopRequireDefault(require("@apidevtools/json-schema-ref-parser/lib/ref.js"));

var _pointer = _interopRequireDefault(require("@apidevtools/json-schema-ref-parser/lib/pointer.js"));

var _url = require("@apidevtools/json-schema-ref-parser/lib/util/url.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = dereference;
/**
 * Crawls the JSON schema, finds all JSON references, and dereferences them.
 * This method mutates the JSON schema object, replacing JSON references with their resolved value.
 *
 * @param parser
 * @param options
 */

exports.default = _default;

function dereference(parser, options) {
  // console.log('Dereferencing $ref pointers in %s', parser.$refs._root$Ref.path);
  // eslint-disable-next-line no-underscore-dangle
  const result = crawl(parser.schema, parser.$refs._root$Ref.path, '#', new Set(), [], parser.$refs, options);
  parser.schema = result.value;
}

const mergeRefObject = (refObject, newObject) => {
  const refKeys = Object.keys(refObject);

  if (refKeys.length < 2) {
    return newObject;
  }

  const filteredKeys = refKeys.filter(key => key !== '$ref' && !(key in newObject));
  const extraKeys = filteredKeys.reduce((acc, key) => {
    acc[key] = refObject[key];
    return acc;
  }, {});
  return _objectSpread(_objectSpread({}, newObject), extraKeys);
};
/**
 * Recursively crawls the given value, and dereferences any JSON references.
 *
 * @param obj - The value to crawl. If it's not an object or array, it will be ignored.
 * @param path - The full path of `obj`, possibly with a JSON Pointer in the hash
 * @param pathFromRoot - The path of `obj` from the schema root
 * @param parents - An array of the parent objects that have already been dereferenced
 * @param {array<string>} pathList - An array of the list of parents reference points for error handling
 * @param $refs
 * @param options
 * @returns
 */


function crawl(obj, path, pathFromRoot, parents, pathList, $refs, options) {
  // function crawl(obj: any, path: string, pathFromRoot: string, parents: Set<any>, pathList: Array<string>, $refs: $Refs, options: $RefParserOptions, ) : any {
  if (!obj || typeof obj !== 'object' || ArrayBuffer.isView(obj) || options && options.dereference && options.dereference.excludedPathMatcher(pathFromRoot)) {
    return {
      value: obj,
      circular: false
    };
  }

  if (parents.has(obj)) {
    foundCircularReference(pathList.pop(), $refs, options);
    return {
      value: obj,
      circular: true
    };
  } // If it is a $ref


  if (_ref.default.isAllowed$Ref(obj, options)) {
    const $refObject = obj;
    const $refPath = (0, _url.resolve)(path, $refObject.$ref); // eslint-disable-next-line no-underscore-dangle

    const pointer = $refs._resolve($refPath, path, options);

    if (!pointer) {
      return {
        value: null
      };
    } // Dereference the JSON reference


    const dereferencedValue = mergeRefObject($refObject, _ref.default.dereference($refObject, pointer.value));

    if (pointer.circular) {
      // The pointer is a DIRECT circular reference (i.e. it references itself).
      // So replace the $ref path with the absolute path from the JSON Schema root
      dereferencedValue.$ref = pathFromRoot;
      foundCircularReference(path, $refs, options);
      return {
        value: dereferencedValue,
        circular: true
      };
    }

    if (options.dereference.onDereference) {
      options.dereference.onDereference(pathFromRoot, dereferencedValue);
    }

    const result = crawl(dereferencedValue, pointer.path, pathFromRoot, new Set(parents).add(obj), pathList.concat(path), $refs, options);

    if (result.circular && options && options.dereference && options.dereference.circular && options.dereference.circular === 'ignore') {
      return {
        circular: false,
        value: _objectSpread(_objectSpread({}, $refObject), {}, {
          circularReference: {
            $ref: $refObject.$ref,
            name: $refObject.$ref.split('/').slice(-1)[0]
          }
        })
      };
    }

    return result;
  } // If it is an Array


  if (Array.isArray(obj)) {
    let circular;
    const arrayResult = []; // eslint-disable-next-line no-restricted-syntax, guard-for-in

    for (const arrayIndex in obj) {
      const keyPath = _pointer.default.join(path, arrayIndex);

      const keyPathFromRoot = _pointer.default.join(pathFromRoot, arrayIndex);

      const result = crawl(obj[arrayIndex], keyPath, keyPathFromRoot, new Set(parents).add(obj), pathList.concat(path), $refs, options);
      circular = circular || result.circular;
      arrayResult.push(result.value);
    }

    return {
      value: arrayResult,
      circular
    };
  } // Otherwise it is an object


  let circular; // eslint-disable-next-line no-restricted-syntax

  for (const key of Object.keys(obj)) {
    const keyPath = _pointer.default.join(path, key);

    const keyPathFromRoot = _pointer.default.join(pathFromRoot, key);

    const result = crawl(obj[key], keyPath, keyPathFromRoot, new Set(parents).add(obj), pathList.concat(path), $refs, options);
    circular = circular || result.circular;
    obj[key] = result.value;
  }

  return {
    value: obj,
    circular
  };
}
/**
 * Called when a circular reference is found.
 * It sets the {@link $Refs#circular} flag, and throws an error if options.dereference.circular is false.
 *
 * @param keyPath - The JSON Reference path of the circular reference
 * @param $refs
 * @param options
 * @returns - always returns true, to indicate that a circular reference was found
 */
// function foundCircularReference(keyPath: string | undefined, $refs: any, options: $RefParserOptions) {


function foundCircularReference(keyPath, $refs, options) {
  $refs.circular = true;

  if (options.dereference && !options.dereference.circular) {
    throw Error(`Circular $ref pointer found at ${keyPath}`);
  }

  return true;
}