"use strict";

exports.__esModule = true;
exports.default = void 0;

var _jsYaml = _interopRequireDefault(require("js-yaml"));

var _lodash = _interopRequireDefault(require("lodash.clonedeepwith"));

var _refParser = _interopRequireDefault(require("./refParser.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

async function resolver(specUrlOrObject) {
  const result = await dereference(specUrlOrObject);
  const refStack = [];
  const keyPath = []; // eslint-disable-next-line no-unused-vars

  function handleCircularReferences(objectWithRef, key) {
    if (typeof objectWithRef !== 'object') {
      return undefined;
    }

    if (objectWithRef === null) {
      return null;
    }

    if (!Object.hasOwnProperty.call(objectWithRef, '$ref')) {
      if (Array.isArray(objectWithRef)) {
        return undefined;
      }

      const newObject = {};
      Object.keys(objectWithRef).forEach(objectKey => {
        keyPath.push(objectKey);
        newObject[objectKey] = (0, _lodash.default)(objectWithRef[objectKey], handleCircularReferences);
        keyPath.pop();
      });
      return newObject;
    }

    const clonedObject = (0, _lodash.default)(objectWithRef);
    const ref = clonedObject.$ref;
    delete clonedObject.$ref;
    const keyPathMatch = ref.split('/').slice(1).every((part, partIndex) => keyPath[partIndex] === part);

    if (refStack.includes(ref) || keyPathMatch) {
      // eslint-disable-next-line prettier/prettier
      return Object.assign(clonedObject, {
        circularReference: {
          $ref: ref,
          name: ref.split('/').slice(-1)[0]
        }
      });
    }

    refStack.push(ref);
    keyPath.push(key);
    const newValue = result.$refs.get(ref);

    const mergedResult = _objectSpread(_objectSpread({}, newValue), clonedObject);

    const finalResult = (0, _lodash.default)(mergedResult, handleCircularReferences);
    refStack.pop();
    keyPath.pop();
    return finalResult;
  } // const specWithReferences = cloneDeepWith(result.schema, handleCircularReferences);


  return result.schema; // return specWithReferences;
}

async function dereference(specUrlOrObject) {
  const parser = new _refParser.default();
  const options = {
    dereference: {
      circular: 'ignore'
    }
  };

  if (typeof specUrlOrObject === 'object') {
    if (typeof specUrlOrObject.href === 'string') {
      await dereference(specUrlOrObject.toString(), options);
      return parser;
    }

    await parser.dereference(specUrlOrObject, options);
    return parser;
  }

  try {
    await parser.dereference(JSON.parse(specUrlOrObject), options);
    return parser;
  } catch (error) {
    /* */
  }

  const loadedYamlDoc = await _jsYaml.default.load(specUrlOrObject);
  await parser.dereference(loadedYamlDoc, options);
  return parser;
}

resolver.resolve = resolver;
var _default = resolver;
exports.default = _default;