"use strict";

exports.__esModule = true;
exports.default = void 0;
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var _lodash = _interopRequireDefault(require("lodash.clonedeepwith"));
var _refParser = _interopRequireDefault(require("./refParser.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /* eslint-disable no-bitwise */ // eslint-disable-next-line import/no-named-as-default
async function resolver(specUrlOrObject) {
  const result = await dereference(specUrlOrObject);
  const refStack = [];
  const keyPath = [];
  // eslint-disable-next-line no-unused-vars
  function handleCircularReferences(objectWithRef, key) {
    if (typeof objectWithRef !== 'object') {
      return undefined;
    }
    if (objectWithRef === null) {
      return null;
    }
    if (!Object.hasOwnProperty.call(objectWithRef, '$ref')) {
      if (Array.isArray(objectWithRef)) {
        return undefined;
      }
      const newObject = {};
      Object.keys(objectWithRef).forEach(objectKey => {
        keyPath.push(objectKey);
        newObject[objectKey] = (0, _lodash.default)(objectWithRef[objectKey], handleCircularReferences);
        keyPath.pop();
      });
      return newObject;
    }
    const clonedObject = (0, _lodash.default)(objectWithRef);
    const ref = clonedObject.$ref;
    delete clonedObject.$ref;
    const keyPathMatch = ref.split('/').slice(1).every((part, partIndex) => keyPath[partIndex] === part);
    if (refStack.includes(ref) || keyPathMatch) {
      // eslint-disable-next-line prettier/prettier
      return Object.assign(clonedObject, {
        circularReference: {
          $ref: ref,
          name: ref.split('/').slice(-1)[0]
        }
      });
    }
    refStack.push(ref);
    keyPath.push(key);
    const newValue = result.$refs.get(ref);
    const mergedResult = _objectSpread(_objectSpread({}, newValue), clonedObject);
    const finalResult = (0, _lodash.default)(mergedResult, handleCircularReferences);
    refStack.pop();
    keyPath.pop();
    return finalResult;
  }

  // const specWithReferences = cloneDeepWith(result.schema, handleCircularReferences);
  return result.schema;
  // return specWithReferences;
}
async function dereference(specUrlOrObject) {
  const parser = new _refParser.default();
  const options = {
    dereference: {
      circular: 'ignore'
    }
  };
  if (typeof specUrlOrObject === 'object') {
    if (typeof specUrlOrObject.href === 'string') {
      await parser.dereference(specUrlOrObject.toString(), options);
      return parser;
    }
    await parser.dereference(specUrlOrObject, options);
    return parser;
  }
  try {
    await parser.dereference(JSON.parse(specUrlOrObject), options);
    return parser;
  } catch (error) {
    /* */
  }
  const loadedYamlDoc = await _jsYaml.default.load(specUrlOrObject);
  await parser.dereference(loadedYamlDoc, options);
  return parser;
}
resolver.resolve = resolver;
var _default = exports.default = resolver;