"use strict";
/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var token_request_1 = require("./token_request");
describe('Token Request tests', function () {
    var clientId = 'client_id';
    var redirectUri = 'http://my/redirect_uri';
    var code = 'some_code';
    var extras = { 'key': 'value' };
    var request = new token_request_1.TokenRequest({
        client_id: clientId,
        redirect_uri: redirectUri,
        grant_type: token_request_1.GRANT_TYPE_AUTHORIZATION_CODE,
        code: code,
        refresh_token: undefined,
        extras: extras
    });
    it('Basic Token Request Tests', function () {
        expect(request).not.toBeNull();
        expect(request.clientId).toBe(clientId);
        expect(request.redirectUri).toBe(redirectUri);
        expect(request.code).toBe(code);
        expect(request.grantType).toBe(token_request_1.GRANT_TYPE_AUTHORIZATION_CODE);
        expect(request.extras).toBeTruthy();
        expect(request.extras['key']).toBe('value');
        expect(request.extras).toEqual(extras);
    });
    it('To Json() and from Json() should work', function () {
        var json = JSON.parse(JSON.stringify(request.toJson()));
        expect(json).not.toBeNull();
        var newRequest = new token_request_1.TokenRequest(json);
        expect(newRequest).not.toBeNull();
        expect(newRequest.clientId).toBe(clientId);
        expect(newRequest.redirectUri).toBe(redirectUri);
        expect(newRequest.code).toBe(code);
        expect(newRequest.grantType).toBe(token_request_1.GRANT_TYPE_AUTHORIZATION_CODE);
        expect(newRequest.extras).toBeTruthy();
        expect(newRequest.extras['key']).toBe('value');
        expect(newRequest.extras).toEqual(extras);
    });
});
//# sourceMappingURL=data:application/json;base64,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