# v3.11.0

## Summary

The v3.11.0 release includes features and fixes from 73 pull requests since the v3.10.1 release.  New features and improvements include:

* Support for raster reprojection - load raster sources in one projection and view them in another.
* Support for Mapbox Vector Tiles!
* Improved KML support, GeoJSON & TopoJSON fixes, and much more.  See below for the full list.

## Upgrade notes

#### `ol.format.KML` changes

KML icons are scaled 50% so that the rendering better matches Google Earth rendering.

If a KML placemark has a name and is a point, an `ol.style.Text` is created with the name displayed to the right of the icon (if there is an icon).
This can be controlled with the showPointNames option which defaults to true.

To disable rendering of the point names for placemarks, use the option:
new ol.format.KML({ showPointNames: false });

#### `ol.interaction.DragBox` and `ol.interaction.DragZoom` changes

Styling is no longer done with `ol.Style`, but with pure CSS. The `style` constructor option is no longer required, and no longer available. Instead, there is a `className` option for the CSS selector. The default for `ol.interaction.DragBox` is `ol-dragbox`, and `ol.interaction.DragZoom` uses `ol-dragzoom`. If you previously had
```js
new ol.interaction.DragZoom({
  style: new ol.style.Style({
    stroke: new ol.style.Stroke({
      color: 'red',
      width: 3
    }),
    fill: new ol.style.Fill({
      color: [255, 255, 255, 0.4]
    })
  })
});
```
you'll now just need
```js
new ol.interaction.DragZoom();
```
but with additional css:
```css
.ol-dragzoom {
  border-color: red;
  border-width: 3px;
  background-color: rgba(255,255,255,0.4);
}
```

#### Removal of `ol.source.TileVector`

With the introduction of true vector tile support, `ol.source.TileVector` becomes obsolete. Change your code to use `ol.layer.VectorTile` and `ol.source.VectorTile` instead of `ol.layer.Vector` and `ol.source.TileVector`.

#### `ol.Map#forEachFeatureAtPixel` changes for unmanaged layers

`ol.Map#forEachFeatureAtPixel` will still be called for unmanaged layers, but the 2nd argument to the callback function will be `null` instead of a reference to the unmanaged layer. This brings back the behavior of the abandoned `ol.FeatureOverlay` that was replaced by unmanaged layers.

If you are affected by this change, please change your unmanaged layer to a regular layer by using e.g. `ol.Map#addLayer` instead of `ol.layer.Layer#setMap`.

## Full list of changes

 * [#4394](https://github.com/openlayers/ol3/pull/4394) - Allow ol.Object property update without notification. ([@DavidHequet](https://github.com/DavidHequet))
 * [#4395](https://github.com/openlayers/ol3/pull/4395) - Flag ol.style.Text setOffsetX and Y as @api. ([@adube](https://github.com/adube))
 * [#4393](https://github.com/openlayers/ol3/pull/4393) - Faster vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#4392](https://github.com/openlayers/ol3/pull/4392) - Update clean-css to version 3.4.7 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4391](https://github.com/openlayers/ol3/pull/4391) - Pass null as forEachFeatureAtPixel layer arg for unmanaged layers ([@ahocevar](https://github.com/ahocevar))
 * [#4390](https://github.com/openlayers/ol3/pull/4390) - Fix usage of mocha-phantomjs-core after update ([@ahocevar](https://github.com/ahocevar))
 * [#4387](https://github.com/openlayers/ol3/pull/4387) - Add default argument to getRendererFromQueryString ([@ahocevar](https://github.com/ahocevar))
 * [#4376](https://github.com/openlayers/ol3/pull/4376) - Make KML format ignore image styles that aren't icons ([@elemoine](https://github.com/elemoine))
 * [#4385](https://github.com/openlayers/ol3/pull/4385) - Don't transform the scale specified by the user ([@oterral](https://github.com/oterral))
 * [#4388](https://github.com/openlayers/ol3/pull/4388) - Quick-fix running tests with PhantomJS ([@ahocevar](https://github.com/ahocevar))
 * [#4378](https://github.com/openlayers/ol3/pull/4378) - Add a writeStyles option to KML format ([@elemoine](https://github.com/elemoine))
 * [#4375](https://github.com/openlayers/ol3/pull/4375) - Fixed documentation typo (ol.source.ImageWMS) ([@simonseyock](https://github.com/simonseyock))
 * [#4371](https://github.com/openlayers/ol3/pull/4371) - Fix typo in closure compilation tutorial ([@dtreiter](https://github.com/dtreiter))
 * [#4370](https://github.com/openlayers/ol3/pull/4370) - Improve ol.interaction.Select#getLayer documentation. ([@jonataswalker](https://github.com/jonataswalker))
 * [#4365](https://github.com/openlayers/ol3/pull/4365) - Update fs-extra to version 0.26.2 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4366](https://github.com/openlayers/ol3/pull/4366) - Update resemblejs to version 2.0.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4368](https://github.com/openlayers/ol3/pull/4368) - Append KML placemark text style to existing styles ([@marcjansen](https://github.com/marcjansen))
 * [#4361](https://github.com/openlayers/ol3/pull/4361) - Make GPX format not fail on unsupported geometries ([@elemoine](https://github.com/elemoine))
 * [#4360](https://github.com/openlayers/ol3/pull/4360) - Update getExtent return value jsdoc tag ([@fredj](https://github.com/fredj))
 * [#4359](https://github.com/openlayers/ol3/pull/4359) - Update closure-util to version 1.9.0 🚀 ([@openlayers](https://github.com/openlayers))
 * [#4357](https://github.com/openlayers/ol3/pull/4357) - Update all dependencies. ([@openlayers](https://github.com/openlayers))
 * [#4356](https://github.com/openlayers/ol3/pull/4356) - Update Metalsmith and layouts plugin. ([@tschaub](https://github.com/tschaub))
 * [#4355](https://github.com/openlayers/ol3/pull/4355) - Update PhantomJS. ([@tschaub](https://github.com/tschaub))
 * [#4353](https://github.com/openlayers/ol3/pull/4353) - Resolve path to jsdoc-fork. ([@tschaub](https://github.com/tschaub))
 * [#3627](https://github.com/openlayers/ol3/pull/3627) - Make package.json compatible for npm frontend use. ([@ThomasG77](https://github.com/ThomasG77))
 * [#4163](https://github.com/openlayers/ol3/pull/4163) - Fixes for building with Node 4.x. ([@tschaub](https://github.com/tschaub))
 * [#4347](https://github.com/openlayers/ol3/pull/4347) - Use require.resolve() to find jsdoc. ([@tschaub](https://github.com/tschaub))
 * [#4291](https://github.com/openlayers/ol3/pull/4291) - Add 'Move a feature along a line' example. ([@jonataswalker](https://github.com/jonataswalker))
 * [#4344](https://github.com/openlayers/ol3/pull/4344) - Allow different resolutions in x and y direction for ol.source.ImageStatic ([@bartvde](https://github.com/bartvde))
 * [#4339](https://github.com/openlayers/ol3/pull/4339) - Make sure drawImage width and height are not too big ([@bartvde](https://github.com/bartvde))
 * [#4334](https://github.com/openlayers/ol3/pull/4334) - Check view extent within image extent ([@ahocevar](https://github.com/ahocevar))
 * [#4332](https://github.com/openlayers/ol3/pull/4332) - Fix write out GeoJSON features with id equal to 0 ([@fredj](https://github.com/fredj))
 * [#4331](https://github.com/openlayers/ol3/pull/4331) - Allow TopoJSON features with id equal to 0 ([@fredj](https://github.com/fredj))
 * [#4330](https://github.com/openlayers/ol3/pull/4330) - ol.format.TopoJSON is read only, update the jsdoc ([@openlayers](https://github.com/openlayers))
 * [#4327](https://github.com/openlayers/ol3/pull/4327) - Allow GeoJSON features with id equal to 0 ([@fredj](https://github.com/fredj))
 * [#4219](https://github.com/openlayers/ol3/pull/4219) - Support tiled vector data and Mapbox vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#4322](https://github.com/openlayers/ol3/pull/4322) - Add wrapX override support for ol.source.Cluster ([@FRizZL](https://github.com/FRizZL))
 * [#4316](https://github.com/openlayers/ol3/pull/4316) - Render name labels if the geometry is a point in KML format (@tamarmot) ([@marcjansen](https://github.com/marcjansen))
 * [#4313](https://github.com/openlayers/ol3/pull/4313) - Align logos nicely with attribution text ([@ahocevar](https://github.com/ahocevar))
 * [#4297](https://github.com/openlayers/ol3/pull/4297) - Create standalone versions of ol.ext packages ([@ahocevar](https://github.com/ahocevar))
 * [#4302](https://github.com/openlayers/ol3/pull/4302) - scale icons by 0.5 so they are not huge ([@tamarmot](https://github.com/tamarmot))
 * [#4301](https://github.com/openlayers/ol3/pull/4301) - Remove jshint -W069 tags in source code ([@fredj](https://github.com/fredj))
 * [#4273](https://github.com/openlayers/ol3/pull/4273) - Expand docs on ol.source url prop. ([@Barryrowe](https://github.com/Barryrowe))
 * [#4293](https://github.com/openlayers/ol3/pull/4293) - Refine the pull request process ([@ahocevar](https://github.com/ahocevar))
 * [#4289](https://github.com/openlayers/ol3/pull/4289) - Restrict maxZoom of the static-image example ([@ahocevar](https://github.com/ahocevar))
 * [#4275](https://github.com/openlayers/ol3/pull/4275) - Fix ol.events.condition.mouseOnly parameter type ([@fredj](https://github.com/fredj))
 * [#4248](https://github.com/openlayers/ol3/pull/4248) - Use Math.cosh of ES6/2015 if available ([@marcjansen](https://github.com/marcjansen))
 * [#4286](https://github.com/openlayers/ol3/pull/4286) - Add a color manipulation example. ([@tschaub](https://github.com/tschaub))
 * [#4122](https://github.com/openlayers/ol3/pull/4122) - Raster reprojection ([@klokantech](https://github.com/klokantech))
 * [#4283](https://github.com/openlayers/ol3/pull/4283) - Flag ol.tilegrid.TileGrid getTileCoordExtent as @api ([@adube](https://github.com/adube))
 * [#4280](https://github.com/openlayers/ol3/pull/4280) - Use overlay container instead of viewport for ol.render.Box ([@ahocevar](https://github.com/ahocevar))
 * [#4278](https://github.com/openlayers/ol3/pull/4278) - Use DOM instead of map canvas for ol.render.Box ([@ahocevar](https://github.com/ahocevar))
 * [#4277](https://github.com/openlayers/ol3/pull/4277) - Improve the box select example ([@fredj](https://github.com/fredj))
 * [#4276](https://github.com/openlayers/ol3/pull/4276) - Better ol.events.condition.platformModifierKeyOnly documentation ([@fredj](https://github.com/fredj))
 * [#4102](https://github.com/openlayers/ol3/pull/4102) - Export ol.Observable#dispatchEvent function ([@fredj](https://github.com/fredj))
 * [#4261](https://github.com/openlayers/ol3/pull/4261) - ol.events.condition.mouseOnly may be wrong ([@fredj](https://github.com/fredj))
 * [#4269](https://github.com/openlayers/ol3/pull/4269) - Fix Zoom control duration option - allow `0` as value ([@adube](https://github.com/adube))
 * [#4268](https://github.com/openlayers/ol3/pull/4268) - Add method for retrieving ol.Overlay by id ([@jonataswalker](https://github.com/jonataswalker))
 * [#4257](https://github.com/openlayers/ol3/pull/4257) - Remove unused ol.math-methods ([@marcjansen](https://github.com/marcjansen))
 * [#4270](https://github.com/openlayers/ol3/pull/4270) - Fix Keyboard zoom interation options ([@adube](https://github.com/adube))
 * [#4272](https://github.com/openlayers/ol3/pull/4272) - Allow the DragZoom interaction created in defaults to use zoomDuration option. ([@adube](https://github.com/adube))
 * [#4271](https://github.com/openlayers/ol3/pull/4271) - Fix DragZoom interaction duration, allow `0` value ([@adube](https://github.com/adube))
 * [#4267](https://github.com/openlayers/ol3/pull/4267) - Example usability improvements ([@ahocevar](https://github.com/ahocevar))
 * [#4263](https://github.com/openlayers/ol3/pull/4263) - Add back CSSProperties.prototype.touchAction extern ([@fredj](https://github.com/fredj))
 * [#4259](https://github.com/openlayers/ol3/pull/4259) - Remove use of toDegrees/toRadians util functions ([@marcjansen](https://github.com/marcjansen))
 * [#4258](https://github.com/openlayers/ol3/pull/4258) - Remove usage of goog.dom.TagName enum ([@marcjansen](https://github.com/marcjansen))
 * [#4255](https://github.com/openlayers/ol3/pull/4255) - Fix zoom slider width for retina displays ([@ahocevar](https://github.com/ahocevar))
 * [#4249](https://github.com/openlayers/ol3/pull/4249) - Make whole example box clickable ([@ahocevar](https://github.com/ahocevar))
 * [#4045](https://github.com/openlayers/ol3/pull/4045) - Add parser for dimension property from WMTS Capabilities.xml ([@Jenselme](https://github.com/Jenselme))
 * [#4161](https://github.com/openlayers/ol3/pull/4161) - Add `translatestart`, `translateend` and `translating` events to `ol.interaction.Translate` ([@jonataswalker](https://github.com/jonataswalker))
 * [#4186](https://github.com/openlayers/ol3/pull/4186) - Do not export ol.webgl.Context ([@elemoine](https://github.com/elemoine))
 * [#4239](https://github.com/openlayers/ol3/pull/4239) - Changing highlighted to highlight ([@austinkeeley](https://github.com/austinkeeley))
 * [#3727](https://github.com/openlayers/ol3/pull/3727) - Added getOverviewMap getter method in overviewmapcontrol.js ([@bogdanvaduva](https://github.com/bogdanvaduva))
