# 3.1.0

## Summary

The 3.1.0 release includes a whopping 214 merged pull requests since 3.0.0.  Of note, the WebGL renderer [now supports point rendering](https://github.com/openlayers/ol3/pull/2967).  You can use [UTFGrids for interaction](https://github.com/openlayers/ol3/pull/3015)!  Styles can now specify [alternate geometries for rendering](https://github.com/openlayers/ol3/pull/3010).  Library builds [can now be loaded](https://github.com/openlayers/ol3/pull/3039) with module loaders like Browserify or RequireJS.  You can now symbolize point features with stars, squares, enneadecagons, or [any other regular(ish) polygon](https://github.com/openlayers/ol3/pull/2706).  See the full list of [changes](#changes) below.

## Upgrade notes

The 3.1.0 release maintains a backwards-compatible API with the 3.0.0 release, so upgrades should be painless.  Some special considerations below.

 * If you are using a `ol.source.ImageStatic`, you no longer need to provide an `imageSize` option if you don't want any special scaling on your image (see [#2796](https://github.com/openlayers/ol3/pull/2796)).

 * Instead of calling `obj.unByKey(key)` you can now call `ol.Observable.unByKey(key)` (see [#2794](https://github.com/openlayers/ol3/pull/2794)).

 * If you were using `format.writeFeatures(features)`, note that this method returns a string for all feature formats.  We considered the previous behavior a bug (see [#3003](https://github.com/openlayers/ol3/pull/3003)).

 * The `obj.dispatchChangeEvent()` method is now spelled `obj.changed()`.  This method is still unstable (see [#2684](https://github.com/openlayers/ol3/pull/2684)).

## Changes

 * [#3076](https://github.com/openlayers/ol3/pull/3076) - Add script to standardize changelog creation. ([@tschaub](https://github.com/tschaub))
 * [#3074](https://github.com/openlayers/ol3/pull/3074) - Remove misplaced function annotation. ([@fredj](https://github.com/fredj))
 * [#3075](https://github.com/openlayers/ol3/pull/3075) - Remove unneeded undefined from ol.proj.ProjectionLike definitions (r=@tschaub) ([@bartvde](https://github.com/bartvde))
 * [#3071](https://github.com/openlayers/ol3/pull/3071) - Add task for publishing to npm. ([@tschaub](https://github.com/tschaub))
 * [#3070](https://github.com/openlayers/ol3/pull/3070) - Define goog and assign to global when generating UMD debug builds. ([@tschaub](https://github.com/tschaub))
 * [#3068](https://github.com/openlayers/ol3/pull/3068) - Update pre-release version. ([@tschaub](https://github.com/tschaub))
 * [#3039](https://github.com/openlayers/ol3/pull/3039) - Support for UMD builds. ([@tschaub](https://github.com/tschaub))
 * [#3038](https://github.com/openlayers/ol3/pull/3038) - Update attribution CSS #2803 ([@acanimal](https://github.com/acanimal))
 * [#3061](https://github.com/openlayers/ol3/pull/3061) - Add a renderBuffer option to ol.layer.Vector ([@elemoine](https://github.com/elemoine))
 * [#3048](https://github.com/openlayers/ol3/pull/3048) - Add a drag-features example ([@elemoine](https://github.com/elemoine))
 * [#3060](https://github.com/openlayers/ol3/pull/3060) - Update closure-library version ([@fredj](https://github.com/fredj))
 * [#3058](https://github.com/openlayers/ol3/pull/3058) - Use an API function to extend the extent ([@ahocevar](https://github.com/ahocevar))
 * [#3010](https://github.com/openlayers/ol3/pull/3010) - Allow styles to override feature geometries ([@ahocevar](https://github.com/ahocevar))
 * [#3056](https://github.com/openlayers/ol3/pull/3056) - Reuse previousExtent_ local variable ([@fredj](https://github.com/fredj))
 * [#3055](https://github.com/openlayers/ol3/pull/3055) - ol.tilecoord.createOrUpdate: add 'opt_' prefix to optional param ([@fredj](https://github.com/fredj))
 * [#3044](https://github.com/openlayers/ol3/pull/3044) - Mark Image style constructor properties `@api` ([@gberaudo](https://github.com/gberaudo))
 * [#3052](https://github.com/openlayers/ol3/pull/3052) - Add a testcase for parsing GML feature with only boundedBy ([@bartvde](https://github.com/bartvde))
 * [#3051](https://github.com/openlayers/ol3/pull/3051) - Remove // NOCOMPILE from vector-wfs ([@elemoine](https://github.com/elemoine))
 * [#2699](https://github.com/openlayers/ol3/pull/2699) - No need for featureNS and featureType to be quoted ([@bartvde](https://github.com/bartvde))
 * [#3047](https://github.com/openlayers/ol3/pull/3047) - Move description above annotation to avoid JSDoc warnings. ([@tschaub](https://github.com/tschaub))
 * [#2996](https://github.com/openlayers/ol3/pull/2996) - Add getter functions for points and angle in ol.style.RegularShape ([@bartvde](https://github.com/bartvde))
 * [#3046](https://github.com/openlayers/ol3/pull/3046) - Need exportable constructor for constructor options in olx ([@ahocevar](https://github.com/ahocevar))
 * [#3043](https://github.com/openlayers/ol3/pull/3043) - Use // NOCOMPILE for vector-wfs ([@elemoine](https://github.com/elemoine))
 * [#3042](https://github.com/openlayers/ol3/pull/3042) - Print example name in check-examples exception ([@gberaudo](https://github.com/gberaudo))
 * [#3032](https://github.com/openlayers/ol3/pull/3032) - Extension points for custom controls and interactions ([@elemoine](https://github.com/elemoine))
 * [#3033](https://github.com/openlayers/ol3/pull/3033) - Allow custom mousemove conditions for Select interaction ([@ahocevar](https://github.com/ahocevar))
 * [#3040](https://github.com/openlayers/ol3/pull/3040) - Transform the coordinates in place ([@fredj](https://github.com/fredj))
 * [#3036](https://github.com/openlayers/ol3/pull/3036) - Respect geometry stride in modify interaction ([@tonio](https://github.com/tonio))
 * [#3020](https://github.com/openlayers/ol3/pull/3020) - Correct error message from generate-info.js. ([@tschaub](https://github.com/tschaub))
 * [#3037](https://github.com/openlayers/ol3/pull/3037) - Implement rotation for ol.style.RegularShape ([@bartvde](https://github.com/bartvde))
 * [#3015](https://github.com/openlayers/ol3/pull/3015) - UTFGrid Support ([@klokantech](https://github.com/klokantech))
 * [#3012](https://github.com/openlayers/ol3/pull/3012) - Failing tests in IE9 ([@bartvde](https://github.com/bartvde))
 * [#3029](https://github.com/openlayers/ol3/pull/3029) - Update closure compiler and library ([@fredj](https://github.com/fredj))
 * [#3031](https://github.com/openlayers/ol3/pull/3031) - Add missing maxZoom property in olx.view.FitGeometryOptions ([@fredj](https://github.com/fredj))
 * [#3028](https://github.com/openlayers/ol3/pull/3028) - ol.format.WFS cleanup ([@fredj](https://github.com/fredj))
 * [#3024](https://github.com/openlayers/ol3/pull/3024) - Add missing gmlFormat to olx.format.WFSOptions ([@fredj](https://github.com/fredj))
 * [#3023](https://github.com/openlayers/ol3/pull/3023) - Change loader function return type ([@fredj](https://github.com/fredj))
 * [#3021](https://github.com/openlayers/ol3/pull/3021) - Add missing properties in olx.control.AttributionOptions typedef ([@fredj](https://github.com/fredj))
 * [#3013](https://github.com/openlayers/ol3/pull/3013) - Improve vector source clear() performance ([@gberaudo](https://github.com/gberaudo))
 * [#3017](https://github.com/openlayers/ol3/pull/3017) - Use writeFeatures instead of writeFeaturesNode in GPX and KML example (r=@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#3014](https://github.com/openlayers/ol3/pull/3014) - Simplify hit detection code ([@elemoine](https://github.com/elemoine))
 * [#3006](https://github.com/openlayers/ol3/pull/3006) - gml3.js and gml2.js don't follow file naming conventions ([@bartvde](https://github.com/bartvde))
 * [#3003](https://github.com/openlayers/ol3/pull/3003) - The writeFeatures method should always return a string (r=@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#3011](https://github.com/openlayers/ol3/pull/3011) - opt_options may not be defined, use options ([@pagameba](https://github.com/pagameba))
 * [#3009](https://github.com/openlayers/ol3/pull/3009) - Fix hit detection bug ([@elemoine](https://github.com/elemoine))
 * [#3002](https://github.com/openlayers/ol3/pull/3002) - Passing options to RegularShape is mandatory ([@elemoine](https://github.com/elemoine))
 * [#2967](https://github.com/openlayers/ol3/pull/2967) - Add support for drawing points with WebGL ([@camptocamp](https://github.com/camptocamp))
 * [#2701](https://github.com/openlayers/ol3/pull/2701) - Writing GeoJSON does not respect the feature's geometryName ([@bartvde](https://github.com/bartvde))
 * [#3000](https://github.com/openlayers/ol3/pull/3000) - Explain that return of ol.color.asArray should not be modified ([@bartvde](https://github.com/bartvde))
 * [#2997](https://github.com/openlayers/ol3/pull/2997) - Use new demo GeoServer location ([@ahocevar](https://github.com/ahocevar))
 * [#2976](https://github.com/openlayers/ol3/pull/2976) - Add an example to show off ol.style.RegularShape ([@bartvde](https://github.com/bartvde))
 * [#2992](https://github.com/openlayers/ol3/pull/2992) - Add support for finding features at a given coordinates for vector tiles - fixes ([@pgiraud](https://github.com/pgiraud))
 * [#2987](https://github.com/openlayers/ol3/pull/2987) - Image layer renderers use source projection if given and equivalent ([@kartverket](https://github.com/kartverket))
 * [#2975](https://github.com/openlayers/ol3/pull/2975) - Use offsetX and offsetY if available ([@fredj](https://github.com/fredj))
 * [#2973](https://github.com/openlayers/ol3/pull/2973) - Making GetTileCoordFor methods public avaible ([@s093294](https://github.com/s093294))
 * [#2986](https://github.com/openlayers/ol3/pull/2986) - Add support for finding features at a given coordinates for vector tiles ([@pgiraud](https://github.com/pgiraud))
 * [#2937](https://github.com/openlayers/ol3/pull/2937) - Clip layer rendering to limited extent. ([@tschaub](https://github.com/tschaub))
 * [#2971](https://github.com/openlayers/ol3/pull/2971) - Two ol.source.TileVector fixes ([@elemoine](https://github.com/elemoine))
 * [#2988](https://github.com/openlayers/ol3/pull/2988) - Correct olx.style.RegularShapeOptions definition (r=@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#2981](https://github.com/openlayers/ol3/pull/2981) - Use lineDash in ol.style.Circle's and ol.style.RegularShape's stroke (r=@fredj,@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#2982](https://github.com/openlayers/ol3/pull/2982) - Allow radius1 as an alias for radius in ol.style.RegularShape ([@bartvde](https://github.com/bartvde))
 * [#2980](https://github.com/openlayers/ol3/pull/2980) - Export ol.source.TileVector#getFeatures in built mode ([@pgiraud](https://github.com/pgiraud))
 * [#2979](https://github.com/openlayers/ol3/pull/2979) - Support OGC srs urns without an EPSG database version ([@bartvde](https://github.com/bartvde))
 * [#2978](https://github.com/openlayers/ol3/pull/2978) - Fix zoom levels for the MapQuest Street layer ([@ahocevar](https://github.com/ahocevar))
 * [#2889](https://github.com/openlayers/ol3/pull/2889) - Add GetFeatureInfo format ([@fgravin](https://github.com/fgravin))
 * [#2965](https://github.com/openlayers/ol3/pull/2965) - Fix pan with select interaction in mousemove mode. ([@tonio](https://github.com/tonio))
 * [#2960](https://github.com/openlayers/ol3/pull/2960) - LayerGroup extent should be used if extent not set on child layer ([@bartvde](https://github.com/bartvde))
 * [#2956](https://github.com/openlayers/ol3/pull/2956) - Revert "Remove mousewheel event name workaround" ([@fredj](https://github.com/fredj))
 * [#2959](https://github.com/openlayers/ol3/pull/2959) - Fix typo in selector ([@ahocevar](https://github.com/ahocevar))
 * [#2895](https://github.com/openlayers/ol3/pull/2895) - Move font-family customization to layout.css ([@fredj](https://github.com/fredj))
 * [#2896](https://github.com/openlayers/ol3/pull/2896) - Remove duplicated style parameter ([@kalinbas](https://github.com/kalinbas))
 * [#2938](https://github.com/openlayers/ol3/pull/2938) - Additional image static docs. ([@tschaub](https://github.com/tschaub))
 * [#2939](https://github.com/openlayers/ol3/pull/2939) - Make stability checkbox sticky. ([@tschaub](https://github.com/tschaub))
 * [#2949](https://github.com/openlayers/ol3/pull/2949) - Add ol.ext to hosted dir ([@elemoine](https://github.com/elemoine))
 * [#2943](https://github.com/openlayers/ol3/pull/2943) - Mark applyTransform api stable ([@fredj](https://github.com/fredj))
 * [#2936](https://github.com/openlayers/ol3/pull/2936) - Fix unselection of selected features ([@ahocevar](https://github.com/ahocevar))
 * [#2935](https://github.com/openlayers/ol3/pull/2935) - Fix jsdoc comment ([@geosense](https://github.com/geosense))
 * [#2933](https://github.com/openlayers/ol3/pull/2933) - Fix compile warning ([@elemoine](https://github.com/elemoine))
 * [#2931](https://github.com/openlayers/ol3/pull/2931) - Improvement to view docs ([@elemoine](https://github.com/elemoine))
 * [#2906](https://github.com/openlayers/ol3/pull/2906) - Assume a latitude, longitude order for Polyline format ([@fredj](https://github.com/fredj))
 * [#2927](https://github.com/openlayers/ol3/pull/2927) - Make it possible to programmatically finish drawing ([@elemoine](https://github.com/elemoine))
 * [#2928](https://github.com/openlayers/ol3/pull/2928) - Do not rename handleMapBrowserEvent internally ([@elemoine](https://github.com/elemoine))
 * [#2924](https://github.com/openlayers/ol3/pull/2924) - Readability rearangement in canvasmaprenderer.js ([@gberaudo](https://github.com/gberaudo))
 * [#2911](https://github.com/openlayers/ol3/pull/2911) - List events fired in the navigation. ([@tschaub](https://github.com/tschaub))
 * [#2921](https://github.com/openlayers/ol3/pull/2921) - Small feature overlay optimization ([@gberaudo](https://github.com/gberaudo))
 * [#2897](https://github.com/openlayers/ol3/pull/2897) - Remove pointerup listener on controls ([@fredj](https://github.com/fredj))
 * [#2912](https://github.com/openlayers/ol3/pull/2912) - jQuery externs update ([@fredj](https://github.com/fredj))
 * [#2888](https://github.com/openlayers/ol3/pull/2888) - Element boundedBy must not be set as geometry field on GML reading ([@fgravin](https://github.com/fgravin))
 * [#2903](https://github.com/openlayers/ol3/pull/2903) - Improved docs for icon options ([@elemoine](https://github.com/elemoine))
 * [#2900](https://github.com/openlayers/ol3/pull/2900) - Allow build.js task to add header. ([@tschaub](https://github.com/tschaub))
 * [#2893](https://github.com/openlayers/ol3/pull/2893) - Don't pass an object to goog.dom.createDom for the class name ([@fredj](https://github.com/fredj))
 * [#2781](https://github.com/openlayers/ol3/pull/2781) - Use a standard title attribute for the control buttons ([@fredj](https://github.com/fredj))
 * [#2852](https://github.com/openlayers/ol3/pull/2852) - Add missing space between class names ([@fredj](https://github.com/fredj))
 * [#2891](https://github.com/openlayers/ol3/pull/2891) - Introduce a load function for image sources ([@ahocevar](https://github.com/ahocevar))
 * [#2885](https://github.com/openlayers/ol3/pull/2885) - Add wrapX option to TileJSON source ([@elemoine](https://github.com/elemoine))
 * [#2890](https://github.com/openlayers/ol3/pull/2890) - Use correct layer property names ([@elemoine](https://github.com/elemoine))
 * [#2887](https://github.com/openlayers/ol3/pull/2887) - Explicitly pass coordinate dimension before transforming. ([@tschaub](https://github.com/tschaub))
 * [#2886](https://github.com/openlayers/ol3/pull/2886) - Use ternary notation ([@elemoine](https://github.com/elemoine))
 * [#2869](https://github.com/openlayers/ol3/pull/2869) - Export useful xml functions ([@tonio](https://github.com/tonio))
 * [#2884](https://github.com/openlayers/ol3/pull/2884) - Make WKT methods throw errors instead of calling a method that throws. ([@tschaub](https://github.com/tschaub))
 * [#2746](https://github.com/openlayers/ol3/pull/2746) - Add versioning for GML format ([@fgravin](https://github.com/fgravin))
 * [#2882](https://github.com/openlayers/ol3/pull/2882) - Allow olx.source.WMTSOptions#requestEncoding to be a string ([@fredj](https://github.com/fredj))
 * [#2881](https://github.com/openlayers/ol3/pull/2881) - Add default requestEncoding in documentation ([@fredj](https://github.com/fredj))
 * [#2877](https://github.com/openlayers/ol3/pull/2877) - Remove FIXME in src/ol/structs/rbush.js ([@fredj](https://github.com/fredj))
 * [#2870](https://github.com/openlayers/ol3/pull/2870) - Use bulk-insertion for addFeatures ([@tsauerwein](https://github.com/tsauerwein))
 * [#2856](https://github.com/openlayers/ol3/pull/2856) - Allow layer source to be set. ([@tschaub](https://github.com/tschaub))
 * [#2875](https://github.com/openlayers/ol3/pull/2875) - Avoid modifying `map.logos_` with each frame. ([@tschaub](https://github.com/tschaub))
 * [#2874](https://github.com/openlayers/ol3/pull/2874) - Avoid shrinking logos. ([@tschaub](https://github.com/tschaub))
 * [#2872](https://github.com/openlayers/ol3/pull/2872) - Remove the beforepropertychange event from ol.Object ([@fredj](https://github.com/fredj))
 * [#2868](https://github.com/openlayers/ol3/pull/2868) - Remove doc about dispatching events. ([@tschaub](https://github.com/tschaub))
 * [#2871](https://github.com/openlayers/ol3/pull/2871) - Make `npm install` a dependency of node based targets. ([@tschaub](https://github.com/tschaub))
 * [#2867](https://github.com/openlayers/ol3/pull/2867) - Support for importing CommonJS style modules (like rbush). ([@openlayers](https://github.com/openlayers))
 * [#2865](https://github.com/openlayers/ol3/pull/2865) - Add old value to property change events ([@elemoine](https://github.com/elemoine))
 * [#2866](https://github.com/openlayers/ol3/pull/2866) - Cluster source calls loadFeatures on vector source ([@elemoine](https://github.com/elemoine))
 * [#2864](https://github.com/openlayers/ol3/pull/2864) - Avoid mixed content in Bing Maps (r=@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#2855](https://github.com/openlayers/ol3/pull/2855) - Move touchstart preventDefault to ol.renderer.dom.Map ([@fredj](https://github.com/fredj))
 * [#2690](https://github.com/openlayers/ol3/pull/2690) - Vector rendering with the DOM renderer ([@ahocevar](https://github.com/ahocevar))
 * [#2859](https://github.com/openlayers/ol3/pull/2859) - Document exportable vector source symbols. ([@tschaub](https://github.com/tschaub))
 * [#2857](https://github.com/openlayers/ol3/pull/2857) - Update the OSM attribution. ([@tschaub](https://github.com/tschaub))
 * [#2847](https://github.com/openlayers/ol3/pull/2847) - Constrain center in zoomify example ([@elemoine](https://github.com/elemoine))
 * [#2838](https://github.com/openlayers/ol3/pull/2838) - ol.source.WMTS now passes tileClass option to ol.source.TileImage ([@mike-mcgann](https://github.com/mike-mcgann))
 * [#2821](https://github.com/openlayers/ol3/pull/2821) - Add ol.geom.Polygon.fromExtent ([@elemoine](https://github.com/elemoine))
 * [#2835](https://github.com/openlayers/ol3/pull/2835) - Use correct Stamen URL for SSL. ([@j16sdiz](https://github.com/j16sdiz))
 * [#2839](https://github.com/openlayers/ol3/pull/2839) - Dependency updates and new package name. ([@tschaub](https://github.com/tschaub))
 * [#2840](https://github.com/openlayers/ol3/pull/2840) - Fewer point resolution tests. ([@tschaub](https://github.com/tschaub))
 * [#2836](https://github.com/openlayers/ol3/pull/2836) - Give priority to feature's style instead of source's style ([@oterral](https://github.com/oterral))
 * [#2834](https://github.com/openlayers/ol3/pull/2834) - Use ADVANCED instead of ADVANCED_OPTIMIZATIONS ([@fredj](https://github.com/fredj))
 * [#2833](https://github.com/openlayers/ol3/pull/2833) - Avoid too many files open with graceful-fs@3.0.3. ([@tschaub](https://github.com/tschaub))
 * [#2829](https://github.com/openlayers/ol3/pull/2829) - Zoom slider refactor. ([@tschaub](https://github.com/tschaub))
 * [#2757](https://github.com/openlayers/ol3/pull/2757) - Clear the canvas on layer extent changes. ([@tschaub](https://github.com/tschaub))
 * [#2796](https://github.com/openlayers/ol3/pull/2796) - Determine image size on load. ([@tschaub](https://github.com/tschaub))
 * [#2825](https://github.com/openlayers/ol3/pull/2825) - Change comments for examples_star_json build target ([@elemoine](https://github.com/elemoine))
 * [#2822](https://github.com/openlayers/ol3/pull/2822) - Remove obsolete comment ([@gingerik](https://github.com/gingerik))
 * [#2769](https://github.com/openlayers/ol3/pull/2769) - OverviewMap control ([@adube](https://github.com/adube))
 * [#2820](https://github.com/openlayers/ol3/pull/2820) - Add parsing of LabelStyle in KML format ([@oterral](https://github.com/oterral))
 * [#2819](https://github.com/openlayers/ol3/pull/2819) - Improvements to the xyz-esri-4326-512 example ([@elemoine](https://github.com/elemoine))
 * [#2743](https://github.com/openlayers/ol3/pull/2743) - Handle ol.interaction.Draw activation/deactivation ([@elemoine](https://github.com/elemoine))
 * [#2816](https://github.com/openlayers/ol3/pull/2816) - Exit on check-examples failure ([@gberaudo](https://github.com/gberaudo))
 * [#2794](https://github.com/openlayers/ol3/pull/2794) - Add ol.Observable.unByKey ([@elemoine](https://github.com/elemoine))
 * [#2815](https://github.com/openlayers/ol3/pull/2815) - Fix jquery.min.js path in xyz-esri-4326-512 example ([@fredj](https://github.com/fredj))
 * [#2756](https://github.com/openlayers/ol3/pull/2756) - Add an example for using an Esri 512x512 tile server in EPSG:4326 (r=@elemoine) ([@bartvde](https://github.com/bartvde))
 * [#2814](https://github.com/openlayers/ol3/pull/2814) - Add missing whitespaces in CSS calc ([@fredj](https://github.com/fredj))
 * [#2811](https://github.com/openlayers/ol3/pull/2811) - Remove defaultProjection and object from typedef ([@fredj](https://github.com/fredj))
 * [#2779](https://github.com/openlayers/ol3/pull/2779) - Update jQuery to 1.9.1 ([@fredj](https://github.com/fredj))
 * [#2810](https://github.com/openlayers/ol3/pull/2810) - Remove unused properties from olx.source.TileVectorOptions ([@pagameba](https://github.com/pagameba))
 * [#2808](https://github.com/openlayers/ol3/pull/2808) - Remove reprojectTo option from olx.source.OSMXMLOptions ([@fredj](https://github.com/fredj))
 * [#2809](https://github.com/openlayers/ol3/pull/2809) - Miscellaneous controls cleanups ([@fredj](https://github.com/fredj))
 * [#2805](https://github.com/openlayers/ol3/pull/2805) - Enable subclassing Interaction in public API ([@sweco-sebhar](https://github.com/sweco-sebhar))
 * [#2798](https://github.com/openlayers/ol3/pull/2798) - Update closure-util to version 1.0.0 ([@fredj](https://github.com/fredj))
 * [#2785](https://github.com/openlayers/ol3/pull/2785) - Use goog.* types in externs ([@ahocevar](https://github.com/ahocevar))
 * [#2795](https://github.com/openlayers/ol3/pull/2795) - Externs ([@gingerik](https://github.com/gingerik))
 * [#2792](https://github.com/openlayers/ol3/pull/2792) - Use valid mediatype for GPX export. ([@pgiraud](https://github.com/pgiraud))
 * [#2784](https://github.com/openlayers/ol3/pull/2784) - Add 'tooltip'-tag to KML example. ([@marcjansen](https://github.com/marcjansen))
 * [#2782](https://github.com/openlayers/ol3/pull/2782) - Hide the rotate control when the rotation is 0 ([@fredj](https://github.com/fredj))
 * [#2774](https://github.com/openlayers/ol3/pull/2774) - Remove unused distinctFeatures object in ol.interaction.Modify#handlePointerDown ([@fredj](https://github.com/fredj))
 * [#2771](https://github.com/openlayers/ol3/pull/2771) - Allow package to be published in npm registry. ([@tschaub](https://github.com/tschaub))
 * [#2773](https://github.com/openlayers/ol3/pull/2773) - Type-related changes to ol.style.Image ([@elemoine](https://github.com/elemoine))
 * [#2751](https://github.com/openlayers/ol3/pull/2751) - Export constructors and options of ol.source.Source children ([@gberaudo](https://github.com/gberaudo))
 * [#2772](https://github.com/openlayers/ol3/pull/2772) - Rename updatefeature event to changefeature ([@fredj](https://github.com/fredj))
 * [#2766](https://github.com/openlayers/ol3/pull/2766) - Make interaction "active" an ol.Object property ([@elemoine](https://github.com/elemoine))
 * [#2765](https://github.com/openlayers/ol3/pull/2765) - Treat unknown opt types as Object in ol externs ([@elemoine](https://github.com/elemoine))
 * [#2759](https://github.com/openlayers/ol3/pull/2759) - Fix test failures. ([@tschaub](https://github.com/tschaub))
 * [#2762](https://github.com/openlayers/ol3/pull/2762) - Report test failures to the console. ([@tschaub](https://github.com/tschaub))
 * [#2768](https://github.com/openlayers/ol3/pull/2768) - Write the function name correctly in the doc. ([@xamgreen](https://github.com/xamgreen))
 * [#2764](https://github.com/openlayers/ol3/pull/2764) - Remove rtree example ([@fredj](https://github.com/fredj))
 * [#2763](https://github.com/openlayers/ol3/pull/2763) - Miscellaneous coding style and typo fixes ([@fredj](https://github.com/fredj))
 * [#2758](https://github.com/openlayers/ol3/pull/2758) - Correctly generate child tile ranges for XYZ tiles. ([@tschaub](https://github.com/tschaub))
 * [#2734](https://github.com/openlayers/ol3/pull/2734) - Add maxZoom option to BingMaps ([@elemoine](https://github.com/elemoine))
 * [#2752](https://github.com/openlayers/ol3/pull/2752) - Call loadFeatures from ol.source.ImageVector ([@elemoine](https://github.com/elemoine))
 * [#2658](https://github.com/openlayers/ol3/pull/2658) - Set inherited values when parsing a GetCapabilities ([@oterral](https://github.com/oterral))
 * [#2750](https://github.com/openlayers/ol3/pull/2750) - Export ol.layer.Base ([@fredj](https://github.com/fredj))
 * [#2749](https://github.com/openlayers/ol3/pull/2749) - Export ol.source.Source ([@fredj](https://github.com/fredj))
 * [#2742](https://github.com/openlayers/ol3/pull/2742) - Dispatch an 'updatefeature' from the vector source ([@fredj](https://github.com/fredj))
 * [#2747](https://github.com/openlayers/ol3/pull/2747) - Fix incorrect web address. ([@lazaruslarue](https://github.com/lazaruslarue))
 * [#2745](https://github.com/openlayers/ol3/pull/2745) - DragBox Interaction: getGeometry return type can be ol.geom.Polygon (r=@fredj) ([@bartvde](https://github.com/bartvde))
 * [#2744](https://github.com/openlayers/ol3/pull/2744) - Fix ol.Feature 'change' event documentation ([@fredj](https://github.com/fredj))
 * [#2741](https://github.com/openlayers/ol3/pull/2741) - issue with reading scientific notation coordinates in ol.format.GML (r=@fredj) ([@bartvde](https://github.com/bartvde))
 * [#2739](https://github.com/openlayers/ol3/pull/2739) - Revert "Function circular renamed to createCircularOnSphere" ([@elemoine](https://github.com/elemoine))
 * [#2616](https://github.com/openlayers/ol3/pull/2616) - Target for attribution links differs between maps ([@fredj](https://github.com/fredj))
 * [#2740](https://github.com/openlayers/ol3/pull/2740) - Make interactions activable and deactivable ([@elemoine](https://github.com/elemoine))
 * [#2727](https://github.com/openlayers/ol3/pull/2727) - Rename ol.geom.Polygon#circular to createCircularOnSphere ([@elemoine](https://github.com/elemoine))
 * [#2730](https://github.com/openlayers/ol3/pull/2730) - Do not call toLowerCase when forming a change:property event ([@elemoine](https://github.com/elemoine))
 * [#2728](https://github.com/openlayers/ol3/pull/2728) - Mark `ol.extent.getIntersection` as stable. ([@tschaub](https://github.com/tschaub))
 * [#2726](https://github.com/openlayers/ol3/pull/2726) - Make ol.Feature#setStyle accept null ([@elemoine](https://github.com/elemoine))
 * [#2724](https://github.com/openlayers/ol3/pull/2724) - Error when compiling individual example ([@fredj](https://github.com/fredj))
 * [#1959](https://github.com/openlayers/ol3/pull/1959) - Add a feature box selection example ([@elemoine](https://github.com/elemoine))
 * [#2722](https://github.com/openlayers/ol3/pull/2722) - Make ol.Map#setView do not accept undefined ([@elemoine](https://github.com/elemoine))
 * [#2696](https://github.com/openlayers/ol3/pull/2696) - Consistent circle transform. ([@gberaudo](https://github.com/gberaudo))
 * [#2717](https://github.com/openlayers/ol3/pull/2717) - Change the control visibility by using css class ([@fredj](https://github.com/fredj))
 * [#2715](https://github.com/openlayers/ol3/pull/2715) - Add an EPSG:3857 map to Tissot example ([@elemoine](https://github.com/elemoine))
 * [#2714](https://github.com/openlayers/ol3/pull/2714) - Set the opacity directly to element.style.opacity ([@fredj](https://github.com/fredj))
 * [#2647](https://github.com/openlayers/ol3/pull/2647) - Upgrade closure library version ([@fredj](https://github.com/fredj))
 * [#2549](https://github.com/openlayers/ol3/pull/2549) - Use goog.array.ASSUME_NATIVE_FUNCTIONS define ([@fredj](https://github.com/fredj))
 * [#2711](https://github.com/openlayers/ol3/pull/2711) - Remove Google Maps example ([@elemoine](https://github.com/elemoine))
 * [#2684](https://github.com/openlayers/ol3/pull/2684) - Rename ol.Observable#dispatchChangeEvent() to #changed() ([@ahocevar](https://github.com/ahocevar))
 * [#2678](https://github.com/openlayers/ol3/pull/2678) - Mutable symbolizer properties for styles ([@ahocevar](https://github.com/ahocevar))
 * [#2568](https://github.com/openlayers/ol3/pull/2568) - re-implement auto-configure code for ol.format.GML (r=@ahocevar) ([@bartvde](https://github.com/bartvde))
 * [#2704](https://github.com/openlayers/ol3/pull/2704) - Use pool thread for calling bin/check-example.js. ([@gberaudo](https://github.com/gberaudo))
 * [#2698](https://github.com/openlayers/ol3/pull/2698) - StaticVector is not an abstract base class ([@ahocevar](https://github.com/ahocevar))
 * [#2702](https://github.com/openlayers/ol3/pull/2702) - Add vector layer in export-map example ([@fredj](https://github.com/fredj))
 * [#2687](https://github.com/openlayers/ol3/pull/2687) - Use ol.LEGACY_IE_SUPPORT and ol.IS_LEGACY_IE define ([@fredj](https://github.com/fredj))
 * [#2675](https://github.com/openlayers/ol3/pull/2675) - Remove undefined from ol.Map#getLayers return type ([@fredj](https://github.com/fredj))
 * [#2692](https://github.com/openlayers/ol3/pull/2692) - Unset z-index in overlay example ([@fredj](https://github.com/fredj))
 * [#2681](https://github.com/openlayers/ol3/pull/2681) - Make tileSize a config option for ol.source.XYZ ([@ahocevar](https://github.com/ahocevar))
 * [#2534](https://github.com/openlayers/ol3/pull/2534) - Document ol.geom.Polygon#getLinearRing function ([@fredj](https://github.com/fredj))
 * [#2677](https://github.com/openlayers/ol3/pull/2677) - Add TextStyle offsets getters to API. ([@gberaudo](https://github.com/gberaudo))
 * [#2676](https://github.com/openlayers/ol3/pull/2676) - ol.FeatureOverlay: use the feature style if defined ([@fredj](https://github.com/fredj))
 * [#2656](https://github.com/openlayers/ol3/pull/2656) - Set ol.layer.Image#getSource return type to ol.source.Image ([@fredj](https://github.com/fredj))
 * [#2651](https://github.com/openlayers/ol3/pull/2651) - ol.layer.Vector.getSource return type specialisation. ([@gberaudo](https://github.com/gberaudo))
 * [#2669](https://github.com/openlayers/ol3/pull/2669) - Revert "snapshot" ([@fredj](https://github.com/fredj))
 * [#2663](https://github.com/openlayers/ol3/pull/2663) - Set tracking property to false on geolocation error ([@fredj](https://github.com/fredj))
 * [#2662](https://github.com/openlayers/ol3/pull/2662) - Delegate transformation in ol.source.FormatVector#readFeatures to `ol.format.*` ([@gingerik](https://github.com/gingerik))
 * [#2447](https://github.com/openlayers/ol3/pull/2447) - Correct documentation typo. ([@lazaruslarue](https://github.com/lazaruslarue))
 * [#2660](https://github.com/openlayers/ol3/pull/2660) - New domain in the build header ([@elemoine](https://github.com/elemoine))
