#!/bin/bash

if [[ -z $1 ]]; then
    echo "Usage: $0 <branch_name>"
    exit 1
fi

branch=$1
repo="build/ol3-gh-pages"

if [[ ! -d ${repo} ]]; then
    git clone git@github.com:elemoine/ol3.git ${repo}
fi

./build.py host-examples

pushd ${repo}
git fetch origin
git checkout gh-pages
git merge --ff-only origin/gh-pages
git rm --ignore-unmatch -rqf ${branch}
cp -r ../hosted/${branch} ./
git add -A .
git commit -m 'Update gh-pages'
git push origin gh-pages
popd
