const openpgp = typeof window !== 'undefined' && window.openpgp ? window.openpgp : require('../../../dist/openpgp');

const chai = require('chai');

const { util } = openpgp;
const { expect } = chai;

it('Twofish with test vectors from https://www.schneier.com/code/ecb_ival.txt', function(done) {
  function TFencrypt(block, key) {
    const tf = new openpgp.crypto.cipher.twofish(util.str_to_Uint8Array(key));

    return tf.encrypt(block);
  }

  const start = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
  const start_short = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
  const testvectors = [[0x57,0xFF,0x73,0x9D,0x4D,0xC9,0x2C,0x1B,0xD7,0xFC,0x01,0x70,0x0C,0xC8,0x21,0x6F],
            [0xD4,0x3B,0xB7,0x55,0x6E,0xA3,0x2E,0x46,0xF2,0xA2,0x82,0xB7,0xD4,0x5B,0x4E,0x0D],
            [0x90,0xAF,0xE9,0x1B,0xB2,0x88,0x54,0x4F,0x2C,0x32,0xDC,0x23,0x9B,0x26,0x35,0xE6],
            [0x6C,0xB4,0x56,0x1C,0x40,0xBF,0x0A,0x97,0x05,0x93,0x1C,0xB6,0xD4,0x08,0xE7,0xFA],
            [0x30,0x59,0xD6,0xD6,0x17,0x53,0xB9,0x58,0xD9,0x2F,0x47,0x81,0xC8,0x64,0x0E,0x58],
            [0xE6,0x94,0x65,0x77,0x05,0x05,0xD7,0xF8,0x0E,0xF6,0x8C,0xA3,0x8A,0xB3,0xA3,0xD6],
            [0x5A,0xB6,0x7A,0x5F,0x85,0x39,0xA4,0xA5,0xFD,0x9F,0x03,0x73,0xBA,0x46,0x34,0x66],
            [0xDC,0x09,0x6B,0xCD,0x99,0xFC,0x72,0xF7,0x99,0x36,0xD4,0xC7,0x48,0xE7,0x5A,0xF7],
            [0xC5,0xA3,0xE7,0xCE,0xE0,0xF1,0xB7,0x26,0x05,0x28,0xA6,0x8F,0xB4,0xEA,0x05,0xF2],
            [0x43,0xD5,0xCE,0xC3,0x27,0xB2,0x4A,0xB9,0x0A,0xD3,0x4A,0x79,0xD0,0x46,0x91,0x51]];
  testvectors[47] = [0x43,0x10,0x58,0xF4,0xDB,0xC7,0xF7,0x34,0xDA,0x4F,0x02,0xF0,0x4C,0xC4,0xF4,0x59];
  testvectors[48] = [0x37,0xFE,0x26,0xFF,0x1C,0xF6,0x61,0x75,0xF5,0xDD,0xF4,0xC3,0x3B,0x97,0xA2,0x05];

  for (let i = 0; i < 49; i++) {
    let res;
    let exp;
    let blk;
    let key;
    let ct;

    if (i === 0) {
      blk = start_short;
      key = util.Uint8Array_to_str(start);
      ct = testvectors[0];
      res = util.Uint8Array_to_str(TFencrypt(blk,key));
      exp = util.Uint8Array_to_str(ct);
    } else if (i === 1) {
      blk = testvectors[0];
      key = util.Uint8Array_to_str(start);
      ct = testvectors[1];
      res = util.Uint8Array_to_str(TFencrypt(blk,key));
      exp = util.Uint8Array_to_str(ct);
    } else if (i === 2) {
      blk = testvectors[i-1];
      key = util.Uint8Array_to_str(testvectors[i-2].concat(start_short));
      ct = testvectors[i];
      res = util.Uint8Array_to_str(TFencrypt(blk,key));
      exp = util.Uint8Array_to_str(ct);
    } else if (i < 10 || i > 46) {
      blk = testvectors[i-1];
      key = util.Uint8Array_to_str(testvectors[i-2].concat(testvectors[i-3]));
      ct = testvectors[i];
      res = util.Uint8Array_to_str(TFencrypt(blk,key));
      exp = util.Uint8Array_to_str(ct);
    } else {
      testvectors[i] = TFencrypt(testvectors[i-1],util.Uint8Array_to_str(testvectors[i-2].concat(testvectors[i-3])));
      continue;
    }
    expect(res, 'vector with block ' + util.Uint8Array_to_hex(blk) +
                ' with key ' + util.str_to_hex(key) +
                ' should be ' + util.Uint8Array_to_hex(ct) +
                ' but is ' + util.Uint8Array_to_hex(TFencrypt(blk,key))).to.equal(exp);
  }
  done();
});
