/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Context, ContextManager } from '@opentelemetry/context-base';
/**
 * Singleton object which represents the entry point to the OpenTelemetry Context API
 */
export declare class ContextAPI {
    private static _instance?;
    /** Empty private constructor prevents end users from constructing a new instance of the API */
    private constructor();
    /** Get the singleton instance of the Context API */
    static getInstance(): ContextAPI;
    /**
     * Set the current context manager. Returns the initialized context manager
     */
    setGlobalContextManager(contextManager: ContextManager): ContextManager;
    /**
     * Get the currently active context
     */
    active(): Context;
    /**
     * Execute a function with an active context
     *
     * @param context context to be active during function execution
     * @param fn function to execute in a context
     */
    with<T extends (...args: unknown[]) => ReturnType<T>>(context: Context, fn: T): ReturnType<T>;
    /**
     * Bind a context to a target function or event emitter
     *
     * @param target function or event emitter to bind
     * @param context context to bind to the event emitter or function. Defaults to the currently active context
     */
    bind<T>(target: T, context?: Context): T;
    private _getContextManager;
    /** Disable and remove the global context manager */
    disable(): void;
}
//# sourceMappingURL=context.d.ts.map