/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Meter } from '../metrics/Meter';
import { MeterProvider } from '../metrics/MeterProvider';
/**
 * Singleton object which represents the entry point to the OpenTelemetry Metrics API
 */
export declare class MetricsAPI {
    private static _instance?;
    /** Empty private constructor prevents end users from constructing a new instance of the API */
    private constructor();
    /** Get the singleton instance of the Metrics API */
    static getInstance(): MetricsAPI;
    /**
     * Set the current global meter. Returns the initialized global meter provider.
     */
    setGlobalMeterProvider(provider: MeterProvider): MeterProvider;
    /**
     * Returns the global meter provider.
     */
    getMeterProvider(): MeterProvider;
    /**
     * Returns a meter from the global meter provider.
     */
    getMeter(name: string, version?: string): Meter;
    /** Remove the global meter provider */
    disable(): void;
}
//# sourceMappingURL=metrics.d.ts.map