/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Tracer } from '../trace/tracer';
import { TracerProvider } from '../trace/tracer_provider';
/**
 * Singleton object which represents the entry point to the OpenTelemetry Tracing API
 */
export declare class TraceAPI {
    private static _instance?;
    /** Empty private constructor prevents end users from constructing a new instance of the API */
    private constructor();
    /** Get the singleton instance of the Trace API */
    static getInstance(): TraceAPI;
    /**
     * Set the current global tracer. Returns the initialized global tracer provider
     */
    setGlobalTracerProvider(provider: TracerProvider): TracerProvider;
    /**
     * Returns the global tracer provider.
     */
    getTracerProvider(): TracerProvider;
    /**
     * Returns a tracer from the global tracer provider.
     */
    getTracer(name: string, version?: string): Tracer;
    /** Remove the global tracer provider */
    disable(): void;
}
//# sourceMappingURL=trace.d.ts.map