"use strict";
/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const NoopTracerProvider_1 = require("../trace/NoopTracerProvider");
const global_utils_1 = require("./global-utils");
/**
 * Singleton object which represents the entry point to the OpenTelemetry Tracing API
 */
class TraceAPI {
    /** Empty private constructor prevents end users from constructing a new instance of the API */
    constructor() { }
    /** Get the singleton instance of the Trace API */
    static getInstance() {
        if (!this._instance) {
            this._instance = new TraceAPI();
        }
        return this._instance;
    }
    /**
     * Set the current global tracer. Returns the initialized global tracer provider
     */
    setGlobalTracerProvider(provider) {
        if (global_utils_1._global[global_utils_1.GLOBAL_TRACE_API_KEY]) {
            // global tracer provider has already been set
            return this.getTracerProvider();
        }
        global_utils_1._global[global_utils_1.GLOBAL_TRACE_API_KEY] = global_utils_1.makeGetter(global_utils_1.API_BACKWARDS_COMPATIBILITY_VERSION, provider, NoopTracerProvider_1.NOOP_TRACER_PROVIDER);
        return this.getTracerProvider();
    }
    /**
     * Returns the global tracer provider.
     */
    getTracerProvider() {
        var _a, _b, _c;
        return (_c = (_b = (_a = global_utils_1._global)[global_utils_1.GLOBAL_TRACE_API_KEY]) === null || _b === void 0 ? void 0 : _b.call(_a, global_utils_1.API_BACKWARDS_COMPATIBILITY_VERSION), (_c !== null && _c !== void 0 ? _c : NoopTracerProvider_1.NOOP_TRACER_PROVIDER));
    }
    /**
     * Returns a tracer from the global tracer provider.
     */
    getTracer(name, version) {
        return this.getTracerProvider().getTracer(name, version);
    }
    /** Remove the global tracer provider */
    disable() {
        delete global_utils_1._global[global_utils_1.GLOBAL_TRACE_API_KEY];
    }
}
exports.TraceAPI = TraceAPI;
//# sourceMappingURL=trace.js.map