"use strict";
/*!
 * Copyright 2019, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
__export(require("./context/propagation/getter"));
__export(require("./context/propagation/NoopHttpTextPropagator"));
__export(require("./context/propagation/setter"));
__export(require("./correlation_context/EntryValue"));
__export(require("./metrics/Metric"));
__export(require("./metrics/NoopMeter"));
__export(require("./metrics/NoopMeterProvider"));
__export(require("./trace/NoopSpan"));
__export(require("./trace/NoopTracer"));
__export(require("./trace/NoopTracerProvider"));
__export(require("./trace/span_kind"));
__export(require("./trace/status"));
__export(require("./trace/trace_flags"));
var context_base_1 = require("@opentelemetry/context-base");
exports.Context = context_base_1.Context;
const context_1 = require("./api/context");
/** Entrypoint for context API */
exports.context = context_1.ContextAPI.getInstance();
const trace_1 = require("./api/trace");
/** Entrypoint for trace API */
exports.trace = trace_1.TraceAPI.getInstance();
const metrics_1 = require("./api/metrics");
/** Entrypoint for metrics API */
exports.metrics = metrics_1.MetricsAPI.getInstance();
const propagation_1 = require("./api/propagation");
/** Entrypoint for propagation API */
exports.propagation = propagation_1.PropagationAPI.getInstance();
exports.default = {
    trace: exports.trace,
    metrics: exports.metrics,
    context: exports.context,
    propagation: exports.propagation,
};
//# sourceMappingURL=index.js.map