/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Metric Observable class to handle asynchronous metrics
 */
export interface MetricObservable {
    /**
     * Sets the next value for observable metric
     * @param value
     */
    next: (value: number) => void;
    /**
     * Subscribes for every value change
     * @param callback
     */
    subscribe: (callback: (value: number) => void) => void;
    /**
     * Removes the subscriber
     * @param [callback]
     */
    unsubscribe: (callback?: (value: number) => void) => void;
}
//# sourceMappingURL=MetricObservable.d.ts.map