/*!
 * Copyright 2019, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { TimeInput } from '../common/Time';
import { Attributes } from './attributes';
import { Span } from './span';
import { SpanContext } from './span_context';
import { Status } from './status';
export declare const INVALID_TRACE_ID = "0";
export declare const INVALID_SPAN_ID = "0";
/**
 * The NoopSpan is the default {@link Span} that is used when no Span
 * implementation is available. All operations are no-op including context
 * propagation.
 */
export declare class NoopSpan implements Span {
    private readonly _spanContext;
    constructor(_spanContext?: SpanContext);
    context(): SpanContext;
    setAttribute(key: string, value: unknown): this;
    setAttributes(attributes: Attributes): this;
    addEvent(name: string, attributes?: Attributes): this;
    setStatus(status: Status): this;
    updateName(name: string): this;
    end(endTime?: TimeInput): void;
    isRecording(): boolean;
}
export declare const NOOP_SPAN: NoopSpan;
//# sourceMappingURL=NoopSpan.d.ts.map