"use strict";
/*!
 * Copyright 2019, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const trace_flags_1 = require("./trace_flags");
exports.INVALID_TRACE_ID = '0';
exports.INVALID_SPAN_ID = '0';
const INVALID_SPAN_CONTEXT = {
    traceId: exports.INVALID_TRACE_ID,
    spanId: exports.INVALID_SPAN_ID,
    traceFlags: trace_flags_1.TraceFlags.NONE,
};
/**
 * The NoopSpan is the default {@link Span} that is used when no Span
 * implementation is available. All operations are no-op including context
 * propagation.
 */
class NoopSpan {
    constructor(_spanContext = INVALID_SPAN_CONTEXT) {
        this._spanContext = _spanContext;
    }
    // Returns a SpanContext.
    context() {
        return this._spanContext;
    }
    // By default does nothing
    setAttribute(key, value) {
        return this;
    }
    // By default does nothing
    setAttributes(attributes) {
        return this;
    }
    // By default does nothing
    addEvent(name, attributes) {
        return this;
    }
    // By default does nothing
    setStatus(status) {
        return this;
    }
    // By default does nothing
    updateName(name) {
        return this;
    }
    // By default does nothing
    end(endTime) { }
    // isRecording always returns false for noopSpan.
    isRecording() {
        return false;
    }
}
exports.NoopSpan = NoopSpan;
exports.NOOP_SPAN = new NoopSpan();
//# sourceMappingURL=NoopSpan.js.map