"use strict";
/*!
 * Copyright 2020, OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const NoopSpan_1 = require("./NoopSpan");
/**
 * No-op implementations of {@link Tracer}.
 */
class NoopTracer {
    getCurrentSpan() {
        return NoopSpan_1.NOOP_SPAN;
    }
    // startSpan starts a noop span.
    startSpan(name, options) {
        return NoopSpan_1.NOOP_SPAN;
    }
    withSpan(span, fn) {
        return fn();
    }
    bind(target, span) {
        return target;
    }
}
exports.NoopTracer = NoopTracer;
exports.NOOP_TRACER = new NoopTracer();
//# sourceMappingURL=NoopTracer.js.map