/*!
 *  opentok-angular (https://github.com/aullman/OpenTok-Angular)
 *
 *  Angular module for OpenTok
 *
 *  @Author: Adam Ullman (http://github.com/aullman)
 *  @Copyright (c) 2014 Adam Ullman
 *  @License: Released under the MIT license (http://opensource.org/licenses/MIT)
 **/
if(!window.OT)throw new Error("You must include the OT library before the OT_Angular library");var ng;ng="undefined"==typeof angular&&"undefined"!=typeof require?require("angular"):angular;var initLayoutContainer;initLayoutContainer=window.hasOwnProperty("initLayoutContainer")||"undefined"==typeof require?window.initLayoutContainer:require("opentok-layout-js").initLayoutContainer,ng.module("opentok",[]).factory("OT",function(){return OT}).factory("OTSession",["OT","$rootScope",function(e,n){var i={streams:[],connections:[],publishers:[],init:function(t,o,s,r){this.session=e.initSession(t,o),i.session.on({sessionConnected:function(){i.publishers.forEach(function(e){i.session.publish(e,function(i){i&&n.$broadcast("otPublisherError",i,e)})})},streamCreated:function(e){n.$apply(function(){i.streams.push(e.stream)})},streamDestroyed:function(e){n.$apply(function(){i.streams.splice(i.streams.indexOf(e.stream),1)})},sessionDisconnected:function(){n.$apply(function(){i.streams.splice(0,i.streams.length),i.connections.splice(0,i.connections.length)})},connectionCreated:function(e){n.$apply(function(){i.connections.push(e.connection)})},connectionDestroyed:function(e){n.$apply(function(){i.connections.splice(i.connections.indexOf(e.connection),1)})}}),this.session.connect(s,function(e){r&&r(e,i.session)}),this.trigger("init")},addPublisher:function(e){this.publishers.push(e),this.trigger("otPublisherAdded")}};return e.$.eventing(i),i}]).directive("otLayout",["$window","$parse","OT","OTSession",function(e,n,i,t){return{restrict:"E",scope:{props:"&"},link:function(n,i,o){var s=function(){var e=n.props()||{},t=initLayoutContainer(i[0],e);t.layout(),n.$emit("otLayoutComplete")};n.$watch(function(){return i.children().length},s),e.addEventListener("resize",s),n.$on("otLayout",s);var r=function(){t.session.on("streamPropertyChanged",function(e){"videoDimensions"===e.changedProperty&&s()})};t.session?r():t.on("init",r)}}}]).directive("otPublisher",["OTSession","$rootScope",function(e,n){return{restrict:"E",scope:{props:"&"},link:function(i,t,o){var s=i.props()||{};s.width=s.width?s.width:ng.element(t).width(),s.height=s.height?s.height:ng.element(t).height();var r=ng.element(t).children();i.publisher=OT.initPublisher(o.apikey||e.session.apiKey,t[0],s,function(e){e&&i.$emit("otPublisherError",e,i.publisher)}),ng.element(t).append(r),i.publisher.on({accessDenied:function(){i.$emit("otAccessDenied")},accessDialogOpened:function(){i.$emit("otAccessDialogOpened")},accessDialogClosed:function(){i.$emit("otAccessDialogClosed")},accessAllowed:function(){ng.element(t).addClass("allowed"),i.$emit("otAccessAllowed")},loaded:function(){n.$broadcast("otLayout")},streamCreated:function(e){i.$emit("otStreamCreated",e)},streamDestroyed:function(e){i.$emit("otStreamDestroyed",e)}}),i.$on("$destroy",function(){e.session?e.session.unpublish(i.publisher):i.publisher.destroy(),e.publishers=e.publishers.filter(function(e){return e!==i.publisher}),i.publisher=null}),e.session&&(e.session.connected||e.session.isConnected&&e.session.isConnected())&&e.session.publish(i.publisher,function(e){e&&i.$emit("otPublisherError",e,i.publisher)}),e.addPublisher(i.publisher)}}}]).directive("otSubscriber",["OTSession","$rootScope",function(e,n){return{restrict:"E",scope:{stream:"=",props:"&"},link:function(i,t){var o=i.stream,s=i.props()||{};s.width=s.width?s.width:ng.element(t).width(),s.height=s.height?s.height:ng.element(t).height();var r=ng.element(t).children(),c=e.session.subscribe(o,t[0],s,function(e){e&&i.$emit("otSubscriberError",e,c)});c.on("loaded",function(){n.$broadcast("otLayout")}),ng.element(t).append(r),i.$on("$destroy",function(){e.session.unsubscribe(c)})}}}]);