/*!
 * OverlayScrollbars
 * Version: 2.0.0-beta.3
 *
 * Copyright (c) Rene Haas | KingSora.
 * https://github.com/KingSora
 *
 * Released under the MIT license.
 */

var OverlayScrollbarsGlobal = function(r) {
  "use strict";
  function each(r, a) {
    if (p(r)) {
      for (var n = 0; n < r.length; n++) {
        if (false === a(r[n], n, r)) {
          break;
        }
      }
    } else if (r) {
      each(Object.keys(r), (function(n) {
        return a(r[n], n, r);
      }));
    }
    return r;
  }
  function style(r, a) {
    var n = c(a);
    var e = h(a) || n;
    if (e) {
      var t = n ? "" : {};
      if (r) {
        var i = window.getComputedStyle(r, null);
        t = n ? Hr(r, i, a) : a.reduce((function(a, n) {
          a[n] = Hr(r, i, n);
          return a;
        }), t);
      }
      return t;
    }
    r && each(P(a), (function(n) {
      return Mr(r, n, a[n]);
    }));
  }
  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function(r) {
      for (var a = 1; a < arguments.length; a++) {
        var n = arguments[a];
        for (var e in n) {
          if (Object.prototype.hasOwnProperty.call(n, e)) {
            r[e] = n[e];
          }
        }
      }
      return r;
    };
    return _extends.apply(this, arguments);
  }
  var a = function createCache(r, a) {
    var n = r.v, e = r.o, t = r.u;
    var i = n;
    var v;
    var o = function cacheUpdateContextual(r, a) {
      var n = i;
      var o = r;
      var u = a || (e ? !e(n, o) : n !== o);
      if (u || t) {
        i = o;
        v = n;
      }
      return [ i, u, v ];
    };
    var u = function cacheUpdateIsolated(r) {
      return o(a(i, v), r);
    };
    var f = function getCurrentCache(r) {
      return [ i, !!r, v ];
    };
    return [ a ? u : o, f ];
  };
  var n = function isClient() {
    return "undefined" !== typeof window;
  };
  var e = n() && Node.ELEMENT_NODE;
  var t = Object.prototype, i = t.toString, v = t.hasOwnProperty;
  var o = function isUndefined(r) {
    return void 0 === r;
  };
  var u = function isNull(r) {
    return null === r;
  };
  var f = function type(r) {
    return o(r) || u(r) ? "" + r : i.call(r).replace(/^\[object (.+)\]$/, "$1").toLowerCase();
  };
  var l = function isNumber(r) {
    return "number" === typeof r;
  };
  var c = function isString(r) {
    return "string" === typeof r;
  };
  var s = function isBoolean(r) {
    return "boolean" === typeof r;
  };
  var d = function isFunction(r) {
    return "function" === typeof r;
  };
  var h = function isArray(r) {
    return Array.isArray(r);
  };
  var g = function isObject(r) {
    return "object" === typeof r && !h(r) && !u(r);
  };
  var p = function isArrayLike(r) {
    var a = !!r && r.length;
    var n = l(a) && a > -1 && a % 1 == 0;
    return h(r) || !d(r) && n ? a > 0 && g(r) ? a - 1 in r : true : false;
  };
  var w = function isPlainObject(r) {
    if (!r || !g(r) || "object" !== f(r)) {
      return false;
    }
    var a;
    var n = "constructor";
    var e = r[n];
    var t = e && e.prototype;
    var i = v.call(r, n);
    var u = t && v.call(t, "isPrototypeOf");
    if (e && !i && !u) {
      return false;
    }
    for (a in r) {}
    return o(a) || v.call(r, a);
  };
  var b = function isHTMLElement(r) {
    var a = HTMLElement;
    return r ? a ? r instanceof a : r.nodeType === e : false;
  };
  var m = function isElement(r) {
    var a = Element;
    return r ? a ? r instanceof a : r.nodeType === e : false;
  };
  var y = function indexOf(r, a, n) {
    return r.indexOf(a, n);
  };
  var S = function push(r, a, n) {
    !n && !c(a) && p(a) ? Array.prototype.push.apply(r, a) : r.push(a);
    return r;
  };
  var C = function from(r) {
    var a = Array.from;
    var n = [];
    if (a && r) {
      return a(r);
    }
    if (r instanceof Set) {
      r.forEach((function(r) {
        S(n, r);
      }));
    } else {
      each(r, (function(r) {
        S(n, r);
      }));
    }
    return n;
  };
  var O = function isEmptyArray(r) {
    return !!r && 0 === r.length;
  };
  var x = function runEachAndClear(r, a, n) {
    var e = function runFn(r) {
      return r && r.apply(void 0, a || []);
    };
    each(r, e);
    !n && (r.length = 0);
  };
  var E = function hasOwnProperty(r, a) {
    return Object.prototype.hasOwnProperty.call(r, a);
  };
  var P = function keys(r) {
    return r ? Object.keys(r) : [];
  };
  var T = function assignDeep(r, a, n, e, t, i, v) {
    var o = [ a, n, e, t, i, v ];
    if (("object" !== typeof r || u(r)) && !d(r)) {
      r = {};
    }
    each(o, (function(a) {
      each(P(a), (function(n) {
        var e = a[n];
        if (r === e) {
          return true;
        }
        var t = h(e);
        if (e && (w(e) || t)) {
          var i = r[n];
          var v = i;
          if (t && !h(i)) {
            v = [];
          } else if (!t && !w(i)) {
            v = {};
          }
          r[n] = assignDeep(v, e);
        } else {
          r[n] = e;
        }
      }));
    }));
    return r;
  };
  var z = function isEmptyObject(r) {
    for (var a in r) {
      return false;
    }
    return true;
  };
  var A = function getSetProp(r, a, n, e) {
    if (o(e)) {
      return n ? n[r] : a;
    }
    n && (c(e) || l(e)) && (n[r] = e);
  };
  var L = function attr(r, a, n) {
    if (o(n)) {
      return r ? r.getAttribute(a) : null;
    }
    r && r.setAttribute(a, n);
  };
  var H = function attrClass(r, a, n, e) {
    if (n) {
      var t = L(r, a) || "";
      var i = new Set(t.split(" "));
      i[e ? "add" : "delete"](n);
      L(r, a, C(i).join(" ").trim());
    }
  };
  var M = function hasAttrClass(r, a, n) {
    var e = L(r, a) || "";
    var t = new Set(e.split(" "));
    return t.has(n);
  };
  var R = function removeAttr(r, a) {
    r && r.removeAttribute(a);
  };
  var D = function scrollLeft(r, a) {
    return A("scrollLeft", 0, r, a);
  };
  var I = function scrollTop(r, a) {
    return A("scrollTop", 0, r, a);
  };
  var k = n() && Element.prototype;
  var V = function find(r, a) {
    var n = [];
    var e = a ? m(a) ? a : null : document;
    return e ? S(n, e.querySelectorAll(r)) : n;
  };
  var B = function findFirst(r, a) {
    var n = a ? m(a) ? a : null : document;
    return n ? n.querySelector(r) : null;
  };
  var j = function is(r, a) {
    if (m(r)) {
      var n = k.matches || k.msMatchesSelector;
      return n.call(r, a);
    }
    return false;
  };
  var q = function contents(r) {
    return r ? C(r.childNodes) : [];
  };
  var F = function parent(r) {
    return r ? r.parentElement : null;
  };
  var U = function closest(r, a) {
    if (m(r)) {
      var n = k.closest;
      if (n) {
        return n.call(r, a);
      }
      do {
        if (j(r, a)) {
          return r;
        }
        r = F(r);
      } while (r);
    }
    return null;
  };
  var N = function liesBetween(r, a, n) {
    var e = r && U(r, a);
    var t = r && B(n, e);
    var i = U(t, a) === e;
    return e && t ? e === r || t === r || i && U(U(r, n), a) !== e : false;
  };
  var Y = function before(r, a, n) {
    if (n && r) {
      var e = a;
      var t;
      if (p(n)) {
        t = document.createDocumentFragment();
        each(n, (function(r) {
          if (r === e) {
            e = r.previousSibling;
          }
          t.appendChild(r);
        }));
      } else {
        t = n;
      }
      if (a) {
        if (!e) {
          e = r.firstChild;
        } else if (e !== a) {
          e = e.nextSibling;
        }
      }
      r.insertBefore(t, e || null);
    }
  };
  var W = function appendChildren(r, a) {
    Y(r, null, a);
  };
  var G = function insertBefore(r, a) {
    Y(F(r), r, a);
  };
  var X = function insertAfter(r, a) {
    Y(F(r), r && r.nextSibling, a);
  };
  var Z = function removeElements(r) {
    if (p(r)) {
      each(C(r), (function(r) {
        return removeElements(r);
      }));
    } else if (r) {
      var a = F(r);
      if (a) {
        a.removeChild(r);
      }
    }
  };
  var $ = function createDiv(r) {
    var a = document.createElement("div");
    if (r) {
      L(a, "class", r);
    }
    return a;
  };
  var J = function createDOM(r) {
    var a = $();
    a.innerHTML = r.trim();
    return each(q(a), (function(r) {
      return Z(r);
    }));
  };
  var K = function firstLetterToUpper(r) {
    return r.charAt(0).toUpperCase() + r.slice(1);
  };
  var Q = function getDummyStyle() {
    return $().style;
  };
  var rr = [ "-webkit-", "-moz-", "-o-", "-ms-" ];
  var ar = [ "WebKit", "Moz", "O", "MS", "webkit", "moz", "o", "ms" ];
  var nr = {};
  var er = {};
  var tr = function cssProperty(r) {
    var a = er[r];
    if (E(er, r)) {
      return a;
    }
    var n = K(r);
    var e = Q();
    each(rr, (function(t) {
      var i = t.replace(/-/g, "");
      var v = [ r, t + r, i + n, K(i) + n ];
      return !(a = v.find((function(r) {
        return void 0 !== e[r];
      })));
    }));
    return er[r] = a || "";
  };
  var ir = function jsAPI(r) {
    if (n()) {
      var a = nr[r] || window[r];
      if (E(nr, r)) {
        return a;
      }
      each(ar, (function(n) {
        a = a || window[n + K(r)];
        return !a;
      }));
      nr[r] = a;
      return a;
    }
  };
  var vr = ir("MutationObserver");
  var or = ir("IntersectionObserver");
  var ur = ir("ResizeObserver");
  var fr = ir("cancelAnimationFrame");
  var lr = ir("requestAnimationFrame");
  var cr = n() && window.setTimeout;
  var sr = n() && window.clearTimeout;
  var dr = function equal(r, a, n, e) {
    if (r && a) {
      var t = true;
      each(n, (function(n) {
        var i = e ? e(r[n]) : r[n];
        var v = e ? e(a[n]) : a[n];
        if (i !== v) {
          t = false;
        }
      }));
      return t;
    }
    return false;
  };
  var hr = function equalWH(r, a) {
    return dr(r, a, [ "w", "h" ]);
  };
  var gr = function equalXY(r, a) {
    return dr(r, a, [ "x", "y" ]);
  };
  var pr = function equalTRBL(r, a) {
    return dr(r, a, [ "t", "r", "b", "l" ]);
  };
  var _r = function equalBCRWH(r, a, n) {
    return dr(r, a, [ "width", "height" ], n && function(r) {
      return Math.round(r);
    });
  };
  var wr = function noop() {};
  var br = function selfClearTimeout(r) {
    var a;
    var n = r ? cr : lr;
    var e = r ? sr : fr;
    return [ function(t) {
      e(a);
      a = n(t, d(r) ? r() : r);
    }, function() {
      return e(a);
    } ];
  };
  var mr = function debounce(r, a) {
    var n;
    var e;
    var t;
    var i = wr;
    var v = a || {}, o = v.g, u = v.p, f = v._;
    var c = function invokeFunctionToDebounce(a) {
      i();
      sr(n);
      n = e = void 0;
      i = wr;
      r.apply(this, a);
    };
    var s = function mergeParms(r) {
      return f && e ? f(e, r) : r;
    };
    var h = function flush() {
      if (i !== wr) {
        c(s(t) || t);
      }
    };
    var g = function debouncedFn() {
      var r = C(arguments);
      var a = d(o) ? o() : o;
      var v = l(a) && a >= 0;
      if (v) {
        var f = d(u) ? u() : u;
        var g = l(f) && f >= 0;
        var p = a > 0 ? cr : lr;
        var w = a > 0 ? sr : fr;
        var b = s(r);
        var m = b || r;
        var y = c.bind(0, m);
        i();
        var S = p(y, a);
        i = function clear() {
          return w(S);
        };
        if (g && !n) {
          n = cr(h, f);
        }
        e = t = m;
      } else {
        c(r);
      }
    };
    g.m = h;
    return g;
  };
  var yr = Math.max;
  var Sr = function animationCurrentTime() {
    return performance.now();
  };
  var Cr = function animateNumber(r, a, n, e, t) {
    var i = 0;
    var v = Sr();
    var o = Math.max(0, n);
    var u = function frame(n) {
      var u = Sr();
      var f = u - v;
      var l = f >= o;
      var c = n ? 1 : 1 - (yr(0, v + o - u) / o || 0);
      var s = (a - r) * (d(t) ? t(c, c * o, 0, 1, o) : c) + r;
      var h = l || 1 === c;
      e && e(s, c, h);
      i = h ? 0 : lr((function() {
        return frame();
      }));
    };
    u();
    return function(r) {
      fr(i);
      r && u(r);
    };
  };
  var Or = /[^\x20\t\r\n\f]+/g;
  var xr = function classListAction(r, a, n) {
    var e = r && r.classList;
    var t;
    var i = 0;
    var v = false;
    if (e && a && c(a)) {
      var o = a.match(Or) || [];
      v = o.length > 0;
      while (t = o[i++]) {
        v = !!n(e, t) && v;
      }
    }
    return v;
  };
  var Er = function hasClass(r, a) {
    return xr(r, a, (function(r, a) {
      return r.contains(a);
    }));
  };
  var Pr = function removeClass(r, a) {
    xr(r, a, (function(r, a) {
      return r.remove(a);
    }));
  };
  var Tr = function addClass(r, a) {
    xr(r, a, (function(r, a) {
      return r.add(a);
    }));
    return Pr.bind(0, r, a);
  };
  var zr = {
    opacity: 1,
    zindex: 1
  };
  var Ar = function parseToZeroOrNumber(r, a) {
    var n = a ? parseFloat(r) : parseInt(r, 10);
    return n === n ? n : 0;
  };
  var Lr = function adaptCSSVal(r, a) {
    return !zr[r.toLowerCase()] && l(a) ? a + "px" : a;
  };
  var Hr = function getCSSVal(r, a, n) {
    return null != a ? a[n] || a.getPropertyValue(n) : r.style[n];
  };
  var Mr = function setCSSVal(r, a, n) {
    try {
      var e = r.style;
      if (!o(e[a])) {
        e[a] = Lr(a, n);
      } else {
        e.setProperty(a, n);
      }
    } catch (t) {}
  };
  var Rr = function directionIsRTL(r) {
    return "rtl" === style(r, "direction");
  };
  var Dr = function topRightBottomLeft(r, a, n) {
    var e = a ? a + "-" : "";
    var t = n ? "-" + n : "";
    var i = e + "top" + t;
    var v = e + "right" + t;
    var o = e + "bottom" + t;
    var u = e + "left" + t;
    var f = style(r, [ i, v, o, u ]);
    return {
      t: Ar(f[i], true),
      r: Ar(f[v], true),
      b: Ar(f[o], true),
      l: Ar(f[u], true)
    };
  };
  var Ir = Math.round;
  var kr = {
    w: 0,
    h: 0
  };
  var Vr = function windowSize() {
    return {
      w: window.innerWidth,
      h: window.innerHeight
    };
  };
  var Br = function offsetSize(r) {
    return r ? {
      w: r.offsetWidth,
      h: r.offsetHeight
    } : kr;
  };
  var jr = function clientSize(r) {
    return r ? {
      w: r.clientWidth,
      h: r.clientHeight
    } : kr;
  };
  var qr = function scrollSize(r) {
    return r ? {
      w: r.scrollWidth,
      h: r.scrollHeight
    } : kr;
  };
  var Fr = function fractionalSize(r) {
    var a = parseFloat(style(r, "height")) || 0;
    var n = parseFloat(style(r, "width")) || 0;
    return {
      w: n - Ir(n),
      h: a - Ir(a)
    };
  };
  var Ur = function getBoundingClientRect(r) {
    return r.getBoundingClientRect();
  };
  var Nr;
  var Yr = function supportPassiveEvents() {
    if (o(Nr)) {
      Nr = false;
      try {
        window.addEventListener("test", null, Object.defineProperty({}, "passive", {
          get: function get() {
            Nr = true;
          }
        }));
      } catch (r) {}
    }
    return Nr;
  };
  var Wr = function splitEventNames(r) {
    return r.split(" ");
  };
  var Gr = function off(r, a, n, e) {
    each(Wr(a), (function(a) {
      r.removeEventListener(a, n, e);
    }));
  };
  var Xr = function on(r, a, n, e) {
    var t;
    var i = Yr();
    var v = null != (t = i && e && e.S) ? t : i;
    var o = e && e.C || false;
    var u = e && e.O || false;
    var f = [];
    var l = i ? {
      passive: v,
      capture: o
    } : o;
    each(Wr(a), (function(a) {
      var e = u ? function(t) {
        r.removeEventListener(a, e, o);
        n && n(t);
      } : n;
      S(f, Gr.bind(null, r, a, e, o));
      r.addEventListener(a, e, l);
    }));
    return x.bind(0, f);
  };
  var Zr = function stopPropagation(r) {
    return r.stopPropagation();
  };
  var $r = function preventDefault(r) {
    return r.preventDefault();
  };
  var Jr = {
    x: 0,
    y: 0
  };
  var Kr = function absoluteCoordinates(r) {
    var a = r ? Ur(r) : 0;
    return a ? {
      x: a.left + window.pageYOffset,
      y: a.top + window.pageXOffset
    } : Jr;
  };
  var Qr = function manageListener(r, a) {
    each(h(a) ? a : [ a ], r);
  };
  var ra = function createEventListenerHub(r) {
    var a = new Map;
    var n = function removeEvent(r, n) {
      if (r) {
        var e = a.get(r);
        Qr((function(r) {
          if (e) {
            e[r ? "delete" : "clear"](r);
          }
        }), n);
      } else {
        a.forEach((function(r) {
          r.clear();
        }));
        a.clear();
      }
    };
    var e = function addEvent(r, e) {
      var t = a.get(r) || new Set;
      a.set(r, t);
      Qr((function(r) {
        r && t.add(r);
      }), e);
      return n.bind(0, r, e);
    };
    var t = function triggerEvent(r, n) {
      var e = a.get(r);
      each(C(e), (function(r) {
        if (n && !O(n)) {
          r.apply(0, n);
        } else {
          r();
        }
      }));
    };
    var i = P(r);
    each(i, (function(a) {
      e(a, r[a]);
    }));
    return [ e, n, t ];
  };
  var aa = function opsStringify(r) {
    return JSON.stringify(r, (function(r, a) {
      if (d(a)) {
        throw new Error;
      }
      return a;
    }));
  };
  var na = {
    paddingAbsolute: false,
    showNativeOverlaidScrollbars: false,
    update: {
      elementEvents: [ [ "img", "load" ] ],
      debounce: [ 0, 33 ],
      attributes: null,
      ignoreMutation: null
    },
    overflow: {
      x: "scroll",
      y: "scroll"
    },
    scrollbars: {
      theme: "os-theme-dark",
      visibility: "auto",
      autoHide: "never",
      autoHideDelay: 1300,
      dragScroll: true,
      clickScroll: false,
      pointers: [ "mouse", "touch", "pen" ]
    }
  };
  var ea = function getOptionsDiff(r, a) {
    var n = {};
    var e = P(a).concat(P(r));
    each(e, (function(e) {
      var t = r[e];
      var i = a[e];
      if (g(t) && g(i)) {
        T(n[e] = {}, getOptionsDiff(t, i));
        if (z(n[e])) {
          delete n[e];
        }
      } else if (E(a, e) && i !== t) {
        var v = true;
        if (h(t) || h(i)) {
          try {
            if (aa(t) === aa(i)) {
              v = false;
            }
          } catch (o) {}
        }
        if (v) {
          n[e] = i;
        }
      }
    }));
    return n;
  };
  var ta = "os-environment";
  var ia = ta + "-flexbox-glue";
  var va = ia + "-max";
  var oa = "data-overlayscrollbars";
  var ua = oa + "-overflow-x";
  var fa = oa + "-overflow-y";
  var la = "overflowVisible";
  var ca = "scrollbarHidden";
  var sa = "updating";
  var da = "os-padding";
  var ha = "os-viewport";
  var ga = ha + "-arrange";
  var pa = "os-content";
  var _a = ha + "-scrollbar-hidden";
  var wa = "os-overflow-visible";
  var ba = "os-size-observer";
  var ma = ba + "-appear";
  var ya = ba + "-listener";
  var Sa = ya + "-scroll";
  var Ca = ya + "-item";
  var Oa = Ca + "-final";
  var xa = "os-trinsic-observer";
  var Ea = "os-scrollbar";
  var Pa = Ea + "-rtl";
  var Ta = Ea + "-horizontal";
  var za = Ea + "-vertical";
  var Aa = Ea + "-track";
  var La = Ea + "-handle";
  var Ha = Ea + "-visible";
  var Ma = Ea + "-cornerless";
  var Ra = Ea + "-transitionless";
  var Da = Ea + "-interaction";
  var Ia = Ea + "-unusable";
  var ka = Ea + "-auto-hidden";
  var Va = Ea + "-wheel";
  var Ba = Aa + "-interactive";
  var ja = La + "-interactive";
  var qa = {};
  var Fa = function getPlugins() {
    return qa;
  };
  var Ua = function addPlugin(r) {
    var a = [];
    each(h(r) ? r : [ r ], (function(r) {
      var n = P(r);
      each(n, (function(n) {
        S(a, qa[n] = r[n]);
      }));
    }));
    return a;
  };
  var Na = {
    boolean: "__TPL_boolean_TYPE__",
    number: "__TPL_number_TYPE__",
    string: "__TPL_string_TYPE__",
    array: "__TPL_array_TYPE__",
    object: "__TPL_object_TYPE__",
    function: "__TPL_function_TYPE__",
    null: "__TPL_null_TYPE__"
  };
  var Ya = function validateRecursive(r, a, n, e) {
    var t = {};
    var i = _extends({}, a);
    var v = P(r).filter((function(r) {
      return E(a, r);
    }));
    each(v, (function(v) {
      var u = a[v];
      var l = r[v];
      var s = w(l);
      var d = e ? e + "." : "";
      if (s && w(u)) {
        var g = validateRecursive(l, u, n, d + v), p = g[0], b = g[1];
        t[v] = p;
        i[v] = b;
        each([ i, t ], (function(r) {
          if (z(r[v])) {
            delete r[v];
          }
        }));
      } else if (!s) {
        var m = false;
        var y = [];
        var C = [];
        var O = f(u);
        var x = !h(l) ? [ l ] : l;
        each(x, (function(r) {
          var a;
          each(Na, (function(n, e) {
            if (n === r) {
              a = e;
            }
          }));
          var n = o(a);
          if (n && c(u)) {
            var e = r.split(" ");
            m = !!e.find((function(r) {
              return r === u;
            }));
            S(y, e);
          } else {
            m = Na[O] === r;
          }
          S(C, n ? Na.string : a);
          return !m;
        }));
        if (m) {
          t[v] = u;
        } else if (n) {
          console.warn('The option "' + d + v + "\" wasn't set, because it doesn't accept the type [ " + O.toUpperCase() + ' ] with the value of "' + u + '".\r\n' + "Accepted types are: [ " + C.join(", ").toUpperCase() + " ].\r\n" + (y.length > 0 ? "\r\nValid strings are: [ " + y.join(", ") + " ]." : ""));
        }
        delete i[v];
      }
    }));
    return [ t, i ];
  };
  var Wa = function validateOptions(r, a, n) {
    return Ya(r, a, n);
  };
  var Ga = Na.number;
  var Xa = Na.boolean;
  var Za = [ Na.array, Na.null ];
  var $a = "hidden scroll visible visible-hidden";
  var Ja = "visible hidden auto";
  var Ka = "never scroll leavemove";
  var Qa = {
    paddingAbsolute: Xa,
    showNativeOverlaidScrollbars: Xa,
    update: {
      elementEvents: Za,
      attributes: Za,
      debounce: [ Na.number, Na.array, Na.null ],
      ignoreMutation: [ Na.function, Na.null ]
    },
    overflow: {
      x: $a,
      y: $a
    },
    scrollbars: {
      theme: [ Na.string, Na.null ],
      visibility: Ja,
      autoHide: Ka,
      autoHideDelay: Ga,
      dragScroll: Xa,
      clickScroll: Xa,
      pointers: [ Na.array, Na.null ]
    }
  };
  var rn = "__osOptionsValidationPlugin";
  /* @__PURE__ */  (function() {
    var r;
    return r = {}, r[rn] = {
      P: function _(r, a) {
        var n = Wa(Qa, r, a), e = n[0], t = n[1];
        return _extends({}, t, e);
      }
    }, r;
  })();
  var an = 3333333;
  var nn = "scroll";
  var en = "__osSizeObserverPlugin";
  var tn = /* @__PURE__ */ function() {
    var r;
    return r = {}, r[en] = {
      P: function _(r, a, n) {
        var e = J('<div class="' + Ca + '" dir="ltr"><div class="' + Ca + '"><div class="' + Oa + '"></div></div><div class="' + Ca + '"><div class="' + Oa + '" style="width: 200%; height: 200%"></div></div></div>');
        W(r, e);
        Tr(r, Sa);
        var t = e[0];
        var i = t.lastChild;
        var v = t.firstChild;
        var o = null == v ? void 0 : v.firstChild;
        var u = Br(t);
        var f = u;
        var l = false;
        var c;
        var s = function reset() {
          D(v, an);
          I(v, an);
          D(i, an);
          I(i, an);
        };
        var d = function onResized(r) {
          c = 0;
          if (l) {
            u = f;
            a(true === r);
          }
        };
        var h = function onScroll(r) {
          f = Br(t);
          l = !r || !hr(f, u);
          if (r) {
            Zr(r);
            if (l && !c) {
              fr(c);
              c = lr(d);
            }
          } else {
            d(false === r);
          }
          s();
        };
        var g = S([], [ Xr(v, nn, h), Xr(i, nn, h) ]);
        style(o, {
          width: an,
          height: an
        });
        lr(s);
        return [ n ? h.bind(0, false) : s, g ];
      }
    }, r;
  }();
  var vn = 0;
  var un = Math.round, fn = Math.abs;
  var ln = function getWindowDPR() {
    var r = window.screen.deviceXDPI || 0;
    var a = window.screen.logicalXDPI || 1;
    return window.devicePixelRatio || r / a;
  };
  var cn = function diffBiggerThanOne(r, a) {
    var n = fn(r);
    var e = fn(a);
    return !(n === e || n + 1 === e || n - 1 === e);
  };
  var sn = "__osScrollbarsHidingPlugin";
  var dn = /* @__PURE__ */ function() {
    var r;
    return r = {}, r[sn] = {
      T: function _createUniqueViewportArrangeElement(r) {
        var a = r.A, n = r.L, e = r.H;
        var t = !e && !a && (n.x || n.y);
        var i = t ? document.createElement("style") : false;
        if (i) {
          L(i, "id", ga + "-" + vn);
          vn++;
        }
        return i;
      },
      M: function _overflowUpdateSegment(r, a, n, e, t, i, v) {
        var o = function arrangeViewport(a, i, v, o) {
          if (r) {
            var u = t(), f = u.R;
            var l = a.D, c = a.I;
            var s = c.x, d = c.y;
            var h = l.x, g = l.y;
            var p = o ? "paddingRight" : "paddingLeft";
            var w = f[p];
            var b = f.paddingTop;
            var m = i.w + v.w;
            var y = i.h + v.h;
            var S = {
              w: g && d ? g + m - w + "px" : "",
              h: h && s ? h + y - b + "px" : ""
            };
            if (e) {
              var C = e.sheet;
              if (C) {
                var O = C.cssRules;
                if (O) {
                  if (!O.length) {
                    C.insertRule("#" + L(e, "id") + " + ." + ga + "::before {}", 0);
                  }
                  var x = O[0].style;
                  x.width = S.w;
                  x.height = S.h;
                }
              }
            } else {
              style(n, {
                "--os-vaw": S.w,
                "--os-vah": S.h
              });
            }
          }
          return r;
        };
        var u = function undoViewportArrange(e, o, u) {
          if (r) {
            var f = u || i(e);
            var l = t(), c = l.R;
            var s = f.I;
            var d = s.x, h = s.y;
            var g = {};
            var p = function assignProps(r) {
              return each(r.split(" "), (function(r) {
                g[r] = c[r];
              }));
            };
            if (d) {
              p("marginBottom paddingTop paddingBottom");
            }
            if (h) {
              p("marginLeft marginRight paddingLeft paddingRight");
            }
            var w = style(n, P(g));
            Pr(n, ga);
            if (!a) {
              g.height = "";
            }
            style(n, g);
            return [ function() {
              v(f, o, r, w);
              style(n, w);
              Tr(n, ga);
            }, f ];
          }
          return [ wr ];
        };
        return [ o, u ];
      },
      k: function _envWindowZoom() {
        var r = {
          w: 0,
          h: 0
        };
        var a = 0;
        return function(n, e, t) {
          var i = Vr();
          var v = {
            w: i.w - r.w,
            h: i.h - r.h
          };
          if (0 === v.w && 0 === v.h) {
            return;
          }
          var o = {
            w: fn(v.w),
            h: fn(v.h)
          };
          var u = {
            w: fn(un(i.w / (r.w / 100))),
            h: fn(un(i.h / (r.h / 100)))
          };
          var f = ln();
          var l = o.w > 2 && o.h > 2;
          var c = !cn(u.w, u.h);
          var s = f !== a && f > 0;
          var d = l && c && s;
          if (d) {
            var h = e(), g = h[0], p = h[1];
            T(n.V, g);
            if (p) {
              t();
            }
          }
          r = i;
          a = f;
        };
      }
    }, r;
  }();
  var hn = "__osClickScrollPlugin";
  var gn = /* @__PURE__ */ function() {
    var r;
    return r = {}, r[hn] = {
      P: function _(r, a, n, e, t) {
        var i = 0;
        var v = wr;
        var o = function animateClickScroll(o) {
          v = Cr(o, o + e * Math.sign(n), 133, (function(n, o, u) {
            r(n);
            var f = a();
            var l = f + e;
            var c = t >= f && t <= l;
            if (u && !c) {
              if (i) {
                animateClickScroll(n);
              } else {
                var s = setTimeout((function() {
                  animateClickScroll(n);
                }), 222);
                v = function clear() {
                  clearTimeout(s);
                };
              }
              i++;
            }
          }));
        };
        o(0);
        return function() {
          return v();
        };
      }
    }, r;
  }();
  var pn;
  var _n = function getNativeScrollbarSize(r, a, n, e) {
    W(r, a);
    var t = jr(a);
    var i = Br(a);
    var v = Fr(n);
    e && Z(a);
    return {
      x: i.h - t.h + v.h,
      y: i.w - t.w + v.w
    };
  };
  var wn = function getNativeScrollbarsHiding(r) {
    var a = false;
    var n = Tr(r, _a);
    try {
      a = "none" === style(r, tr("scrollbar-width")) || "none" === window.getComputedStyle(r, "::-webkit-scrollbar").getPropertyValue("display");
    } catch (e) {}
    n();
    return a;
  };
  var bn = function getRtlScrollBehavior(r, a) {
    var n = "hidden";
    style(r, {
      overflowX: n,
      overflowY: n,
      direction: "rtl"
    });
    D(r, 0);
    var e = Kr(r);
    var t = Kr(a);
    D(r, -999);
    var i = Kr(a);
    return {
      i: e.x === t.x,
      n: t.x !== i.x
    };
  };
  var mn = function getFlexboxGlue(r, a) {
    var n = Tr(r, ia);
    var e = Ur(r);
    var t = Ur(a);
    var i = _r(t, e, true);
    var v = Tr(r, va);
    var o = Ur(r);
    var u = Ur(a);
    var f = _r(u, o, true);
    n();
    v();
    return i && f;
  };
  var yn = function createEnvironment() {
    var r = document, n = r.body;
    var e = J('<div class="' + ta + '"><div></div></div>');
    var t = e[0];
    var i = t.firstChild;
    var v = ra(), o = v[0], u = v[2];
    var f = a({
      v: _n(n, t, i),
      o: gr
    }, _n.bind(0, n, t, i, true)), l = f[0], c = f[1];
    var s = c(), d = s[0];
    var h = wn(t);
    var g = {
      x: 0 === d.x,
      y: 0 === d.y
    };
    var p = {
      elements: {
        host: null,
        padding: !h,
        viewport: function viewport(r) {
          return h && r === r.ownerDocument.body && r;
        },
        content: false
      },
      scrollbars: {
        slot: true
      },
      cancel: {
        nativeScrollbarsOverlaid: false,
        body: null
      }
    };
    var w = T({}, na);
    var b = {
      V: d,
      L: g,
      A: h,
      H: "-1" === style(t, "zIndex"),
      B: bn(t, i),
      j: mn(t, i),
      q: function _addListener(r) {
        return o("_", r);
      },
      F: T.bind(0, {}, p),
      U: function _setDefaultInitialization(r) {
        T(p, r);
      },
      N: T.bind(0, {}, w),
      Y: function _setDefaultOptions(r) {
        T(w, r);
      },
      W: T({}, p),
      G: T({}, w)
    };
    R(t, "style");
    Z(t);
    if (!h && (!g.x || !g.y)) {
      var m;
      window.addEventListener("resize", (function() {
        var r = Fa()[sn];
        m = m || r && r.k();
        m && m(b, l, u.bind(0, "_"));
      }));
    }
    return b;
  };
  var Sn = function getEnvironment() {
    if (!pn) {
      pn = yn();
    }
    return pn;
  };
  var Cn = function resolveInitialization(r, a) {
    return d(r) ? r.apply(0, a) : r;
  };
  var On = function staticInitializationElement(r, a, n, e) {
    var t = o(e) ? n : e;
    var i = Cn(t, r);
    return i || a.apply(0, r);
  };
  var xn = function dynamicInitializationElement(r, a, n, e) {
    var t = o(e) ? n : e;
    var i = Cn(t, r);
    return !!i && (b(i) ? i : a.apply(0, r));
  };
  var En = function cancelInitialization(r, a, n) {
    var e = n || {}, t = e.nativeScrollbarsOverlaid, i = e.body;
    var v = Sn(), f = v.L, l = v.A;
    var c = a.nativeScrollbarsOverlaid, s = a.body;
    var d = null != t ? t : c;
    var h = o(i) ? s : i;
    var g = (f.x || f.y) && d;
    var p = r && (u(h) ? !l : h);
    return !!g || !!p;
  };
  var Pn = new WeakMap;
  var Tn = function addInstance(r, a) {
    Pn.set(r, a);
  };
  var zn = function removeInstance(r) {
    Pn.delete(r);
  };
  var An = function getInstance(r) {
    return Pn.get(r);
  };
  var Ln = function getPropByPath(r, a) {
    return r ? a.split(".").reduce((function(r, a) {
      return r && E(r, a) ? r[a] : void 0;
    }), r) : void 0;
  };
  var Hn = function createOptionCheck(r, a, n) {
    return function(e) {
      return [ Ln(r, e), n || void 0 !== Ln(a, e) ];
    };
  };
  var Mn = function createState(r) {
    var a = r;
    return [ function() {
      return a;
    }, function(r) {
      a = T({}, a, r);
    } ];
  };
  var Rn = "tabindex";
  var Dn = $.bind(0, "");
  var In = function unwrap(r) {
    W(F(r), q(r));
    Z(r);
  };
  var kn = function createStructureSetupElements(r) {
    var a = Sn();
    var n = a.F, e = a.A;
    var t = Fa()[sn];
    var i = t && t.T;
    var v = n(), o = v.elements;
    var u = o.host, f = o.viewport, l = o.padding, c = o.content;
    var s = b(r);
    var d = s ? {} : r;
    var h = d.elements;
    var g = h || {}, p = g.host, w = g.padding, m = g.viewport, C = g.content;
    var O = s ? r : d.target;
    var E = j(O, "textarea");
    var T = O.ownerDocument;
    var z = T.documentElement;
    var A = O === T.body;
    var D = T.defaultView;
    var I = On.bind(0, [ O ]);
    var k = xn.bind(0, [ O ]);
    var V = I(Dn, f, m);
    var B = V === O;
    var U = B && A;
    var N = T.activeElement;
    var Y = !B && D.top === D && N === O;
    var $ = {
      X: O,
      Z: E ? I(Dn, u, p) : O,
      $: V,
      J: !B && k(Dn, l, w),
      K: !B && k(Dn, c, C),
      rr: !B && !e && i && i(a),
      ar: U ? z : V,
      nr: U ? T : V,
      er: D,
      tr: T,
      ir: E,
      vr: A,
      ur: s,
      lr: B,
      cr: function _viewportHasClass(r, a) {
        return B ? M(V, oa, a) : Er(V, r);
      },
      sr: function _viewportAddRemoveClass(r, a, n) {
        return B ? H(V, oa, a, n) : (n ? Tr : Pr)(V, r);
      }
    };
    var J = P($).reduce((function(r, a) {
      var n = $[a];
      return S(r, n && !F(n) ? n : false);
    }), []);
    var K = function elementIsGenerated(r) {
      return r ? y(J, r) > -1 : null;
    };
    var Q = $.X, rr = $.Z, ar = $.J, nr = $.$, er = $.K, tr = $.rr;
    var ir = [ function() {
      R(rr, oa);
      if (A) {
        R(z, oa);
      }
    } ];
    var vr = E && K(rr);
    var or = E ? Q : q([ er, nr, ar, rr, Q ].find((function(r) {
      return false === K(r);
    })));
    var ur = er || nr;
    var fr = function appendElements() {
      L(rr, oa, B ? "viewport" : "host");
      var r = Tr(ar, da);
      var a = Tr(nr, !B && ha);
      var n = Tr(er, pa);
      var t = A ? Tr(F(O), _a) : wr;
      if (vr) {
        X(Q, rr);
        S(ir, (function() {
          X(rr, Q);
          Z(rr);
        }));
      }
      W(ur, or);
      W(rr, ar);
      W(ar || rr, !B && nr);
      W(nr, er);
      S(ir, (function() {
        t();
        R(nr, ua);
        R(nr, fa);
        if (K(er)) {
          In(er);
        }
        if (K(nr)) {
          In(nr);
        }
        if (K(ar)) {
          In(ar);
        }
        r();
        a();
        n();
      }));
      if (e && !B) {
        S(ir, Pr.bind(0, nr, _a));
      }
      if (tr) {
        G(nr, tr);
        S(ir, Z.bind(0, tr));
      }
      if (Y) {
        var i = L(nr, Rn);
        L(nr, Rn, "-1");
        nr.focus();
        var v = Xr(T, "pointerdown keydown", (function() {
          i ? L(nr, Rn, i) : R(nr, Rn);
          v();
        }));
      } else if (N && N.focus) {
        N.focus();
      }
      or = 0;
    };
    return [ $, fr, x.bind(0, ir) ];
  };
  var Vn = function createTrinsicUpdateSegment(r, a) {
    var n = r.K;
    var e = a[0];
    return function(r) {
      var a = Sn(), t = a.j;
      var i = e(), v = i.dr;
      var o = r.hr;
      var u = (n || !t) && o;
      if (u) {
        style(n, {
          height: v ? "" : "100%"
        });
      }
      return {
        gr: u,
        pr: u
      };
    };
  };
  var Bn = function createPaddingUpdateSegment(r, n) {
    var e = n[0], t = n[1];
    var i = r.Z, v = r.J, o = r.$, u = r.lr;
    var f = a({
      o: pr,
      v: Dr()
    }, Dr.bind(0, i, "padding", "")), l = f[0], c = f[1];
    return function(r, a, n) {
      var i = c(n), f = i[0], s = i[1];
      var d = Sn(), h = d.A, g = d.j;
      var p = e(), w = p._r;
      var b = r.gr, m = r.pr, y = r.wr;
      var S = a("paddingAbsolute"), C = S[0], O = S[1];
      var x = !g && m;
      if (b || s || x) {
        var E = l(n);
        f = E[0];
        s = E[1];
      }
      var P = !u && (O || y || s);
      if (P) {
        var z = !C || !v && !h;
        var A = f.r + f.l;
        var L = f.t + f.b;
        var H = {
          marginRight: z && !w ? -A : 0,
          marginBottom: z ? -L : 0,
          marginLeft: z && w ? -A : 0,
          top: z ? -f.t : 0,
          right: z ? w ? -f.r : "auto" : 0,
          left: z ? w ? "auto" : -f.l : 0,
          width: z ? "calc(100% + " + A + "px)" : ""
        };
        var M = {
          paddingTop: z ? f.t : 0,
          paddingRight: z ? f.r : 0,
          paddingBottom: z ? f.b : 0,
          paddingLeft: z ? f.l : 0
        };
        style(v || o, H);
        style(o, M);
        t({
          J: f,
          br: !z,
          R: v ? M : T({}, H, M)
        });
      }
      return {
        mr: P
      };
    };
  };
  var jn = Math.max;
  var qn = jn.bind(0, 0);
  var Fn = "visible";
  var Un = "hidden";
  var Nn = 42;
  var Yn = {
    o: hr,
    v: {
      w: 0,
      h: 0
    }
  };
  var Wn = {
    o: gr,
    v: {
      x: Un,
      y: Un
    }
  };
  var Gn = function getOverflowAmount(r, a) {
    var n = window.devicePixelRatio % 1 !== 0 ? 1 : 0;
    var e = {
      w: qn(r.w - a.w),
      h: qn(r.h - a.h)
    };
    return {
      w: e.w > n ? e.w : 0,
      h: e.h > n ? e.h : 0
    };
  };
  var Xn = function conditionalClass(r, a, n) {
    return n ? Tr(r, a) : Pr(r, a);
  };
  var Zn = function overflowIsVisible(r) {
    return 0 === r.indexOf(Fn);
  };
  var $n = function createOverflowUpdateSegment(r, n) {
    var e = n[0], t = n[1];
    var i = r.Z, v = r.J, o = r.$, u = r.rr, f = r.lr, l = r.sr, c = r.vr, s = r.er;
    var d = Sn(), h = d.V, g = d.j, p = d.A, w = d.L;
    var b = Fa()[sn];
    var m = !f && !p && (w.x || w.y);
    var y = c && f;
    var S = a(Yn, Fr.bind(0, o)), C = S[0], O = S[1];
    var x = a(Yn, qr.bind(0, o)), E = x[0], P = x[1];
    var T = a(Yn), z = T[0], A = T[1];
    var M = a(Yn), R = M[0], D = M[1];
    var I = a(Wn), k = I[0];
    var V = function fixFlexboxGlue(r, a) {
      style(o, {
        height: ""
      });
      if (a) {
        var n = e(), t = n.br, v = n.J;
        var u = r.yr, f = r.D;
        var l = Fr(i);
        var c = jr(i);
        var s = "content-box" === style(o, "boxSizing");
        var d = t || s ? v.b + v.t : 0;
        var h = !(w.x && s);
        style(o, {
          height: c.h + l.h + (u.x && h ? f.x : 0) - d
        });
      }
    };
    var B = function getViewportOverflowState(r, a) {
      var n = !p && !r ? Nn : 0;
      var e = function getStatePerAxis(r, e, t) {
        var i = style(o, r);
        var v = a ? a[r] : i;
        var u = "scroll" === v;
        var f = e ? n : t;
        var l = u && !p ? f : 0;
        var c = e && !!n;
        return [ i, u, l, c ];
      };
      var t = e("overflowX", w.x, h.x), i = t[0], v = t[1], u = t[2], f = t[3];
      var l = e("overflowY", w.y, h.y), c = l[0], s = l[1], d = l[2], g = l[3];
      return {
        Sr: {
          x: i,
          y: c
        },
        yr: {
          x: v,
          y: s
        },
        D: {
          x: u,
          y: d
        },
        I: {
          x: f,
          y: g
        }
      };
    };
    var j = function setViewportOverflowState(r, a, n, e) {
      var t = function setAxisOverflowStyle(r, a) {
        var n = Zn(r);
        var e = a && n && r.replace(Fn + "-", "") || "";
        return [ a && !n ? r : "", Zn(e) ? "hidden" : e ];
      };
      var i = t(n.x, a.x), v = i[0], o = i[1];
      var u = t(n.y, a.y), f = u[0], l = u[1];
      e.overflowX = o && f ? o : v;
      e.overflowY = l && v ? l : f;
      return B(r, e);
    };
    var q = function hideNativeScrollbars(r, a, n, t) {
      var i = r.D, v = r.I;
      var o = v.x, u = v.y;
      var f = i.x, l = i.y;
      var c = e(), s = c.R;
      var d = a ? "marginLeft" : "marginRight";
      var h = a ? "paddingLeft" : "paddingRight";
      var g = s[d];
      var p = s.marginBottom;
      var w = s[h];
      var b = s.paddingBottom;
      t.width = "calc(100% + " + (l + -1 * g) + "px)";
      t[d] = -l + g;
      t.marginBottom = -f + p;
      if (n) {
        t[h] = w + (u ? l : 0);
        t.paddingBottom = b + (o ? f : 0);
      }
    };
    var F = b ? b.M(m, g, o, u, e, B, q) : [ function() {
      return m;
    }, function() {
      return [ wr ];
    } ], U = F[0], N = F[1];
    return function(r, a, n) {
      var u = r.gr, c = r.Cr, d = r.pr, h = r.mr, b = r.hr, m = r.wr;
      var S = e(), x = S.dr, T = S._r;
      var M = a("showNativeOverlaidScrollbars"), I = M[0], F = M[1];
      var Y = a("overflow"), W = Y[0], G = Y[1];
      var X = I && w.x && w.y;
      var Z = !f && !g && (u || d || c || F || b);
      var $ = Zn(W.x);
      var J = Zn(W.y);
      var K = $ || J;
      var Q = O(n);
      var rr = P(n);
      var ar = A(n);
      var nr = D(n);
      var er;
      if (F && p) {
        l(_a, ca, !X);
      }
      if (Z) {
        er = B(X);
        V(er, x);
      }
      if (u || h || d || m || F) {
        if (K) {
          l(wa, la, false);
        }
        var tr = N(X, T, er), ir = tr[0], vr = tr[1];
        var or = Q = C(n), ur = or[0], fr = or[1];
        var lr = rr = E(n), cr = lr[0], sr = lr[1];
        var dr = jr(o);
        var hr = cr;
        var gr = dr;
        ir();
        if ((sr || fr || F) && vr && !X && U(vr, cr, ur, T)) {
          gr = jr(o);
          hr = qr(o);
        }
        var pr = {
          w: qn(jn(cr.w, hr.w) + ur.w),
          h: qn(jn(cr.h, hr.h) + ur.h)
        };
        var _r = {
          w: qn((y ? s.innerWidth : gr.w + qn(dr.w - cr.w)) + ur.w),
          h: qn((y ? s.innerHeight + ur.h : gr.h + qn(dr.h - cr.h)) + ur.h)
        };
        nr = R(_r);
        ar = z(Gn(pr, _r), n);
      }
      var wr = nr, br = wr[0], mr = wr[1];
      var yr = ar, Sr = yr[0], Cr = yr[1];
      var Or = rr, xr = Or[0], Er = Or[1];
      var Pr = Q, Tr = Pr[0], zr = Pr[1];
      var Ar = {
        x: Sr.w > 0,
        y: Sr.h > 0
      };
      var Lr = $ && J && (Ar.x || Ar.y) || $ && Ar.x && !Ar.y || J && Ar.y && !Ar.x;
      if (h || m || zr || Er || mr || Cr || G || F || Z) {
        var Hr = {
          marginRight: 0,
          marginBottom: 0,
          marginLeft: 0,
          width: "",
          overflowY: "",
          overflowX: ""
        };
        var Mr = j(X, Ar, W, Hr);
        var Rr = U(Mr, xr, Tr, T);
        if (!f) {
          q(Mr, T, Rr, Hr);
        }
        if (Z) {
          V(Mr, x);
        }
        if (f) {
          L(i, ua, Hr.overflowX);
          L(i, fa, Hr.overflowY);
        } else {
          style(o, Hr);
        }
      }
      H(i, oa, la, Lr);
      Xn(v, wa, Lr);
      !f && Xn(o, wa, K);
      var Dr = k(B(X).Sr), Ir = Dr[0], kr = Dr[1];
      t({
        Sr: Ir,
        Or: {
          x: br.w,
          y: br.h
        },
        Er: {
          x: Sr.w,
          y: Sr.h
        },
        Pr: Ar
      });
      return {
        Tr: kr,
        zr: mr,
        Ar: Cr
      };
    };
  };
  var Jn = function prepareUpdateHints(r, a, n) {
    var e = {};
    var t = a || {};
    var i = P(r).concat(P(t));
    each(i, (function(a) {
      var i = r[a];
      var v = t[a];
      e[a] = !!(n || i || v);
    }));
    return e;
  };
  var Kn = function createStructureSetupUpdate(r, a) {
    var n = r.X, e = r.$, t = r.sr, i = r.lr;
    var v = Sn(), o = v.A, u = v.L, f = v.j;
    var l = !o && (u.x || u.y);
    var c = [ Vn(r, a), Bn(r, a), $n(r, a) ];
    return function(r, a, v) {
      var o = Jn(T({
        gr: false,
        mr: false,
        wr: false,
        hr: false,
        zr: false,
        Ar: false,
        Tr: false,
        Cr: false,
        pr: false
      }, a), {}, v);
      var u = l || !f;
      var s = u && D(e);
      var d = u && I(e);
      t("", sa, true);
      var h = o;
      each(c, (function(a) {
        h = Jn(h, a(h, r, !!v) || {}, v);
      }));
      D(e, s);
      I(e, d);
      t("", sa);
      if (!i) {
        D(n, 0);
        I(n, 0);
      }
      return h;
    };
  };
  var Qn = function createEventContentChange(r, a, n) {
    var e;
    var t = false;
    var i = function destroy() {
      t = true;
    };
    var v = function updateElements(i) {
      if (n) {
        var v = n.reduce((function(a, n) {
          if (n) {
            var e = n[0], t = n[1];
            var v = t && e && (i ? i(e) : V(e, r));
            if (v && v.length && t && c(t)) {
              S(a, [ v, t.trim() ], true);
            }
          }
          return a;
        }), []);
        each(v, (function(n) {
          return each(n[0], (function(i) {
            var v = n[1];
            var o = e.get(i) || [];
            var u = r.contains(i);
            if (u) {
              var f = Xr(i, v, (function(r) {
                if (t) {
                  f();
                  e.delete(i);
                } else {
                  a(r);
                }
              }));
              e.set(i, S(o, f));
            } else {
              x(o);
              e.delete(i);
            }
          }));
        }));
      }
    };
    if (n) {
      e = new WeakMap;
      v();
    }
    return [ i, v ];
  };
  var re = function createDOMObserver(r, a, n, e) {
    var t = false;
    var i = e || {}, v = i.Lr, o = i.Hr, u = i.Mr, f = i.Rr, l = i.Dr, s = i.Ir;
    var d = mr((function() {
      if (t) {
        n(true);
      }
    }), {
      g: 33,
      p: 99
    });
    var h = Qn(r, d, u), g = h[0], p = h[1];
    var w = v || [];
    var b = o || [];
    var m = w.concat(b);
    var x = function observerCallback(t, i) {
      var v = l || wr;
      var o = s || wr;
      var u = new Set;
      var d = new Set;
      var h = false;
      var g = false;
      each(t, (function(n) {
        var t = n.attributeName, i = n.target, l = n.type, s = n.oldValue, p = n.addedNodes, w = n.removedNodes;
        var m = "attributes" === l;
        var S = "childList" === l;
        var C = r === i;
        var O = m && c(t) ? L(i, t) : 0;
        var x = 0 !== O && s !== O;
        var E = y(b, t) > -1 && x;
        if (a && (S || !C)) {
          var P = !m;
          var T = m && x;
          var z = T && f && j(i, f);
          var A = z ? !v(i, t, s, O) : P || T;
          var H = A && !o(n, !!z, r, e);
          each(p, (function(r) {
            return u.add(r);
          }));
          each(w, (function(r) {
            return u.add(r);
          }));
          g = g || H;
        }
        if (!a && C && x && !v(i, t, s, O)) {
          d.add(t);
          h = h || E;
        }
      }));
      if (u.size > 0) {
        p((function(r) {
          return C(u).reduce((function(a, n) {
            S(a, V(r, n));
            return j(n, r) ? S(a, n) : a;
          }), []);
        }));
      }
      if (a) {
        !i && g && n(false);
        return [ false ];
      }
      if (d.size > 0 || h) {
        var w = [ C(d), h ];
        !i && n.apply(0, w);
        return w;
      }
    };
    var E = new vr((function(r) {
      return x(r);
    }));
    E.observe(r, {
      attributes: true,
      attributeOldValue: true,
      attributeFilter: m,
      subtree: a,
      childList: a,
      characterData: a
    });
    t = true;
    return [ function() {
      if (t) {
        g();
        E.disconnect();
        t = false;
      }
    }, function() {
      if (t) {
        d.m();
        var r = E.takeRecords();
        return !O(r) && x(r, true);
      }
    } ];
  };
  var ae = 3333333;
  var ne = function domRectHasDimensions(r) {
    return r && (r.height || r.width);
  };
  var ee = function createSizeObserver(r, n, e) {
    var t = e || {}, i = t.kr, v = void 0 === i ? false : i, o = t.Vr, u = void 0 === o ? false : o;
    var f = Fa()[en];
    var l = Sn(), c = l.B;
    var d = J('<div class="' + ba + '"><div class="' + ya + '"></div></div>');
    var p = d[0];
    var w = p.firstChild;
    var b = Rr.bind(0, r);
    var m = a({
      v: void 0,
      u: true,
      o: function _equal(r, a) {
        return !(!r || !ne(r) && ne(a));
      }
    }), y = m[0];
    var C = function onSizeChangedCallbackProxy(r) {
      var a = h(r) && r.length > 0 && g(r[0]);
      var e = !a && s(r[0]);
      var t = false;
      var i = false;
      var o = true;
      if (a) {
        var u = y(r.pop().contentRect), f = u[0], l = u[2];
        var d = ne(f);
        var w = ne(l);
        t = !l || !d;
        i = !w && d;
        o = !t;
      } else if (e) {
        o = r[1];
      } else {
        i = true === r;
      }
      if (v && o) {
        var b = e ? r[0] : Rr(p);
        D(p, b ? c.n ? -ae : c.i ? 0 : ae : ae);
        I(p, ae);
      }
      if (!t) {
        n({
          gr: !e,
          Br: e ? r : void 0,
          Vr: !!i
        });
      }
    };
    var O = [];
    var E = u ? C : false;
    return [ function() {
      x(O);
      Z(p);
    }, function() {
      if (ur) {
        var n = new ur(C);
        n.observe(w);
        S(O, (function() {
          n.disconnect();
        }));
      } else if (f) {
        var e = f.P(w, C, u), t = e[0], i = e[1];
        E = t;
        S(O, i);
      }
      if (v) {
        var o = a({
          v: !b()
        }, b), l = o[0];
        S(O, Xr(p, "scroll", (function(r) {
          var a = l();
          var n = a[0], e = a[1];
          if (e) {
            Pr(w, "ltr rtl");
            if (n) {
              Tr(w, "rtl");
            } else {
              Tr(w, "ltr");
            }
            C(a);
          }
          Zr(r);
        })));
      }
      if (E) {
        Tr(p, ma);
        S(O, Xr(p, "animationstart", E, {
          O: !!ur
        }));
      }
      if (ur || f) {
        W(r, p);
      }
    } ];
  };
  var te = function isHeightIntrinsic(r) {
    return 0 === r.h || r.isIntersecting || r.intersectionRatio > 0;
  };
  var ie = function createTrinsicObserver(r, n) {
    var e;
    var t = $(xa);
    var i = [];
    var v = a({
      v: false
    }), o = v[0];
    var u = function triggerOnTrinsicChangedCallback(r, a) {
      if (r) {
        var e = o(te(r));
        var t = e[1];
        if (t) {
          !a && n(e);
          return [ e ];
        }
      }
    };
    var f = function intersectionObserverCallback(r, a) {
      if (r && r.length > 0) {
        return u(r.pop(), a);
      }
    };
    return [ function() {
      x(i);
      Z(t);
    }, function() {
      if (or) {
        e = new or((function(r) {
          return f(r);
        }), {
          root: r
        });
        e.observe(t);
        S(i, (function() {
          e.disconnect();
        }));
      } else {
        var a = function onSizeChanged() {
          var r = Br(t);
          u(r);
        };
        var n = ee(t, a), v = n[0], o = n[1];
        S(i, v);
        o();
        a();
      }
      W(r, t);
    }, function() {
      if (e) {
        return f(e.takeRecords(), true);
      }
    } ];
  };
  var ve = "[" + oa + "]";
  var oe = "." + ha;
  var ue = [ "tabindex" ];
  var fe = [ "wrap", "cols", "rows" ];
  var le = [ "id", "class", "style", "open" ];
  var ce = function createStructureSetupObservers(r, n, e) {
    var t;
    var i;
    var v;
    var o = r.Z, u = r.$, f = r.K, s = r.ir, g = r.lr, p = r.cr, w = r.sr;
    var b = Sn(), m = b.j;
    var C = a({
      o: hr,
      v: {
        w: 0,
        h: 0
      }
    }, (function() {
      var r = p(wa, la);
      var a = p(ga, "");
      var n = a && D(u);
      var e = a && I(u);
      w(wa, la);
      w(ga, "");
      w("", sa, true);
      var t = qr(f);
      var i = qr(u);
      var v = Fr(u);
      w(wa, la, r);
      w(ga, "", a);
      w("", sa);
      D(u, n);
      I(u, e);
      return {
        w: i.w + t.w + v.w,
        h: i.h + t.h + v.h
      };
    })), O = C[0];
    var x = s ? fe : le.concat(fe);
    var E = mr(e, {
      g: function _timeout() {
        return t;
      },
      p: function _maxDelay() {
        return i;
      },
      _: function _mergeParams(r, a) {
        var n = r[0];
        var e = a[0];
        return [ P(n).concat(P(e)).reduce((function(r, a) {
          r[a] = n[a] || e[a];
          return r;
        }), {}) ];
      }
    });
    var z = function updateViewportAttrsFromHost(r) {
      each(r || ue, (function(r) {
        if (y(ue, r) > -1) {
          var a = L(o, r);
          if (c(a)) {
            L(u, r, a);
          } else {
            R(u, r);
          }
        }
      }));
    };
    var A = function onTrinsicChanged(r, a) {
      var t = r[0], i = r[1];
      var v = {
        hr: i
      };
      n({
        dr: t
      });
      !a && e(v);
      return v;
    };
    var H = function onSizeChanged(r) {
      var a = r.gr, t = r.Br, i = r.Vr;
      var v = !a || i ? e : E;
      var o = false;
      if (t) {
        var u = t[0], f = t[1];
        o = f;
        n({
          _r: u
        });
      }
      v({
        gr: a,
        wr: o
      });
    };
    var M = function onContentMutation(r, a) {
      var n = O(), t = n[1];
      var i = {
        pr: t
      };
      var v = r ? e : E;
      if (t) {
        !a && v(i);
      }
      return i;
    };
    var k = function onHostMutation(r, a, n) {
      var e = {
        Cr: a
      };
      if (a) {
        !n && E(e);
      } else if (!g) {
        z(r);
      }
      return e;
    };
    var V = f || !m ? ie(o, A) : [ wr, wr, wr ], B = V[0], j = V[1], q = V[2];
    var F = !g ? ee(o, H, {
      Vr: true,
      kr: true
    }) : [ wr, wr ], Y = F[0], W = F[1];
    var G = re(o, false, k, {
      Hr: le,
      Lr: le.concat(ue)
    }), X = G[0], Z = G[1];
    var $ = g && ur && new ur(H.bind(0, {
      gr: true
    }));
    $ && $.observe(o);
    z();
    return [ function() {
      B();
      Y();
      v && v[0]();
      $ && $.disconnect();
      X();
    }, function() {
      W();
      j();
    }, function() {
      var r = {};
      var a = Z();
      var n = q();
      var e = v && v[1]();
      if (a) {
        T(r, k.apply(0, S(a, true)));
      }
      if (n) {
        T(r, A.apply(0, S(n, true)));
      }
      if (e) {
        T(r, M.apply(0, S(e, true)));
      }
      return r;
    }, function(r) {
      var a = r("update.ignoreMutation"), n = a[0];
      var e = r("update.attributes"), o = e[0], c = e[1];
      var s = r("update.elementEvents"), p = s[0], w = s[1];
      var b = r("update.debounce"), m = b[0], y = b[1];
      var S = w || c;
      var C = function ignoreMutationFromOptions(r) {
        return d(n) && n(r);
      };
      if (S) {
        if (v) {
          v[1]();
          v[0]();
        }
        v = re(f || u, true, M, {
          Lr: x.concat(o || []),
          Mr: p,
          Rr: ve,
          Ir: function _ignoreContentChange(r, a) {
            var n = r.target, e = r.attributeName;
            var t = !a && e && !g ? N(n, ve, oe) : false;
            return t || !!U(n, "." + Ea) || !!C(r);
          }
        });
      }
      if (y) {
        E.m();
        if (h(m)) {
          var O = m[0];
          var P = m[1];
          t = l(O) && O;
          i = l(P) && P;
        } else if (l(m)) {
          t = m;
          i = false;
        } else {
          t = false;
          i = false;
        }
      }
    } ];
  };
  var se = {
    x: 0,
    y: 0
  };
  var de = {
    J: {
      t: 0,
      r: 0,
      b: 0,
      l: 0
    },
    br: false,
    R: {
      marginRight: 0,
      marginBottom: 0,
      marginLeft: 0,
      paddingTop: 0,
      paddingRight: 0,
      paddingBottom: 0,
      paddingLeft: 0
    },
    Or: se,
    Er: se,
    Sr: {
      x: "hidden",
      y: "hidden"
    },
    Pr: {
      x: false,
      y: false
    },
    dr: false,
    _r: false
  };
  var he = function createStructureSetup(r, a) {
    var n = Hn(a, {});
    var e = Mn(de);
    var t = ra(), i = t[0], v = t[1], o = t[2];
    var u = e[0], f = e[1];
    var l = kn(r), c = l[0], s = l[1], d = l[2];
    var h = Kn(c, e);
    var g = function triggerUpdateEvent(r, a, n) {
      var e = P(r).some((function(a) {
        return r[a];
      }));
      var t = e || !z(a) || n;
      if (t) {
        o("u", [ r, a, n ]);
      }
      return t;
    };
    var p = ce(c, f, (function(r) {
      return g(h(n, r), {}, false);
    })), w = p[0], b = p[1], m = p[2], y = p[3];
    var S = u.bind(0);
    S.jr = function(r) {
      return i("u", r);
    };
    S.qr = function() {
      var r = c.X, a = c.$;
      var n = D(r);
      var e = I(r);
      b();
      s();
      D(a, n);
      I(a, e);
    };
    S.Fr = c;
    return [ function(r, n) {
      var e = Hn(a, r, n);
      y(e);
      return g(h(e, m(), n), r, !!n);
    }, S, function() {
      v();
      w();
      d();
    } ];
  };
  var ge = Math.round;
  var pe = function getScale(r) {
    var a = Ur(r), n = a.width, e = a.height;
    var t = Br(r), i = t.w, v = t.h;
    return {
      x: ge(n) / i || 1,
      y: ge(e) / v || 1
    };
  };
  var _e = function continuePointerDown(r, a, n) {
    var e = a.scrollbars;
    var t = r.button, i = r.isPrimary, v = r.pointerType;
    var o = e.pointers;
    return 0 === t && i && e[n ? "dragScroll" : "clickScroll"] && (o || []).includes(v);
  };
  var we = function createRootClickStopPropagationEvents(r, a) {
    return Xr(r, "mousedown", Xr.bind(0, a, "click", Zr, {
      O: true,
      C: true
    }), {
      C: true
    });
  };
  var be = function createInteractiveScrollEvents(r, a, n, e, t, i) {
    var v = Sn(), o = v.B;
    var u = n.Ur, f = n.Nr, l = n.Yr;
    var c = "scroll" + (i ? "Left" : "Top");
    var s = "client" + (i ? "X" : "Y");
    var d = i ? "width" : "height";
    var h = i ? "left" : "top";
    var g = i ? "w" : "h";
    var p = i ? "x" : "y";
    var w = function createRelativeHandleMove(r, a) {
      return function(n) {
        var v = t(), s = v.Er;
        var d = Br(f)[g] - Br(u)[g];
        var h = a * n / d;
        var w = h * s[p];
        var b = Rr(l);
        var m = b && i ? o.n || o.i ? 1 : -1 : 1;
        e[c] = r + w * m;
      };
    };
    return Xr(f, "pointerdown", (function(n) {
      var t = U(n.target, "." + La) === u;
      if (_e(n, r, t)) {
        var i = !t && n.shiftKey;
        var v = function getHandleRect() {
          return Ur(u);
        };
        var o = function getTrackRect() {
          return Ur(f);
        };
        var l = function getHandleOffset(r, a) {
          return (r || v())[h] - (a || o())[h];
        };
        var g = w(e[c] || 0, 1 / pe(e)[p]);
        var b = n[s];
        var m = v();
        var y = o();
        var C = m[d];
        var O = l(m, y) + C / 2;
        var E = b - y[h];
        var P = t ? 0 : E - O;
        var T = [ Xr(a, "selectstart", (function(r) {
          return $r(r);
        }), {
          S: false
        }), Xr(f, "pointermove", (function(r) {
          var a = r[s] - b;
          if (t || i) {
            g(P + a);
          }
        })) ];
        if (i) {
          g(P);
        } else if (!t) {
          var z = Fa()[hn];
          if (z) {
            S(T, z.P(g, l, P, C, E));
          }
        }
        Xr(f, "pointerup", (function(r) {
          x(T);
          f.releasePointerCapture(r.pointerId);
        }), {
          O: true
        });
        f.setPointerCapture(n.pointerId);
      }
    }));
  };
  var me = function createScrollbarsSetupEvents(r, a) {
    return function(n, e, t, i, v, o) {
      var u = n.Yr;
      var f = br(333), l = f[0], c = f[1];
      var s = !!v.scrollBy;
      var d = true;
      return x.bind(0, [ Xr(u, "pointerenter", (function() {
        e(Da, true);
      })), Xr(u, "pointerleave pointercancel", (function() {
        e(Da);
      })), Xr(u, "wheel", (function(r) {
        var a = r.deltaX, n = r.deltaY, t = r.deltaMode;
        if (s && d && 0 === t && F(u) === i) {
          v.scrollBy({
            left: a,
            top: n,
            behavior: "smooth"
          });
        }
        d = false;
        e(Va, true);
        l((function() {
          d = true;
          e(Va);
        }));
        $r(r);
      }), {
        S: false,
        C: true
      }), we(u, t), be(r, t, n, v, a, o), c ]);
    };
  };
  var ye = Math.min, Se = Math.max, Ce = Math.abs, Oe = Math.round;
  var xe = function getScrollbarHandleLengthRatio(r, a, n, e) {
    if (e) {
      var t = n ? "x" : "y";
      var i = e.Er, v = e.Or;
      var o = v[t];
      var u = i[t];
      return Se(0, ye(1, o / (o + u)));
    }
    var f = n ? "w" : "h";
    var l = Br(r)[f];
    var c = Br(a)[f];
    return Se(0, ye(1, l / c));
  };
  var Ee = function getScrollbarHandleOffsetRatio(r, a, n, e, t, i) {
    var v = Sn(), o = v.B;
    var u = i ? "x" : "y";
    var f = i ? "Left" : "Top";
    var l = e.Er;
    var c = Oe(l[u]);
    var s = Ce(n["scroll" + f]);
    var d = i && t;
    var h = o.i ? s : c - s;
    var g = d ? h : s;
    var p = ye(1, g / c);
    var w = xe(r, a, i);
    return 1 / w * (1 - w) * p;
  };
  var Pe = function createScrollbarsSetupElements(r, a, n) {
    var e = Sn(), t = e.F;
    var i = t(), v = i.scrollbars;
    var o = v.slot;
    var u = a.tr, f = a.X, l = a.Z, c = a.$, d = a.ur, h = a.ar;
    var g = d ? {} : r, p = g.scrollbars;
    var w = p || {}, b = w.slot;
    var m = xn([ f, l, c ], (function() {
      return l;
    }), o, b);
    var y = function scrollbarStructureAddRemoveClass(r, a, n) {
      var e = n ? Tr : Pr;
      each(r, (function(r) {
        e(r.Yr, a);
      }));
    };
    var C = function scrollbarsHandleStyle(r, a) {
      each(r, (function(r) {
        var n = a(r), e = n[0], t = n[1];
        style(e, t);
      }));
    };
    var E = function scrollbarStructureRefreshHandleLength(r, a, n) {
      C(r, (function(r) {
        var e;
        var t = r.Ur, i = r.Nr;
        return [ t, (e = {}, e[n ? "width" : "height"] = (100 * xe(t, i, n, a)).toFixed(3) + "%", 
        e) ];
      }));
    };
    var P = function scrollbarStructureRefreshHandleOffset(r, a, n) {
      var e = n ? "X" : "Y";
      C(r, (function(r) {
        var t = r.Ur, i = r.Nr, v = r.Yr;
        var o = Ee(t, i, h, a, Rr(v), n);
        var u = o === o;
        return [ t, {
          transform: u ? "translate" + e + "(" + (100 * o).toFixed(3) + "%)" : ""
        } ];
      }));
    };
    var T = [];
    var z = [];
    var A = [];
    var L = function scrollbarsAddRemoveClass(r, a, n) {
      var e = s(n);
      var t = e ? n : true;
      var i = e ? !n : true;
      t && y(z, r, a);
      i && y(A, r, a);
    };
    var H = function refreshScrollbarsHandleLength(r) {
      E(z, r, true);
      E(A, r);
    };
    var M = function refreshScrollbarsHandleOffset(r) {
      P(z, r, true);
      P(A, r);
    };
    var R = function generateScrollbarDOM(r) {
      var a = r ? Ta : za;
      var e = r ? z : A;
      var t = O(e) ? Ra : "";
      var i = $(Ea + " " + a + " " + t);
      var v = $(Aa);
      var o = $(La);
      var f = {
        Yr: i,
        Nr: v,
        Ur: o
      };
      W(i, v);
      W(v, o);
      S(e, f);
      S(T, [ Z.bind(0, i), n(f, L, u, l, h, r) ]);
      return f;
    };
    var D = R.bind(0, true);
    var I = R.bind(0, false);
    var k = function appendElements() {
      W(m, z[0].Yr);
      W(m, A[0].Yr);
      cr((function() {
        L(Ra);
      }), 300);
    };
    D();
    I();
    return [ {
      Wr: H,
      Gr: M,
      Xr: L,
      Zr: {
        $r: z,
        Jr: D,
        Kr: C.bind(0, z)
      },
      Qr: {
        $r: A,
        Jr: I,
        Kr: C.bind(0, A)
      }
    }, k, x.bind(0, T) ];
  };
  var Te = function createScrollbarsSetup(r, a, n) {
    var e;
    var t;
    var i;
    var v;
    var o;
    var u = 0;
    var f = Mn({});
    var l = f[0];
    var c = br(), s = c[0], d = c[1];
    var h = br(), g = h[0], p = h[1];
    var w = br(100), b = w[0], m = w[1];
    var y = br(100), S = y[0], C = y[1];
    var O = br((function() {
      return u;
    })), E = O[0], P = O[1];
    var T = Pe(r, n.Fr, me(a, n)), z = T[0], A = T[1], L = T[2];
    var H = n.Fr, M = H.Z, R = H.$, k = H.ar, V = H.nr, B = H.lr, j = H.vr;
    var q = z.Zr, U = z.Qr, N = z.Xr, Y = z.Wr, W = z.Gr;
    var G = q.Kr;
    var X = U.Kr;
    var Z = function styleScrollbarPosition(r) {
      var a = r.Yr;
      var n = B && !j && F(a) === R && a;
      return [ n, {
        transform: n ? "translate(" + D(k) + "px, " + I(k) + "px)" : ""
      } ];
    };
    var $ = function manageScrollbarsAutoHide(r, a) {
      P();
      if (r) {
        N(ka);
      } else {
        var n = function hide() {
          return N(ka, true);
        };
        if (u > 0 && !a) {
          E(n);
        } else {
          n();
        }
      }
    };
    var J = function onHostMouseEnter() {
      v = t;
      v && $(true);
    };
    var K = [ m, P, C, p, d, L, Xr(M, "pointerover", J, {
      O: true
    }), Xr(M, "pointerenter", J), Xr(M, "pointerleave", (function() {
      v = false;
      t && $(false);
    })), Xr(M, "pointermove", (function() {
      e && s((function() {
        m();
        $(true);
        S((function() {
          e && $(false);
        }));
      }));
    })), Xr(V, "scroll", (function() {
      g((function() {
        W(n());
        i && $(true);
        b((function() {
          i && !v && $(false);
        }));
      }));
      B && G(Z);
      B && X(Z);
    })) ];
    var Q = l.bind(0);
    Q.Fr = z;
    Q.qr = A;
    return [ function(r, v, f) {
      var l = f.zr, c = f.Ar, s = f.Tr, d = f.wr;
      var h = Hn(a, r, v);
      var g = n();
      var p = g.Er, w = g.Sr, b = g._r;
      var m = h("scrollbars.theme"), y = m[0], S = m[1];
      var C = h("scrollbars.visibility"), O = C[0], x = C[1];
      var E = h("scrollbars.autoHide"), P = E[0], T = E[1];
      var z = h("scrollbars.autoHideDelay"), A = z[0];
      var L = h("scrollbars.dragScroll"), H = L[0], M = L[1];
      var R = h("scrollbars.clickScroll"), D = R[0], I = R[1];
      var k = l || c || d || v;
      var V = s || x || v;
      var B = function setScrollbarVisibility(r, a) {
        var n = "visible" === O || "auto" === O && "scroll" === r;
        N(Ha, n, a);
        return n;
      };
      u = A;
      if (S) {
        N(o);
        N(y, true);
        o = y;
      }
      if (T) {
        e = "move" === P;
        t = "leave" === P;
        i = "never" !== P;
        $(!i, true);
      }
      if (M) {
        N(ja, H);
      }
      if (I) {
        N(Ba, D);
      }
      if (V) {
        var q = B(w.x, true);
        var F = B(w.y, false);
        var U = q && F;
        N(Ma, !U);
      }
      if (k) {
        Y(g);
        W(g);
        N(Ia, !p.x, true);
        N(Ia, !p.y, false);
        N(Pa, b && !j);
      }
    }, Q, x.bind(0, K) ];
  };
  var ze = function invokePluginInstance(r, a, n) {
    if (d(r)) {
      r(a || void 0, n || void 0);
    }
  };
  var Ae = function OverlayScrollbars(r, a, n) {
    var e = Sn(), t = e.N, i = e.F, v = e.q;
    var o = Fa();
    var u = b(r);
    var f = u ? r : r.target;
    var l = An(f);
    if (a && !l) {
      var c = false;
      var s = function validateOptions(r) {
        var a = Fa()[rn];
        var n = a && a.P;
        return n ? n(r, true) : r;
      };
      var d = T({}, t(), s(a));
      var h = ra(n), g = h[0], p = h[1], w = h[2];
      var m = he(r, d), y = m[0], S = m[1], C = m[2];
      var O = Te(r, d, S), x = O[0], E = O[1], A = O[2];
      var L = function update(r, a) {
        return y(r, !!a);
      };
      var H = v(L.bind(0, {}, true));
      var M = function destroy(r) {
        zn(f);
        H();
        A();
        C();
        c = true;
        w("destroyed", [ R, !!r ]);
        p();
      };
      var R = {
        options: function options(r) {
          if (r) {
            var a = ea(d, s(r));
            if (!z(a)) {
              T(d, a);
              L(a);
            }
          }
          return T({}, d);
        },
        on: g,
        off: function off(r, a) {
          r && a && p(r, a);
        },
        state: function state() {
          var r = S(), a = r.Or, n = r.Er, e = r.Sr, t = r.Pr, i = r.J, v = r.br, o = r._r;
          return T({}, {
            overflowEdge: a,
            overflowAmount: n,
            overflowStyle: e,
            hasOverflow: t,
            padding: i,
            paddingAbsolute: v,
            directionRTL: o,
            destroyed: c
          });
        },
        elements: function elements() {
          var r = S.Fr, a = r.X, n = r.Z, e = r.J, t = r.$, i = r.K, v = r.ar, o = r.nr;
          var u = E.Fr, f = u.Zr, l = u.Qr;
          var c = function translateScrollbarStructure(r) {
            var a = r.Ur, n = r.Nr, e = r.Yr;
            return {
              scrollbar: e,
              track: n,
              handle: a
            };
          };
          var s = function translateScrollbarsSetupElement(r) {
            var a = r.$r, n = r.Jr;
            var e = c(a[0]);
            return T({}, e, {
              clone: function clone() {
                var r = c(n());
                x({}, true, {});
                return r;
              }
            });
          };
          return T({}, {
            target: a,
            host: n,
            padding: e || t,
            viewport: t,
            content: i || t,
            scrollOffsetElement: v,
            scrollEventElement: o,
            scrollbarHorizontal: s(f),
            scrollbarVertical: s(l)
          });
        },
        update: function update(r) {
          return L({}, r);
        },
        destroy: M.bind(0)
      };
      S.jr((function(r, a, n) {
        x(a, n, r);
      }));
      Tn(f, R);
      each(P(o), (function(r) {
        return ze(o[r], 0, R);
      }));
      if (En(S.Fr.vr, i().cancel, !u && r.cancel)) {
        M(true);
        return R;
      }
      S.qr();
      E.qr();
      w("initialized", [ R ]);
      S.jr((function(r, a, n) {
        var e = r.gr, t = r.wr, i = r.hr, v = r.zr, o = r.Ar, u = r.Tr, f = r.pr, l = r.Cr;
        w("updated", [ R, {
          updateHints: {
            sizeChanged: e,
            directionChanged: t,
            heightIntrinsicChanged: i,
            overflowEdgeChanged: v,
            overflowAmountChanged: o,
            overflowStyleChanged: u,
            contentMutation: f,
            hostMutation: l
          },
          changedOptions: a,
          force: n
        } ]);
      }));
      R.update(true);
      return R;
    }
    return l;
  };
  Ae.plugin = function(r) {
    each(Ua(r), (function(r) {
      return ze(r, Ae);
    }));
  };
  Ae.valid = function(r) {
    var a = r && r.elements;
    var n = d(a) && a();
    return w(n) && !!An(n.target);
  };
  Ae.env = function() {
    var r = Sn(), a = r.V, n = r.L, e = r.A, t = r.B, i = r.j, v = r.H, o = r.W, u = r.G, f = r.F, l = r.U, c = r.N, s = r.Y;
    return T({}, {
      scrollbarsSize: a,
      scrollbarsOverlaid: n,
      scrollbarsHiding: e,
      rtlScrollBehavior: t,
      flexboxGlue: i,
      cssCustomProperties: v,
      staticDefaultInitialization: o,
      staticDefaultOptions: u,
      getDefaultInitialization: f,
      setDefaultInitialization: l,
      getDefaultOptions: c,
      setDefaultOptions: s
    });
  };
  r.ClickScrollPlugin = gn;
  r.OverlayScrollbars = Ae;
  r.ScrollbarsHidingPlugin = dn;
  r.SizeObserverPlugin = tn;
  Object.defineProperty(r, "ra", {
    value: true
  });
  return r;
}({});
//# sourceMappingURL=overlayscrollbars.browser.es5.js.map
