/*!
 * OverlayScrollbars
 * Version: 2.0.0-beta.3
 *
 * Copyright (c) Rene Haas | KingSora.
 * https://github.com/KingSora
 *
 * Released under the MIT license.
 */

function each(t, n) {
  if (isArrayLike(t)) {
    for (let o = 0; o < t.length; o++) {
      if (false === n(t[o], o, t)) {
        break;
      }
    }
  } else if (t) {
    each(Object.keys(t), (o => n(t[o], o, t)));
  }
  return t;
}

function style(t, n) {
  const o = isString(n);
  const s = isArray(n) || o;
  if (s) {
    let s = o ? "" : {};
    if (t) {
      const e = window.getComputedStyle(t, null);
      s = o ? getCSSVal(t, e, n) : n.reduce(((n, o) => {
        n[o] = getCSSVal(t, e, o);
        return n;
      }), s);
    }
    return s;
  }
  t && each(keys(n), (o => setCSSVal(t, o, n[o])));
}

const createCache = (t, n) => {
  const {o: o, u: s, _: e} = t;
  let c = o;
  let r;
  const cacheUpdateContextual = (t, n) => {
    const o = c;
    const i = t;
    const l = n || (s ? !s(o, i) : o !== i);
    if (l || e) {
      c = i;
      r = o;
    }
    return [ c, l, r ];
  };
  const cacheUpdateIsolated = t => cacheUpdateContextual(n(c, r), t);
  const getCurrentCache = t => [ c, !!t, r ];
  return [ n ? cacheUpdateIsolated : cacheUpdateContextual, getCurrentCache ];
};

const isClient = () => "undefined" !== typeof window;

const t = isClient() && Node.ELEMENT_NODE;

const {toString: n, hasOwnProperty: o} = Object.prototype;

const isUndefined = t => void 0 === t;

const isNull = t => null === t;

const type = t => isUndefined(t) || isNull(t) ? `${t}` : n.call(t).replace(/^\[object (.+)\]$/, "$1").toLowerCase();

const isNumber = t => "number" === typeof t;

const isString = t => "string" === typeof t;

const isBoolean = t => "boolean" === typeof t;

const isFunction = t => "function" === typeof t;

const isArray = t => Array.isArray(t);

const isObject = t => "object" === typeof t && !isArray(t) && !isNull(t);

const isArrayLike = t => {
  const n = !!t && t.length;
  const o = isNumber(n) && n > -1 && n % 1 == 0;
  return isArray(t) || !isFunction(t) && o ? n > 0 && isObject(t) ? n - 1 in t : true : false;
};

const isPlainObject = t => {
  if (!t || !isObject(t) || "object" !== type(t)) {
    return false;
  }
  let n;
  const s = "constructor";
  const e = t[s];
  const c = e && e.prototype;
  const r = o.call(t, s);
  const i = c && o.call(c, "isPrototypeOf");
  if (e && !r && !i) {
    return false;
  }
  for (n in t) {}
  return isUndefined(n) || o.call(t, n);
};

const isHTMLElement = n => {
  const o = HTMLElement;
  return n ? o ? n instanceof o : n.nodeType === t : false;
};

const isElement = n => {
  const o = Element;
  return n ? o ? n instanceof o : n.nodeType === t : false;
};

const indexOf = (t, n, o) => t.indexOf(n, o);

const push = (t, n, o) => {
  !o && !isString(n) && isArrayLike(n) ? Array.prototype.push.apply(t, n) : t.push(n);
  return t;
};

const from = t => {
  const n = Array.from;
  const o = [];
  if (n && t) {
    return n(t);
  }
  if (t instanceof Set) {
    t.forEach((t => {
      push(o, t);
    }));
  } else {
    each(t, (t => {
      push(o, t);
    }));
  }
  return o;
};

const isEmptyArray = t => !!t && 0 === t.length;

const runEachAndClear = (t, n, o) => {
  const runFn = t => t && t.apply(void 0, n || []);
  each(t, runFn);
  !o && (t.length = 0);
};

const hasOwnProperty = (t, n) => Object.prototype.hasOwnProperty.call(t, n);

const keys = t => t ? Object.keys(t) : [];

const assignDeep = (t, n, o, s, e, c, r) => {
  const i = [ n, o, s, e, c, r ];
  if (("object" !== typeof t || isNull(t)) && !isFunction(t)) {
    t = {};
  }
  each(i, (n => {
    each(keys(n), (o => {
      const s = n[o];
      if (t === s) {
        return true;
      }
      const e = isArray(s);
      if (s && (isPlainObject(s) || e)) {
        const n = t[o];
        let c = n;
        if (e && !isArray(n)) {
          c = [];
        } else if (!e && !isPlainObject(n)) {
          c = {};
        }
        t[o] = assignDeep(c, s);
      } else {
        t[o] = s;
      }
    }));
  }));
  return t;
};

const isEmptyObject = t => {
  for (const n in t) {
    return false;
  }
  return true;
};

const getSetProp = (t, n, o, s) => {
  if (isUndefined(s)) {
    return o ? o[t] : n;
  }
  o && (isString(s) || isNumber(s)) && (o[t] = s);
};

const attr = (t, n, o) => {
  if (isUndefined(o)) {
    return t ? t.getAttribute(n) : null;
  }
  t && t.setAttribute(n, o);
};

const attrClass = (t, n, o, s) => {
  if (o) {
    const e = attr(t, n) || "";
    const c = new Set(e.split(" "));
    c[s ? "add" : "delete"](o);
    attr(t, n, from(c).join(" ").trim());
  }
};

const hasAttrClass = (t, n, o) => {
  const s = attr(t, n) || "";
  const e = new Set(s.split(" "));
  return e.has(o);
};

const removeAttr = (t, n) => {
  t && t.removeAttribute(n);
};

const scrollLeft = (t, n) => getSetProp("scrollLeft", 0, t, n);

const scrollTop = (t, n) => getSetProp("scrollTop", 0, t, n);

const s = isClient() && Element.prototype;

const find = (t, n) => {
  const o = [];
  const s = n ? isElement(n) ? n : null : document;
  return s ? push(o, s.querySelectorAll(t)) : o;
};

const findFirst = (t, n) => {
  const o = n ? isElement(n) ? n : null : document;
  return o ? o.querySelector(t) : null;
};

const is = (t, n) => {
  if (isElement(t)) {
    const o = s.matches || s.msMatchesSelector;
    return o.call(t, n);
  }
  return false;
};

const contents = t => t ? from(t.childNodes) : [];

const parent = t => t ? t.parentElement : null;

const closest = (t, n) => {
  if (isElement(t)) {
    const o = s.closest;
    if (o) {
      return o.call(t, n);
    }
    do {
      if (is(t, n)) {
        return t;
      }
      t = parent(t);
    } while (t);
  }
  return null;
};

const liesBetween = (t, n, o) => {
  const s = t && closest(t, n);
  const e = t && findFirst(o, s);
  const c = closest(e, n) === s;
  return s && e ? s === t || e === t || c && closest(closest(t, o), n) !== s : false;
};

const before = (t, n, o) => {
  if (o && t) {
    let s = n;
    let e;
    if (isArrayLike(o)) {
      e = document.createDocumentFragment();
      each(o, (t => {
        if (t === s) {
          s = t.previousSibling;
        }
        e.appendChild(t);
      }));
    } else {
      e = o;
    }
    if (n) {
      if (!s) {
        s = t.firstChild;
      } else if (s !== n) {
        s = s.nextSibling;
      }
    }
    t.insertBefore(e, s || null);
  }
};

const appendChildren = (t, n) => {
  before(t, null, n);
};

const insertBefore = (t, n) => {
  before(parent(t), t, n);
};

const insertAfter = (t, n) => {
  before(parent(t), t && t.nextSibling, n);
};

const removeElements = t => {
  if (isArrayLike(t)) {
    each(from(t), (t => removeElements(t)));
  } else if (t) {
    const n = parent(t);
    if (n) {
      n.removeChild(t);
    }
  }
};

const createDiv = t => {
  const n = document.createElement("div");
  if (t) {
    attr(n, "class", t);
  }
  return n;
};

const createDOM = t => {
  const n = createDiv();
  n.innerHTML = t.trim();
  return each(contents(n), (t => removeElements(t)));
};

const firstLetterToUpper = t => t.charAt(0).toUpperCase() + t.slice(1);

const getDummyStyle = () => createDiv().style;

const e = [ "-webkit-", "-moz-", "-o-", "-ms-" ];

const c = [ "WebKit", "Moz", "O", "MS", "webkit", "moz", "o", "ms" ];

const r = {};

const i = {};

const cssProperty = t => {
  let n = i[t];
  if (hasOwnProperty(i, t)) {
    return n;
  }
  const o = firstLetterToUpper(t);
  const s = getDummyStyle();
  each(e, (e => {
    const c = e.replace(/-/g, "");
    const r = [ t, e + t, c + o, firstLetterToUpper(c) + o ];
    return !(n = r.find((t => void 0 !== s[t])));
  }));
  return i[t] = n || "";
};

const jsAPI = t => {
  if (isClient()) {
    let n = r[t] || window[t];
    if (hasOwnProperty(r, t)) {
      return n;
    }
    each(c, (o => {
      n = n || window[o + firstLetterToUpper(t)];
      return !n;
    }));
    r[t] = n;
    return n;
  }
};

const l = jsAPI("MutationObserver");

const a = jsAPI("IntersectionObserver");

const u = jsAPI("ResizeObserver");

const d = jsAPI("cancelAnimationFrame");

const f = jsAPI("requestAnimationFrame");

const _ = isClient() && window.setTimeout;

const h = isClient() && window.clearTimeout;

const equal = (t, n, o, s) => {
  if (t && n) {
    let e = true;
    each(o, (o => {
      const c = s ? s(t[o]) : t[o];
      const r = s ? s(n[o]) : n[o];
      if (c !== r) {
        e = false;
      }
    }));
    return e;
  }
  return false;
};

const equalWH = (t, n) => equal(t, n, [ "w", "h" ]);

const equalXY = (t, n) => equal(t, n, [ "x", "y" ]);

const equalTRBL = (t, n) => equal(t, n, [ "t", "r", "b", "l" ]);

const equalBCRWH = (t, n, o) => equal(t, n, [ "width", "height" ], o && (t => Math.round(t)));

const noop = () => {};

const selfClearTimeout = t => {
  let n;
  const o = t ? _ : f;
  const s = t ? h : d;
  return [ e => {
    s(n);
    n = o(e, isFunction(t) ? t() : t);
  }, () => s(n) ];
};

const debounce = (t, n) => {
  let o;
  let s;
  let e;
  let c = noop;
  const {g: r, v: i, p: l} = n || {};
  const a = function invokeFunctionToDebounce(n) {
    c();
    h(o);
    o = s = void 0;
    c = noop;
    t.apply(this, n);
  };
  const mergeParms = t => l && s ? l(s, t) : t;
  const flush = () => {
    if (c !== noop) {
      a(mergeParms(e) || e);
    }
  };
  const u = function debouncedFn() {
    const t = from(arguments);
    const n = isFunction(r) ? r() : r;
    const l = isNumber(n) && n >= 0;
    if (l) {
      const r = isFunction(i) ? i() : i;
      const l = isNumber(r) && r >= 0;
      const u = n > 0 ? _ : f;
      const g = n > 0 ? h : d;
      const v = mergeParms(t);
      const w = v || t;
      const p = a.bind(0, w);
      c();
      const b = u(p, n);
      c = () => g(b);
      if (l && !o) {
        o = _(flush, r);
      }
      s = e = w;
    } else {
      a(t);
    }
  };
  u.m = flush;
  return u;
};

const {max: g} = Math;

const animationCurrentTime = () => performance.now();

const animateNumber = (t, n, o, s, e) => {
  let c = 0;
  const r = animationCurrentTime();
  const i = Math.max(0, o);
  const frame = o => {
    const l = animationCurrentTime();
    const a = l - r;
    const u = a >= i;
    const d = o ? 1 : 1 - (g(0, r + i - l) / i || 0);
    const _ = (n - t) * (isFunction(e) ? e(d, d * i, 0, 1, i) : d) + t;
    const h = u || 1 === d;
    s && s(_, d, h);
    c = h ? 0 : f((() => frame()));
  };
  frame();
  return t => {
    d(c);
    t && frame(t);
  };
};

const v = /[^\x20\t\r\n\f]+/g;

const classListAction = (t, n, o) => {
  const s = t && t.classList;
  let e;
  let c = 0;
  let r = false;
  if (s && n && isString(n)) {
    const t = n.match(v) || [];
    r = t.length > 0;
    while (e = t[c++]) {
      r = !!o(s, e) && r;
    }
  }
  return r;
};

const hasClass = (t, n) => classListAction(t, n, ((t, n) => t.contains(n)));

const removeClass = (t, n) => {
  classListAction(t, n, ((t, n) => t.remove(n)));
};

const addClass = (t, n) => {
  classListAction(t, n, ((t, n) => t.add(n)));
  return removeClass.bind(0, t, n);
};

const w = {
  opacity: 1,
  zindex: 1
};

const parseToZeroOrNumber = (t, n) => {
  const o = n ? parseFloat(t) : parseInt(t, 10);
  return o === o ? o : 0;
};

const adaptCSSVal = (t, n) => !w[t.toLowerCase()] && isNumber(n) ? `${n}px` : n;

const getCSSVal = (t, n, o) => null != n ? n[o] || n.getPropertyValue(o) : t.style[o];

const setCSSVal = (t, n, o) => {
  try {
    const {style: s} = t;
    if (!isUndefined(s[n])) {
      s[n] = adaptCSSVal(n, o);
    } else {
      s.setProperty(n, o);
    }
  } catch (s) {}
};

const directionIsRTL = t => "rtl" === style(t, "direction");

const topRightBottomLeft = (t, n, o) => {
  const s = n ? `${n}-` : "";
  const e = o ? `-${o}` : "";
  const c = `${s}top${e}`;
  const r = `${s}right${e}`;
  const i = `${s}bottom${e}`;
  const l = `${s}left${e}`;
  const a = style(t, [ c, r, i, l ]);
  return {
    t: parseToZeroOrNumber(a[c], true),
    r: parseToZeroOrNumber(a[r], true),
    b: parseToZeroOrNumber(a[i], true),
    l: parseToZeroOrNumber(a[l], true)
  };
};

const {round: p} = Math;

const b = {
  w: 0,
  h: 0
};

const windowSize = () => ({
  w: window.innerWidth,
  h: window.innerHeight
});

const offsetSize = t => t ? {
  w: t.offsetWidth,
  h: t.offsetHeight
} : b;

const clientSize = t => t ? {
  w: t.clientWidth,
  h: t.clientHeight
} : b;

const scrollSize = t => t ? {
  w: t.scrollWidth,
  h: t.scrollHeight
} : b;

const fractionalSize = t => {
  const n = parseFloat(style(t, "height")) || 0;
  const o = parseFloat(style(t, "width")) || 0;
  return {
    w: o - p(o),
    h: n - p(n)
  };
};

const getBoundingClientRect = t => t.getBoundingClientRect();

let m;

const supportPassiveEvents = () => {
  if (isUndefined(m)) {
    m = false;
    try {
      window.addEventListener("test", null, Object.defineProperty({}, "passive", {
        get() {
          m = true;
        }
      }));
    } catch (t) {}
  }
  return m;
};

const splitEventNames = t => t.split(" ");

const off = (t, n, o, s) => {
  each(splitEventNames(n), (n => {
    t.removeEventListener(n, o, s);
  }));
};

const on = (t, n, o, s) => {
  var e;
  const c = supportPassiveEvents();
  const r = null != (e = c && s && s.S) ? e : c;
  const i = s && s.$ || false;
  const l = s && s.C || false;
  const a = [];
  const u = c ? {
    passive: r,
    capture: i
  } : i;
  each(splitEventNames(n), (n => {
    const s = l ? e => {
      t.removeEventListener(n, s, i);
      o && o(e);
    } : o;
    push(a, off.bind(null, t, n, s, i));
    t.addEventListener(n, s, u);
  }));
  return runEachAndClear.bind(0, a);
};

const stopPropagation = t => t.stopPropagation();

const preventDefault = t => t.preventDefault();

const y = {
  x: 0,
  y: 0
};

const absoluteCoordinates = t => {
  const n = t ? getBoundingClientRect(t) : 0;
  return n ? {
    x: n.left + window.pageYOffset,
    y: n.top + window.pageXOffset
  } : y;
};

const manageListener = (t, n) => {
  each(isArray(n) ? n : [ n ], t);
};

const createEventListenerHub = t => {
  const n = new Map;
  const removeEvent = (t, o) => {
    if (t) {
      const s = n.get(t);
      manageListener((t => {
        if (s) {
          s[t ? "delete" : "clear"](t);
        }
      }), o);
    } else {
      n.forEach((t => {
        t.clear();
      }));
      n.clear();
    }
  };
  const addEvent = (t, o) => {
    const s = n.get(t) || new Set;
    n.set(t, s);
    manageListener((t => {
      t && s.add(t);
    }), o);
    return removeEvent.bind(0, t, o);
  };
  const triggerEvent = (t, o) => {
    const s = n.get(t);
    each(from(s), (t => {
      if (o && !isEmptyArray(o)) {
        t.apply(0, o);
      } else {
        t();
      }
    }));
  };
  const o = keys(t);
  each(o, (n => {
    addEvent(n, t[n]);
  }));
  return [ addEvent, removeEvent, triggerEvent ];
};

const opsStringify = t => JSON.stringify(t, ((t, n) => {
  if (isFunction(n)) {
    throw new Error;
  }
  return n;
}));

const S = {
  paddingAbsolute: false,
  showNativeOverlaidScrollbars: false,
  update: {
    elementEvents: [ [ "img", "load" ] ],
    debounce: [ 0, 33 ],
    attributes: null,
    ignoreMutation: null
  },
  overflow: {
    x: "scroll",
    y: "scroll"
  },
  scrollbars: {
    theme: "os-theme-dark",
    visibility: "auto",
    autoHide: "never",
    autoHideDelay: 1300,
    dragScroll: true,
    clickScroll: false,
    pointers: [ "mouse", "touch", "pen" ]
  }
};

const getOptionsDiff = (t, n) => {
  const o = {};
  const s = keys(n).concat(keys(t));
  each(s, (s => {
    const e = t[s];
    const c = n[s];
    if (isObject(e) && isObject(c)) {
      assignDeep(o[s] = {}, getOptionsDiff(e, c));
      if (isEmptyObject(o[s])) {
        delete o[s];
      }
    } else if (hasOwnProperty(n, s) && c !== e) {
      let t = true;
      if (isArray(e) || isArray(c)) {
        try {
          if (opsStringify(e) === opsStringify(c)) {
            t = false;
          }
        } catch (r) {}
      }
      if (t) {
        o[s] = c;
      }
    }
  }));
  return o;
};

const x = "os-environment";

const $ = `${x}-flexbox-glue`;

const C = `${$}-max`;

const O = "data-overlayscrollbars";

const T = `${O}-overflow-x`;

const E = `${O}-overflow-y`;

const z = "overflowVisible";

const A = "scrollbarHidden";

const I = "updating";

const L = "os-padding";

const H = "os-viewport";

const M = `${H}-arrange`;

const P = "os-content";

const D = `${H}-scrollbar-hidden`;

const R = `os-overflow-visible`;

const k = "os-size-observer";

const V = `${k}-appear`;

const B = `${k}-listener`;

const Y = `${B}-scroll`;

const j = `${B}-item`;

const q = `${j}-final`;

const N = "os-trinsic-observer";

const F = "os-scrollbar";

const G = `${F}-rtl`;

const X = `${F}-horizontal`;

const U = `${F}-vertical`;

const W = `${F}-track`;

const J = `${F}-handle`;

const K = `${F}-visible`;

const Z = `${F}-cornerless`;

const Q = `${F}-transitionless`;

const tt = `${F}-interaction`;

const nt = `${F}-unusable`;

const ot = `${F}-auto-hidden`;

const st = `${F}-wheel`;

const et = `${W}-interactive`;

const ct = `${J}-interactive`;

const rt = {};

const getPlugins = () => rt;

const addPlugin = t => {
  const n = [];
  each(isArray(t) ? t : [ t ], (t => {
    const o = keys(t);
    each(o, (o => {
      push(n, rt[o] = t[o]);
    }));
  }));
  return n;
};

const it = {
  boolean: "__TPL_boolean_TYPE__",
  number: "__TPL_number_TYPE__",
  string: "__TPL_string_TYPE__",
  array: "__TPL_array_TYPE__",
  object: "__TPL_object_TYPE__",
  function: "__TPL_function_TYPE__",
  null: "__TPL_null_TYPE__"
};

const lt = it.number;

const at = it.boolean;

const ut = [ it.array, it.null ];

const dt = "hidden scroll visible visible-hidden";

const ft = "visible hidden auto";

const _t = "never scroll leavemove";

({
  paddingAbsolute: at,
  showNativeOverlaidScrollbars: at,
  update: {
    elementEvents: ut,
    attributes: ut,
    debounce: [ it.number, it.array, it.null ],
    ignoreMutation: [ it.function, it.null ]
  },
  overflow: {
    x: dt,
    y: dt
  },
  scrollbars: {
    theme: [ it.string, it.null ],
    visibility: ft,
    autoHide: _t,
    autoHideDelay: lt,
    dragScroll: at,
    clickScroll: at,
    pointers: [ it.array, it.null ]
  }
});

const ht = "__osOptionsValidationPlugin";

const gt = 3333333;

const vt = "scroll";

const wt = "__osSizeObserverPlugin";

const pt = /* @__PURE__ */ (() => ({
  [wt]: {
    O: (t, n, o) => {
      const s = createDOM(`<div class="${j}" dir="ltr"><div class="${j}"><div class="${q}"></div></div><div class="${j}"><div class="${q}" style="width: 200%; height: 200%"></div></div></div>`);
      appendChildren(t, s);
      addClass(t, Y);
      const e = s[0];
      const c = e.lastChild;
      const r = e.firstChild;
      const i = null == r ? void 0 : r.firstChild;
      let l = offsetSize(e);
      let a = l;
      let u = false;
      let _;
      const reset = () => {
        scrollLeft(r, gt);
        scrollTop(r, gt);
        scrollLeft(c, gt);
        scrollTop(c, gt);
      };
      const onResized = t => {
        _ = 0;
        if (u) {
          l = a;
          n(true === t);
        }
      };
      const onScroll = t => {
        a = offsetSize(e);
        u = !t || !equalWH(a, l);
        if (t) {
          stopPropagation(t);
          if (u && !_) {
            d(_);
            _ = f(onResized);
          }
        } else {
          onResized(false === t);
        }
        reset();
      };
      const h = push([], [ on(r, vt, onScroll), on(c, vt, onScroll) ]);
      style(i, {
        width: gt,
        height: gt
      });
      f(reset);
      return [ o ? onScroll.bind(0, false) : reset, h ];
    }
  }
}))();

let bt = 0;

const {round: mt, abs: yt} = Math;

const getWindowDPR = () => {
  const t = window.screen.deviceXDPI || 0;
  const n = window.screen.logicalXDPI || 1;
  return window.devicePixelRatio || t / n;
};

const diffBiggerThanOne = (t, n) => {
  const o = yt(t);
  const s = yt(n);
  return !(o === s || o + 1 === s || o - 1 === s);
};

const St = "__osScrollbarsHidingPlugin";

const xt = /* @__PURE__ */ (() => ({
  [St]: {
    T: t => {
      const {A: n, I: o, L: s} = t;
      const e = !s && !n && (o.x || o.y);
      const c = e ? document.createElement("style") : false;
      if (c) {
        attr(c, "id", `${M}-${bt}`);
        bt++;
      }
      return c;
    },
    H: (t, n, o, s, e, c, r) => {
      const arrangeViewport = (n, c, r, i) => {
        if (t) {
          const {M: t} = e();
          const {P: l, D: a} = n;
          const {x: u, y: d} = a;
          const {x: f, y: _} = l;
          const h = i ? "paddingRight" : "paddingLeft";
          const g = t[h];
          const v = t.paddingTop;
          const w = c.w + r.w;
          const p = c.h + r.h;
          const b = {
            w: _ && d ? `${_ + w - g}px` : "",
            h: f && u ? `${f + p - v}px` : ""
          };
          if (s) {
            const {sheet: t} = s;
            if (t) {
              const {cssRules: n} = t;
              if (n) {
                if (!n.length) {
                  t.insertRule(`#${attr(s, "id")} + .${M}::before {}`, 0);
                }
                const o = n[0].style;
                o.width = b.w;
                o.height = b.h;
              }
            }
          } else {
            style(o, {
              "--os-vaw": b.w,
              "--os-vah": b.h
            });
          }
        }
        return t;
      };
      const undoViewportArrange = (s, i, l) => {
        if (t) {
          const a = l || c(s);
          const {M: u} = e();
          const {D: d} = a;
          const {x: f, y: _} = d;
          const h = {};
          const assignProps = t => each(t.split(" "), (t => {
            h[t] = u[t];
          }));
          if (f) {
            assignProps("marginBottom paddingTop paddingBottom");
          }
          if (_) {
            assignProps("marginLeft marginRight paddingLeft paddingRight");
          }
          const g = style(o, keys(h));
          removeClass(o, M);
          if (!n) {
            h.height = "";
          }
          style(o, h);
          return [ () => {
            r(a, i, t, g);
            style(o, g);
            addClass(o, M);
          }, a ];
        }
        return [ noop ];
      };
      return [ arrangeViewport, undoViewportArrange ];
    },
    R: () => {
      let t = {
        w: 0,
        h: 0
      };
      let n = 0;
      return (o, s, e) => {
        const c = windowSize();
        const r = {
          w: c.w - t.w,
          h: c.h - t.h
        };
        if (0 === r.w && 0 === r.h) {
          return;
        }
        const i = {
          w: yt(r.w),
          h: yt(r.h)
        };
        const l = {
          w: yt(mt(c.w / (t.w / 100))),
          h: yt(mt(c.h / (t.h / 100)))
        };
        const a = getWindowDPR();
        const u = i.w > 2 && i.h > 2;
        const d = !diffBiggerThanOne(l.w, l.h);
        const f = a !== n && a > 0;
        const _ = u && d && f;
        if (_) {
          const [t, n] = s();
          assignDeep(o.k, t);
          if (n) {
            e();
          }
        }
        t = c;
        n = a;
      };
    }
  }
}))();

const $t = "__osClickScrollPlugin";

const Ct = /* @__PURE__ */ (() => ({
  [$t]: {
    O: (t, n, o, s, e) => {
      let c = 0;
      let r = noop;
      const animateClickScroll = i => {
        r = animateNumber(i, i + s * Math.sign(o), 133, ((o, i, l) => {
          t(o);
          const a = n();
          const u = a + s;
          const d = e >= a && e <= u;
          if (l && !d) {
            if (c) {
              animateClickScroll(o);
            } else {
              const t = setTimeout((() => {
                animateClickScroll(o);
              }), 222);
              r = () => {
                clearTimeout(t);
              };
            }
            c++;
          }
        }));
      };
      animateClickScroll(0);
      return () => r();
    }
  }
}))();

let Ot;

const getNativeScrollbarSize = (t, n, o, s) => {
  appendChildren(t, n);
  const e = clientSize(n);
  const c = offsetSize(n);
  const r = fractionalSize(o);
  s && removeElements(n);
  return {
    x: c.h - e.h + r.h,
    y: c.w - e.w + r.w
  };
};

const getNativeScrollbarsHiding = t => {
  let n = false;
  const o = addClass(t, D);
  try {
    n = "none" === style(t, cssProperty("scrollbar-width")) || "none" === window.getComputedStyle(t, "::-webkit-scrollbar").getPropertyValue("display");
  } catch (s) {}
  o();
  return n;
};

const getRtlScrollBehavior = (t, n) => {
  const o = "hidden";
  style(t, {
    overflowX: o,
    overflowY: o,
    direction: "rtl"
  });
  scrollLeft(t, 0);
  const s = absoluteCoordinates(t);
  const e = absoluteCoordinates(n);
  scrollLeft(t, -999);
  const c = absoluteCoordinates(n);
  return {
    i: s.x === e.x,
    n: e.x !== c.x
  };
};

const getFlexboxGlue = (t, n) => {
  const o = addClass(t, $);
  const s = getBoundingClientRect(t);
  const e = getBoundingClientRect(n);
  const c = equalBCRWH(e, s, true);
  const r = addClass(t, C);
  const i = getBoundingClientRect(t);
  const l = getBoundingClientRect(n);
  const a = equalBCRWH(l, i, true);
  o();
  r();
  return c && a;
};

const createEnvironment = () => {
  const {body: t} = document;
  const n = createDOM(`<div class="${x}"><div></div></div>`);
  const o = n[0];
  const s = o.firstChild;
  const [e, , c] = createEventListenerHub();
  const [r, i] = createCache({
    o: getNativeScrollbarSize(t, o, s),
    u: equalXY
  }, getNativeScrollbarSize.bind(0, t, o, s, true));
  const [l] = i();
  const a = getNativeScrollbarsHiding(o);
  const u = {
    x: 0 === l.x,
    y: 0 === l.y
  };
  const d = {
    elements: {
      host: null,
      padding: !a,
      viewport: t => a && t === t.ownerDocument.body && t,
      content: false
    },
    scrollbars: {
      slot: true
    },
    cancel: {
      nativeScrollbarsOverlaid: false,
      body: null
    }
  };
  const f = assignDeep({}, S);
  const _ = {
    k: l,
    I: u,
    A: a,
    L: "-1" === style(o, "zIndex"),
    V: getRtlScrollBehavior(o, s),
    B: getFlexboxGlue(o, s),
    Y: t => e("_", t),
    j: assignDeep.bind(0, {}, d),
    q(t) {
      assignDeep(d, t);
    },
    N: assignDeep.bind(0, {}, f),
    F(t) {
      assignDeep(f, t);
    },
    G: assignDeep({}, d),
    X: assignDeep({}, f)
  };
  removeAttr(o, "style");
  removeElements(o);
  if (!a && (!u.x || !u.y)) {
    let t;
    window.addEventListener("resize", (() => {
      const n = getPlugins()[St];
      t = t || n && n.R();
      t && t(_, r, c.bind(0, "_"));
    }));
  }
  return _;
};

const getEnvironment = () => {
  if (!Ot) {
    Ot = createEnvironment();
  }
  return Ot;
};

const resolveInitialization = (t, n) => isFunction(t) ? t.apply(0, n) : t;

const staticInitializationElement = (t, n, o, s) => {
  const e = isUndefined(s) ? o : s;
  const c = resolveInitialization(e, t);
  return c || n.apply(0, t);
};

const dynamicInitializationElement = (t, n, o, s) => {
  const e = isUndefined(s) ? o : s;
  const c = resolveInitialization(e, t);
  return !!c && (isHTMLElement(c) ? c : n.apply(0, t));
};

const cancelInitialization = (t, n, o) => {
  const {nativeScrollbarsOverlaid: s, body: e} = o || {};
  const {I: c, A: r} = getEnvironment();
  const {nativeScrollbarsOverlaid: i, body: l} = n;
  const a = null != s ? s : i;
  const u = isUndefined(e) ? l : e;
  const d = (c.x || c.y) && a;
  const f = t && (isNull(u) ? !r : u);
  return !!d || !!f;
};

const Tt = new WeakMap;

const addInstance = (t, n) => {
  Tt.set(t, n);
};

const removeInstance = t => {
  Tt.delete(t);
};

const getInstance = t => Tt.get(t);

const getPropByPath = (t, n) => t ? n.split(".").reduce(((t, n) => t && hasOwnProperty(t, n) ? t[n] : void 0), t) : void 0;

const createOptionCheck = (t, n, o) => s => [ getPropByPath(t, s), o || void 0 !== getPropByPath(n, s) ];

const createState = t => {
  let n = t;
  return [ () => n, t => {
    n = assignDeep({}, n, t);
  } ];
};

const Et = "tabindex";

const zt = createDiv.bind(0, "");

const unwrap = t => {
  appendChildren(parent(t), contents(t));
  removeElements(t);
};

const createStructureSetupElements = t => {
  const n = getEnvironment();
  const {j: o, A: s} = n;
  const e = getPlugins()[St];
  const c = e && e.T;
  const {elements: r} = o();
  const {host: i, viewport: l, padding: a, content: u} = r;
  const d = isHTMLElement(t);
  const f = d ? {} : t;
  const {elements: _} = f;
  const {host: h, padding: g, viewport: v, content: w} = _ || {};
  const p = d ? t : f.target;
  const b = is(p, "textarea");
  const m = p.ownerDocument;
  const y = m.documentElement;
  const S = p === m.body;
  const x = m.defaultView;
  const $ = staticInitializationElement.bind(0, [ p ]);
  const C = dynamicInitializationElement.bind(0, [ p ]);
  const z = $(zt, l, v);
  const A = z === p;
  const I = A && S;
  const M = m.activeElement;
  const R = !A && x.top === x && M === p;
  const k = {
    U: p,
    W: b ? $(zt, i, h) : p,
    J: z,
    K: !A && C(zt, a, g),
    Z: !A && C(zt, u, w),
    tt: !A && !s && c && c(n),
    nt: I ? y : z,
    ot: I ? m : z,
    st: x,
    et: m,
    ct: b,
    rt: S,
    it: d,
    lt: A,
    ut: (t, n) => A ? hasAttrClass(z, O, n) : hasClass(z, t),
    dt: (t, n, o) => A ? attrClass(z, O, n, o) : (o ? addClass : removeClass)(z, t)
  };
  const V = keys(k).reduce(((t, n) => {
    const o = k[n];
    return push(t, o && !parent(o) ? o : false);
  }), []);
  const elementIsGenerated = t => t ? indexOf(V, t) > -1 : null;
  const {U: B, W: Y, K: j, J: q, Z: N, tt: F} = k;
  const G = [ () => {
    removeAttr(Y, O);
    if (S) {
      removeAttr(y, O);
    }
  } ];
  const X = b && elementIsGenerated(Y);
  let U = b ? B : contents([ N, q, j, Y, B ].find((t => false === elementIsGenerated(t))));
  const W = N || q;
  const appendElements = () => {
    attr(Y, O, A ? "viewport" : "host");
    const t = addClass(j, L);
    const n = addClass(q, !A && H);
    const o = addClass(N, P);
    const e = S ? addClass(parent(p), D) : noop;
    if (X) {
      insertAfter(B, Y);
      push(G, (() => {
        insertAfter(Y, B);
        removeElements(Y);
      }));
    }
    appendChildren(W, U);
    appendChildren(Y, j);
    appendChildren(j || Y, !A && q);
    appendChildren(q, N);
    push(G, (() => {
      e();
      removeAttr(q, T);
      removeAttr(q, E);
      if (elementIsGenerated(N)) {
        unwrap(N);
      }
      if (elementIsGenerated(q)) {
        unwrap(q);
      }
      if (elementIsGenerated(j)) {
        unwrap(j);
      }
      t();
      n();
      o();
    }));
    if (s && !A) {
      push(G, removeClass.bind(0, q, D));
    }
    if (F) {
      insertBefore(q, F);
      push(G, removeElements.bind(0, F));
    }
    if (R) {
      const t = attr(q, Et);
      attr(q, Et, "-1");
      q.focus();
      const n = on(m, "pointerdown keydown", (() => {
        t ? attr(q, Et, t) : removeAttr(q, Et);
        n();
      }));
    } else if (M && M.focus) {
      M.focus();
    }
    U = 0;
  };
  return [ k, appendElements, runEachAndClear.bind(0, G) ];
};

const createTrinsicUpdateSegment = (t, n) => {
  const {Z: o} = t;
  const [s] = n;
  return t => {
    const {B: n} = getEnvironment();
    const {ft: e} = s();
    const {_t: c} = t;
    const r = (o || !n) && c;
    if (r) {
      style(o, {
        height: e ? "" : "100%"
      });
    }
    return {
      ht: r,
      gt: r
    };
  };
};

const createPaddingUpdateSegment = (t, n) => {
  const [o, s] = n;
  const {W: e, K: c, J: r, lt: i} = t;
  const [l, a] = createCache({
    u: equalTRBL,
    o: topRightBottomLeft()
  }, topRightBottomLeft.bind(0, e, "padding", ""));
  return (t, n, e) => {
    let [u, d] = a(e);
    const {A: f, B: _} = getEnvironment();
    const {vt: h} = o();
    const {ht: g, gt: v, wt: w} = t;
    const [p, b] = n("paddingAbsolute");
    const m = !_ && v;
    if (g || d || m) {
      [u, d] = l(e);
    }
    const y = !i && (b || w || d);
    if (y) {
      const t = !p || !c && !f;
      const n = u.r + u.l;
      const o = u.t + u.b;
      const e = {
        marginRight: t && !h ? -n : 0,
        marginBottom: t ? -o : 0,
        marginLeft: t && h ? -n : 0,
        top: t ? -u.t : 0,
        right: t ? h ? -u.r : "auto" : 0,
        left: t ? h ? "auto" : -u.l : 0,
        width: t ? `calc(100% + ${n}px)` : ""
      };
      const i = {
        paddingTop: t ? u.t : 0,
        paddingRight: t ? u.r : 0,
        paddingBottom: t ? u.b : 0,
        paddingLeft: t ? u.l : 0
      };
      style(c || r, e);
      style(r, i);
      s({
        K: u,
        bt: !t,
        M: c ? i : assignDeep({}, e, i)
      });
    }
    return {
      yt: y
    };
  };
};

const {max: At} = Math;

const It = At.bind(0, 0);

const Lt = "visible";

const Ht = "hidden";

const Mt = 42;

const Pt = {
  u: equalWH,
  o: {
    w: 0,
    h: 0
  }
};

const Dt = {
  u: equalXY,
  o: {
    x: Ht,
    y: Ht
  }
};

const getOverflowAmount = (t, n) => {
  const o = window.devicePixelRatio % 1 !== 0 ? 1 : 0;
  const s = {
    w: It(t.w - n.w),
    h: It(t.h - n.h)
  };
  return {
    w: s.w > o ? s.w : 0,
    h: s.h > o ? s.h : 0
  };
};

const conditionalClass = (t, n, o) => o ? addClass(t, n) : removeClass(t, n);

const overflowIsVisible = t => 0 === t.indexOf(Lt);

const createOverflowUpdateSegment = (t, n) => {
  const [o, s] = n;
  const {W: e, K: c, J: r, tt: i, lt: l, dt: a, rt: u, st: d} = t;
  const {k: f, B: _, A: h, I: g} = getEnvironment();
  const v = getPlugins()[St];
  const w = !l && !h && (g.x || g.y);
  const p = u && l;
  const [b, m] = createCache(Pt, fractionalSize.bind(0, r));
  const [y, S] = createCache(Pt, scrollSize.bind(0, r));
  const [x, $] = createCache(Pt);
  const [C, I] = createCache(Pt);
  const [L] = createCache(Dt);
  const fixFlexboxGlue = (t, n) => {
    style(r, {
      height: ""
    });
    if (n) {
      const {bt: n, K: s} = o();
      const {St: c, P: i} = t;
      const l = fractionalSize(e);
      const a = clientSize(e);
      const u = "content-box" === style(r, "boxSizing");
      const d = n || u ? s.b + s.t : 0;
      const f = !(g.x && u);
      style(r, {
        height: a.h + l.h + (c.x && f ? i.x : 0) - d
      });
    }
  };
  const getViewportOverflowState = (t, n) => {
    const o = !h && !t ? Mt : 0;
    const getStatePerAxis = (t, s, e) => {
      const c = style(r, t);
      const i = n ? n[t] : c;
      const l = "scroll" === i;
      const a = s ? o : e;
      const u = l && !h ? a : 0;
      const d = s && !!o;
      return [ c, l, u, d ];
    };
    const [s, e, c, i] = getStatePerAxis("overflowX", g.x, f.x);
    const [l, a, u, d] = getStatePerAxis("overflowY", g.y, f.y);
    return {
      xt: {
        x: s,
        y: l
      },
      St: {
        x: e,
        y: a
      },
      P: {
        x: c,
        y: u
      },
      D: {
        x: i,
        y: d
      }
    };
  };
  const setViewportOverflowState = (t, n, o, s) => {
    const setAxisOverflowStyle = (t, n) => {
      const o = overflowIsVisible(t);
      const s = n && o && t.replace(`${Lt}-`, "") || "";
      return [ n && !o ? t : "", overflowIsVisible(s) ? "hidden" : s ];
    };
    const [e, c] = setAxisOverflowStyle(o.x, n.x);
    const [r, i] = setAxisOverflowStyle(o.y, n.y);
    s.overflowX = c && r ? c : e;
    s.overflowY = i && e ? i : r;
    return getViewportOverflowState(t, s);
  };
  const hideNativeScrollbars = (t, n, s, e) => {
    const {P: c, D: r} = t;
    const {x: i, y: l} = r;
    const {x: a, y: u} = c;
    const {M: d} = o();
    const f = n ? "marginLeft" : "marginRight";
    const _ = n ? "paddingLeft" : "paddingRight";
    const h = d[f];
    const g = d.marginBottom;
    const v = d[_];
    const w = d.paddingBottom;
    e.width = `calc(100% + ${u + -1 * h}px)`;
    e[f] = -u + h;
    e.marginBottom = -a + g;
    if (s) {
      e[_] = v + (l ? u : 0);
      e.paddingBottom = w + (i ? a : 0);
    }
  };
  const [H, M] = v ? v.H(w, _, r, i, o, getViewportOverflowState, hideNativeScrollbars) : [ () => w, () => [ noop ] ];
  return (t, n, i) => {
    const {ht: u, $t: f, gt: v, yt: w, _t: P, wt: k} = t;
    const {ft: V, vt: B} = o();
    const [Y, j] = n("showNativeOverlaidScrollbars");
    const [q, N] = n("overflow");
    const F = Y && g.x && g.y;
    const G = !l && !_ && (u || v || f || j || P);
    const X = overflowIsVisible(q.x);
    const U = overflowIsVisible(q.y);
    const W = X || U;
    let J = m(i);
    let K = S(i);
    let Z = $(i);
    let Q = I(i);
    let tt;
    if (j && h) {
      a(D, A, !F);
    }
    if (G) {
      tt = getViewportOverflowState(F);
      fixFlexboxGlue(tt, V);
    }
    if (u || w || v || k || j) {
      if (W) {
        a(R, z, false);
      }
      const [t, n] = M(F, B, tt);
      const [o, s] = J = b(i);
      const [e, c] = K = y(i);
      const l = clientSize(r);
      let u = e;
      let f = l;
      t();
      if ((c || s || j) && n && !F && H(n, e, o, B)) {
        f = clientSize(r);
        u = scrollSize(r);
      }
      const _ = {
        w: It(At(e.w, u.w) + o.w),
        h: It(At(e.h, u.h) + o.h)
      };
      const h = {
        w: It((p ? d.innerWidth : f.w + It(l.w - e.w)) + o.w),
        h: It((p ? d.innerHeight + o.h : f.h + It(l.h - e.h)) + o.h)
      };
      Q = C(h);
      Z = x(getOverflowAmount(_, h), i);
    }
    const [nt, ot] = Q;
    const [st, et] = Z;
    const [ct, rt] = K;
    const [it, lt] = J;
    const at = {
      x: st.w > 0,
      y: st.h > 0
    };
    const ut = X && U && (at.x || at.y) || X && at.x && !at.y || U && at.y && !at.x;
    if (w || k || lt || rt || ot || et || N || j || G) {
      const t = {
        marginRight: 0,
        marginBottom: 0,
        marginLeft: 0,
        width: "",
        overflowY: "",
        overflowX: ""
      };
      const n = setViewportOverflowState(F, at, q, t);
      const o = H(n, ct, it, B);
      if (!l) {
        hideNativeScrollbars(n, B, o, t);
      }
      if (G) {
        fixFlexboxGlue(n, V);
      }
      if (l) {
        attr(e, T, t.overflowX);
        attr(e, E, t.overflowY);
      } else {
        style(r, t);
      }
    }
    attrClass(e, O, z, ut);
    conditionalClass(c, R, ut);
    !l && conditionalClass(r, R, W);
    const [dt, ft] = L(getViewportOverflowState(F).xt);
    s({
      xt: dt,
      Ct: {
        x: nt.w,
        y: nt.h
      },
      Ot: {
        x: st.w,
        y: st.h
      },
      Tt: at
    });
    return {
      Et: ft,
      zt: ot,
      At: et
    };
  };
};

const prepareUpdateHints = (t, n, o) => {
  const s = {};
  const e = n || {};
  const c = keys(t).concat(keys(e));
  each(c, (n => {
    const c = t[n];
    const r = e[n];
    s[n] = !!(o || c || r);
  }));
  return s;
};

const createStructureSetupUpdate = (t, n) => {
  const {U: o, J: s, dt: e, lt: c} = t;
  const {A: r, I: i, B: l} = getEnvironment();
  const a = !r && (i.x || i.y);
  const u = [ createTrinsicUpdateSegment(t, n), createPaddingUpdateSegment(t, n), createOverflowUpdateSegment(t, n) ];
  return (t, n, r) => {
    const i = prepareUpdateHints(assignDeep({
      ht: false,
      yt: false,
      wt: false,
      _t: false,
      zt: false,
      At: false,
      Et: false,
      $t: false,
      gt: false
    }, n), {}, r);
    const d = a || !l;
    const f = d && scrollLeft(s);
    const _ = d && scrollTop(s);
    e("", I, true);
    let h = i;
    each(u, (n => {
      h = prepareUpdateHints(h, n(h, t, !!r) || {}, r);
    }));
    scrollLeft(s, f);
    scrollTop(s, _);
    e("", I);
    if (!c) {
      scrollLeft(o, 0);
      scrollTop(o, 0);
    }
    return h;
  };
};

const createEventContentChange = (t, n, o) => {
  let s;
  let e = false;
  const destroy = () => {
    e = true;
  };
  const updateElements = c => {
    if (o) {
      const r = o.reduce(((n, o) => {
        if (o) {
          const [s, e] = o;
          const r = e && s && (c ? c(s) : find(s, t));
          if (r && r.length && e && isString(e)) {
            push(n, [ r, e.trim() ], true);
          }
        }
        return n;
      }), []);
      each(r, (o => each(o[0], (c => {
        const r = o[1];
        const i = s.get(c) || [];
        const l = t.contains(c);
        if (l) {
          const t = on(c, r, (o => {
            if (e) {
              t();
              s.delete(c);
            } else {
              n(o);
            }
          }));
          s.set(c, push(i, t));
        } else {
          runEachAndClear(i);
          s.delete(c);
        }
      }))));
    }
  };
  if (o) {
    s = new WeakMap;
    updateElements();
  }
  return [ destroy, updateElements ];
};

const createDOMObserver = (t, n, o, s) => {
  let e = false;
  const {It: c, Lt: r, Ht: i, Mt: a, Pt: u, Dt: d} = s || {};
  const f = debounce((() => {
    if (e) {
      o(true);
    }
  }), {
    g: 33,
    v: 99
  });
  const [_, h] = createEventContentChange(t, f, i);
  const g = c || [];
  const v = r || [];
  const w = g.concat(v);
  const observerCallback = (e, c) => {
    const r = u || noop;
    const i = d || noop;
    const l = new Set;
    const f = new Set;
    let _ = false;
    let g = false;
    each(e, (o => {
      const {attributeName: e, target: c, type: u, oldValue: d, addedNodes: h, removedNodes: w} = o;
      const p = "attributes" === u;
      const b = "childList" === u;
      const m = t === c;
      const y = p && isString(e) ? attr(c, e) : 0;
      const S = 0 !== y && d !== y;
      const x = indexOf(v, e) > -1 && S;
      if (n && (b || !m)) {
        const n = !p;
        const u = p && S;
        const f = u && a && is(c, a);
        const _ = f ? !r(c, e, d, y) : n || u;
        const v = _ && !i(o, !!f, t, s);
        each(h, (t => l.add(t)));
        each(w, (t => l.add(t)));
        g = g || v;
      }
      if (!n && m && S && !r(c, e, d, y)) {
        f.add(e);
        _ = _ || x;
      }
    }));
    if (l.size > 0) {
      h((t => from(l).reduce(((n, o) => {
        push(n, find(t, o));
        return is(o, t) ? push(n, o) : n;
      }), [])));
    }
    if (n) {
      !c && g && o(false);
      return [ false ];
    }
    if (f.size > 0 || _) {
      const t = [ from(f), _ ];
      !c && o.apply(0, t);
      return t;
    }
  };
  const p = new l((t => observerCallback(t)));
  p.observe(t, {
    attributes: true,
    attributeOldValue: true,
    attributeFilter: w,
    subtree: n,
    childList: n,
    characterData: n
  });
  e = true;
  return [ () => {
    if (e) {
      _();
      p.disconnect();
      e = false;
    }
  }, () => {
    if (e) {
      f.m();
      const t = p.takeRecords();
      return !isEmptyArray(t) && observerCallback(t, true);
    }
  } ];
};

const Rt = 3333333;

const domRectHasDimensions = t => t && (t.height || t.width);

const createSizeObserver = (t, n, o) => {
  const {Rt: s = false, kt: e = false} = o || {};
  const c = getPlugins()[wt];
  const {V: r} = getEnvironment();
  const i = createDOM(`<div class="${k}"><div class="${B}"></div></div>`);
  const l = i[0];
  const a = l.firstChild;
  const d = directionIsRTL.bind(0, t);
  const [f] = createCache({
    o: void 0,
    _: true,
    u: (t, n) => !(!t || !domRectHasDimensions(t) && domRectHasDimensions(n))
  });
  const onSizeChangedCallbackProxy = t => {
    const o = isArray(t) && t.length > 0 && isObject(t[0]);
    const e = !o && isBoolean(t[0]);
    let c = false;
    let i = false;
    let a = true;
    if (o) {
      const [n, , o] = f(t.pop().contentRect);
      const s = domRectHasDimensions(n);
      const e = domRectHasDimensions(o);
      c = !o || !s;
      i = !e && s;
      a = !c;
    } else if (e) {
      [, a] = t;
    } else {
      i = true === t;
    }
    if (s && a) {
      const n = e ? t[0] : directionIsRTL(l);
      scrollLeft(l, n ? r.n ? -Rt : r.i ? 0 : Rt : Rt);
      scrollTop(l, Rt);
    }
    if (!c) {
      n({
        ht: !e,
        Vt: e ? t : void 0,
        kt: !!i
      });
    }
  };
  const _ = [];
  let h = e ? onSizeChangedCallbackProxy : false;
  return [ () => {
    runEachAndClear(_);
    removeElements(l);
  }, () => {
    if (u) {
      const t = new u(onSizeChangedCallbackProxy);
      t.observe(a);
      push(_, (() => {
        t.disconnect();
      }));
    } else if (c) {
      const [t, n] = c.O(a, onSizeChangedCallbackProxy, e);
      h = t;
      push(_, n);
    }
    if (s) {
      const [t] = createCache({
        o: !d()
      }, d);
      push(_, on(l, "scroll", (n => {
        const o = t();
        const [s, e] = o;
        if (e) {
          removeClass(a, "ltr rtl");
          if (s) {
            addClass(a, "rtl");
          } else {
            addClass(a, "ltr");
          }
          onSizeChangedCallbackProxy(o);
        }
        stopPropagation(n);
      })));
    }
    if (h) {
      addClass(l, V);
      push(_, on(l, "animationstart", h, {
        C: !!u
      }));
    }
    if (u || c) {
      appendChildren(t, l);
    }
  } ];
};

const isHeightIntrinsic = t => 0 === t.h || t.isIntersecting || t.intersectionRatio > 0;

const createTrinsicObserver = (t, n) => {
  let o;
  const s = createDiv(N);
  const e = [];
  const [c] = createCache({
    o: false
  });
  const triggerOnTrinsicChangedCallback = (t, o) => {
    if (t) {
      const s = c(isHeightIntrinsic(t));
      const [, e] = s;
      if (e) {
        !o && n(s);
        return [ s ];
      }
    }
  };
  const intersectionObserverCallback = (t, n) => {
    if (t && t.length > 0) {
      return triggerOnTrinsicChangedCallback(t.pop(), n);
    }
  };
  return [ () => {
    runEachAndClear(e);
    removeElements(s);
  }, () => {
    if (a) {
      o = new a((t => intersectionObserverCallback(t)), {
        root: t
      });
      o.observe(s);
      push(e, (() => {
        o.disconnect();
      }));
    } else {
      const onSizeChanged = () => {
        const t = offsetSize(s);
        triggerOnTrinsicChangedCallback(t);
      };
      const [t, n] = createSizeObserver(s, onSizeChanged);
      push(e, t);
      n();
      onSizeChanged();
    }
    appendChildren(t, s);
  }, () => {
    if (o) {
      return intersectionObserverCallback(o.takeRecords(), true);
    }
  } ];
};

const kt = `[${O}]`;

const Vt = `.${H}`;

const Bt = [ "tabindex" ];

const Yt = [ "wrap", "cols", "rows" ];

const jt = [ "id", "class", "style", "open" ];

const createStructureSetupObservers = (t, n, o) => {
  let s;
  let e;
  let c;
  const {W: r, J: i, Z: l, ct: a, lt: d, ut: f, dt: _} = t;
  const {B: h} = getEnvironment();
  const [g] = createCache({
    u: equalWH,
    o: {
      w: 0,
      h: 0
    }
  }, (() => {
    const t = f(R, z);
    const n = f(M, "");
    const o = n && scrollLeft(i);
    const s = n && scrollTop(i);
    _(R, z);
    _(M, "");
    _("", I, true);
    const e = scrollSize(l);
    const c = scrollSize(i);
    const r = fractionalSize(i);
    _(R, z, t);
    _(M, "", n);
    _("", I);
    scrollLeft(i, o);
    scrollTop(i, s);
    return {
      w: c.w + e.w + r.w,
      h: c.h + e.h + r.h
    };
  }));
  const v = a ? Yt : jt.concat(Yt);
  const w = debounce(o, {
    g: () => s,
    v: () => e,
    p(t, n) {
      const [o] = t;
      const [s] = n;
      return [ keys(o).concat(keys(s)).reduce(((t, n) => {
        t[n] = o[n] || s[n];
        return t;
      }), {}) ];
    }
  });
  const updateViewportAttrsFromHost = t => {
    each(t || Bt, (t => {
      if (indexOf(Bt, t) > -1) {
        const n = attr(r, t);
        if (isString(n)) {
          attr(i, t, n);
        } else {
          removeAttr(i, t);
        }
      }
    }));
  };
  const onTrinsicChanged = (t, s) => {
    const [e, c] = t;
    const r = {
      _t: c
    };
    n({
      ft: e
    });
    !s && o(r);
    return r;
  };
  const onSizeChanged = ({ht: t, Vt: s, kt: e}) => {
    const c = !t || e ? o : w;
    let r = false;
    if (s) {
      const [t, o] = s;
      r = o;
      n({
        vt: t
      });
    }
    c({
      ht: t,
      wt: r
    });
  };
  const onContentMutation = (t, n) => {
    const [, s] = g();
    const e = {
      gt: s
    };
    const c = t ? o : w;
    if (s) {
      !n && c(e);
    }
    return e;
  };
  const onHostMutation = (t, n, o) => {
    const s = {
      $t: n
    };
    if (n) {
      !o && w(s);
    } else if (!d) {
      updateViewportAttrsFromHost(t);
    }
    return s;
  };
  const [p, b, m] = l || !h ? createTrinsicObserver(r, onTrinsicChanged) : [ noop, noop, noop ];
  const [y, S] = !d ? createSizeObserver(r, onSizeChanged, {
    kt: true,
    Rt: true
  }) : [ noop, noop ];
  const [x, $] = createDOMObserver(r, false, onHostMutation, {
    Lt: jt,
    It: jt.concat(Bt)
  });
  const C = d && u && new u(onSizeChanged.bind(0, {
    ht: true
  }));
  C && C.observe(r);
  updateViewportAttrsFromHost();
  return [ () => {
    p();
    y();
    c && c[0]();
    C && C.disconnect();
    x();
  }, () => {
    S();
    b();
  }, () => {
    const t = {};
    const n = $();
    const o = m();
    const s = c && c[1]();
    if (n) {
      assignDeep(t, onHostMutation.apply(0, push(n, true)));
    }
    if (o) {
      assignDeep(t, onTrinsicChanged.apply(0, push(o, true)));
    }
    if (s) {
      assignDeep(t, onContentMutation.apply(0, push(s, true)));
    }
    return t;
  }, t => {
    const [n] = t("update.ignoreMutation");
    const [o, r] = t("update.attributes");
    const [a, u] = t("update.elementEvents");
    const [f, _] = t("update.debounce");
    const h = u || r;
    const ignoreMutationFromOptions = t => isFunction(n) && n(t);
    if (h) {
      if (c) {
        c[1]();
        c[0]();
      }
      c = createDOMObserver(l || i, true, onContentMutation, {
        It: v.concat(o || []),
        Ht: a,
        Mt: kt,
        Dt: (t, n) => {
          const {target: o, attributeName: s} = t;
          const e = !n && s && !d ? liesBetween(o, kt, Vt) : false;
          return e || !!closest(o, `.${F}`) || !!ignoreMutationFromOptions(t);
        }
      });
    }
    if (_) {
      w.m();
      if (isArray(f)) {
        const t = f[0];
        const n = f[1];
        s = isNumber(t) && t;
        e = isNumber(n) && n;
      } else if (isNumber(f)) {
        s = f;
        e = false;
      } else {
        s = false;
        e = false;
      }
    }
  } ];
};

const qt = {
  x: 0,
  y: 0
};

const Nt = {
  K: {
    t: 0,
    r: 0,
    b: 0,
    l: 0
  },
  bt: false,
  M: {
    marginRight: 0,
    marginBottom: 0,
    marginLeft: 0,
    paddingTop: 0,
    paddingRight: 0,
    paddingBottom: 0,
    paddingLeft: 0
  },
  Ct: qt,
  Ot: qt,
  xt: {
    x: "hidden",
    y: "hidden"
  },
  Tt: {
    x: false,
    y: false
  },
  ft: false,
  vt: false
};

const createStructureSetup = (t, n) => {
  const o = createOptionCheck(n, {});
  const s = createState(Nt);
  const [e, c, r] = createEventListenerHub();
  const [i, l] = s;
  const [a, u, d] = createStructureSetupElements(t);
  const f = createStructureSetupUpdate(a, s);
  const triggerUpdateEvent = (t, n, o) => {
    const s = keys(t).some((n => t[n]));
    const e = s || !isEmptyObject(n) || o;
    if (e) {
      r("u", [ t, n, o ]);
    }
    return e;
  };
  const [_, h, g, v] = createStructureSetupObservers(a, l, (t => triggerUpdateEvent(f(o, t), {}, false)));
  const w = i.bind(0);
  w.Bt = t => e("u", t);
  w.Yt = () => {
    const {U: t, J: n} = a;
    const o = scrollLeft(t);
    const s = scrollTop(t);
    h();
    u();
    scrollLeft(n, o);
    scrollTop(n, s);
  };
  w.jt = a;
  return [ (t, o) => {
    const s = createOptionCheck(n, t, o);
    v(s);
    return triggerUpdateEvent(f(s, g(), o), t, !!o);
  }, w, () => {
    c();
    _();
    d();
  } ];
};

const {round: Ft} = Math;

const getScale = t => {
  const {width: n, height: o} = getBoundingClientRect(t);
  const {w: s, h: e} = offsetSize(t);
  return {
    x: Ft(n) / s || 1,
    y: Ft(o) / e || 1
  };
};

const continuePointerDown = (t, n, o) => {
  const s = n.scrollbars;
  const {button: e, isPrimary: c, pointerType: r} = t;
  const {pointers: i} = s;
  return 0 === e && c && s[o ? "dragScroll" : "clickScroll"] && (i || []).includes(r);
};

const createRootClickStopPropagationEvents = (t, n) => on(t, "mousedown", on.bind(0, n, "click", stopPropagation, {
  C: true,
  $: true
}), {
  $: true
});

const createInteractiveScrollEvents = (t, n, o, s, e, c) => {
  const {V: r} = getEnvironment();
  const {qt: i, Nt: l, Ft: a} = o;
  const u = `scroll${c ? "Left" : "Top"}`;
  const d = `client${c ? "X" : "Y"}`;
  const f = c ? "width" : "height";
  const _ = c ? "left" : "top";
  const h = c ? "w" : "h";
  const g = c ? "x" : "y";
  const createRelativeHandleMove = (t, n) => o => {
    const {Ot: d} = e();
    const f = offsetSize(l)[h] - offsetSize(i)[h];
    const _ = n * o / f;
    const v = _ * d[g];
    const w = directionIsRTL(a);
    const p = w && c ? r.n || r.i ? 1 : -1 : 1;
    s[u] = t + v * p;
  };
  return on(l, "pointerdown", (o => {
    const e = closest(o.target, `.${J}`) === i;
    if (continuePointerDown(o, t, e)) {
      const t = !e && o.shiftKey;
      const getHandleRect = () => getBoundingClientRect(i);
      const getTrackRect = () => getBoundingClientRect(l);
      const getHandleOffset = (t, n) => (t || getHandleRect())[_] - (n || getTrackRect())[_];
      const c = createRelativeHandleMove(s[u] || 0, 1 / getScale(s)[g]);
      const r = o[d];
      const a = getHandleRect();
      const h = getTrackRect();
      const v = a[f];
      const w = getHandleOffset(a, h) + v / 2;
      const p = r - h[_];
      const b = e ? 0 : p - w;
      const m = [ on(n, "selectstart", (t => preventDefault(t)), {
        S: false
      }), on(l, "pointermove", (n => {
        const o = n[d] - r;
        if (e || t) {
          c(b + o);
        }
      })) ];
      if (t) {
        c(b);
      } else if (!e) {
        const t = getPlugins()[$t];
        if (t) {
          push(m, t.O(c, getHandleOffset, b, v, p));
        }
      }
      on(l, "pointerup", (t => {
        runEachAndClear(m);
        l.releasePointerCapture(t.pointerId);
      }), {
        C: true
      });
      l.setPointerCapture(o.pointerId);
    }
  }));
};

const createScrollbarsSetupEvents = (t, n) => (o, s, e, c, r, i) => {
  const {Ft: l} = o;
  const [a, u] = selfClearTimeout(333);
  const d = !!r.scrollBy;
  let f = true;
  return runEachAndClear.bind(0, [ on(l, "pointerenter", (() => {
    s(tt, true);
  })), on(l, "pointerleave pointercancel", (() => {
    s(tt);
  })), on(l, "wheel", (t => {
    const {deltaX: n, deltaY: o, deltaMode: e} = t;
    if (d && f && 0 === e && parent(l) === c) {
      r.scrollBy({
        left: n,
        top: o,
        behavior: "smooth"
      });
    }
    f = false;
    s(st, true);
    a((() => {
      f = true;
      s(st);
    }));
    preventDefault(t);
  }), {
    S: false,
    $: true
  }), createRootClickStopPropagationEvents(l, e), createInteractiveScrollEvents(t, e, o, r, n, i), u ]);
};

const {min: Gt, max: Xt, abs: Ut, round: Wt} = Math;

const getScrollbarHandleLengthRatio = (t, n, o, s) => {
  if (s) {
    const t = o ? "x" : "y";
    const {Ot: n, Ct: e} = s;
    const c = e[t];
    const r = n[t];
    return Xt(0, Gt(1, c / (c + r)));
  }
  const e = o ? "w" : "h";
  const c = offsetSize(t)[e];
  const r = offsetSize(n)[e];
  return Xt(0, Gt(1, c / r));
};

const getScrollbarHandleOffsetRatio = (t, n, o, s, e, c) => {
  const {V: r} = getEnvironment();
  const i = c ? "x" : "y";
  const l = c ? "Left" : "Top";
  const {Ot: a} = s;
  const u = Wt(a[i]);
  const d = Ut(o[`scroll${l}`]);
  const f = c && e;
  const _ = r.i ? d : u - d;
  const h = f ? _ : d;
  const g = Gt(1, h / u);
  const v = getScrollbarHandleLengthRatio(t, n, c);
  return 1 / v * (1 - v) * g;
};

const createScrollbarsSetupElements = (t, n, o) => {
  const {j: s} = getEnvironment();
  const {scrollbars: e} = s();
  const {slot: c} = e;
  const {et: r, U: i, W: l, J: a, it: u, nt: d} = n;
  const {scrollbars: f} = u ? {} : t;
  const {slot: h} = f || {};
  const g = dynamicInitializationElement([ i, l, a ], (() => l), c, h);
  const scrollbarStructureAddRemoveClass = (t, n, o) => {
    const s = o ? addClass : removeClass;
    each(t, (t => {
      s(t.Ft, n);
    }));
  };
  const scrollbarsHandleStyle = (t, n) => {
    each(t, (t => {
      const [o, s] = n(t);
      style(o, s);
    }));
  };
  const scrollbarStructureRefreshHandleLength = (t, n, o) => {
    scrollbarsHandleStyle(t, (t => {
      const {qt: s, Nt: e} = t;
      return [ s, {
        [o ? "width" : "height"]: `${(100 * getScrollbarHandleLengthRatio(s, e, o, n)).toFixed(3)}%`
      } ];
    }));
  };
  const scrollbarStructureRefreshHandleOffset = (t, n, o) => {
    const s = o ? "X" : "Y";
    scrollbarsHandleStyle(t, (t => {
      const {qt: e, Nt: c, Ft: r} = t;
      const i = getScrollbarHandleOffsetRatio(e, c, d, n, directionIsRTL(r), o);
      const l = i === i;
      return [ e, {
        transform: l ? `translate${s}(${(100 * i).toFixed(3)}%)` : ""
      } ];
    }));
  };
  const v = [];
  const w = [];
  const p = [];
  const scrollbarsAddRemoveClass = (t, n, o) => {
    const s = isBoolean(o);
    const e = s ? o : true;
    const c = s ? !o : true;
    e && scrollbarStructureAddRemoveClass(w, t, n);
    c && scrollbarStructureAddRemoveClass(p, t, n);
  };
  const refreshScrollbarsHandleLength = t => {
    scrollbarStructureRefreshHandleLength(w, t, true);
    scrollbarStructureRefreshHandleLength(p, t);
  };
  const refreshScrollbarsHandleOffset = t => {
    scrollbarStructureRefreshHandleOffset(w, t, true);
    scrollbarStructureRefreshHandleOffset(p, t);
  };
  const generateScrollbarDOM = t => {
    const n = t ? X : U;
    const s = t ? w : p;
    const e = isEmptyArray(s) ? Q : "";
    const c = createDiv(`${F} ${n} ${e}`);
    const i = createDiv(W);
    const a = createDiv(J);
    const u = {
      Ft: c,
      Nt: i,
      qt: a
    };
    appendChildren(c, i);
    appendChildren(i, a);
    push(s, u);
    push(v, [ removeElements.bind(0, c), o(u, scrollbarsAddRemoveClass, r, l, d, t) ]);
    return u;
  };
  const b = generateScrollbarDOM.bind(0, true);
  const m = generateScrollbarDOM.bind(0, false);
  const appendElements = () => {
    appendChildren(g, w[0].Ft);
    appendChildren(g, p[0].Ft);
    _((() => {
      scrollbarsAddRemoveClass(Q);
    }), 300);
  };
  b();
  m();
  return [ {
    Gt: refreshScrollbarsHandleLength,
    Xt: refreshScrollbarsHandleOffset,
    Ut: scrollbarsAddRemoveClass,
    Wt: {
      Jt: w,
      Kt: b,
      Zt: scrollbarsHandleStyle.bind(0, w)
    },
    Qt: {
      Jt: p,
      Kt: m,
      Zt: scrollbarsHandleStyle.bind(0, p)
    }
  }, appendElements, runEachAndClear.bind(0, v) ];
};

const createScrollbarsSetup = (t, n, o) => {
  let s;
  let e;
  let c;
  let r;
  let i;
  let l = 0;
  const a = createState({});
  const [u] = a;
  const [d, f] = selfClearTimeout();
  const [_, h] = selfClearTimeout();
  const [g, v] = selfClearTimeout(100);
  const [w, p] = selfClearTimeout(100);
  const [b, m] = selfClearTimeout((() => l));
  const [y, S, x] = createScrollbarsSetupElements(t, o.jt, createScrollbarsSetupEvents(n, o));
  const {W: $, J: C, nt: O, ot: T, lt: E, rt: z} = o.jt;
  const {Wt: A, Qt: I, Ut: L, Gt: H, Xt: M} = y;
  const {Zt: P} = A;
  const {Zt: D} = I;
  const styleScrollbarPosition = t => {
    const {Ft: n} = t;
    const o = E && !z && parent(n) === C && n;
    return [ o, {
      transform: o ? `translate(${scrollLeft(O)}px, ${scrollTop(O)}px)` : ""
    } ];
  };
  const manageScrollbarsAutoHide = (t, n) => {
    m();
    if (t) {
      L(ot);
    } else {
      const hide = () => L(ot, true);
      if (l > 0 && !n) {
        b(hide);
      } else {
        hide();
      }
    }
  };
  const onHostMouseEnter = () => {
    r = e;
    r && manageScrollbarsAutoHide(true);
  };
  const R = [ v, m, p, h, f, x, on($, "pointerover", onHostMouseEnter, {
    C: true
  }), on($, "pointerenter", onHostMouseEnter), on($, "pointerleave", (() => {
    r = false;
    e && manageScrollbarsAutoHide(false);
  })), on($, "pointermove", (() => {
    s && d((() => {
      v();
      manageScrollbarsAutoHide(true);
      w((() => {
        s && manageScrollbarsAutoHide(false);
      }));
    }));
  })), on(T, "scroll", (() => {
    _((() => {
      M(o());
      c && manageScrollbarsAutoHide(true);
      g((() => {
        c && !r && manageScrollbarsAutoHide(false);
      }));
    }));
    E && P(styleScrollbarPosition);
    E && D(styleScrollbarPosition);
  })) ];
  const k = u.bind(0);
  k.jt = y;
  k.Yt = S;
  return [ (t, r, a) => {
    const {zt: u, At: d, Et: f, wt: _} = a;
    const h = createOptionCheck(n, t, r);
    const g = o();
    const {Ot: v, xt: w, vt: p} = g;
    const [b, m] = h("scrollbars.theme");
    const [y, S] = h("scrollbars.visibility");
    const [x, $] = h("scrollbars.autoHide");
    const [C] = h("scrollbars.autoHideDelay");
    const [O, T] = h("scrollbars.dragScroll");
    const [E, A] = h("scrollbars.clickScroll");
    const I = u || d || _ || r;
    const P = f || S || r;
    const setScrollbarVisibility = (t, n) => {
      const o = "visible" === y || "auto" === y && "scroll" === t;
      L(K, o, n);
      return o;
    };
    l = C;
    if (m) {
      L(i);
      L(b, true);
      i = b;
    }
    if ($) {
      s = "move" === x;
      e = "leave" === x;
      c = "never" !== x;
      manageScrollbarsAutoHide(!c, true);
    }
    if (T) {
      L(ct, O);
    }
    if (A) {
      L(et, E);
    }
    if (P) {
      const t = setScrollbarVisibility(w.x, true);
      const n = setScrollbarVisibility(w.y, false);
      const o = t && n;
      L(Z, !o);
    }
    if (I) {
      H(g);
      M(g);
      L(nt, !v.x, true);
      L(nt, !v.y, false);
      L(G, p && !z);
    }
  }, k, runEachAndClear.bind(0, R) ];
};

const invokePluginInstance = (t, n, o) => {
  if (isFunction(t)) {
    t(n || void 0, o || void 0);
  }
};

const OverlayScrollbars = (t, n, o) => {
  const {N: s, j: e, Y: c} = getEnvironment();
  const r = getPlugins();
  const i = isHTMLElement(t);
  const l = i ? t : t.target;
  const a = getInstance(l);
  if (n && !a) {
    let a = false;
    const validateOptions = t => {
      const n = getPlugins()[ht];
      const o = n && n.O;
      return o ? o(t, true) : t;
    };
    const u = assignDeep({}, s(), validateOptions(n));
    const [d, f, _] = createEventListenerHub(o);
    const [h, g, v] = createStructureSetup(t, u);
    const [w, p, b] = createScrollbarsSetup(t, u, g);
    const update = (t, n) => h(t, !!n);
    const m = c(update.bind(0, {}, true));
    const destroy = t => {
      removeInstance(l);
      m();
      b();
      v();
      a = true;
      _("destroyed", [ y, !!t ]);
      f();
    };
    const y = {
      options(t) {
        if (t) {
          const n = getOptionsDiff(u, validateOptions(t));
          if (!isEmptyObject(n)) {
            assignDeep(u, n);
            update(n);
          }
        }
        return assignDeep({}, u);
      },
      on: d,
      off: (t, n) => {
        t && n && f(t, n);
      },
      state() {
        const {Ct: t, Ot: n, xt: o, Tt: s, K: e, bt: c, vt: r} = g();
        return assignDeep({}, {
          overflowEdge: t,
          overflowAmount: n,
          overflowStyle: o,
          hasOverflow: s,
          padding: e,
          paddingAbsolute: c,
          directionRTL: r,
          destroyed: a
        });
      },
      elements() {
        const {U: t, W: n, K: o, J: s, Z: e, nt: c, ot: r} = g.jt;
        const {Wt: i, Qt: l} = p.jt;
        const translateScrollbarStructure = t => {
          const {qt: n, Nt: o, Ft: s} = t;
          return {
            scrollbar: s,
            track: o,
            handle: n
          };
        };
        const translateScrollbarsSetupElement = t => {
          const {Jt: n, Kt: o} = t;
          const s = translateScrollbarStructure(n[0]);
          return assignDeep({}, s, {
            clone: () => {
              const t = translateScrollbarStructure(o());
              w({}, true, {});
              return t;
            }
          });
        };
        return assignDeep({}, {
          target: t,
          host: n,
          padding: o || s,
          viewport: s,
          content: e || s,
          scrollOffsetElement: c,
          scrollEventElement: r,
          scrollbarHorizontal: translateScrollbarsSetupElement(i),
          scrollbarVertical: translateScrollbarsSetupElement(l)
        });
      },
      update: t => update({}, t),
      destroy: destroy.bind(0)
    };
    g.Bt(((t, n, o) => {
      w(n, o, t);
    }));
    addInstance(l, y);
    each(keys(r), (t => invokePluginInstance(r[t], 0, y)));
    if (cancelInitialization(g.jt.rt, e().cancel, !i && t.cancel)) {
      destroy(true);
      return y;
    }
    g.Yt();
    p.Yt();
    _("initialized", [ y ]);
    g.Bt(((t, n, o) => {
      const {ht: s, wt: e, _t: c, zt: r, At: i, Et: l, gt: a, $t: u} = t;
      _("updated", [ y, {
        updateHints: {
          sizeChanged: s,
          directionChanged: e,
          heightIntrinsicChanged: c,
          overflowEdgeChanged: r,
          overflowAmountChanged: i,
          overflowStyleChanged: l,
          contentMutation: a,
          hostMutation: u
        },
        changedOptions: n,
        force: o
      } ]);
    }));
    y.update(true);
    return y;
  }
  return a;
};

OverlayScrollbars.plugin = t => {
  each(addPlugin(t), (t => invokePluginInstance(t, OverlayScrollbars)));
};

OverlayScrollbars.valid = t => {
  const n = t && t.elements;
  const o = isFunction(n) && n();
  return isPlainObject(o) && !!getInstance(o.target);
};

OverlayScrollbars.env = () => {
  const {k: t, I: n, A: o, V: s, B: e, L: c, G: r, X: i, j: l, q: a, N: u, F: d} = getEnvironment();
  return assignDeep({}, {
    scrollbarsSize: t,
    scrollbarsOverlaid: n,
    scrollbarsHiding: o,
    rtlScrollBehavior: s,
    flexboxGlue: e,
    cssCustomProperties: c,
    staticDefaultInitialization: r,
    staticDefaultOptions: i,
    getDefaultInitialization: l,
    setDefaultInitialization: a,
    getDefaultOptions: u,
    setDefaultOptions: d
  });
};

export { Ct as ClickScrollPlugin, OverlayScrollbars, xt as ScrollbarsHidingPlugin, pt as SizeObserverPlugin };
//# sourceMappingURL=overlayscrollbars.mjs.map
