[![Build Status](https://travis-ci.org/processing/p5.js.svg?branch=master)](https://travis-ci.org/processing/p5.js) [![npm version](https://badge.fury.io/js/p5.svg)](https://www.npmjs.com/package/p5)

# [p5.js](http://p5js.org)

[Hello!](http://hello.p5js.org/) p5.js is a JavaScript library that starts with the original goal of Processing, to make coding accessible for artists, designers, educators, and beginners, and reinterprets this for today's web.

Using the original metaphor of a software sketchbook, p5.js has a full set of drawing functionality. However, you're not limited to your drawing canvas, you can think of your whole browser page as your sketch! For this, p5.js has addon libraries that make it easy to interact with other HTML5 objects, including text, input, video, webcam, and sound.

p5.js is a new interpretation, not an emulation or port, and it is in active development. An official editing environment is coming soon, as well as many more features!

If you already know the basics of JavaScript or Processing, the [p5.js overview](https://github.com/processing/p5.js/wiki/p5.js-overview) wiki page is a good place to start. The [frequently asked questions](https://github.com/processing/p5.js/wiki/Frequently-Asked-Questions) might also be helpful.

If you have found a bug in the p5.js library, you can file it here under the [“issues” tab](https://github.com/processing/p5.js/issues). An indicative template for reporting an issue is provided to assist you (and us!) better.

## p5.js library

To use the complete p5.js library, you can [download it here](http://p5js.org/download). If you are interested in the most recent, less stable version, or even simply in (**new!**) certain components of p5.js, you can clone this repository and run `grunt` from the command line to generate the library from source. See the [development](https://github.com/processing/p5.js/wiki/Development#Setup) wiki for more information about our build process to generate the complete as well as selective library.	

You can also start with the [codepen template](https://codepen.io/p5js/pen/wreBKy). You may need to update the version of the p5.js library that is linked into the html section.

## Issues

Please post bugs in the proper repository:

* p5.js general and p5.dom: [https://github.com/processing/p5.js/issues](https://github.com/processing/p5.js/issues)
* p5.sound: [https://github.com/processing/p5.js-sound/issues](https://github.com/processing/p5.js-sound/issues)
* p5.js website: [https://github.com/processing/p5.js-website/issues](https://github.com/processing/p5.js-website/issues)
* p5.js web editor: [https://github.com/processing/p5.js-web-editor/issues](https://github.com/processing/p5.js-web-editor/issues)


## Learning

Check out [p5js.org](http://p5js.org) for lots more! Here are some quick-links:

* [Get Started](http://p5js.org/get-started) — Create and run your first sketch!
* [p5.js overview](https://github.com/processing/p5.js/wiki/p5.js-overview) — An overview of the main features and functionality of p5.js.
* [Reference](http://p5js.org/reference) — The functionality supported by p5.js.
* [Learn](//p5js.org/learn) — Tutorials and short, prototypical examples exploring the basics of p5.js.
* [Forum](http://forum.processing.org/two/categories/p5-js) — Ask and answers questions about how to make things with p5.js here.
* [Libraries](http://p5js.org/libraries) — Extend p5 functionality to interact with HTML, manipulate sound, and more!
* [FAQ](https://github.com/processing/p5.js/wiki/Frequently-Asked-Questions)

## Get Involved

p5.js is a collaborative project created by many individuals, and you are invited to help. All types of involvement are welcome. See the [community section](http://p5js.org/community) to get started!

Developers, check out the [development](https://github.com/processing/p5.js/wiki/Development) wiki page for more in-depth details about contributing code, bug fixes, and documentation.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key))!

We recognize all types of contributions. This project follows the [all-contributors](https://github.com/kentcdodds/all-contributors) specification. Instructions to add yourself or add contribution emojis to your name are [here](https://github.com/processing/p5.js/issues/2309).

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
| [<img src="https://avatars3.githubusercontent.com/u/191056?v=4" width="100px;"/><br /><sub>Lauren McCarthy</sub>](http://lauren-mccarthy.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/504124?v=4" width="100px;"/><br /><sub>Jason Sigal</sub>](http://jasonsigal.cc)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1695075?v=4" width="100px;"/><br /><sub>Karen</sub>](https://twitter.com/KarenPunkPunk)<br /> | [<img src="https://avatars1.githubusercontent.com/u/699840?v=4" width="100px;"/><br /><sub>Evelyn Eastmond</sub>](http://www.evelyneastmond.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/191758?v=4" width="100px;"/><br /><sub>Daniel Shiffman</sub>](http://www.shiffman.net)<br /> | [<img src="https://avatars2.githubusercontent.com/u/677774?v=4" width="100px;"/><br /><sub>Casey Reas</sub>](http://reas.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1623101?v=4" width="100px;"/><br /><sub>Ben Fry</sub>](http://fathom.info)<br /> |
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| [<img src="https://avatars3.githubusercontent.com/u/7543950?v=4" width="100px;"/><br /><sub>Kenneth Lim</sub>](https://designerken.be/designing)<br />[🐛](https://github.com/processing/p5.js/issues?q=author%3Alimzykenneth "Bug reports") [💻](https://github.com/processing/p5.js/commits?author=limzykenneth "Code") [📖](https://github.com/processing/p5.js/commits?author=limzykenneth "Documentation") | [<img src="https://avatars0.githubusercontent.com/u/78966?v=4" width="100px;"/><br /><sub>kate hollenbach</sub>](http://www.katehollenbach.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/10382506?v=4" width="100px;"/><br /><sub>Stalgia Grigg</sub>](https://github.com/mlarghydracept)<br /> | [<img src="https://avatars3.githubusercontent.com/u/3985997?v=4" width="100px;"/><br /><sub>Jerel Johnson</sub>](https://github.com/machinic)<br /> | [<img src="https://avatars2.githubusercontent.com/u/8774516?v=4" width="100px;"/><br /><sub>Saksham Saxena</sub>](http://sakshamsaxena.in)<br /> | [<img src="https://avatars3.githubusercontent.com/u/11218401?v=4" width="100px;"/><br /><sub>saber khan</sub>](https://twitter.com/ed_saber)<br /> | [<img src="https://avatars3.githubusercontent.com/u/737638?v=4" width="100px;"/><br /><sub>dhowe</sub>](https://github.com/dhowe)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/1585036?v=4" width="100px;"/><br /><sub>Kevin Siwoff</sub>](http://kevinsiwoff.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/124687?v=4" width="100px;"/><br /><sub>Atul Varma</sub>](http://portfolio.toolness.org/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/535012?v=4" width="100px;"/><br /><sub>Jess Klein</sub>](http://www.jessklein.is/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/7158943?v=4" width="100px;"/><br /><sub>uno seis tres</sub>](http://unoseistres.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/5489125?v=4" width="100px;"/><br /><sub>susan evans</sub>](http://www.susanev.com/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/2619912?v=4" width="100px;"/><br /><sub>Saskia Freeke</sub>](http://sasj.tumblr.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/783625?v=4" width="100px;"/><br /><sub>Phoenix Perry</sub>](http://www.phoenixperry.com)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/2850174?v=4" width="100px;"/><br /><sub>jesse cahn-thompson</sub>](https://s01e01.xyz/jct)<br /> | [<img src="https://avatars1.githubusercontent.com/u/7377908?v=4" width="100px;"/><br /><sub>Lee T</sub>](https://github.com/lee2sman)<br /> | [<img src="https://avatars0.githubusercontent.com/u/26236471?v=4" width="100px;"/><br /><sub>Chelly Jin</sub>](http://www.cargocollective.com/chellyjin)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1680038?v=4" width="100px;"/><br /><sub>DIYgirls</sub>](http://www.diygirls.org)<br /> | [<img src="https://avatars3.githubusercontent.com/u/8697852?v=4" width="100px;"/><br /><sub>lam802</sub>](https://github.com/lam802)<br /> | [<img src="https://avatars0.githubusercontent.com/u/8224678?v=4" width="100px;"/><br /><sub>Maya Man</sub>](http://www.mayaman.cc)<br /> | [<img src="https://avatars0.githubusercontent.com/u/5488045?v=4" width="100px;"/><br /><sub>Tega Brain</sub>](https://github.com/tegacodes)<br /> |
| [<img src="https://avatars3.githubusercontent.com/u/295879?v=4" width="100px;"/><br /><sub>luisaph</sub>](https://github.com/luisaph)<br /> | [<img src="https://avatars2.githubusercontent.com/u/22488500?v=4" width="100px;"/><br /><sub>AlM Chng</sub>](https://github.com/almchung)<br /> | [<img src="https://avatars3.githubusercontent.com/u/3926350?v=4" width="100px;"/><br /><sub>aarón montoya-moraga</sub>](http://montoyamoraga.io)<br /> | [<img src="https://avatars1.githubusercontent.com/u/6063380?v=4" width="100px;"/><br /><sub>Cassie Tarakajian</sub>](https://github.com/catarak)<br /> | [<img src="https://avatars0.githubusercontent.com/u/20650298?s=460&amp;v=4" width="100px;"/><br /><sub>Niklas Peters</sub>](https://www.niklaspeters.com)<br />[📖](https://github.com/processing/p5.js/commits?author=nikfm "Documentation") [✅](#tutorial-nikfm "Tutorials") | [<img src="https://avatars3.githubusercontent.com/u/5505598?v=4" width="100px;"/><br /><sub>Mathura MG</sub>](http://mathuramg.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/8662372?v=4" width="100px;"/><br /><sub>Yining Shi</sub>](http://1023.io)<br /> |
| [<img src="https://avatars0.githubusercontent.com/u/9204835?v=4" width="100px;"/><br /><sub>Jen Kagan</sub>](http://kaganjd.github.io/portfolio/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/6025418?v=4" width="100px;"/><br /><sub>Jiashan Wu</sub>](http://fromjia.com/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/8646752?v=4" width="100px;"/><br /><sub>Marc Abbey</sub>](https://github.com/futuremarc)<br /> | [<img src="https://avatars1.githubusercontent.com/u/442115?v=4" width="100px;"/><br /><sub>K.Adam White</sub>](http://www.kadamwhite.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/11491479?v=4" width="100px;"/><br /><sub>Joe Cridge</sub>](https://www.joecridge.me/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1131802?v=4" width="100px;"/><br /><sub>Michael Hadley</sub>](http://mikewesthad.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/2047962?v=4" width="100px;"/><br /><sub>Todd H. Page</sub>](http://tiller.dog)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/3926730?v=4" width="100px;"/><br /><sub>Jared Sprague</sub>](http://jaredsprague.com/)<br />[💻](https://github.com/processing/p5.js/commits?author=Jared-Sprague "Code") [📖](https://github.com/processing/p5.js/commits?author=Jared-Sprague "Documentation") [💡](#example-Jared-Sprague "Examples") [💵](#financial-Jared-Sprague "Financial") [⚠️](https://github.com/processing/p5.js/commits?author=Jared-Sprague "Tests") [🐛](https://github.com/processing/p5.js/issues?q=author%3AJared-Sprague "Bug reports") | [<img src="https://avatars3.githubusercontent.com/u/964912?v=4" width="100px;"/><br /><sub>evelyn masso</sub>](http://www.outofambit.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/297936?v=4" width="100px;"/><br /><sub>Blaize Kaye</sub>](http://bomoko.net)<br /> | [<img src="https://avatars1.githubusercontent.com/u/9005407?v=4" width="100px;"/><br /><sub>Sanchit Kapoor</sub>](https://github.com/DarkPrince304)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1187491?v=4" width="100px;"/><br /><sub>Oliver Wright</sub>](http://meiamso.me)<br /> | [<img src="https://avatars1.githubusercontent.com/u/911429?v=4" width="100px;"/><br /><sub>Matthew Kaney</sub>](https://github.com/mindofmatthew)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1088194?v=4" width="100px;"/><br /><sub>Spongman</sub>](https://github.com/Spongman)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/5375410?v=4" width="100px;"/><br /><sub>Claire K-V</sub>](https://github.com/CleezyITP)<br /> | [<img src="https://avatars0.githubusercontent.com/u/4147978?v=4" width="100px;"/><br /><sub>R. Luke DuBois</sub>](http://lukedubois.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1044413?v=4" width="100px;"/><br /><sub>Kevin Barabash</sub>](https://github.com/kevinbarabash)<br /> | [<img src="https://avatars2.githubusercontent.com/u/62246?v=4" width="100px;"/><br /><sub>codeanticode</sub>](http://andrescolubri.net/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/94167?v=4" width="100px;"/><br /><sub>Bob Holt</sub>](http://www.bobholtwebdev.com/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1477362?v=4" width="100px;"/><br /><sub>Sarah Groff Hennigh-Palermo</sub>](http://sarahghp.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/288140?v=4" width="100px;"/><br /><sub>Jordan Shaw</sub>](http://jordanshaw.com)<br /> |
| [<img src="https://avatars3.githubusercontent.com/u/751191?v=4" width="100px;"/><br /><sub>brightredchilli</sub>](https://github.com/brightredchilli)<br /> | [<img src="https://avatars0.githubusercontent.com/u/611218?v=4" width="100px;"/><br /><sub>Derek J. Kinsman</sub>](http://derekkinsman.com/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/8079861?v=4" width="100px;"/><br /><sub>harkirat singh</sub>](https://github.com/hkirat)<br /> | [<img src="https://avatars2.githubusercontent.com/u/6551569?v=4" width="100px;"/><br /><sub>GoToLoop</sub>](https://github.com/GoToLoop)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1191970?v=4" width="100px;"/><br /><sub>Max Goldstein</sub>](http://maxgoldste.in/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1507265?v=4" width="100px;"/><br /><sub>XY Feng</sub>](http://xystudio.cc)<br /> | [<img src="https://avatars1.githubusercontent.com/u/6324861?v=4" width="100px;"/><br /><sub>Sparsh Paliwal</sub>](https://github.com/PaliwalSparsh)<br /> |
| [<img src="https://avatars3.githubusercontent.com/u/4655775?v=4" width="100px;"/><br /><sub>Austin Cawley-Edwards</sub>](https://austince.me)<br />[📖](https://github.com/processing/p5.js/commits?author=austince "Documentation") [💡](#example-austince "Examples") | [<img src="https://avatars1.githubusercontent.com/u/1040718?v=4" width="100px;"/><br /><sub>taseenb</sub>](http://www.estebanalmiron.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/26408?v=4" width="100px;"/><br /><sub>Yannick Assogba</sub>](https://github.com/tafsiri)<br /> | [<img src="https://avatars3.githubusercontent.com/u/2349625?v=4" width="100px;"/><br /><sub>John Pasquarello</sub>](https://github.com/johnpasquarello)<br />[💻](https://github.com/processing/p5.js/commits?author=johnpasquarello "Code") | [<img src="https://avatars1.githubusercontent.com/u/6930986?v=4" width="100px;"/><br /><sub>Kevin Workman</sub>](http://HappyCoding.io)<br /> | [<img src="https://avatars1.githubusercontent.com/u/4229215?v=4" width="100px;"/><br /><sub>gauini</sub>](https://github.com/gauini)<br /> | [<img src="https://avatars0.githubusercontent.com/u/81553?v=4" width="100px;"/><br /><sub>David Wicks</sub>](http://sansumbrella.com/)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/19594257?v=4" width="100px;"/><br /><sub>Guillermo Montecinos</sub>](https://github.com/guillemontecinos)<br /> | [<img src="https://avatars0.githubusercontent.com/u/431774?v=4" width="100px;"/><br /><sub>Shawn Van Every</sub>](http://www.walking-productions.com/notslop/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/579033?v=4" width="100px;"/><br /><sub>Sinan Ascioglu</sub>](http://www.wiredpieces.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/108264?v=4" width="100px;"/><br /><sub>Abe Pazos</sub>](https://hamoid.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/10173517?v=4" width="100px;"/><br /><sub>Char</sub>](http://charstiles.com/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1335251?v=4" width="100px;"/><br /><sub>Gene Kogan</sub>](http://genekogan.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/13109165?v=4" width="100px;"/><br /><sub>Jason Mandel</sub>](https://github.com/jay-manday)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/11917158?v=4" width="100px;"/><br /><sub>Mark Russo</sub>](https://github.com/russomf)<br /> | [<img src="https://avatars1.githubusercontent.com/u/32407?v=4" width="100px;"/><br /><sub>Jonathan Dahan</sub>](http://jedahan.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/670641?v=4" width="100px;"/><br /><sub>Darius Morawiec</sub>](https://nok.onl)<br /> | [<img src="https://avatars3.githubusercontent.com/u/3231573?v=4" width="100px;"/><br /><sub>Darby Rathbone</sub>](https://github.com/darbicus)<br /> | [<img src="https://avatars1.githubusercontent.com/u/2214025?v=4" width="100px;"/><br /><sub>hrishit</sub>](https://github.com/hrishit)<br /> | [<img src="https://avatars1.githubusercontent.com/u/6561433?v=4" width="100px;"/><br /><sub>Chiun Hau You</sub>](https://twitter.com/chiunhauyou)<br /> | [<img src="https://avatars1.githubusercontent.com/u/167611?v=4" width="100px;"/><br /><sub>Francesco Bigiarini</sub>](https://zaerl.com)<br /> |
| [<img src="https://avatars3.githubusercontent.com/u/315106?v=4" width="100px;"/><br /><sub>Fabian Morón Zirfas</sub>](https://fabianmoronzirfas.me)<br /> | [<img src="https://avatars1.githubusercontent.com/u/163429?v=4" width="100px;"/><br /><sub>Mike Anderson</sub>](http://cambridgemike.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/902911?v=4" width="100px;"/><br /><sub>Mikael Lindqvist</sub>](http://linkedin.com/in/limikael)<br /> | [<img src="https://avatars0.githubusercontent.com/u/3980953?v=4" width="100px;"/><br /><sub>Chris</sub>](https://github.com/ctlusto)<br /> | [<img src="https://avatars2.githubusercontent.com/u/16921177?v=4" width="100px;"/><br /><sub>Max Segal</sub>](https://github.com/max0410)<br /> | [<img src="https://avatars1.githubusercontent.com/u/810727?v=4" width="100px;"/><br /><sub>Tyler Stefanich</sub>](https://github.com/tstefanich)<br /> | [<img src="https://avatars3.githubusercontent.com/u/614881?v=4" width="100px;"/><br /><sub>Dave</sub>](http://www.sixhat.net/)<br /> |
| [<img src="https://avatars0.githubusercontent.com/u/326559?v=4" width="100px;"/><br /><sub>Xavier Snelgrove</sub>](http://wxs.ca)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1791943?v=4" width="100px;"/><br /><sub>Gareth Battensby</sub>](https://github.com/DoubleJump)<br /> | [<img src="https://avatars3.githubusercontent.com/u/683107?v=4" width="100px;"/><br /><sub>Taeyoon Choi</sub>](http://taeyoonchoi.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/29796785?v=4" width="100px;"/><br /><sub>AKASH RAJ</sub>](https://github.com/akashraj9828)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1147122?v=4" width="100px;"/><br /><sub>Kevin Ho</sub>](https://github.com/keho98)<br /> | [<img src="https://avatars0.githubusercontent.com/u/2039548?v=4" width="100px;"/><br /><sub>Harsh Agrawal</sub>](http://dexter1691.github.io)<br /> | [<img src="https://avatars1.githubusercontent.com/u/8699557?v=4" width="100px;"/><br /><sub>Luca Damasco</sub>](https://github.com/Luxapodular)<br /> |
| [<img src="https://avatars0.githubusercontent.com/u/344861?v=4" width="100px;"/><br /><sub>Sam Lavigne</sub>](http://lav.io)<br /> | [<img src="https://avatars1.githubusercontent.com/u/658242?v=4" width="100px;"/><br /><sub>Epic Jefferson</sub>](http://epicjefferson.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/3160465?v=4" width="100px;"/><br /><sub>Caroline Record</sub>](http://www.carolinerecord.com/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/7853707?v=4" width="100px;"/><br /><sub>Christine de Carteret</sub>](http://cjdecarteret.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/451107?v=4" width="100px;"/><br /><sub>Chris Hallberg</sub>](http://crhallberg.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/34536?v=4" width="100px;"/><br /><sub>David Newbury</sub>](http://www.workergnome.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/6187313?v=4" width="100px;"/><br /><sub>piinthecloud</sub>](https://github.com/piinthecloud)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/12369651?v=4" width="100px;"/><br /><sub>Paolo Pedercini</sub>](http://www.molleindustria.org)<br /> | [<img src="https://avatars0.githubusercontent.com/u/3819772?v=4" width="100px;"/><br /><sub>Jason Alderman</sub>](http://huah.net/jason/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/295733?v=4" width="100px;"/><br /><sub>Jennifer Jacobs</sub>](http://media.mit.edu/~jacobsj)<br /> | [<img src="https://avatars3.githubusercontent.com/u/687513?v=4" width="100px;"/><br /><sub>Sepand Ansari</sub>](http://sepans.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1289596?v=4" width="100px;"/><br /><sub>Val Head</sub>](http://valhead.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1435725?v=4" width="100px;"/><br /><sub>Emily Chen</sub>](https://github.com/six5532one)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1385996?v=4" width="100px;"/><br /><sub>Ben Moren</sub>](http://benmoren.com)<br /> |
| [<img src="https://avatars0.githubusercontent.com/u/192021?v=4" width="100px;"/><br /><sub>Rune Skjoldborg Madsen</sub>](http://www.runemadsen.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/1034002?v=4" width="100px;"/><br /><sub>Scott Murray</sub>](http://alignedleft.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/786436?v=4" width="100px;"/><br /><sub>Scott Garner</sub>](http://www.scottmadethis.net/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1818874?v=4" width="100px;"/><br /><sub>b2renger</sub>](http://b2renger.github.io/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/4640172?v=4" width="100px;"/><br /><sub>Craig Pickard</sub>](http://craigpickard.net/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/4912796?v=4" width="100px;"/><br /><sub>mxchelle</sub>](https://github.com/mxchelle)<br /> | [<img src="https://avatars0.githubusercontent.com/u/4970417?v=4" width="100px;"/><br /><sub>Zach Rispoli</sub>](http://www.wickeditor.com)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/7039783?v=4" width="100px;"/><br /><sub>Liu Chang</sub>](http://www.liuchang.work)<br /> | [<img src="https://avatars0.githubusercontent.com/u/10605821?v=4" width="100px;"/><br /><sub>Cristóbal Valenzuela</sub>](http://cvalenzuelab.com/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/1015606?v=4" width="100px;"/><br /><sub>Miles Peyton</sub>](http://www.milespeyton.info)<br /> | [<img src="https://avatars2.githubusercontent.com/u/290053?v=4" width="100px;"/><br /><sub>Golan Levin</sub>](http://www.flong.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/378124?v=4" width="100px;"/><br /><sub>feedzh</sub>](https://github.com/feedzh)<br /> | [<img src="https://avatars0.githubusercontent.com/u/4076804?v=4" width="100px;"/><br /><sub>Chiciuc Nicușor</sub>](http://nicusor.org/)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1566844?v=4" width="100px;"/><br /><sub>Ken Miller</sub>](http://www.videoventure.org)<br /> |
| [<img src="https://avatars2.githubusercontent.com/u/69087?v=4" width="100px;"/><br /><sub>Chandler McWilliams</sub>](http://brysonian.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1130929?v=4" width="100px;"/><br /><sub>Jaymz Rhime</sub>](http://wxactly.com/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/181043?v=4" width="100px;"/><br /><sub>Niels Joubert</sub>](http://njoubert.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/6258810?v=4" width="100px;"/><br /><sub>Utkarsh Tiwari</sub>](https://github.com/iamutkarshtiwari)<br /> | [<img src="https://avatars0.githubusercontent.com/u/15258498?v=4" width="100px;"/><br /><sub>Arihant Parsoya</sub>](https://github.com/parsoyaarihant)<br /> | [<img src="https://avatars0.githubusercontent.com/u/1615761?v=4" width="100px;"/><br /><sub>Brad Buchanan</sub>](http://bradleycbuchanan.com)<br /> | [<img src="https://avatars0.githubusercontent.com/u/3482016?v=4" width="100px;"/><br /><sub>Johan Karlsson</sub>](https://twitter.com/DonKarlssonSan)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/1569764?v=4" width="100px;"/><br /><sub>Andy Timmons</sub>](http://andrewjtimmons.github.io)<br /> | [<img src="https://avatars3.githubusercontent.com/u/7537243?v=4" width="100px;"/><br /><sub>zacharystenger</sub>](https://github.com/zacharystenger)<br /> | [<img src="https://avatars3.githubusercontent.com/u/170997?v=4" width="100px;"/><br /><sub>Brian Boucheron</sub>](http://boucheron.org/brian)<br /> | [<img src="https://avatars2.githubusercontent.com/u/22330511?v=4" width="100px;"/><br /><sub>sortasleepy</sub>](https://github.com/sortasleepy)<br /> | [<img src="https://avatars3.githubusercontent.com/u/157106?v=4" width="100px;"/><br /><sub>Kyle McDonald</sub>](http://kylemcdonald.net/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/710282?v=4" width="100px;"/><br /><sub>Antonio Jesús Sánchez Padial</sub>](http://spadial.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/188349?v=4" width="100px;"/><br /><sub>Brad Smith</sub>](http://www.geekdome.net)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/1699443?v=4" width="100px;"/><br /><sub>Vítor Galvão</sub>](https://vitorgalvao.com/)<br /> | [<img src="https://avatars1.githubusercontent.com/u/175530?v=4" width="100px;"/><br /><sub>Devon Rifkin</sub>](https://github.com/drifkin)<br /> | [<img src="https://avatars0.githubusercontent.com/u/5360525?v=4" width="100px;"/><br /><sub>Emily Xie</sub>](http://xie-emily.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/150448?v=4" width="100px;"/><br /><sub>Boris Bucha</sub>](http://twitter.com/borisbucha)<br /> | [<img src="https://avatars3.githubusercontent.com/u/879564?v=4" width="100px;"/><br /><sub>Petr Brzek</sub>](http://avocode.com)<br /> | [<img src="https://avatars1.githubusercontent.com/u/1574219?v=4" width="100px;"/><br /><sub>Ramin</sub>](https://github.com/transfluxus)<br /> | [<img src="https://avatars0.githubusercontent.com/u/7712798?v=4" width="100px;"/><br /><sub>Arsenije Savic</sub>](https://github.com/arsenijesavic)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/15360369?v=4" width="100px;"/><br /><sub>Luke Burgess-Yeo</sub>](http://www.linkedin.com/in/lukeburgessyeo)<br /> | [<img src="https://avatars3.githubusercontent.com/u/3071467?v=4" width="100px;"/><br /><sub>Sun Lifei</sub>](https://github.com/slfmessi)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1988660?v=4" width="100px;"/><br /><sub>naoyashiga</sub>](http://himo.boy.jp/)<br /> | [<img src="https://avatars0.githubusercontent.com/u/8057628?v=4" width="100px;"/><br /><sub>Jimish Fotariya</sub>](http://facebook.com/Jimish.Fotariya)<br /> | [<img src="https://avatars1.githubusercontent.com/u/703744?v=4" width="100px;"/><br /><sub>Jorge Moreno</sub>](http://www.moro.es)<br />[🐛](https://github.com/processing/p5.js/issues?q=author%3Aalterebro "Bug reports") [💻](https://github.com/processing/p5.js/commits?author=alterebro "Code") [📖](https://github.com/processing/p5.js/commits?author=alterebro "Documentation") | [<img src="https://avatars3.githubusercontent.com/u/26755396?v=4" width="100px;"/><br /><sub>Steven Green</sub>](http://stevengreens10.github.io)<br /> | [<img src="https://avatars2.githubusercontent.com/u/10608765?v=4" width="100px;"/><br /><sub>Marcus Parsons</sub>](http://www.marcusparsons.com)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/1482377?v=4" width="100px;"/><br /><sub>Nick Yahnke</sub>](https://github.com/nthitz)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1859451?v=4" width="100px;"/><br /><sub>Anthony Su</sub>](http://www.radialglo.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/720976?v=4" width="100px;"/><br /><sub>kroko / Reinis Adovičs</sub>](http://www.kroko.me/)<br /> | [<img src="https://avatars2.githubusercontent.com/u/5854770?v=4" width="100px;"/><br /><sub>Robyn Overstreet</sub>](https://github.com/robynitp)<br /> | [<img src="https://avatars1.githubusercontent.com/u/7188324?v=4" width="100px;"/><br /><sub>Ben Hinchley</sub>](https://github.com/benhinchley)<br /> | [<img src="https://avatars1.githubusercontent.com/u/3266989?v=4" width="100px;"/><br /><sub>Max Kolyanov</sub>](http://ello.co/maxkolyanov)<br /> | [<img src="https://avatars3.githubusercontent.com/u/2544489?v=4" width="100px;"/><br /><sub>Zeno Zeng</sub>](http://zenozeng.com)<br /> |
| [<img src="https://avatars0.githubusercontent.com/u/8644048?v=4" width="100px;"/><br /><sub>Seth</sub>](http://www.sethkranzler.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/396562?v=4" width="100px;"/><br /><sub>plural</sub>](https://github.com/plural)<br /> | [<img src="https://avatars3.githubusercontent.com/u/1795860?v=4" width="100px;"/><br /><sub>Lionel Ringenbach</sub>](http://ucodia.space)<br /> | [<img src="https://avatars3.githubusercontent.com/u/9111606?v=4" width="100px;"/><br /><sub>Harshil Goel</sub>](https://github.com/darkcoderrises)<br /> | [<img src="https://avatars0.githubusercontent.com/u/12414183?v=4" width="100px;"/><br /><sub>Joshua Storm Becker</sub>](http://becker.codes)<br /> | [<img src="https://avatars2.githubusercontent.com/u/22229196?v=4" width="100px;"/><br /><sub>max_devjs</sub>](http://twitter.com/max_devjs)<br /> | [<img src="https://avatars2.githubusercontent.com/u/9803905?v=4" width="100px;"/><br /><sub>trych</sub>](http://timorychert.de/)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/15284993?v=4" width="100px;"/><br /><sub>Alejandra Trejo</sub>](https://www.alejandratrejo.com/)<br /> | [<img src="https://avatars0.githubusercontent.com/u/9909241?v=4" width="100px;"/><br /><sub>Prashant Gupta</sub>](http://www.pgupta.com)<br /> | [<img src="https://avatars2.githubusercontent.com/u/5270022?v=4" width="100px;"/><br /><sub>Kai-han Chang</sub>](https://github.com/rasca0027)<br /> | [<img src="https://avatars0.githubusercontent.com/u/9029686?v=4" width="100px;"/><br /><sub>kjav</sub>](https://github.com/kjav)<br /> | [<img src="https://avatars0.githubusercontent.com/u/1965049?v=4" width="100px;"/><br /><sub>maddy</sub>](http://maddy.zone)<br /> | [<img src="https://avatars3.githubusercontent.com/u/2354476?v=4" width="100px;"/><br /><sub>Christopher Coleman</sub>](http://digitalcoleman.com)<br /> | [<img src="https://avatars3.githubusercontent.com/u/122117?v=4" width="100px;"/><br /><sub>Boaz</sub>](http://boazsender.com)<br /> |
| [<img src="https://avatars1.githubusercontent.com/u/13515645?v=4" width="100px;"/><br /><sub>Yasai</sub>](https://github.com/wangyasai)<br />[📝](#blog-wangyasai "Blogposts") |
<!-- ALL-CONTRIBUTORS-LIST:END -->

