"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _utils = require("../utils/utils.cjs");
var _dom = require("../utils/dom.cjs");
var _breaktoken = _interopRequireDefault(require("./breaktoken.cjs"));
var _renderresult = _interopRequireDefault(require("./renderresult.cjs"));
var _eventEmitter = _interopRequireDefault(require("event-emitter"));
var _hook = _interopRequireDefault(require("../utils/hook.cjs"));
var _overflow = _interopRequireDefault(require("./overflow.cjs"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var MAX_CHARS_PER_BREAK = 1500;

/**
 * Layout
 * @class
 */
var Layout = /*#__PURE__*/function () {
  function Layout(element, hooks, options) {
    var _this$element$offsetP;
    (0, _classCallCheck2["default"])(this, Layout);
    this.element = element;
    this.bounds = this.element.getBoundingClientRect();
    this.parentBounds = ((_this$element$offsetP = this.element.offsetParent) === null || _this$element$offsetP === void 0 ? void 0 : _this$element$offsetP.getBoundingClientRect()) || {
      left: 0
    };
    var gap = parseFloat(window.getComputedStyle(this.element).columnGap);
    if (gap) {
      var leftMargin = this.bounds.left - this.parentBounds.left;
      this.gap = gap - leftMargin;
    } else {
      this.gap = 0;
    }
    if (hooks) {
      this.hooks = hooks;
    } else {
      this.hooks = {};
      this.hooks.onPageLayout = new _hook["default"]();
      this.hooks.layout = new _hook["default"]();
      this.hooks.renderNode = new _hook["default"]();
      this.hooks.layoutNode = new _hook["default"]();
      this.hooks.beforeOverflow = new _hook["default"]();
      this.hooks.onOverflow = new _hook["default"]();
      this.hooks.afterOverflowRemoved = new _hook["default"]();
      this.hooks.afterOverflowAdded = new _hook["default"]();
      this.hooks.onBreakToken = new _hook["default"]();
      this.hooks.beforeRenderResult = new _hook["default"]();
    }
    this.settings = options || {};
    this.maxChars = this.settings.maxChars || MAX_CHARS_PER_BREAK;
    this.forceRenderBreak = false;
    this.temporaryIndex = 0;
  }
  (0, _createClass2["default"])(Layout, [{
    key: "renderTo",
    value: function () {
      var _renderTo = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(wrapper, source, breakToken) {
        var prevPage,
          bounds,
          start,
          firstDivisible,
          walker,
          node,
          done,
          next,
          forcedBreakQueue,
          prevBreakToken,
          newBreakToken,
          hasRenderedContent,
          named,
          page,
          imgs,
          shallow,
          _args = arguments;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              prevPage = _args.length > 3 && _args[3] !== undefined ? _args[3] : null;
              bounds = _args.length > 4 && _args[4] !== undefined ? _args[4] : this.bounds;
              start = this.getStart(source, breakToken);
              firstDivisible = source;
              while (firstDivisible.children.length == 1) {
                firstDivisible = firstDivisible.children[0];
              }
              walker = (0, _dom.walk)(start, source);
              forcedBreakQueue = [];
              prevBreakToken = breakToken || new _breaktoken["default"](start);
              this.hooks && this.hooks.onPageLayout.trigger(wrapper, prevBreakToken, this);

              // Add overflow, and check that it doesn't have overflow itself.
              this.addOverflowToPage(wrapper, breakToken, prevPage);

              // Footnotes may change the bounds.
              bounds = this.element.getBoundingClientRect();
              newBreakToken = this.findBreakToken(wrapper, source, bounds, prevBreakToken, start);
              if (!prevBreakToken.isFinished()) {
                _context.next = 15;
                break;
              }
              if (newBreakToken) {
                newBreakToken.setFinished();
              }
              return _context.abrupt("return", new _renderresult["default"](newBreakToken));
            case 15:
              hasRenderedContent = !!wrapper.childNodes.length;
              if (prevBreakToken) {
                forcedBreakQueue = prevBreakToken.getForcedBreakQueue();
              }
            case 17:
              if (!(!done && !newBreakToken)) {
                _context.next = 43;
                break;
              }
              next = walker.next();
              node = next.value;
              done = next.done;
              if (node) {
                this.hooks && this.hooks.layoutNode.trigger(node);

                // Footnotes may change the bounds.
                bounds = this.element.getBoundingClientRect();

                // Check if the rendered element has a break set
                // Remember the node but don't apply the break until we have laid
                // out the rest of any parent content - this lets a table or divs
                // side by side still add content to this page before we start a new
                // one.
                if (this.shouldBreak(node) && hasRenderedContent) {
                  forcedBreakQueue.push(node);
                }
                if (!forcedBreakQueue.length && node.dataset && node.dataset.page) {
                  named = node.dataset.page;
                  page = this.element.closest(".pagedjs_page");
                  page.classList.add("pagejs_named_page");
                  page.classList.add("pagedjs_" + named + "_page");
                  if (!node.dataset.splitFrom) {
                    page.classList.add("pagedjs_" + named + "_first_page");
                  }
                }
              }

              // Check whether we have overflow when we've completed laying out a top
              // level element. This lets it have multiple children overflowing and
              // allows us to move all of the overflows onto the next page together.
              if (!(forcedBreakQueue.length || !node || !node.parentElement)) {
                _context.next = 36;
                break;
              }
              this.hooks && this.hooks.layout.trigger(wrapper, this);
              imgs = wrapper.querySelectorAll("img");
              if (!imgs.length) {
                _context.next = 28;
                break;
              }
              _context.next = 28;
              return this.waitForImages(imgs);
            case 28:
              newBreakToken = this.findBreakToken(wrapper, source, bounds, prevBreakToken, node);
              if (newBreakToken && node === undefined) {
                // We have run out of content. Do add the overflow to a new page but
                // don't repeat the whole thing again.
                newBreakToken.setFinished();
              }
              if (forcedBreakQueue.length) {
                if (newBreakToken) {
                  newBreakToken.setForcedBreakQueue(forcedBreakQueue);
                } else {
                  newBreakToken = this.breakAt(forcedBreakQueue.shift(), 0, forcedBreakQueue);
                }
              }
              if (!(newBreakToken && newBreakToken.equals(prevBreakToken))) {
                _context.next = 34;
                break;
              }
              this.failed = true;
              return _context.abrupt("return", new _renderresult["default"](undefined, "Unable to layout item: " + node));
            case 34:
              if (!(!node || newBreakToken)) {
                _context.next = 36;
                break;
              }
              return _context.abrupt("return", new _renderresult["default"](newBreakToken));
            case 36:
              // Should the Node be a shallow or deep clone?
              shallow = (0, _dom.isContainer)(node);
              this.append(node, wrapper, source, breakToken, shallow);
              bounds = this.element.getBoundingClientRect();

              // Check whether layout has content yet.
              if (!hasRenderedContent) {
                hasRenderedContent = (0, _dom.hasContent)(node);
              }

              // Skip to the next node if a deep clone was rendered.
              if (!shallow) {
                walker = (0, _dom.walk)((0, _dom.nodeAfter)(node, source), source);
              }
              _context.next = 17;
              break;
            case 43:
              this.hooks && this.hooks.beforeRenderResult.trigger(newBreakToken, wrapper, this);
              return _context.abrupt("return", new _renderresult["default"](newBreakToken));
            case 45:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function renderTo(_x, _x2, _x3) {
        return _renderTo.apply(this, arguments);
      }
      return renderTo;
    }()
  }, {
    key: "breakAt",
    value: function breakAt(node) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var forcedBreakQueue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var newBreakToken = new _breaktoken["default"](node, offset, forcedBreakQueue);
      var breakHooks = this.hooks.onBreakToken.triggerSync(newBreakToken, undefined, node, this);
      breakHooks.forEach(function (newToken) {
        if (typeof newToken != "undefined") {
          newBreakToken = newToken;
        }
      });
      return newBreakToken;
    }
  }, {
    key: "shouldBreak",
    value: function shouldBreak(node, limiter) {
      var previousNode = (0, _dom.nodeBefore)(node, limiter);
      var parentNode = node.parentNode;
      var parentBreakBefore = (0, _dom.needsBreakBefore)(node) && parentNode && !previousNode && (0, _dom.needsBreakBefore)(parentNode);
      var doubleBreakBefore;
      if (parentBreakBefore) {
        doubleBreakBefore = node.dataset.breakBefore === parentNode.dataset.breakBefore;
      }
      return !doubleBreakBefore && (0, _dom.needsBreakBefore)(node) || (0, _dom.needsPreviousBreakAfter)(node) || (0, _dom.needsPageBreak)(node, previousNode);
    }
  }, {
    key: "forceBreak",
    value: function forceBreak() {
      this.forceRenderBreak = true;
    }
  }, {
    key: "getStart",
    value: function getStart(source, breakToken) {
      var start;
      var node = breakToken && breakToken.node;
      var finished = breakToken && breakToken.finished;
      if (node) {
        start = node;
      } else {
        start = source.firstChild;
      }
      return finished ? undefined : start;
    }

    /**
     * Merge items from source into dest which don't yet exist in dest.
     *
     * @param {element} dest
     *   A destination DOM node tree.
     * @param {element} source
     *   A source DOM node tree.
     *
     * @returns {void}
     */
  }, {
    key: "addOverflowNodes",
    value: function addOverflowNodes(dest, source) {
      var _this = this;
      // Since we are modifying source as we go, we need to remember what
      Array.from(source.childNodes).forEach(function (item) {
        if ((0, _dom.isText)(item)) {
          // If we get to a text node, we assume for now an earlier element
          // would have prevented duplication.
          dest.append(item);
        } else {
          var match = (0, _dom.findElement)(item, dest);
          if (match) {
            _this.addOverflowNodes(match, item);
          } else {
            dest.appendChild(item);
          }
        }
      });
    }

    /**
     * Add overflow to new page.
     *
     * @param {element} dest
     *   The page content being built.
     * @param {breakToken} breakToken
     *   The current break cotent.
     * @param {element} alreadyRendered
     *   The content that has already been rendered.
     *
     * @returns {void}
     */
  }, {
    key: "addOverflowToPage",
    value: function addOverflowToPage(dest, breakToken, alreadyRendered) {
      var _this2 = this;
      if (!breakToken || !breakToken.overflow.length) {
        return;
      }
      var fragment;
      breakToken.overflow.forEach(function (overflow) {
        // A handy way to dump the contents of a fragment.
        // console.log([].map.call(overflow.content.children, e => e.outerHTML).join('\n'));

        fragment = (0, _dom.rebuildTree)(overflow.node, fragment, alreadyRendered);
        // Find the parent to which overflow.content should be added.
        // Overflow.content can be a much shallower start than
        // overflow.node, if the range end was outside of the range
        // start part of the tree. For this reason, we use a match against
        // the parent element of overflow.content if it exists, or fall back
        // to overflow.node's parent element.
        var addTo = overflow.ancestor ? (0, _dom.findElement)(overflow.ancestor, fragment) : fragment;
        _this2.addOverflowNodes(addTo, overflow.content);
      });

      // Record refs.
      Array.from(fragment.querySelectorAll('[data-ref]')).forEach(function (ref) {
        var refId = ref.dataset.ref;
        if (!dest.querySelector("[data-ref='".concat(refId, "']"))) {
          if (!dest.indexOfRefs) {
            dest.indexOfRefs = {};
          }
          dest.indexOfRefs[refId] = ref;
        }
      });
      var tags = ['overflow-tagged', 'overflow-partial', 'range-start-overflow', 'range-end-overflow'];
      tags.forEach(function (tag) {
        var camel = tag.replace(/(?:^\w|[A-Z]|\b\w)/g, function (word, index) {
          return index == 0 ? word.toLowerCase() : word.toUpperCase();
        }).replace(/[-\s]+/g, '');
        var instances = fragment.querySelectorAll("[data-".concat(tag, "]"));
        instances.forEach(function (instance) {
          delete instance.dataset[camel];
        });
      });
      dest.appendChild(fragment);
      this.hooks && this.hooks.afterOverflowAdded.trigger(dest);
    }

    /**
     * Add text to new page.
     *
     * @param {element} node
     *   The node being appended to the destination.
     * @param {element} dest
     *   The destination to which content is being added.
     * @param {element} source
     *   The source DOM
     * @param {breakToken} breakToken
     *   The current breakToken.
     * @param {bool} shallow
     *	 Whether to do a shallow copy of the node.
     * @param {bool} rebuild
     *   Whether to rebuild parents.
     *
     * @returns {ChildNode}
     *   The cloned node.
     */
  }, {
    key: "append",
    value: function append(node, dest, source, breakToken) {
      var shallow = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
      var rebuild = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
      var clone = (0, _dom.cloneNode)(node, !shallow);
      if (node.parentNode && (0, _dom.isElement)(node.parentNode)) {
        var parent = (0, _dom.findElement)(node.parentNode, dest);
        if (parent) {
          (0, _dom.replaceOrAppendElement)(parent, clone);
        } else if (rebuild) {
          var fragment = (0, _dom.rebuildTree)(node.parentElement, undefined, source);
          parent = (0, _dom.findElement)(node.parentNode, fragment);
          (0, _dom.replaceOrAppendElement)(parent, clone);
          dest.appendChild(fragment);
        } else {
          dest.appendChild(clone);
        }
      } else {
        dest.appendChild(clone);
      }
      if (clone.dataset && clone.dataset.ref) {
        if (!dest.indexOfRefs) {
          dest.indexOfRefs = {};
        }
        dest.indexOfRefs[clone.dataset.ref] = clone;
      }
      var nodeHooks = this.hooks.renderNode.triggerSync(clone, node, this);
      nodeHooks.forEach(function (newNode) {
        if (typeof newNode != "undefined") {
          clone = newNode;
        }
      });
      return clone;
    }
  }, {
    key: "rebuildTableFromBreakToken",
    value: function rebuildTableFromBreakToken(breakToken, dest, source) {
      if (!breakToken || !breakToken.node) {
        return;
      }
      var node = breakToken.node;
      var td = (0, _dom.isElement)(node) ? node.closest("td") : node.parentElement.closest("td");
      if (td) {
        var rendered = (0, _dom.findElement)(td, dest, true);
        if (!rendered) {
          return;
        }
        while (td = td.nextElementSibling) {
          this.append(td, dest, source, null, true);
        }
      }
    }
  }, {
    key: "waitForImages",
    value: function () {
      var _waitForImages = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(imgs) {
        var _this3 = this;
        var results;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              results = Array.from(imgs).map( /*#__PURE__*/function () {
                var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(img) {
                  return _regenerator["default"].wrap(function _callee2$(_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        return _context2.abrupt("return", _this3.awaitImageLoaded(img));
                      case 1:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                }));
                return function (_x5) {
                  return _ref.apply(this, arguments);
                };
              }());
              _context3.next = 3;
              return Promise.all(results);
            case 3:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function waitForImages(_x4) {
        return _waitForImages.apply(this, arguments);
      }
      return waitForImages;
    }()
  }, {
    key: "awaitImageLoaded",
    value: function () {
      var _awaitImageLoaded = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(image) {
        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              return _context4.abrupt("return", new Promise(function (resolve) {
                if (image.complete !== true) {
                  image.onload = function () {
                    var _window$getComputedSt = window.getComputedStyle(image),
                      width = _window$getComputedSt.width,
                      height = _window$getComputedSt.height;
                    resolve(width, height);
                  };
                  image.onerror = function (e) {
                    var _window$getComputedSt2 = window.getComputedStyle(image),
                      width = _window$getComputedSt2.width,
                      height = _window$getComputedSt2.height;
                    resolve(width, height, e);
                  };
                } else {
                  var _window$getComputedSt3 = window.getComputedStyle(image),
                    width = _window$getComputedSt3.width,
                    height = _window$getComputedSt3.height;
                  resolve(width, height);
                }
              }));
            case 1:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      }));
      function awaitImageLoaded(_x6) {
        return _awaitImageLoaded.apply(this, arguments);
      }
      return awaitImageLoaded;
    }()
  }, {
    key: "avoidBreakInside",
    value: function avoidBreakInside(node, limiter) {
      var breakNode;
      while (node.parentNode) {
        if (node === limiter) {
          break;
        }
        if ((0, _dom.isElement)(node) && node.dataset.originalBreakInside === "avoid") {
          breakNode = node;
          break;
        }
        node = node.parentNode;
      }
      return breakNode;
    }
  }, {
    key: "createOverflow",
    value: function createOverflow(overflow, rendered, source) {
      var container = overflow.startContainer;
      var offset = overflow.startOffset;
      var node, renderedNode, parent, index, temp;
      var hyphen = this.settings.hyphenGlyph || "\u2011";
      var topLevel = false;
      if ((0, _dom.isElement)(container)) {
        if (container.nodeName == "INPUT") {
          temp = container;
        } else {
          temp = (0, _dom.child)(container, offset);
        }
        if ((0, _dom.isElement)(temp)) {
          renderedNode = (0, _dom.findElement)(temp, rendered);
          if (!renderedNode) {
            // Find closest element with data-ref
            var prevNode = (0, _dom.prevValidNode)(temp);
            if (!(0, _dom.isElement)(prevNode)) {
              prevNode = prevNode.parentElement;
            }
            renderedNode = (0, _dom.findElement)(prevNode, rendered);
            // Check if temp is the last rendered node at its level.
            if (!temp.nextSibling) {
              // We need to ensure that the previous sibling of temp is fully rendered.
              var renderedNodeFromSource = (0, _dom.findElement)(renderedNode, source);
              var walker = document.createTreeWalker(renderedNodeFromSource, NodeFilter.SHOW_ELEMENT);
              var lastChildOfRenderedNodeFromSource = walker.lastChild();
              var lastChildOfRenderedNodeMatchingFromRendered = (0, _dom.findElement)(lastChildOfRenderedNodeFromSource, rendered);
              // Check if we found that the last child in source
              if (!lastChildOfRenderedNodeMatchingFromRendered) {
                // Pending content to be rendered before virtual break token
                return;
              }
              // Otherwise we will return a break token as per below
            }
            // renderedNode is actually the last unbroken box that does not overflow.
            // Break Token is therefore the next sibling of renderedNode within source node.
            node = (0, _dom.findElement)(renderedNode, source).nextSibling;
            offset = 0;
          } else {
            node = (0, _dom.findElement)(renderedNode, source);
            offset = 0;
          }
        } else {
          if (container == rendered) {
            parent = renderedNode = source;
            topLevel = true;
          } else {
            renderedNode = (0, _dom.findElement)(container, rendered);
            if (!renderedNode) {
              renderedNode = (0, _dom.findElement)((0, _dom.prevValidNode)(container), rendered);
            }
            parent = (0, _dom.findElement)(renderedNode, source);
          }
          index = (0, _dom.indexOfTextNode)(temp, parent, hyphen);
          // No seperation for the first textNode of an element
          if (index === 0) {
            node = parent;
            offset = 0;
          } else {
            node = (0, _dom.child)(parent, index);
            offset = 0;
          }
        }
      } else {
        renderedNode = (0, _dom.findElement)(container.parentNode, rendered);
        if (!renderedNode) {
          renderedNode = (0, _dom.findElement)((0, _dom.prevValidNode)(container.parentNode), rendered);
        }
        parent = (0, _dom.findElement)(renderedNode, source);
        index = (0, _dom.indexOfTextNode)(container, parent, hyphen);
        if (index === -1) {
          return;
        }
        node = (0, _dom.child)(parent, index);
        offset += node.textContent.indexOf(container.textContent);
      }
      if (!node) {
        return;
      }
      return new _overflow["default"](node, offset, overflow.getBoundingClientRect().height, overflow, topLevel);
    }
  }, {
    key: "lastChildCheck",
    value: function lastChildCheck(parentElement, rootElement) {
      if (parentElement.childElementCount) {
        this.lastChildCheck(parentElement.lastElementChild, rootElement);
      }
      var refId = parentElement.dataset.ref;

      // A table row, math element or paragraph from which all content has been removed
      // can itself also be removed. It will be added on the next page.
      if (parentElement.dataset.overflowTagged && parentElement.textContent.trim() == '') {
        parentElement.parentNode.removeChild(parentElement);
      } else if (refId && !rootElement.indexOfRefs[refId]) {
        rootElement.indexOfRefs[refId] = parentElement;
      }
    }
  }, {
    key: "processOverflowResult",
    value: function processOverflowResult(ranges, rendered, source, bounds, prevBreakToken, node, extract) {
      var _this4 = this;
      var breakToken, breakLetter;
      ranges.forEach(function (overflowRange) {
        var _overflow$node;
        var overflowHooks = _this4.hooks.onOverflow.triggerSync(overflowRange, rendered, bounds, _this4);
        overflowHooks.forEach(function (newOverflow) {
          if (typeof newOverflow != "undefined") {
            overflowRange = newOverflow;
          }
        });
        var overflow = _this4.createOverflow(overflowRange, rendered, source);
        if (!breakToken) {
          breakToken = new _breaktoken["default"](node, [overflow]);
        } else {
          breakToken.overflow.push(overflow);
        }

        // breakToken is nullable
        var breakHooks = _this4.hooks.onBreakToken.triggerSync(breakToken, overflowRange, rendered, _this4);
        breakHooks.forEach(function (newToken) {
          if (typeof newToken != "undefined") {
            breakToken = newToken;
          }
        });

        // Stop removal if we are in a loop
        if (breakToken.equals(prevBreakToken)) {
          return;
        }
        if (overflow !== null && overflow !== void 0 && overflow.node && overflow !== null && overflow !== void 0 && overflow.offset && overflow !== null && overflow !== void 0 && (_overflow$node = overflow.node) !== null && _overflow$node !== void 0 && _overflow$node.textContent) {
          breakLetter = overflow.node.textContent.charAt(overflow.offset);
        } else {
          breakLetter = undefined;
        }
        if (overflow !== null && overflow !== void 0 && overflow.node && extract) {
          overflow.ancestor = (0, _dom.findElement)(overflow.range.commonAncestorContainer, source);
          overflow.content = _this4.removeOverflow(overflowRange, breakLetter);
        }
      });

      // For each overflow that is removed, see if we have an empty td that can be removed.
      // Also check that the data-ref is set so we get all the split-froms and tos. If a copy
      // of a node wasn't shallow, the indexOfRefs entry won't be there yet.
      ranges.forEach(function (overflowRange) {
        _this4.lastChildCheck(rendered, rendered);
      });

      // And then see if the last element has been completely removed and not split.
      if (rendered.indexOfRefs && extract && breakToken.overflow.length) {
        var firstOverflow = breakToken.overflow[0];
        if (firstOverflow !== null && firstOverflow !== void 0 && firstOverflow.node && firstOverflow.content) {
          // Remove data-refs in the overflow from the index.
          Array.from(firstOverflow.content.querySelectorAll('[data-ref]')).forEach(function (ref) {
            var refId = ref.dataset.ref;
            if (!rendered.querySelector("[data-ref='".concat(refId, "']"))) {
              delete rendered.indexOfRefs[refId];
            }
          });
        }
      }
      breakToken.overflow.forEach(function (overflow) {
        _this4.hooks && _this4.hooks.afterOverflowRemoved.trigger(overflow.content, rendered, _this4);
      });
      return breakToken;
    }
  }, {
    key: "findBreakToken",
    value: function findBreakToken(rendered, source) {
      var _this5 = this;
      var bounds = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.bounds;
      var prevBreakToken = arguments.length > 3 ? arguments[3] : undefined;
      var node = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
      var extract = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
      var breakToken,
        overflow = [];
      var overflowResult = this.findOverflow(rendered, bounds, source);
      var _loop = function _loop() {
        // Check whether overflow already added - multiple overflows might result in the
        // same range via avoid break rules.
        var existing = false;
        overflow.forEach(function (item) {
          if (item.startContainer == overflowResult.startContainer && item.endContainer == overflowResult.endContainer) {
            if (item.startOffset >= overflowResult.startOffset && item.endOffset <= overflowResult.endOffset) {
              item.setStart(overflowResult.startContainer, overflowResult.startOffset);
              existing = true;
            }
            if (item.endOffset > overflowResult.endOffset && item.startOffset == overflowResult.startOffset) {
              item.EndOffset = overflowResult.EndOffset;
              item.setEnd(overflowResult.endContainer, overflowResult.endOffset);
              existing = true;
            }
          }
        });
        if (!existing) {
          overflow.push(overflowResult);
        }
        overflowResult = _this5.findOverflow(rendered, bounds, source);
      };
      while (overflowResult) {
        _loop();
      }
      if (overflow.length) {
        breakToken = this.processOverflowResult(overflow, rendered, source, bounds, prevBreakToken, node, extract);
      }
      return breakToken;
    }

    /**
     * Does the element exceed the bounds?
     *
     * @param {element} element
     *   The element being constrained.
     * @param {array} bounds
     *   The bounding element.
     *
     * @returns {bool}
     *   Whether the element is within bounds.
     */
  }, {
    key: "hasOverflow",
    value: function hasOverflow(element) {
      var bounds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.bounds;
      var constrainingElement = element && element.parentNode; // this gets the element, instead of the wrapper for the width workaround
      if (constrainingElement.classList.contains("pagedjs_page_content")) {
        constrainingElement = element;
      }
      var _element$getBoundingC = element.getBoundingClientRect(),
        width = _element$getBoundingC.width,
        height = _element$getBoundingC.height;
      var scrollWidth = constrainingElement ? constrainingElement.scrollWidth : 0;
      var scrollHeight = constrainingElement ? constrainingElement.scrollHeight : 0;
      return Math.max(Math.ceil(width), scrollWidth) > Math.ceil(bounds.width) || Math.max(Math.ceil(height), scrollHeight) > Math.ceil(bounds.height);
    }

    /**
     * Sums padding, borders and margins for bottom/right of parent elements.
     *
     * Assumes no margin collapsing because we're considering overflow
     * on a page.
     *
     * This and callers need to be extended to handle right-to-left text and
     * flow but I'll get LTR going first in the hope that it will simplify
     * the task of getting RTL sorted later. Need test cases too.
     */
  }, {
    key: "getAncestorPaddingBorderAndMarginSums",
    value: function getAncestorPaddingBorderAndMarginSums(element) {
      var attribs = ['padding-top', 'padding-right', 'padding-bottom', 'padding-left', 'border-top-width', 'border-right-width', 'border-bottom-width', 'border-left-width', 'margin-top', 'margin-right', 'margin-bottom', 'margin-left'];
      var result = {};
      attribs.forEach(function (attrib) {
        return result[attrib] = 0;
      });
      var _loop2 = function _loop2() {
        var style = window.getComputedStyle(element);
        attribs.forEach(function (attrib) {
          return result[attrib] += parseInt(style[attrib]);
        });
        element = element.parentElement;
      };
      while (element && !element.classList.contains('pagedjs_page_content') && !element.classList.contains('pagedjs_footnote_inner_content')) {
        _loop2();
      }
      return result;
    }

    /**
     * Checks whether an element is within a table and gets any THEAD sizes.
     */
  }, {
    key: "getAncestorTheadSizes",
    value: function getAncestorTheadSizes(element) {
      var result = 0;
      while (element && !element.classList.contains('pagedjs_page_content') && !element.classList.contains('pagedjs_footnote_inner_content')) {
        if (element.tagName == 'TABLE') {
          element.childNodes.forEach(function (node) {
            if (node.tagName == 'THEAD') {
              var style = getComputedStyle(node);
              result += parseInt(style.height);
            }
          });
        }
        element = element.parentElement;
      }
      return result;
    }

    /**
     * Adds temporary data-split-to/from attribute where needed.
     *
     * @param DomElement element
     *   The deepest child, from which to start.
     */
  }, {
    key: "addTemporarySplit",
    value: function addTemporarySplit(element) {
      var isTo = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      this.temporaryIndex++;
      var name = isTo ? 'data-split-to' : 'data-split-from';
      while (element && !element.classList.contains('pagedjs_page_content') && !element.classList.contains('pagedjs_footnote_inner_content')) {
        if (!element.getAttribute(name)) {
          element.setAttribute(name, 'temp-' + this.temporaryIndex);
        }
        element = element.parentElement;
      }
    }

    /**
     * Removes temporary data-split-to/from attribute where added.
     *
     * @param DomElement element
     *   The deepest child, from which to start.
     * @param boolean isTo
     *   Whether a split-to or -from was added.
     */
  }, {
    key: "deleteTemporarySplit",
    value: function deleteTemporarySplit(element) {
      var isTo = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var name = isTo ? 'data-split-to' : 'data-split-from';
      while (element && !element.classList.contains('pagedjs_page_content') && !element.classList.contains('pagedjs_footnote_inner_content')) {
        var value = element.getAttribute(name);
        if (value == 'temp-' + this.temporaryIndex) {
          element.removeAttribute(name);
        }
        element = element.parentElement;
      }
    }

    /**
     * Returns the first child that overflows the bounds.
     *
     * There may be no children that overflow (the height might be extended
     * by a sibling). In this case, this function returns NULL.
     *
     * @param {node} node
     *   The parent node of the children we are searching.
     * @param {array} bounds
     *   The bounds of the page area.
     * @returns {ChildNode | null | undefined}
     *   The first overflowing child within the node.
     */
  }, {
    key: "firstOverflowingChild",
    value: function firstOverflowingChild(node, bounds) {
      var bLeft = Math.ceil(bounds.left);
      var bRight = Math.floor(bounds.right);
      var bTop = Math.ceil(bounds.top);
      var bBottom = Math.floor(bounds.bottom);
      var result = undefined;
      var skipRange = false;
      var parentBottomPaddingBorder = 0,
        parentBottomMargin = 0;
      if ((0, _dom.isElement)(node)) {
        var _result = this.getAncestorPaddingBorderAndMarginSums(node);
        parentBottomPaddingBorder = _result['border-bottom-width'];
        parentBottomMargin = _result['margin-bottom'];
      }
      var _iterator = _createForOfIteratorHelper(node.childNodes),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _child = _step.value;
          if (_child.tagName == "COLGROUP") {
            continue;
          }
          var pos = (0, _utils.getBoundingClientRect)(_child);
          var bottomMargin = 0;
          if ((0, _dom.isElement)(_child)) {
            var styles = window.getComputedStyle(_child);
            var skipThis = false;
            bottomMargin = parseInt(styles["margin-bottom"]);
            if (_child.dataset.rangeStartOverflow !== undefined) {
              skipRange = skipThis = true;
              result = null;
              // Don't continue. The start may also be the end.
            }

            if (_child.dataset.rangeEndOverflow !== undefined) {
              skipRange = false;
              result = undefined;
              continue;
            }
            if (_child.dataset.overflowTagged !== undefined) {
              continue;
            }
          } else {
            bottomMargin = parentBottomMargin;
          }
          if (skipRange) {
            continue;
          }
          var left = Math.ceil(pos.left);
          var right = Math.floor(pos.right);
          var top = Math.ceil(pos.top);
          var bottom = Math.floor(pos.bottom + bottomMargin + (node.lastChild == _child ? parentBottomPaddingBorder : 0));
          if (!(pos.height + bottomMargin)) {
            continue;
          }
          if (left < bLeft || right > bRight || top < bTop || bottom > bBottom) {
            return _child;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return result;
    }
  }, {
    key: "removeHeightConstraint",
    value: function removeHeightConstraint(element) {
      var pageBox = element.parentElement.closest('.pagedjs_page');
      pageBox.style.setProperty('--pagedjs-pagebox-height', '5000px');
      this.addTemporarySplit(element.parentElement, false);
    }
  }, {
    key: "restoreHeightConstraint",
    value: function restoreHeightConstraint(element) {
      var pageBox = element.parentElement.closest('.pagedjs_page');
      this.deleteTemporarySplit(element.parentElement, false);
      pageBox.style.removeProperty('--pagedjs-pagebox-height');
    }
  }, {
    key: "getUnconstrainedElementHeight",
    value: function getUnconstrainedElementHeight(element) {
      var includeAncestors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var includeTableHead = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      this.removeHeightConstraint(element);
      var unconstrainedHeight = (0, _utils.getBoundingClientRect)(element).height;
      if (includeAncestors) {
        var extra = this.getAncestorPaddingBorderAndMarginSums(element.parentElement);
        ['top', 'bottom'].forEach(function (direction) {
          unconstrainedHeight += extra["padding-".concat(direction)] + extra["border-".concat(direction, "-width")] + extra["margin-".concat(direction)];
        });
      }
      if (includeTableHead) {
        unconstrainedHeight += this.getAncestorTheadSizes(element.parentElement);
      }
      this.restoreHeightConstraint(element);
      return unconstrainedHeight;
    }
  }, {
    key: "getRange",
    value: function getRange(rangeStart, offset, rangeEnd) {
      var range = document.createRange();
      if ((0, _dom.isText)(rangeStart)) {
        range.setStart(rangeStart, offset);
      } else {
        range.selectNode(rangeStart);
      }

      // Additional nodes may have been added that will overflow further beyond
      // node. Include them in the range.
      rangeEnd = rangeEnd || rangeStart;
      range.setEndAfter(rangeEnd);
      return range;
    }
  }, {
    key: "startOfNewOverflow",
    value: function startOfNewOverflow(node, rendered, bounds) {
      var childNode,
        done = false;
      var prev;
      var anyOverflowFound = false;
      var topNode = node;
      do {
        prev = node;
        do {
          var parentBottomPaddingBorder = void 0,
            parentBottomMargin = void 0;
          childNode = this.firstOverflowingChild(node, bounds);
          if (childNode) {
            anyOverflowFound = true;
          } else if (childNode === undefined) {
            // The overflow isn't caused by children. It could be caused by:
            // * a sibling div / td / element with height that stretches this
            //   element
            // * margin / padding on this element
            // In the former case, we want to ignore this node and take the
            // sibling. In the later case, we want to move this node.
            var intrinsicBottom = 0,
              intrinsicRight = 0;
            var childBounds = (0, _utils.getBoundingClientRect)(node);
            var styles = void 0;
            if ((0, _dom.isElement)(node)) {
              // Assume that any height is the result of matching the
              // height of surrounding content if there's no content.
              var result = this.getAncestorPaddingBorderAndMarginSums(node);
              parentBottomPaddingBorder = result['border-bottom-width'] + result['padding-bottom'];
              parentBottomMargin = result['margin-bottom'];
              if (node.childNodes.length) {
                var lastChild = node.lastChild;
                if ((0, _dom.isText)(lastChild) && !node.dataset.overflowTagged || !(0, _dom.isText)(lastChild) && !lastChild.dataset.overflowTagged) {
                  childBounds = (0, _utils.getBoundingClientRect)(lastChild);
                  intrinsicRight = childBounds.right;
                  intrinsicBottom = childBounds.bottom;
                }
              } else {
                // Do we count this node even though it has no children?
                // Seems to only be needed for BR.
                if (node instanceof HTMLBRElement) {
                  intrinsicRight = childBounds.right;
                  intrinsicBottom = childBounds.bottom;
                }
              }
            } else {
              intrinsicRight = childBounds.right;
              intrinsicBottom = childBounds.bottom;
              var _result2 = this.getAncestorPaddingBorderAndMarginSums(node.parentElement);
              parentBottomPaddingBorder = _result2['border-bottom-width'];
              parentBottomMargin = _result2['margin-bottom'];
            }
            intrinsicBottom += parentBottomPaddingBorder + parentBottomMargin;
            if (intrinsicBottom <= bounds.bottom && intrinsicRight <= bounds.right) {
              var ascended = void 0;
              do {
                ascended = false;
                do {
                  node = node.nextElementSibling;
                } while (node && node.dataset.overflowTagged);
                if (!node && rendered !== prev) {
                  ascended = true;
                  prev = node = prev.parentElement;
                }
              } while (ascended && node && node !== topNode);
              if (!node || node == topNode) {
                return [null, false];
              }
            } else {
              // Node is causing the overflow via padding and margin or text content.
              done = true;
            }
          } else {
            // childNode is null. Overflowing children have been ignored and no other
            // overflowing children were found. Check the node's next sibling or one of
            // an ancestor.
            do {
              while (!node.nextElementSibling) {
                if (node == rendered) {
                  return [null, false];
                }
                node = node.parentElement;
              }
              do {
                node = node.nextElementSibling;
              } while (node.nextElementSibling && node.dataset.overflowTagged);
            } while (node.dataset.overflowTagged);
          }
        } while (node && !childNode && !done);
        if (node) {
          node = childNode;
        }
      } while (node && !done);
      return [prev, anyOverflowFound];
    }
  }, {
    key: "tagAndCreateOverflowRange",
    value: function tagAndCreateOverflowRange(startOfOverflow, rangeStart, rangeEnd, bounds, rendered) {
      var offset = 0;
      var start = bounds.left;
      var end = bounds.right;
      var vStart = bounds.top;
      var vEnd = bounds.bottom;
      var range;
      if ((0, _dom.isText)(rangeStart) && rangeStart.textContent.trim().length) {
        offset = this.textBreak(rangeStart, start, end, vStart, vEnd);
        if (offset === undefined) {
          // Adding split-to changed the CSS and meant we don't need to
          // split this node.
          var next = rangeStart;
          while (!next.nextElementSibling) {
            next = next.parentElement;
            if (next == rendered) {
              return;
            }
          }
          startOfOverflow = rangeStart = next.nextElementSibling;
        }
      }
      var previousElement = (0, _dom.nodeBefore)(rangeStart, rendered, true);
      var shouldContinue = true;
      var newRangeStart = rangeStart;
      while (!offset && previousElement && shouldContinue && ((0, _dom.isText)(newRangeStart) && (newRangeStart.parentElement.dataset.previousBreakAfter == 'avoid' || newRangeStart.parentElement.dataset.breakBefore == 'avoid') || !(0, _dom.isText)(newRangeStart) && (newRangeStart.dataset.previousBreakAfter == 'avoid' || newRangeStart.dataset.breakBefore == 'avoid'))) {
        // We are trying to avoid putting a break at newRangeStart.
        // See if we can move some of the content above into the overflow.
        var newPreviousElement = (0, _dom.nodeBefore)(previousElement, rendered, true);
        // Don't go back into stuff already rendered.
        if (!newPreviousElement || newPreviousElement.dataset.splitFrom) {
          shouldContinue = false;
        } else {
          newRangeStart = previousElement;
          previousElement = newPreviousElement;
        }
      }
      if (shouldContinue) {
        // We found earlier content that doesn't want to avoid having a break after it.
        // newRangeStart is the next node (new overflow start).
        rangeStart = newRangeStart;
      }

      // Set the start of the range and record on node or the previous element
      // that overflow was moved.
      var position = rangeStart;
      range = this.getRange(rangeStart, offset, rangeEnd);
      if ((0, _dom.isText)(rangeStart)) {
        rangeStart.parentElement.dataset.splitTo = rangeStart.parentElement.dataset.ref;
        rangeStart.parentElement.dataset.rangeStartOverflow = true;
        rangeStart.parentElement.dataset.overflowTagged = true;
        position = rangeStart.parentElement;
      } else {
        rangeStart.dataset.rangeStartOverflow = true;
      }
      rangeEnd = rangeEnd || rangeStart;
      if ((0, _dom.isElement)(rangeEnd)) {
        if (rangeStart.parentElement.closest("[data-ref='".concat(rangeEnd.dataset.ref, "']"))) {
          var nextNode = (0, _dom.nodeAfter)(rangeEnd);
          if (nextNode) {
            nextNode.dataset.rangeEndOverflow = true;
            nextNode.dataset.overflowTagged = true;
          }
        } else {
          rangeEnd.dataset.rangeEndOverflow = true;
          rangeEnd.dataset.overflowTagged = true;
        }
      } else {
        rangeEnd.parentElement.dataset.rangeEndOverflow = true;
      }

      // Add splitTo
      while (position !== rendered) {
        if (position.previousSibling) {
          position.parentElement.dataset.splitTo = position.parentElement.dataset.ref;
        }
        position = position.parentElement;
      }

      // Tag ancestors in the range so we don't generate additional ranges
      // that then cause problems when removing the ranges.
      position = rangeStart;
      while (position.parentElement !== range.commonAncestorContainer) {
        position = position.parentElement;
        position.dataset.overflowTagged = true;
      }
      if ((0, _dom.isElement)(position)) {
        var stopAt = rangeEnd;
        while (stopAt.parentElement !== range.commonAncestorContainer) {
          stopAt = stopAt.parentElement;
        }
        while (position !== stopAt) {
          position = position.nextSibling;
          if ((0, _dom.isElement)(position)) {
            position.dataset.overflowTagged = true;
          }
        }
      } else {
        position = position.parentElement;
      }
      while (!position.nextElementSibling && position !== rendered) {
        position = position.parentElement;
        position.dataset.overflowTagged = true;
      }
      return range;
    }
  }, {
    key: "rowspanNeedsBreakAt",
    value: function rowspanNeedsBreakAt(tableRow, rendered) {
      if (tableRow.nodeName !== 'TR') {
        return;
      }
      var table = (0, _dom.parentOf)(tableRow, "TABLE", rendered);
      if (!table) {
        return;
      }
      var rowspan = table.querySelector("[colspan]");
      if (!rowspan) {
        return;
      }
      var columnCount = 0;
      for (var _i = 0, _Array$from = Array.from(table.rows[0].cells); _i < _Array$from.length; _i++) {
        var cell = _Array$from[_i];
        columnCount += parseInt(cell.getAttribute("colspan") || "1");
      }
      if (tableRow.cells.length !== columnCount) {
        var previousRow = tableRow;
        var previousRowColumnCount;
        while (previousRow !== null) {
          previousRowColumnCount = 0;
          for (var _i2 = 0, _Array$from2 = Array.from(previousRow.cells); _i2 < _Array$from2.length; _i2++) {
            var _cell = _Array$from2[_i2];
            previousRowColumnCount += parseInt(_cell.getAttribute("colspan") || "1");
          }
          if (previousRowColumnCount === columnCount) {
            break;
          }
          previousRow = previousRow.previousElementSibling;
        }
        if (previousRowColumnCount === columnCount) {
          return previousRow;
        }
      }
    }
  }, {
    key: "findOverflow",
    value: function findOverflow(rendered, bounds, source) {
      if (!this.hasOverflow(rendered, bounds) || rendered.dataset.overflowTagged) {
        return;
      }

      // The pattern here is:
      // Round the bounds towards the smaller rectangle (round up top & left and
      // round down bottom and right) and round the content towards the larger
      // rectangle (round down top and left and round up bottom and right). Then
      // use > and < to check if bounds are exceeded. That way portions of pixels
      // will be correctly handled - you can't render a fraction of a pixel so
      // bounds should have any fraction treated like that pixel isn't available
      // and content should have any fraction of a pixel treated like the whole
      // pixel is required.
      var end = bounds.right;
      var vEnd = bounds.bottom;
      var anyOverflowFound;

      // Find the deepest element that is the first in set of siblings with
      // overflow. There may be others. We just take the first we find and
      // are called again to check for additional instances.
      var node = rendered,
        startOfOverflow,
        check;
      while ((0, _dom.isText)(node)) {
        node = node.nextElementSibling;
      }
      var _this$startOfNewOverf = this.startOfNewOverflow(node, rendered, bounds);
      var _this$startOfNewOverf2 = (0, _slicedToArray2["default"])(_this$startOfNewOverf, 2);
      startOfOverflow = _this$startOfNewOverf2[0];
      anyOverflowFound = _this$startOfNewOverf2[1];
      if (!anyOverflowFound) {
        return;
      }
      var startOfOverflowIsText = (0, _dom.isText)(startOfOverflow);
      if (startOfOverflowIsText && startOfOverflow.parentElement.dataset.overflowTagged || !startOfOverflowIsText && startOfOverflow.dataset.overflowTagged) {
        return;
      }

      // The node we finished on may be within something asking not to have its
      // contents split. It - or a parent - may also have to be split because
      // the content is just too big for the page.
      // Resolve those requirements, deciding on a node that will be split in
      // the following way:
      // 1) Prefer the smallest node we can (start with the one we ended on).
      //    While going back up the ancestors, check that subsequent children
      //    of the ancestor are all entirely in overflow too. If they are, we
      //    can take a range starting at our initial node and going to the end
      //    of the ancestor's children.

      var rangeStart = check = node = startOfOverflow;
      var visibleSiblings = false;
      var rangeEnd = rendered.lastElementChild;
      do {
        var _siblingBounds2;
        var checkBounds = (0, _utils.getBoundingClientRect)(check);
        var hasOverflow = checkBounds.bottom > vEnd || checkBounds.right > end;
        var rowspanNeedsBreakAt = void 0;
        if (hasOverflow && this.avoidBreakInside(check, rendered)) {
          rowspanNeedsBreakAt = this.rowspanNeedsBreakAt(check, rendered);
          if (rowspanNeedsBreakAt) {
            // No question - break earlier.
            rangeStart = rowspanNeedsBreakAt;
            rangeEnd = rendered.lastChild;
            break;
          } else {
            // If there is an element with overflow and it is within a
            // break-inside: avoid, we take the whole container, provided that it
            // will fit on a page by itself. But calculating whether it will fit
            // by itself is non-trivial. If it is within a dom structure, the
            // space available will be reduced by the containers. We can use the
            // current container (that will get duplicated) but there might be
            // subtle differences in styling due to the split-from class being
            // added. We therefore temporary add the split-from to the current
            // structure and find out how much space we need for the whole thing.
            //
            // To calculate whether we must split the element, we need to know its
            // unconstrained height. If it has been wrapped into another column
            // by .pagedjs_pagebox's display:grid, we need to temporarily lengthen
            // the current column to get the maximum width it would take. Go from
            // check's parent to simplify handling where check is a text node.
            var unconstrainedHeight = void 0;
            if (checkBounds.width > bounds.width) {
              unconstrainedHeight = this.getUnconstrainedElementHeight(check);
            } else {
              unconstrainedHeight = checkBounds.height;
            }
            var mustSplit = unconstrainedHeight > bounds.height;
            if (!mustSplit) {
              // Move the whole thing.
              rangeStart = check;
            }
          }
        }
        var sibling = check,
          siblingBounds = void 0;
        do {
          var _siblingBounds;
          sibling = sibling.nextSibling;
          siblingBounds = sibling ? (0, _utils.getBoundingClientRect)(sibling) : undefined;
        } while (sibling && !((_siblingBounds = siblingBounds) !== null && _siblingBounds !== void 0 && _siblingBounds.height));
        if (sibling && (_siblingBounds2 = siblingBounds) !== null && _siblingBounds2 !== void 0 && _siblingBounds2.height && !rowspanNeedsBreakAt) {
          // Is the sibling entirely in overflow? If yes, so must all following
          // siblings be - add them to this range; they can't have anything we
          // want to keep on this page.
          if ((siblingBounds.left > end || siblingBounds.top > vEnd) && !visibleSiblings) {
            if (!rowspanNeedsBreakAt) {
              rangeEnd = check.parentElement.lastChild;
            }
          } else {
            visibleSiblings = true;
            rangeEnd = undefined;
          }
        }

        // Get the columns widths and make them attributes so removal of
        // overflow doesn't do strange things - they may be affecting
        // widths on this page.
        Array.from(check.parentElement.children).forEach(function (childNode) {
          var style = getComputedStyle(childNode);
          childNode.width = style.width;
        });
        if ((0, _dom.isElement)(check) && Array.from(check.classList).filter(function (value) {
          return ['region-content', 'pagedjs_page_content'].includes(value);
        }).length) {
          break;
        }
        check = check.parentElement;
      } while (check && check !== rendered);
      return this.tagAndCreateOverflowRange(startOfOverflow, rangeStart, rangeEnd, bounds, rendered);
    }
  }, {
    key: "findEndToken",
    value: function findEndToken(rendered, source) {
      if (rendered.childNodes.length === 0) {
        return;
      }
      var lastChild = rendered.lastChild;
      var lastNodeIndex;
      while (lastChild && lastChild.lastChild) {
        if (!(0, _dom.validNode)(lastChild)) {
          // Only get elements with refs
          lastChild = lastChild.previousSibling;
        } else if (!(0, _dom.validNode)(lastChild.lastChild)) {
          // Deal with invalid dom items
          lastChild = (0, _dom.prevValidNode)(lastChild.lastChild);
          break;
        } else {
          lastChild = lastChild.lastChild;
        }
      }
      if ((0, _dom.isText)(lastChild)) {
        if (lastChild.parentNode.dataset.ref) {
          lastNodeIndex = (0, _dom.indexOf)(lastChild);
          lastChild = lastChild.parentNode;
        } else {
          lastChild = lastChild.previousSibling;
        }
      }
      var original = (0, _dom.findElement)(lastChild, source);
      if (lastNodeIndex) {
        original = original.childNodes[lastNodeIndex];
      }
      var after = (0, _dom.nodeAfter)(original);
      return this.breakAt(after);
    }
  }, {
    key: "textBreak",
    value: function textBreak(node, start, end, vStart, vEnd) {
      var wordwalker = (0, _dom.words)(node);
      var left = 0;
      var right = 0;
      var top = 0;
      var bottom = 0;
      var word, next, done, pos;
      var offset;

      // Margin bottom is needed when the node is in a block level element
      // such as a table, grid or flex, where margins don't collapse.
      // Temporarily add data-split-to as this may change margins too
      // (It always does in current code but let's not assume that).
      // With the split-to set, margin might be removed, resulting in us
      // not actually needing to split this text. In that case, the return
      // result will be undefined and the split should be done at the next
      // node. In this case we also keep the data-split-to=foo so the
      // styling that removes the need for the overflow remains active.
      // "Margin" includes bottom padding and border in this calculation.

      this.addTemporarySplit(node.parentElement);
      var parentAdditions = this.getAncestorPaddingBorderAndMarginSums(node.parentElement);
      parentAdditions = parentAdditions['padding-bottom'] + parentAdditions['border-bottom-width'] + parentAdditions['margin-bottom'];
      while (!done) {
        next = wordwalker.next();
        word = next.value;
        done = next.done;
        if (!word) {
          break;
        }
        pos = (0, _utils.getBoundingClientRect)(word);
        left = Math.floor(pos.left);
        right = Math.floor(pos.right);
        top = pos.top;
        bottom = pos.bottom;
        if (left > end || top > vEnd - parentAdditions) {
          offset = word.startOffset;
          break;
        }

        // The bounds won't be exceeded so we need >= rather than >.
        // Also below for the letters.
        if (right > end || bottom > vEnd - parentAdditions) {
          var letterwalker = (0, _dom.letters)(word);
          var letter = void 0,
            nextLetter = void 0,
            doneLetter = void 0;
          while (!doneLetter) {
            // Note that the letter walker continues to walk beyond the end of the word, until the end of the
            // text node.
            nextLetter = letterwalker.next();
            letter = nextLetter.value;
            doneLetter = nextLetter.done;
            if (!letter) {
              break;
            }
            pos = (0, _utils.getBoundingClientRect)(letter);
            right = pos.right;
            bottom = pos.bottom;
            if (right > end || bottom > vEnd - parentAdditions) {
              offset = letter.startOffset;
              done = true;
              break;
            }
          }
        }
      }

      // See comment above the addTemporarySplit call above for the offset ==
      // undefined part of why we may leave the temporary split-to attribute in
      // place. This should be overridden though if a break is to be avoided.
      // In that case,
      if (offset != undefined) {
        this.deleteTemporarySplit(node.parentElement);
      }

      // Don't get tricked into doing a split by whitespace at the start of a string.
      if (node.textContent.substring(0, offset).trim() == '') {
        return 0;
      }
      return offset;
    }
  }, {
    key: "removeOverflow",
    value: function removeOverflow(overflow, breakLetter) {
      var startContainer = overflow.startContainer;
      var extracted = overflow.extractContents();
      this.hyphenateAtBreak(startContainer, breakLetter);
      return extracted;
    }
  }, {
    key: "hyphenateAtBreak",
    value: function hyphenateAtBreak(startContainer, breakLetter) {
      if ((0, _dom.isText)(startContainer)) {
        var startText = startContainer.textContent;
        var prevLetter = startText[startText.length - 1];

        // Add a hyphen if previous character is a letter or soft hyphen
        if (breakLetter && /^\w|\u00AD$/.test(prevLetter) && /^\w|\u00AD$/.test(breakLetter) || !breakLetter && prevLetter && /^\w|\u00AD$/.test(prevLetter)) {
          startContainer.parentNode.classList.add("pagedjs_hyphen");
          startContainer.textContent += this.settings.hyphenGlyph || "\u2011";
        }
      }
    }
  }, {
    key: "equalTokens",
    value: function equalTokens(a, b) {
      if (!a || !b) {
        return false;
      }
      if (a["node"] && b["node"] && a["node"] !== b["node"]) {
        return false;
      }
      if (a["offset"] && b["offset"] && a["offset"] !== b["offset"]) {
        return false;
      }
      return true;
    }
  }]);
  return Layout;
}();
(0, _eventEmitter["default"])(Layout.prototype);
var _default = Layout;
exports["default"] = _default;