/*!
 * Paper.js v0.10.1 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2016, Juerg Lehni & Jonathan Puckey
 * http://scratchdisk.com/ & http://jonathanpuckey.com/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Sat Jul 9 17:17:25 2016 +0200
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2016 Juerg Lehni
 * http://scratchdisk.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * http://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=function(t,e){var i=t?t.window:require("./node/window"),n=i&&i.document;t=t||i;var r=new function(){function t(t,e,i,n,a){function o(s,o){o=o||(o=u(e,s))&&(o.get?o:o.value),"string"==typeof o&&"#"===o[0]&&(o=t[o.substring(1)]||o);var l,d="function"==typeof o,f=o,_=a||d&&!o.base?o&&o.get?s in t:t[s]:null;a&&_||(d&&_&&(o.base=_),d&&n!==!1&&(l=s.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(h[l[3].toLowerCase()+l[4]]=l[2]),f&&!d&&f.get&&"function"==typeof f.get&&r.isPlainObject(f)||(f={value:f,writable:!0}),(u(t,s)||{configurable:!0}).configurable&&(f.configurable=!0,f.enumerable=i),c(t,s,f))}var h={};if(e){for(var l in e)e.hasOwnProperty(l)&&!s.test(l)&&o(l);for(var l in h){var d=h[l],f=t["set"+d],_=t["get"+d]||f&&t["is"+d];!_||n!==!0&&0!==_.length||o(l,{get:_,set:f})}}return t}function i(t,e,i){return t&&("length"in t&&!t.getLength&&"number"==typeof t.length?a:o).call(t,e,i=i||t),i}function n(t,e,i){for(var n=i,r=e.length;n<r;n++){var s=e[n];for(var a in s)s.hasOwnProperty(a)&&(t[a]=s[a])}return t}var s=/^(statics|enumerable|beans|preserve)$/,a=[].forEach||function(t,e){for(var i=0,n=this.length;i<n;i++)t.call(e,this[i],i,this)},o=function(t,e){for(var i in this)this.hasOwnProperty(i)&&t.call(e,this[i],i,this)},h=Object.create||function(t){return{__proto__:t}},u=Object.getOwnPropertyDescriptor||function(t,e){var i=t.__lookupGetter__&&t.__lookupGetter__(e);return i?{get:i,set:t.__lookupSetter__(e),enumerable:!0,configurable:!0}:t.hasOwnProperty(e)?{value:t[e],enumerable:!0,configurable:!0,writable:!0}:null},l=Object.defineProperty||function(t,e,i){return(i.get||i.set)&&t.__defineGetter__?(i.get&&t.__defineGetter__(e,i.get),i.set&&t.__defineSetter__(e,i.set)):t[e]=i.value,t},c=function(t,e,i){return delete t[e],l(t,e,i)};return t(function(){n(this,arguments,0)},{inject:function(e){if(e){var i=e.statics===!0?e:e.statics,n=e.beans,r=e.preserve;i!==e&&t(this.prototype,e,e.enumerable,n,r),t(this,i,!0,n,r)}for(var s=1,a=arguments.length;s<a;s++)this.inject(arguments[s]);return this},extend:function(){for(var e,i,n,r=this,s=0,a=arguments.length;s<a&&(!e||!i);s++)n=arguments[s],e=e||n.initialize,i=i||n.prototype;return e=e||function(){r.apply(this,arguments)},i=e.prototype=i||h(this.prototype),c(i,"constructor",{value:e,writable:!0,configurable:!0}),t(e,this,!0),arguments.length&&this.inject.apply(e,arguments),e.base=r,e}},!0).inject({inject:function(){for(var e=0,i=arguments.length;e<i;e++){var n=arguments[e];n&&t(this,n,n.enumerable,n.beans,n.preserve)}return this},extend:function(){var t=h(this);return t.inject.apply(t,arguments)},each:function(t,e){return i(this,t,e)},set:function(){return n(this,arguments,0)},clone:function(){return new this.constructor(this)},statics:{each:i,create:h,define:c,describe:u,set:function(t){return n(t,arguments,1)},clone:function(t){return n(new t.constructor,arguments,0)},isPlainObject:function(t){var e=null!=t&&t.constructor;return e&&(e===Object||e===r||"Object"===e.name)},pick:function(t,i){return t!==e?t:i}}})};"undefined"!=typeof module&&(module.exports=r),r.inject({toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+r.each(this,function(t,e){if(!/^_/.test(e)){var i=typeof t;this.push(e+": "+("number"===i?h.instance.number(t):"string"===i?"'"+t+"'":t))}},[]).join(", ")+" }"},getClassName:function(){return this._class||""},importJSON:function(t){return r.importJSON(t,this)},exportJSON:function(t){return r.exportJSON(this,t)},toJSON:function(){return r.serialize(this)},_set:function(t){if(t&&r.isPlainObject(t))return r.filter(this,t)},statics:{exports:{enumerable:!0},extend:function nt(){var t=nt.base.apply(this,arguments),e=t.prototype._class;return e&&!r.exports[e]&&(r.exports[e]=t),t},equals:function(t,e){if(t===e)return!0;if(t&&t.equals)return t.equals(e);if(e&&e.equals)return e.equals(t);if(t&&e&&"object"==typeof t&&"object"==typeof e){if(Array.isArray(t)&&Array.isArray(e)){var i=t.length;if(i!==e.length)return!1;for(;i--;)if(!r.equals(t[i],e[i]))return!1}else{var n=Object.keys(t),i=n.length;if(i!==Object.keys(e).length)return!1;for(;i--;){var s=n[i];if(!e.hasOwnProperty(s)||!r.equals(t[s],e[s]))return!1}}return!0}return!1},read:function(t,i,n,s){if(this===r){var a=this.peek(t,i);return t.__index++,a}var o=this.prototype,h=o._readIndex,u=i||h&&t.__index||0;s||(s=t.length-u);var l=t[u];return l instanceof this||n&&n.readNull&&null==l&&s<=1?(h&&(t.__index=u+1),l&&n&&n.clone?l.clone():l):(l=r.create(this.prototype),h&&(l.__read=!0),l=l.initialize.apply(l,u>0||s<t.length?Array.prototype.slice.call(t,u,u+s):t)||l,h&&(t.__index=u+l.__read,l.__read=e),l)},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readAll:function(t,e,i){for(var n,r=[],s=e||0,a=t.length;s<a;s++)r.push(Array.isArray(n=t[s])?this.read(n,0,i):this.read(t,s,i,1));return r},readNamed:function(t,i,n,s,a){var o=this.getNamed(t,i),h=o!==e;if(h){var u=t._filtered;u||(u=t._filtered=r.create(t[0]),u._filtering=t[0]),u[i]=e}return this.read(h?[o]:t,n,s,a)},getNamed:function(t,i){var n=t[0];if(t._hasObject===e&&(t._hasObject=1===t.length&&r.isPlainObject(n)),t._hasObject)return i?n[i]:t._filtered||n},hasNamed:function(t,e){return!!this.getNamed(t,e)},filter:function(t,i,n){for(var r=Object.keys(i._filtering||i),s=0,a=r.length;s<a;s++){var o=r[s];if(!n||!n[o]){var h=i[o];h!==e&&(t[o]=h)}}return t},isPlainValue:function(t,e){return this.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,e,i,n){e=e||{};var s,a=!n;if(a&&(e.formatter=new h(e.precision),n={length:0,definitions:{},references:{},add:function(t,e){var i="#"+t._id,n=this.references[i];if(!n){this.length++;var r=e.call(t),s=t._class;s&&r[0]!==s&&r.unshift(s),this.definitions[i]=r,n=this.references[i]=[i]}return n}}),t&&t._serialize){s=t._serialize(e,n);var o=t._class;!o||t._compactSerialize||!a&&i||s[0]===o||s.unshift(o)}else if(Array.isArray(t)){s=[];for(var u=0,l=t.length;u<l;u++)s[u]=r.serialize(t[u],e,i,n)}else if(r.isPlainObject(t)){s={};for(var c=Object.keys(t),u=0,l=c.length;u<l;u++){var d=c[u];s[d]=r.serialize(t[d],e,i,n)}}else s="number"==typeof t?e.formatter.number(t,e.precision):t;return a&&n.length>0?[["dictionary",n.definitions],s]:s},deserialize:function(t,e,i,n,s){var a=t,o=!i,h=o&&t&&t.length&&"dictionary"===t[0][0];if(i=i||{},Array.isArray(t)){var u=t[0],l="dictionary"===u;if(1==t.length&&/^#/.test(u))return i.dictionary[u];u=r.exports[u],a=[];for(var c=u?1:0,d=t.length;c<d;c++)a.push(r.deserialize(t[c],e,i,l,h));if(u){var f=a;e?a=e(u,f,o||s):(a=r.create(u.prototype),u.apply(a,f))}}else if(r.isPlainObject(t)){a={},n&&(i.dictionary=a);for(var _ in t)a[_]=r.deserialize(t[_],e,i)}return h?a[1]:a},exportJSON:function(t,e){var i=r.serialize(t,e);return e&&e.asString===!1?i:JSON.stringify(i)},importJSON:function(t,e){return r.deserialize("string"==typeof t?JSON.parse(t):t,function(t,i,n){var s=n&&e&&e.constructor===t,a=s?e:r.create(t.prototype);if(1===i.length&&a instanceof w&&(s||!(a instanceof b))){var o=i[0];r.isPlainObject(o)&&(o.insert=!1)}return(s?a._set:t).apply(a,i),s&&(e=null),a})},splice:function(t,i,n,r){var s=i&&i.length,a=n===e;n=a?t.length:n,n>t.length&&(n=t.length);for(var o=0;o<s;o++)i[o]._index=n+o;if(a)return t.push.apply(t,i),[];var h=[n,r];i&&h.push.apply(h,i);for(var u=t.splice.apply(t,h),o=0,l=u.length;o<l;o++)u[o]._index=e;for(var o=n+s,l=t.length;o<l;o++)t[o]._index=o;return u},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var s={on:function(t,e){if("string"!=typeof t)r.each(t,function(t,e){this.on(e,t)},this);else{var i=this._eventTypes,n=i&&i[t],s=this._callbacks=this._callbacks||{};s=s[t]=s[t]||[],s.indexOf(e)===-1&&(s.push(e),n&&n.install&&1===s.length&&n.install.call(this,t))}return this},off:function(t,e){if("string"!=typeof t)return void r.each(t,function(t,e){this.off(e,t)},this);var i,n=this._eventTypes,s=n&&n[t],a=this._callbacks&&this._callbacks[t];return a&&(!e||(i=a.indexOf(e))!==-1&&1===a.length?(s&&s.uninstall&&s.uninstall.call(this,t),delete this._callbacks[t]):i!==-1&&a.splice(i,1)),this},once:function(t,e){return this.on(t,function(){e.apply(this,arguments),this.off(t,e)})},emit:function(t,e){var i=this._callbacks&&this._callbacks[t];if(!i)return!1;var n=[].slice.call(arguments,1),r=e&&e.target&&!e.currentTarget;i=i.slice(),r&&(e.currentTarget=this);for(var s=0,a=i.length;s<a;s++)if(i[s].apply(this,n)===!1){e&&e.stop&&e.stop();break}return r&&delete e.currentTarget,!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e=this._eventTypes,i=this._callbacks,n=t?"install":"uninstall";if(e)for(var r in i)if(i[r].length>0){var s=e[r],a=s&&s[n];a&&a.call(this,r)}},statics:{inject:function rt(t){var e=t._events;if(e){var i={};r.each(e,function(e,n){var s="string"==typeof e,a=s?e:n,o=r.capitalize(a),h=a.substring(2).toLowerCase();i[h]=s?{}:e,a="_"+a,t["get"+o]=function(){return this[a]},t["set"+o]=function(t){var e=this[a];e&&this.off(h,e),t&&this.on(h,t),this[a]=t}}),t._eventTypes=i}return rt.base.apply(this,arguments)}}},a=r.extend({_class:"PaperScope",initialize:function st(){paper=this,this.settings=new r({applyMatrix:!0,insertItems:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this.palettes=[],this._id=st._id++,st._scopes[this._id]=this;var e=st.prototype;if(!this.support){var i=Q.getContext(1,1)||{};e.support={nativeDash:"setLineDash"in i||"mozDash"in i,nativeBlendModes:tt.nativeModes},Q.release(i)}if(!this.agent){var n=t.navigator.userAgent.toLowerCase(),s=(/(darwin|win|mac|linux|freebsd|sunos)/.exec(n)||[])[0],a="darwin"===s?"mac":s,o=e.agent=e.browser={platform:a};a&&(o[a]=!0),n.replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom|node)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:v?([.\d]+))?/g,function(t,e,i,n,r){if(!o.chrome){var s="opera"===e?n:/^(node|trident)$/.test(e)?r:i;o.version=s,o.versionNumber=parseFloat(s),e="trident"===e?"msie":e,o.name=e,o[e]=!0}}),o.chrome&&delete o.webkit,o.atom&&delete o.chrome}},version:"0.10.1",getView:function(){var t=this.project;return t&&t._view},getPaper:function(){return this},execute:function(t,e){paper.PaperScript.execute(t,this,e),U.updateFocus()},install:function(t){var e=this;r.each(["project","view","tool"],function(i){r.define(t,i,{configurable:!0,get:function(){return e[i]}})});for(var i in this)!/^_/.test(i)&&this[i]&&(t[i]=this[i])},setup:function(t){return paper=this,this.project=new y(t),this},createCanvas:function(t,e){return Q.getCanvas(t,e)},activate:function(){paper=this},clear:function(){for(var t=this.projects,e=this.tools,i=this.palettes,n=t.length-1;n>=0;n--)t[n].remove();for(var n=e.length-1;n>=0;n--)e[n].remove();for(var n=i.length-1;n>=0;n--)i[n].remove()},remove:function(){this.clear(),delete a._scopes[this._id]},statics:new function(){function t(t){return t+="Attribute",function(e,i){return e[t](i)||e[t]("data-paper-"+i)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),o=r.extend(s,{initialize:function(t){this._scope=paper,this._index=this._scope[this._list].push(this)-1,!t&&this._scope[this._reference]||this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),this._scope[this._reference]=this,this.emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null!=this._index&&(r.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),this._scope=null,!0)},getView:function(){return this._scope.getView()}}),h=r.extend({initialize:function(t){this.precision=r.pick(t,5),this.multiplier=Math.pow(10,this.precision)},number:function(t){return this.precision<16?Math.round(t*this.multiplier)/this.multiplier:t},pair:function(t,e,i){return this.number(t)+(i||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});h.instance=new h;var u=new function(){function t(t,e,i){return t<e?e:t>i?i:t}function e(t,e,i){function n(t){var e=134217729*t,i=t-e,n=i+e,r=t-n;return[n,r]}var r=e*e-t*i,a=e*e+t*i;if(3*s(r)<a){var o=n(t),h=n(e),u=n(i),l=e*e,c=h[0]*h[0]-l+2*h[0]*h[1]+h[1]*h[1],d=t*i,f=o[0]*u[0]-d+o[0]*u[1]+o[1]*u[0]+o[1]*u[1];r=l-d+(c-f)}return r}function i(){var t=Math.max.apply(Math,arguments);return t&&(t<1e-8||t>1e8)?o(2,-Math.round(h(t))):0}var n=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],r=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],s=Math.abs,a=Math.sqrt,o=Math.pow,h=Math.log2||function(t){return Math.log(t)*Math.LOG2E},l=1e-12,c=1.12e-16;return{TOLERANCE:1e-6,EPSILON:l,MACHINE_EPSILON:c,CURVETIME_EPSILON:4e-7,GEOMETRIC_EPSILON:2e-7,WINDING_EPSILON:2e-7,TRIGONOMETRIC_EPSILON:1e-7,CLIPPING_EPSILON:1e-9,KAPPA:4*(a(2)-1)/3,isZero:function(t){return t>=-l&&t<=l},clamp:t,integrate:function(t,e,i,s){for(var a=n[s-2],o=r[s-2],h=.5*(i-e),u=h+e,l=0,c=s+1>>1,d=1&s?o[l++]*t(u):0;l<c;){var f=h*a[l];d+=o[l++]*(t(u+f)+t(u-f))}return h*d},findRoot:function(t,e,i,n,r,a,o){for(var h=0;h<a;h++){var u=t(i),l=u/e(i),c=i-l;if(s(l)<o)return c;u>0?(r=i,i=c<=n?.5*(n+r):c):(n=i,i=c>=r?.5*(n+r):c)}return i},solveQuadratic:function(n,r,o,h,u,d){var f,_=1/0;if(s(n)<l){if(s(r)<l)return s(o)<l?-1:0;f=-o/r}else{r*=-.5;var g=e(n,r,o);if(g&&s(g)<c){var v=i(s(n),s(r),s(o));v&&(n*=v,r*=v,o*=v,g=e(n,r,o))}if(g>=-c){var p=g<0?0:a(g),m=r+(r<0?-p:p);0===m?(f=o/n,_=-f):(f=m/n,_=o/m)}}var y=0,w=null==u,x=u-l,b=d+l;return isFinite(f)&&(w||f>x&&f<b)&&(h[y++]=w?f:t(f,u,d)),_!==f&&isFinite(_)&&(w||_>x&&_<b)&&(h[y++]=w?_:t(_,u,d)),y},solveCubic:function(e,n,r,h,d,f,_){function g(t){v=t;var i=e*v;p=i+n,m=p*v+r,y=(i+p)*v+m,w=m*v+h}var v,p,m,y,w,x=i(s(e),s(n),s(r),s(h));if(x&&(e*=x,n*=x,r*=x,h*=x),s(e)<l)e=n,p=r,m=h,v=1/0;else if(s(h)<l)p=n,m=r,v=0;else{g(-(n/e)/3);var b=w/e,C=o(s(b),1/3),S=b<0?-1:1,P=-y/e,I=P>0?1.324717957244746*Math.max(C,a(P)):C,M=v-S*I;if(M!==v){do g(M),M=0===y?v:v-w/y/(1+c);while(S*M>S*v);s(e)*v*v>s(h/v)&&(m=-h/v,p=(m-r)/v)}}var T=u.solveQuadratic(e,p,m,d,f,_),k=null==f;return isFinite(v)&&(0===T||T>0&&v!==d[0]&&v!==d[1])&&(k||v>f-l&&v<_+l)&&(d[T++]=k?v:t(v,f,_)),T}}},l={_id:1,_pools:{},get:function(t){if(t){var e=this._pools[t];return e||(e=this._pools[t]={_id:1}),e._id++}return this._id++}},c=r.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var i=typeof t;if("number"===i){var n="number"==typeof e;this.x=t,this.y=n?e:t,this.__read&&(this.__read=n?2:1)}else if("undefined"===i||null===t)this.x=this.y=0,this.__read&&(this.__read=null===t?1:0);else{var r="string"===i?t.split(/[\s,]+/)||[]:t;Array.isArray(r)?(this.x=r[0],this.y=r.length>1?r[1]:r[0]):"x"in r?(this.x=r.x,this.y=r.y):"width"in r?(this.x=r.width,this.y=r.height):"angle"in r?(this.x=r.length,this.y=0,this.setAngle(r.angle)):(this.x=this.y=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1)}},set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new c(this.x,this.y)},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){if(this.isZero()){var e=this._angle||0;this.set(Math.cos(e)*t,Math.sin(e)*t)}else{var i=t/this.getLength();u.isZero(i)&&this.getAngle(),this.set(this.x*i,this.y*i)}},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=c.read(arguments),e=this.getLength()*t.getLength();if(u.isZero(e))return NaN;var i=this.dot(t)/e;return Math.acos(i<-1?-1:i>1?1:i)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){if(this._angle=t,!this.isZero()){var e=this.getLength();this.set(Math.cos(t)*e,Math.sin(t)*e)}},getQuadrant:function(){return this.x>=0?this.y>=0?1:4:this.y>=0?2:3}},{beans:!1,getDirectedAngle:function(){var t=c.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=c.read(arguments),e=t.x-this.x,i=t.y-this.y,n=e*e+i*i,s=r.read(arguments);return s?n:Math.sqrt(n)},normalize:function(t){t===e&&(t=1);var i=this.getLength(),n=0!==i?t/i:0,r=new c(this.x*n,this.y*n);return n>=0&&(r._angle=this._angle),r},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var i=e?this.subtract(e):this,n=Math.sin(t),r=Math.cos(t);return i=new c(i.x*r-i.y*n,i.x*n+i.y*r),e?i.add(e):i},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=c.read(arguments);return new c(this.x+t.x,this.y+t.y)},subtract:function(){var t=c.read(arguments);return new c(this.x-t.x,this.y-t.y)},multiply:function(){var t=c.read(arguments);return new c(this.x*t.x,this.y*t.y)},divide:function(){var t=c.read(arguments);return new c(this.x/t.x,this.y/t.y)},modulo:function(){var t=c.read(arguments);return new c(this.x%t.x,this.y%t.y)},negate:function(){return new c((-this.x),(-this.y))},isInside:function(){return g.read(arguments).contains(this)},isClose:function(){var t=c.read(arguments),e=r.read(arguments);return this.getDistance(t)<=e},isCollinear:function(){var t=c.read(arguments);return c.isCollinear(this.x,this.y,t.x,t.y)},isColinear:"#isCollinear",isOrthogonal:function(){var t=c.read(arguments);return c.isOrthogonal(this.x,this.y,t.x,t.y)},isZero:function(){return u.isZero(this.x)&&u.isZero(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},dot:function(){var t=c.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=c.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=c.read(arguments),e=t.isZero()?0:this.dot(t)/t.dot(t);return new c(t.x*e,t.y*e)},statics:{min:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.min(t.x,e.x),Math.min(t.y,e.y))},max:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.max(t.x,e.x),Math.max(t.y,e.y))},random:function(){return new c(Math.random(),Math.random())},isCollinear:function(t,e,i,n){return Math.abs(t*n-e*i)<=1e-7*Math.sqrt((t*t+e*e)*(i*i+n*n))},isOrthogonal:function(t,e,i,n){return Math.abs(t*i+e*n)<=1e-7*Math.sqrt((t*t+e*e)*(i*i+n*n))}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new c(e(this.x),e(this.y))}},{})),d=c.extend({initialize:function(t,e,i,n){this._x=t,this._y=e,this._owner=i,this._setter=n},set:function(t,e,i){return this._x=t,this._y=e,i||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner.changeSelection(this._getSelection(),t)},_getSelection:function(){return"setPosition"===this._setter?4:0}}),f=r.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var i=typeof t;if("number"===i){var n="number"==typeof e;this.width=t,this.height=n?e:t,this.__read&&(this.__read=n?2:1)}else if("undefined"===i||null===t)this.width=this.height=0,this.__read&&(this.__read=null===t?1:0);else{var r="string"===i?t.split(/[\s,]+/)||[]:t;Array.isArray(r)?(this.width=r[0],this.height=r.length>1?r[1]:r[0]):"width"in r?(this.width=r.width,this.height=r.height):"x"in r?(this.width=r.x,this.height=r.y):(this.width=this.height=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1)}},set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new f(this.width,this.height)},toString:function(){var t=h.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.width),e.number(this.height)]},add:function(){var t=f.read(arguments);return new f(this.width+t.width,this.height+t.height)},subtract:function(){var t=f.read(arguments);return new f(this.width-t.width,this.height-t.height)},multiply:function(){var t=f.read(arguments);return new f(this.width*t.width,this.height*t.height)},divide:function(){var t=f.read(arguments);return new f(this.width/t.width,this.height/t.height)},modulo:function(){var t=f.read(arguments);return new f(this.width%t.width,this.height%t.height)},negate:function(){return new f((-this.width),(-this.height))},isZero:function(){return u.isZero(this.width)&&u.isZero(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new f(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new f(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new f(Math.random(),Math.random())}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new f(e(this.width),e(this.height))}},{})),_=f.extend({initialize:function(t,e,i,n){this._width=t,this._height=e,this._owner=i,this._setter=n},set:function(t,e,i){return this._width=t,this._height=e,i||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),g=r.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(t,i,n,s){var a=typeof t,o=0;if("number"===a?(this.x=t,this.y=i,this.width=n,this.height=s,o=4):"undefined"===a||null===t?(this.x=this.y=this.width=this.height=0,o=null===t?1:0):1===arguments.length&&(Array.isArray(t)?(this.x=t[0],this.y=t[1],this.width=t[2],this.height=t[3],o=1):t.x!==e||t.width!==e?(this.x=t.x||0,this.y=t.y||0,this.width=t.width||0,this.height=t.height||0,o=1):t.from===e&&t.to===e&&(this.x=this.y=this.width=this.height=0,this._set(t),o=1)),!o){var h=c.readNamed(arguments,"from"),u=r.peek(arguments);if(this.x=h.x,this.y=h.y,u&&u.x!==e||r.hasNamed(arguments,"to")){var l=c.readNamed(arguments,"to");this.width=l.x-h.x,this.height=l.y-h.y,this.width<0&&(this.x=l.x,this.width=-this.width),this.height<0&&(this.y=l.y,this.height=-this.height)}else{var d=f.read(arguments);this.width=d.width,this.height=d.height}o=arguments.__index}this.__read&&(this.__read=o)},set:function(t,e,i,n){return this.x=t,this.y=e,this.width=i,this.height=n,this},clone:function(){return new g(this.x,this.y,this.width,this.height)},equals:function(t){var e=r.isPlainValue(t)?g.read(arguments):t;return e===this||e&&this.x===e.x&&this.y===e.y&&this.width===e.width&&this.height===e.height||!1},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y),e.number(this.width),e.number(this.height)]},getPoint:function(t){var e=t?c:d;return new e(this.x,this.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){var e=t?f:_;return new e(this.width,this.height,this,"setSize")},setSize:function(){var t=f.read(arguments);this._fixX&&(this.x+=(this.width-t.width)*this._fixX),this._fixY&&(this.y+=(this.height-t.height)*this._fixY),this.width=t.width,this.height=t.height,this._fixW=1,this._fixH=1},getLeft:function(){return this.x},setLeft:function(t){this._fixW||(this.width-=t-this.x),this.x=t,this._fixX=0},getTop:function(){return this.y},setTop:function(t){this._fixH||(this.height-=t-this.y),this.y=t,this._fixY=0},getRight:function(){return this.x+this.width},setRight:function(t){this._fixX!==e&&1!==this._fixX&&(this._fixW=0),this._fixW?this.x=t-this.width:this.width=t-this.x,this._fixX=1},getBottom:function(){return this.y+this.height},setBottom:function(t){this._fixY!==e&&1!==this._fixY&&(this._fixH=0),this._fixH?this.y=t-this.height:this.height=t-this.y,this._fixY=1},getCenterX:function(){return this.x+.5*this.width},setCenterX:function(t){this.x=t-.5*this.width,this._fixX=.5},getCenterY:function(){return this.y+.5*this.height},setCenterY:function(t){this.y=t-.5*this.height,this._fixY=.5},getCenter:function(t){var e=t?c:d;return new e(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=c.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(t){return t&&t.width!==e||4===(Array.isArray(t)?t:arguments).length?this._containsRectangle(g.read(arguments)):this._containsPoint(c.read(arguments))},_containsPoint:function(t){var e=t.x,i=t.y;return e>=this.x&&i>=this.y&&e<=this.x+this.width&&i<=this.y+this.height},_containsRectangle:function(t){var e=t.x,i=t.y;return e>=this.x&&i>=this.y&&e+t.width<=this.x+this.width&&i+t.height<=this.y+this.height},intersects:function(){var t=g.read(arguments);return t.x+t.width>this.x&&t.y+t.height>this.y&&t.x<this.x+this.width&&t.y<this.y+this.height},touches:function(){var t=g.read(arguments);return t.x+t.width>=this.x&&t.y+t.height>=this.y&&t.x<=this.x+this.width&&t.y<=this.y+this.height},intersect:function(){var t=g.read(arguments),e=Math.max(this.x,t.x),i=Math.max(this.y,t.y),n=Math.min(this.x+this.width,t.x+t.width),r=Math.min(this.y+this.height,t.y+t.height);return new g(e,i,n-e,r-i)},unite:function(){var t=g.read(arguments),e=Math.min(this.x,t.x),i=Math.min(this.y,t.y),n=Math.max(this.x+this.width,t.x+t.width),r=Math.max(this.y+this.height,t.y+t.height);return new g(e,i,n-e,r-i)},include:function(){var t=c.read(arguments),e=Math.min(this.x,t.x),i=Math.min(this.y,t.y),n=Math.max(this.x+this.width,t.x),r=Math.max(this.y+this.height,t.y);return new g(e,i,n-e,r-i)},expand:function(){var t=f.read(arguments),e=t.width,i=t.height;return new g(this.x-e/2,this.y-i/2,this.width+e,this.height+i)},scale:function(t,i){return this.expand(this.width*t-this.width,this.height*(i===e?t:i)-this.height)}},r.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var i=t.join(""),n=/^[RL]/.test(i);e>=4&&(t[1]+=n?"Y":"X");var r=t[n?0:1],s=t[n?1:0],a="get"+r,o="get"+s,h="set"+r,u="set"+s,l="get"+i,f="set"+i;this[l]=function(t){var e=t?c:d;return new e(this[a](),this[o](),this,f)},this[f]=function(){var t=c.read(arguments);this[h](t.x),this[u](t.y)}},{beans:!0})),v=g.extend({initialize:function(t,e,i,n,r,s){this.set(t,e,i,n,!0),this._owner=r,this._setter=s},set:function(t,e,i,n,r){return this._x=t,this._y=e,this._width=i,this._height=n,r||this._owner[this._setter](this),this}},new function(){var t=g.prototype;return r.each(["x","y","width","height"],function(t){var e=r.capitalize(t),i="_"+t;this["get"+e]=function(){return this[i]},this["set"+e]=function(t){this[i]=t,this._dontNotify||this._owner[this._setter](this)}},r.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(e){var i="set"+e;this[i]=function(){this._dontNotify=!0,t[i].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return!!(2&this._owner._selection)},setSelected:function(t){var e=this._owner;e.changeSelection&&e.changeSelection(2,t)}}))}),p=r.extend({_class:"Matrix",initialize:function at(t){var e=arguments.length,i=!0;if(6===e?this.set.apply(this,arguments):1===e?t instanceof at?this.set(t._a,t._b,t._c,t._d,t._tx,t._ty):Array.isArray(t)?this.set.apply(this,t):i=!1:0===e?this.reset():i=!1,!i)throw new Error("Unsupported matrix parameters")},set:function(t,e,i,n,r,s,a){return this._a=t,this._b=e,this._c=i,this._d=n,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t,e){return r.serialize(this.getValues(),t,!0,e)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(9))},clone:function(){return new p(this._a,this._b,this._c,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty},toString:function(){var t=h.instance;return"[["+[t.number(this._a),t.number(this._c),t.number(this._tx)].join(", ")+"], ["+[t.number(this._b),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._b=this._c=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,e){var i=this._owner;return!!i&&(i.transform(null,!0,r.pick(t,!0),e),this.isIdentity())},translate:function(){var t=c.read(arguments),e=t.x,i=t.y;return this._tx+=e*this._a+i*this._c,
this._ty+=e*this._b+i*this._d,this._changed(),this},scale:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});return e&&this.translate(e),this._a*=t.x,this._b*=t.x,this._c*=t.y,this._d*=t.y,e&&this.translate(e.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=c.read(arguments,1),i=e.x,n=e.y,r=Math.cos(t),s=Math.sin(t),a=i-i*r+n*s,o=n-i*s-n*r,h=this._a,u=this._b,l=this._c,d=this._d;return this._a=r*h+s*l,this._b=r*u+s*d,this._c=-s*h+r*l,this._d=-s*u+r*d,this._tx+=a*h+o*l,this._ty+=a*u+o*d,this._changed(),this},shear:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});e&&this.translate(e);var i=this._a,n=this._b;return this._a+=t.y*this._c,this._b+=t.y*this._d,this._c+=t.x*i,this._d+=t.x*n,e&&this.translate(e.negate()),this._changed(),this},skew:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0}),i=Math.PI/180,n=new c(Math.tan(t.x*i),Math.tan(t.y*i));return this.shear(n,e)},append:function(t){if(t){var e=this._a,i=this._b,n=this._c,r=this._d,s=t._a,a=t._c,o=t._b,h=t._d,u=t._tx,l=t._ty;this._a=s*e+o*n,this._c=a*e+h*n,this._b=s*i+o*r,this._d=a*i+h*r,this._tx+=u*e+l*n,this._ty+=u*i+l*r,this._changed()}return this},prepend:function(t){if(t){var e=this._a,i=this._b,n=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._c,u=t._b,l=t._d,c=t._tx,d=t._ty;this._a=o*e+h*i,this._c=o*n+h*r,this._b=u*e+l*i,this._d=u*n+l*r,this._tx=o*s+h*a+c,this._ty=u*s+l*a+d,this._changed()}return this},appended:function(t){return this.clone().append(t)},prepended:function(t){return this.clone().prepend(t)},invert:function(){var t=this._a,e=this._b,i=this._c,n=this._d,r=this._tx,s=this._ty,a=t*n-e*i,o=null;return a&&!isNaN(a)&&isFinite(r)&&isFinite(s)&&(this._a=n/a,this._b=-e/a,this._c=-i/a,this._d=t/a,this._tx=(i*s-n*r)/a,this._ty=(e*r-t*s)/a,o=this),o},inverted:function(){return this.clone().invert()},concatenate:"#append",preConcatenate:"#prepend",chain:"#appended",_shiftless:function(){return new p(this._a,this._b,this._c,this._d,0,0)},_orNullIfIdentity:function(){return this.isIdentity()?null:this},isIdentity:function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty},isInvertible:function(){var t=this._a*this._d-this._c*this._b;return t&&!isNaN(t)&&isFinite(this._tx)&&isFinite(this._ty)},isSingular:function(){return!this.isInvertible()},transform:function(t,e,i){return arguments.length<3?this._transformPoint(c.read(arguments)):this._transformCoordinates(t,e,i)},_transformPoint:function(t,e,i){var n=t.x,r=t.y;return e||(e=new c),e.set(n*this._a+r*this._c+this._tx,n*this._b+r*this._d+this._ty,i)},_transformCoordinates:function(t,e,i){for(var n=0,r=2*i;n<r;n+=2){var s=t[n],a=t[n+1];e[n]=s*this._a+a*this._c+this._tx,e[n+1]=s*this._b+a*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,i=t.y,n=e+t.width,r=i+t.height,s=[e,i,n,i,n,r,e,r];return this._transformCoordinates(s,s,4)},_transformBounds:function(t,e,i){for(var n=this._transformCorners(t),r=n.slice(0,2),s=r.slice(),a=2;a<8;a++){var o=n[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return e||(e=new g),e.set(r[0],r[1],s[0]-r[0],s[1]-r[1],i)},inverseTransform:function(){return this._inverseTransform(c.read(arguments))},_inverseTransform:function(t,e,i){var n=this._a,r=this._b,s=this._c,a=this._d,o=this._tx,h=this._ty,u=n*a-r*s,l=null;if(u&&!isNaN(u)&&isFinite(o)&&isFinite(h)){var d=t.x-this._tx,f=t.y-this._ty;e||(e=new c),l=e.set((d*a-f*s)/u,(f*n-d*r)/u,i)}return l},decompose:function(){var t,e,i,n=this._a,r=this._b,s=this._c,a=this._d,o=n*a-r*s,h=Math.sqrt,u=Math.atan2,l=180/Math.PI;if(0!==n||0!==r){var d=h(n*n+r*r);t=Math.acos(n/d)*(r>0?1:-1),e=[d,o/d],i=[u(n*s+r*a,d*d),0]}else if(0!==s||0!==a){var f=h(s*s+a*a);t=Math.asin(s/f)*(a>0?1:-1),e=[o/f,f],i=[0,u(n*s+r*a,f*f)]}else t=0,i=e=[0,0];return{translation:this.getTranslation(),rotation:t*l,scaling:new c(e),skewing:new c(i[0]*l,i[1]*l)}},getValues:function(){return[this._a,this._b,this._c,this._d,this._tx,this._ty]},getTranslation:function(){return new c(this._tx,this._ty)},getScaling:function(){return(this.decompose()||{}).scaling},getRotation:function(){return(this.decompose()||{}).rotation},applyToContext:function(t){this.isIdentity()||t.transform(this._a,this._b,this._c,this._d,this._tx,this._ty)}},r.each(["a","b","c","d","tx","ty"],function(t){var e=r.capitalize(t),i="_"+t;this["get"+e]=function(){return this[i]},this["set"+e]=function(t){this[i]=t,this._changed()}},{})),m=r.extend({_class:"Line",initialize:function(t,e,i,n,r){var s=!1;arguments.length>=4?(this._px=t,this._py=e,this._vx=i,this._vy=n,s=r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,s=i),s||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new c(this._px,this._py)},getVector:function(){return new c(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return m.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t,e){return m.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0,e)},getDistance:function(t){return Math.abs(m.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0))},isCollinear:function(t){return c.isCollinear(this._vx,this._vy,t._vx,t._vy)},isOrthogonal:function(t){return c.isOrthogonal(this._vx,this._vy,t._vx,t._vy)},statics:{intersect:function(t,e,i,n,r,s,a,o,h,l){h||(i-=t,n-=e,a-=r,o-=s);var d=i*o-n*a;if(!u.isZero(d)){var f=t-r,_=e-s,g=(a*_-o*f)/d,v=(i*_-n*f)/d,p=1e-12,m=-p,y=1+p;if(l||m<g&&g<y&&m<v&&v<y)return l||(g=g<=0?0:g>=1?1:g),new c(t+g*i,e+g*n)}},getSide:function(t,e,i,n,r,s,a,o){a||(i-=t,n-=e);var h=r-t,u=s-e,l=h*n-u*i;return 0!==l||o||(l=(h*i+h*i)/(i*i+n*n),l>=0&&l<=1&&(l=0)),l<0?-1:l>0?1:0},getSignedDistance:function(t,e,i,n,r,s,a){return a||(i-=t,n-=e),0===i?n>0?r-t:t-r:0===n?i<0?s-e:e-s:((r-t)*n-(s-e)*i)/Math.sqrt(i*i+n*n)}}}),y=o.extend({_class:"Project",_list:"projects",_reference:"project",_compactSerialize:!0,initialize:function(t){o.call(this,!0),this._children=[],this._namedChildren={},this._activeLayer=null,this._currentStyle=new V(null,null,this),this._view=U.create(this,t||Q.getCanvas(1,1)),this._selectionItems={},this._selectionCount=0,this._updateVersion=0},_serialize:function(t,e){return r.serialize(this._children,t,!0,e)},_changed:function(t,e){if(1&t){var i=this._view;i&&(i._needsUpdate=!0,!i._requested&&i._autoUpdate&&i.requestUpdate())}var n=this._changes;if(n&&e){var r=this._changesById,s=e._id,a=r[s];a?a.flags|=t:n.push(r[s]={item:e,flags:t})}},clear:function(){for(var t=this._children,e=t.length-1;e>=0;e--)t[e].remove()},isEmpty:function(){return 0===this._children.length},remove:function ot(){return!!ot.base.call(this)&&(this._view&&this._view.remove(),!0)},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.initialize(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getLayers:function(){return this._children},getActiveLayer:function(){return this._activeLayer||new b({project:this,insert:!0})},getSymbolDefinitions:function(){var t=[],e={};return this.getItems({"class":P,match:function(i){var n=i._definition,r=n._id;return e[r]||(e[r]=!0,t.push(n)),!1}}),t},getSymbols:"getSymbolDefinitions",getSelectedItems:function(){var t=this._selectionItems,e=[];for(var i in t){var n=t[i],r=n._selection;1&r&&n.isInserted()?e.push(n):r||this._updateSelection(n)}return e},_updateSelection:function(t){var e=t._id,i=this._selectionItems;t._selection?i[e]!==t&&(this._selectionCount++,i[e]=t):i[e]===t&&(this._selectionCount--,delete i[e])},selectAll:function(){for(var t=this._children,e=0,i=t.length;e<i;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t=this._selectionItems;for(var e in t)t[e].setFullySelected(!1)},addLayer:function(t){return this.insertLayer(e,t)},insertLayer:function(t,e){if(e instanceof b){e._remove(!1,!0),r.splice(this._children,[e],t,0),e._setProject(this,!0);var i=e._name;i&&e.setName(i),this._changes&&e._changed(5),this._activeLayer||(this._activeLayer=e)}else e=null;return e},_insertItem:function(t,i,n,r){return i=this.insertLayer(t,i)||(this._activeLayer||this._insertItem(e,new b(w.NO_INSERT),!0,!0)).insertChild(t,i,n),r&&i.activate&&i.activate(),i},getItems:function(t){return w._getItems(this,t)},getItem:function(t){return w._getItems(this,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var e=this._activeLayer;return r.importJSON(t,e&&e.isEmpty()&&e)},removeOn:function(t){var e=this._removeSets;if(e){"mouseup"===t&&(e.mousedrag=null);var i=e[t];if(i){for(var n in i){var r=i[n];for(var s in e){var a=e[s];a&&a!=i&&delete a[r._id]}r.remove()}e[t]=null}}},draw:function(t,e,i){this._updateVersion++,t.save(),e.applyToContext(t);for(var n=this._children,s=new r({offset:new c(0,0),pixelRatio:i,viewMatrix:e.isIdentity()?null:e,matrices:[new p],updateMatrix:!0}),a=0,o=n.length;a<o;a++)n[a].draw(t,s);if(t.restore(),this._selectionCount>0){t.save(),t.strokeWidth=1;var h=this._selectionItems,u=this._scope.settings.handleSize,l=this._updateVersion;for(var d in h)h[d]._drawSelection(t,e,u,h,l);t.restore()}}}),w=r.extend(s,{statics:{extend:function ht(t){return t._serializeFields&&(t._serializeFields=r.set({},this.prototype._serializeFields,t._serializeFields)),ht.base.apply(this,arguments)},NO_INSERT:{insert:!1}},_class:"Item",_name:null,_applyMatrix:!0,_canApplyMatrix:!0,_canScaleStroke:!1,_pivot:null,_visible:!0,_blendMode:"normal",_opacity:1,_locked:!1,_guide:!1,_clipMask:!1,_selection:0,_selectBounds:!0,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new p,pivot:null,visible:!0,blendMode:"normal",opacity:1,locked:!1,guide:!1,clipMask:!1,selected:!1,data:{}}},new function(){var t=["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"];return r.each(t,function(t){this._events[t]={install:function(t){this.getView()._countItemEvent(t,1)},uninstall:function(t){this.getView()._countItemEvent(t,-1)}}},{_events:{onFrame:{install:function(){this.getView()._animateItem(this,!0)},uninstall:function(){this.getView()._animateItem(this,!1)}},onLoad:{},onError:{}},statics:{_itemHandlers:t}})},{initialize:function(){},_initialize:function(t,i){var n=t&&r.isPlainObject(t),s=n&&t.internal===!0,a=this._matrix=new p,o=n&&t.project||paper.project,h=paper.settings;return this._id=s?null:l.get(),this._parent=this._index=null,this._applyMatrix=this._canApplyMatrix&&h.applyMatrix,i&&a.translate(i),a._owner=this,this._style=new V(o._currentStyle,this,o),s||n&&t.insert===!1||!h.insertItems&&(!n||t.insert!==!0)?this._setProject(o):(n&&t.parent||o)._insertItem(e,this,!0,!0),n&&t!==w.NO_INSERT&&r.filter(this,t,{internal:!0,insert:!0,project:!0,parent:!0}),n},_serialize:function(t,e){function i(i){for(var a in i){var o=s[a];r.equals(o,"leading"===a?1.2*i.fontSize:i[a])||(n[a]=r.serialize(o,t,"data"!==a,e))}}var n={},s=this;return i(this._serializeFields),this instanceof x||i(this._style._defaults),[this._class,n]},_changed:function(t){var i=this._symbol,n=this._parent||i,r=this._project;8&t&&(this._bounds=this._position=this._decomposed=this._globalMatrix=e),n&&40&t&&w._clearBoundsCache(n),2&t&&w._clearBoundsCache(this),r&&r._changed(t,this),i&&i._changed(t)},set:function(t){return t&&this._set(t),this},getId:function(){return this._id},getName:function(){return this._name},setName:function(t){if(this._name&&this._removeNamed(),t===+t+"")throw new Error("Names consisting only of numbers are not supported.");var i=this._getOwner();if(t&&i){var n=i._children,r=i._namedChildren;(r[t]=r[t]||[]).push(this),t in n||(n[t]=this)}this._name=t||e,this._changed(128)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},r.each(["locked","visible","blendMode","opacity","guide"],function(t){var e=r.capitalize(t),t="_"+t;this["get"+e]=function(){return this[t]},this["set"+e]=function(e){e!=this[t]&&(this[t]=e,this._changed("_locked"===t?128:129))}},{}),{beans:!0,getSelection:function(){return this._selection},setSelection:function(t){if(t!==this._selection){this._selection=t;var e=this._project;e&&(e._updateSelection(this),this._changed(129))}},changeSelection:function(t,e){var i=this._selection;this.setSelection(e?i|t:i&~t)},isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,i=t.length;e<i;e++)if(t[e].isSelected())return!0;return!!(1&this._selection)},setSelected:function(t){if(this._selectChildren)for(var e=this._children,i=0,n=e.length;i<n;i++)e[i].setSelected(t);this.changeSelection(1,t)},isFullySelected:function(){var t=this._children,e=!!(1&this._selection);if(t&&e){for(var i=0,n=t.length;i<n;i++)if(!t[i].isFullySelected())return!1;return!0}return e},setFullySelected:function(t){var e=this._children;if(e)for(var i=0,n=e.length;i<n;i++)e[i].setFullySelected(t);this.changeSelection(1,t)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&(this._clipMask=t,t&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(129),this._parent&&this._parent._changed(1024))},getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=this._position,i=t?c:d;if(!e){var n=this._pivot;e=this._position=n?this._matrix._transformPoint(n):this.getBounds().getCenter(!0)}return new i(e.x,e.y,this,"setPosition")},setPosition:function(){this.translate(c.read(arguments).subtract(this.getPosition(!0)))},getPivot:function(t){var e=this._pivot;if(e){var i=t?c:d;e=new i(e.x,e.y,this,"setPivot")}return e},setPivot:function(){this._pivot=c.read(arguments,0,{clone:!0,readNull:!0}),this._position=e}},r.each({getStrokeBounds:{stroke:!0},getHandleBounds:{handle:!0},getInternalBounds:{internal:!0}},function(t,e){this[e]=function(e){return this.getBounds(e,t)}},{beans:!0,getBounds:function(t,e){var i=e||t instanceof p,n=r.set({},i?e:t,this._boundsOptions);n.stroke&&!this.getStrokeScaling()||(n.cacheItem=this);var s=this._getCachedBounds(i&&t,n);return 0===arguments.length?new v(s.x,s.y,s.width,s.height,this,"setBounds"):s},setBounds:function(){var t=g.read(arguments),e=this.getBounds(),i=this._matrix,n=new p,r=t.getCenter();n.translate(r),t.width==e.width&&t.height==e.height||(i.isInvertible()||(i.initialize(i._backup||(new p).translate(i.getTranslation())),e=this.getBounds()),n.scale(0!==e.width?t.width/e.width:0,0!==e.height?t.height/e.height:0)),r=e.getCenter(),n.translate(-r.x,-r.y),this.transform(n)},_getBounds:function(t,e){var i=this._children;return i&&0!==i.length?(w._updateBoundsCache(this,e.cacheItem),w._getBounds(i,t,e)):new g},_getCachedBounds:function(t,e){t=t&&t._orNullIfIdentity();var i=e.internal,n=e.cacheItem,r=i?null:this._matrix._orNullIfIdentity(),s=n&&(!t||t.equals(r))&&[e.stroke?1:0,e.handle?1:0,i?1:0].join("");if(w._updateBoundsCache(this._parent||this._symbol,n),s&&this._bounds&&s in this._bounds)return this._bounds[s].rect.clone();var a=this._getBounds(t||r,e);if(s){this._bounds||(this._bounds={});this._bounds[s]={rect:a.clone(),internal:e.internal}}return a},_getStrokeMatrix:function(t,e){var i=this.getStrokeScaling()?null:e&&e.internal?this:this._parent||this._symbol&&this._symbol._item,n=i?i.getViewMatrix().invert():t;return n&&n._shiftless()},statics:{_updateBoundsCache:function(t,e){if(t&&e){var i=e._id,n=t._boundsCache=t._boundsCache||{ids:{},list:[]};n.ids[i]||(n.list.push(e),n.ids[i]=e)}},_clearBoundsCache:function(t){var i=t._boundsCache;if(i){t._bounds=t._position=t._boundsCache=e;for(var n=0,r=i.list,s=r.length;n<s;n++){var a=r[n];a!==t&&(a._bounds=a._position=e,a._boundsCache&&w._clearBoundsCache(a))}}},_getBounds:function(t,e,i){var n=1/0,r=-n,s=n,a=r;i=i||{};for(var o=0,h=t.length;o<h;o++){var u=t[o];if(u._visible&&!u.isEmpty()){var l=u._getCachedBounds(e&&e.appended(u._matrix),i);n=Math.min(l.x,n),s=Math.min(l.y,s),r=Math.max(l.x+l.width,r),a=Math.max(l.y+l.height,a)}}return isFinite(n)?new g(n,s,r-n,a-s):new g}}}),{beans:!0,_decompose:function(){return this._decomposed||(this._decomposed=this._matrix.decompose())},getRotation:function(){var t=this._decompose();return t&&t.rotation},setRotation:function(t){var e=this.getRotation();null!=e&&null!=t&&this.rotate(t-e)},getScaling:function(t){var e=this._decompose(),i=e&&e.scaling,n=t?c:d;return i&&new n(i.x,i.y,this,"setScaling")},setScaling:function(){var t=this.getScaling(),e=c.read(arguments,0,{clone:!0,readNull:!0});t&&e&&this.scale(e.x/t.x,e.y/t.y)},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},getGlobalMatrix:function(t){var e=this._globalMatrix,i=this._project._updateVersion;if(e&&e._updateVersion!==i&&(e=null),!e){e=this._globalMatrix=this._matrix.clone();var n=this._parent;n&&e.prepend(n.getGlobalMatrix(!0)),e._updateVersion=i}return t?e:e.clone()},getViewMatrix:function(){return this.getGlobalMatrix().prepend(this.getView()._matrix)},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var i=this._children,n=0,r=i&&i.length;n<r;n++)i[n]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project._view},_installEvents:function ut(t){ut.base.call(this,t);for(var e=this._children,i=0,n=e&&e.length;i<n;i++)e[i]._installEvents(t)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof b)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},_getOwner:"#getParent",getChildren:function(){return this._children},setChildren:function(t,e){this.removeChildren(),this.addChildren(t,e)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){var t=this._getOwner();return t&&t._children[this._index+1]||null},getPreviousSibling:function(){var t=this._getOwner();return t&&t._children[this._index-1]||null},getIndex:function(){return this._index},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return r.equals(this._children,t._children)},clone:function(t){var i=new this.constructor(w.NO_INSERT),n=this._children,s=r.pick(t?t.insert:e,t===e||t===!0),a=r.pick(t?t.deep:e,!0);n&&i.copyAttributes(this),n&&!a||i.copyContent(this),n||i.copyAttributes(this),s&&i.insertAbove(this);var o=this._name,h=this._parent;if(o&&h){for(var n=h._children,u=o,l=1;n[o];)o=u+" "+l++;o!==u&&i.setName(o)}return i},copyContent:function(t){for(var e=t._children,i=0,n=e&&e.length;i<n;i++)this.addChild(e[i].clone(!1),!0)},copyAttributes:function(t,e){this.setStyle(t._style);for(var i=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide"],n=0,s=i.length;n<s;n++){var a=i[n];t.hasOwnProperty(a)&&(this[a]=t[a])}e||this._matrix.initialize(t._matrix),this.setApplyMatrix(t._applyMatrix),this.setPivot(t._pivot),this.setSelection(t._selection);var o=t._data,h=t._name;this._data=o?r.clone(o):null,h&&this.setName(h)},rasterize:function(t,i){var n=this.getStrokeBounds(),s=(t||this.getView().getResolution())/72,a=n.getTopLeft().floor(),o=n.getBottomRight().ceil(),h=new f(o.subtract(a)),u=new S(w.NO_INSERT);if(!h.isZero()){var l=Q.getCanvas(h.multiply(s)),c=l.getContext("2d"),d=(new p).scale(s).translate(a.negate());c.save(),d.applyToContext(c),this.draw(c,new r({matrices:[d]})),c.restore(),u.setCanvas(l)}return u.transform((new p).translate(a.add(h.divide(2))).scale(1/s)),(i===e||i)&&u.insertAbove(this),u},contains:function(){return!!this._contains(this._matrix._inverseTransform(c.read(arguments)))},_contains:function(t){var e=this._children;if(e){for(var i=e.length-1;i>=0;i--)if(e[i].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return g.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new L.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof w&&this._asPathItem().getIntersections(t._asPathItem(),null,e,!0).length>0}},new function(){function t(){return this._hitTest(c.read(arguments),M.getOptions(arguments))}function e(){var t=c.read(arguments),e=M.getOptions(arguments),i=e.match,n=[];return e=r.set({},e,{match:function(t){i&&!i(t)||n.push(t)}}),this._hitTest(t,e),n}function i(t,e,i,n){var r=this._children;if(r)for(var s=r.length-1;s>=0;s--){var a=r[s],o=a!==n&&a._hitTest(t,e,i);if(o)return o}return null}return y.inject({hitTest:t,hitTestAll:e,_hitTest:i}),{hitTest:t,hitTestAll:e,_hitTestChildren:i}},{_hitTest:function(t,e,i){function n(t){return!g||t&&g(t)?t:null}function s(e,i){var n=c["get"+i]();if(t.subtract(n).divide(l).length<=1)return new M(e,v,{name:r.hyphenate(i),point:n})}if(this._locked||!this._visible||this._guide&&!e.guides||this.isEmpty())return null;var a=this._matrix,o=i?i.appended(a):this.getGlobalMatrix().prepend(this.getView()._matrix),h=this.getStrokeScaling()?null:o.inverted()._shiftless(),u=Math.max(e.tolerance,1e-6),l=e._tolerancePadding=new f(L._getStrokePadding(u,h));if(t=a._inverseTransform(t),!t||!this._children&&!this.getBounds({internal:!0,stroke:!0,handle:!0}).expand(l.multiply(2))._containsPoint(t))return null;var c,d,_=!(e.guides&&!this._guide||e.selected&&!this.isSelected()||e.type&&e.type!==r.hyphenate(this._class)||e["class"]&&!(this instanceof e["class"])),g=e.match,v=this;if(_&&(e.center||e.bounds)&&this._parent){if(c=this.getInternalBounds(),e.center&&(d=s("center","Center")),!d&&e.bounds)for(var p=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],m=0;m<8&&!d;m++)d=s("bounds",p[m]);d=n(d)}return d||(d=this._hitTestChildren(t,e,o)||_&&n(this._hitTestSelf(t,e,o,h))||null),d&&d.point&&(d.point=a.transform(d.point)),d},_hitTestSelf:function(t,e){if(e.fill&&this.hasFill()&&this._contains(t))return new M("fill",this)},matches:function(t,e){function i(t,e){for(var n in t)if(t.hasOwnProperty(n)){var s=t[n],a=e[n];if(r.isPlainObject(s)&&r.isPlainObject(a)){if(!i(s,a))return!1}else if(!r.equals(s,a))return!1}return!0}var n=typeof t;if("object"===n){for(var s in t)if(t.hasOwnProperty(s)&&!this.matches(s,t[s]))return!1;return!0}if("function"===n)return t(this);if("match"===t)return e(this);var a=/^(empty|editable)$/.test(t)?this["is"+r.capitalize(t)]():"type"===t?r.hyphenate(this._class):this[t];if("class"===t){if("function"==typeof e)return this instanceof e;a=this._class}if("function"==typeof e)return!!e(a);if(e){if(e.test)return e.test(a);if(r.isPlainObject(e))return i(e,a)}return r.equals(a,e)},getItems:function(t){return w._getItems(this,t,this._matrix)},getItem:function(t){return w._getItems(this,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function lt(t,e,i,n,s){if(!n){var a="object"==typeof e&&e,o=a&&a.overlapping,h=a&&a.inside,u=o||h,l=u&&g.read([u]);n={items:[],recursive:a&&a.recursive!==!1,inside:!!h,overlapping:!!o,rect:l,path:o&&new L.Rectangle({rectangle:l,insert:!1})},a&&(e=r.filter({},e,{recursive:!0,inside:!0,overlapping:!0}))}var c=t._children,d=n.items,l=n.rect;i=l&&(i||new p);for(var f=0,_=c&&c.length;f<_;f++){var v=c[f],m=i&&i.appended(v._matrix),y=!0;if(l){var u=v.getBounds(m);if(!l.intersects(u))continue;l.contains(u)||n.overlapping&&(u.contains(l)||n.path.intersects(v,m))||(y=!1)}if(y&&v.matches(e)&&(d.push(v),s))break;if(n.recursive!==!1&&lt(v,e,m,n,s),s&&d.length>0)break}return d}}},{importJSON:function(t){var e=r.importJSON(t,this);return e!==this?this.addChild(e):e},addChild:function(t,i){return this.insertChild(e,t,i)},insertChild:function(t,e,i){var n=e?this.insertChildren(t,[e],i):null;return n&&n[0]},addChildren:function(t,e){return this.insertChildren(this._children.length,t,e)},insertChildren:function(t,e,i,n){var s=this._children;if(s&&e&&e.length>0){e=Array.prototype.slice.apply(e);for(var a=e.length-1;a>=0;a--){var o=e[a];o&&(!n||o instanceof n)?o._remove(!1,!0):e.splice(a,1)}r.splice(s,e,t,0);for(var h=this._project,u=h._changes,a=0,l=e.length;a<l;a++){var o=e[a],c=o._name;o._parent=this,o._setProject(h,!0),c&&o.setName(c),u&&this._changed(5)}this._changed(11)}else e=null;return e},_insertItem:"#insertChild",_insertAt:function(t,e,i){var n=this;if(n!==t){var r=t&&t._getOwner();r?(n._remove(!1,!0),r._insertItem(t._index+e,n,i)):n=null}return n},insertAbove:function(t,e){return this._insertAt(t,1,e)},insertBelow:function(t,e){return this._insertAt(t,0,e)},sendToBack:function(){var t=this._getOwner();return t?t._insertItem(0,this):null},bringToFront:function(){var t=this._getOwner();return t?t._insertItem(e,this):null},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",copyTo:function(t){return t._insertItem(e,this.clone(!1))},reduce:function(t){var e=this._children;if(e&&1===e.length){var i=e[0].reduce(t);return this._parent?(i.insertAbove(this),this.remove()):i.remove(),i}return this},_removeNamed:function(){var t=this._getOwner();if(t){var e=t._children,i=t._namedChildren,n=this._name,r=i[n],s=r?r.indexOf(this):-1;s!==-1&&(e[n]==this&&delete e[n],r.splice(s,1),r.length?e[n]=r[0]:delete i[n])}},_remove:function(t,e){var i=this._getOwner(),n=this._project,s=this._index;return!!i&&(null!=s&&(n._activeLayer===this&&(n._activeLayer=this.getNextSibling()||this.getPreviousSibling()),r.splice(i._children,null,s,1)),this._name&&this._removeNamed(),this._installEvents(!1),t&&n._changes&&this._changed(5),e&&i._changed(11,this),this._parent=null,!0)},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){var e=t&&t.insertBelow(this);return e&&this.remove(),e},removeChildren:function(t,e){if(!this._children)return null;t=t||0,e=r.pick(e,this._children.length);for(var i=r.splice(this._children,null,t,e-t),n=i.length-1;n>=0;n--)i[n]._remove(!0,!1);return i.length>0&&this._changed(11),i},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;t<e;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(){return!this._children||0===this._children.length},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){var e=[];do e.unshift(t);while(t=t._parent);return e}for(var i=e(this),n=e(t),r=0,s=Math.min(i.length,n.length);r<s;r++)if(i[r]!=n[r])return i[r]._index<n[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&this._children.length>0},isInserted:function(){return!!this._parent&&this._parent.isInserted()},isAbove:function(t){return this._getOrder(t)===-1},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e===t)return!0;return!1},isAncestor:function(t){return!!t&&t.isDescendant(this)},isSibling:function(t){return this._parent===t._parent},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var i=(e?r:c).read(arguments),n=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](i,n||this.getPosition(!0)))}},{translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},transform:function(t,e,i,n){t&&t.isIdentity()&&(t=null);var r=this._matrix,s=(e||this._applyMatrix)&&(!r.isIdentity()||t||e&&i&&this._children);if(!t&&!s)return this;if(t&&(!t.isInvertible()&&r.isInvertible()&&(r._backup=r.getValues()),r.prepend(t)),s=s&&this._transformContent(r,i,n)){var a=this._pivot,o=this._style,h=o.getFillColor(!0),u=o.getStrokeColor(!0);a&&r._transformPoint(a,a,!0),h&&h.transform(r),u&&u.transform(r),r.reset(!0),n&&this._canApplyMatrix&&(this._applyMatrix=!0)}var l=this._bounds,c=this._position;this._changed(9);var d=l&&t&&t.decompose();if(d&&!d.shearing&&d.rotation%90===0){for(var f in l){var _=l[f];if(s||!_.internal){var g=_.rect;t._transformBounds(g,g)}}var v=this._boundsGetter,g=l[v&&v.getBounds||v||"getBounds"];g&&(this._position=g.getCenter(!0)),this._bounds=l}else t&&c&&(this._position=t._transformPoint(c,c));return this},_transformContent:function(t,e,i){var n=this._children;if(n){for(var r=0,s=n.length;r<s;r++)n[r].transform(t,!0,e,i);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(c.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(c.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(c.read(arguments))},localToParent:function(){return this._matrix._transformPoint(c.read(arguments))},fitBounds:function(t,e){t=g.read(arguments);var i=this.getBounds(),n=i.height/i.width,r=t.height/t.width,s=(e?n>r:n<r)?t.width/i.width:t.height/i.height,a=new g(new c,new f(i.width*s,i.height*s));a.setCenter(t.getCenter()),this.setBounds(a)}}),{_setStyles:function(t,e,i){var n=this._style;if(n.hasFill()&&(t.fillStyle=n.getFillColor().toCanvasStyle(t)),n.hasStroke()){t.strokeStyle=n.getStrokeColor().toCanvasStyle(t),t.lineWidth=n.getStrokeWidth();var r=n.getStrokeJoin(),s=n.getStrokeCap(),a=n.getMiterLimit();if(r&&(t.lineJoin=r),s&&(t.lineCap=s),a&&(t.miterLimit=a),paper.support.nativeDash){var o=n.getDashArray(),h=n.getDashOffset();o&&o.length&&("setLineDash"in t?(t.setLineDash(o),t.lineDashOffset=h):(t.mozDash=o,t.mozDashOffset=h))}}if(n.hasShadow()){var u=e.pixelRatio||1,l=i._shiftless().prepend((new p).scale(u,u)),d=l.transform(new c(n.getShadowBlur(),0)),f=l.transform(this.getShadowOffset());t.shadowColor=n.getShadowColor().toCanvasStyle(t),t.shadowBlur=d.getLength(),t.shadowOffsetX=f.x,t.shadowOffsetY=f.y}},draw:function(t,e,i){var n=this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var r=e.matrices,s=e.viewMatrix,a=this._matrix,o=r[r.length-1].appended(a);if(o.isInvertible()){s=s?s.appended(o):o,r.push(o),e.updateMatrix&&(o._updateVersion=n,this._globalMatrix=o);var h,u,l,c=this._blendMode,d=this._opacity,f="normal"===c,_=tt.nativeModes[c],g=f&&1===d||e.dontStart||e.clip||(_||f&&d<1)&&this._canComposite(),v=e.pixelRatio||1;if(!g){var p=this.getStrokeBounds(s);if(!p.width||!p.height)return;l=e.offset,u=e.offset=p.getTopLeft().floor(),h=t,t=Q.getContext(p.getSize().ceil().add(1).multiply(v)),1!==v&&t.scale(v,v)}t.save();var m=i?i.appended(a):this._canScaleStroke&&!this.getStrokeScaling(!0)&&s,y=!g&&e.clipItem,w=!m||y;if(g?(t.globalAlpha=d,_&&(t.globalCompositeOperation=c)):w&&t.translate(-u.x,-u.y),w&&(g?a:s).applyToContext(t),y&&e.clipItem.draw(t,e.extend({clip:!0})),m){t.setTransform(v,0,0,v,0,0);var x=e.offset;x&&t.translate(-x.x,-x.y)}this._draw(t,e,s,m),t.restore(),r.pop(),e.clip&&!e.dontFinish&&t.clip(),g||(tt.process(c,t,h,d,u.subtract(l).multiply(v)),Q.release(t),e.offset=l)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof N)return e._isUpdated(t);var i=this._updateVersion===t;return!i&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,i=!0),i},_drawSelection:function(t,e,i,n,r){var s=this._selection,a=1&s,o=2&s||a&&this._selectBounds,h=4&s;if(this._drawSelected||(a=!1),
(a||o||h)&&this._isUpdated(r)){var u,l=this.getSelectedColor(!0)||(u=this.getLayer())&&u.getSelectedColor(!0),c=e.appended(this.getGlobalMatrix(!0)),d=i/2;if(t.strokeStyle=t.fillStyle=l?l.toCanvasStyle(t):"#009dec",a&&this._drawSelected(t,c,n),h){var f=this.getPosition(!0),_=f.x,g=f.y;t.beginPath(),t.arc(_,g,d,0,2*Math.PI,!0),t.stroke();for(var v=[[0,-1],[1,0],[0,1],[-1,0]],p=d,m=i+1,y=0;y<4;y++){var w=v[y],x=w[0],b=w[1];t.moveTo(_+x*p,g+b*p),t.lineTo(_+x*m,g+b*m),t.stroke()}}if(o){var C=c._transformCorners(this.getInternalBounds());t.beginPath();for(var y=0;y<8;y++)t[0===y?"moveTo":"lineTo"](C[y],C[++y]);t.closePath(),t.stroke();for(var y=0;y<8;y++)t.fillRect(C[y]-d,C[++y]-d,i,i)}}},_canComposite:function(){return!1}},r.each(["down","drag","up","move"],function(t){this["removeOn"+r.capitalize(t)]=function(){var e={};return e[t]=!0,this.removeOn(e)}},{removeOn:function(t){for(var e in t)if(t[e]){var i="mouse"+e,n=this._project,r=n._removeSets=n._removeSets||{};r[i]=r[i]||{},r[i][this._id]=this}return this}})),x=w.extend({_class:"Group",_selectBounds:!1,_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function ct(t){ct.base.call(this,t),1026&t&&(this._clipItem=e)},_getClipItem:function(){var t=this._clipItem;if(t===e){t=null;for(var i=this._children,n=0,r=i.length;n<r;n++)if(i[n]._clipMask){t=i[n];break}this._clipItem=t}return t},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_getBounds:function dt(t,e){var i=this._getClipItem();return i?i._getCachedBounds(t&&t.appended(i._matrix),r.set({},e,{stroke:!1})):dt.base.call(this,t,e)},_hitTestChildren:function ft(t,e,i){var n=this._getClipItem();return(!n||n.contains(t))&&ft.base.call(this,t,e,i,n)},_draw:function(t,e){var i=e.clip,n=!i&&this._getClipItem();e=e.extend({clipItem:n,clip:!1}),i?(t.beginPath(),e.dontStart=e.dontFinish=!0):n&&n.draw(t,e.extend({clip:!0}));for(var r=this._children,s=0,a=r.length;s<a;s++){var o=r[s];o!==n&&o.draw(t,e)}}}),b=x.extend({_class:"Layer",initialize:function(){x.apply(this,arguments)},_getOwner:function(){return this._parent||null!=this._index&&this._project},isInserted:function _t(){return this._parent?_t.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_hitTestSelf:function(){}}),C=w.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_canScaleStroke:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t){this._initialize(t)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&r.equals(this._radius,t._radius)},copyContent:function(t){this.setType(t._type),this.setSize(t._size),this.setRadius(t._radius)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new _(t.width,t.height,this,"setSize")},setSize:function(){var t=f.read(arguments);if(this._size){if(!this._size.equals(t)){var e=this._type,i=t.width,n=t.height;if("rectangle"===e){var r=f.min(this._radius,t.divide(2));this._radius.set(r.width,r.height)}else"circle"===e?(i=n=(i+n)/2,this._radius=i/2):"ellipse"===e&&this._radius.set(i/2,n/2);this._size.set(i,n),this._changed(9)}}else this._size=t.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new _(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var i=2*t;this._radius=t,this._size.set(i,i)}else if(t=f.read(arguments),this._radius){if(this._radius.equals(t))return;if(this._radius.set(t.width,t.height),"rectangle"===e){var i=f.max(this._size,t.multiply(2));this._size.set(i.width,i.height)}else"ellipse"===e&&this._size.set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(t){var i=new(L[r.capitalize(this._type)])({center:new c,size:this._size,radius:this._radius,insert:!1});return i.copyAttributes(this),paper.settings.applyMatrix&&i.setApplyMatrix(!0),(t===e||t)&&i.insertAbove(this),i},toShape:"#clone",_draw:function(t,e,i,n){var r=this._style,s=r.hasFill(),a=r.hasStroke(),o=e.dontFinish||e.clip,h=!n;if(s||a||o){var u=this._type,l=this._radius,c="circle"===u;if(e.dontStart||t.beginPath(),h&&c)t.arc(0,0,l,0,2*Math.PI,!0);else{var d=c?l:l.width,f=c?l:l.height,_=this._size,g=_.width,v=_.height;if(h&&"rectangle"===u&&0===d&&0===f)t.rect(-g/2,-v/2,g,v);else{var p=g/2,m=v/2,y=.44771525016920644,w=d*y,x=f*y,b=[-p,-m+f,-p,-m+x,-p+w,-m,-p+d,-m,p-d,-m,p-w,-m,p,-m+x,p,-m+f,p,m-f,p,m-x,p-w,m,p-d,m,-p+d,m,-p+w,m,-p,m-x,-p,m-f];n&&n.transform(b,b,32),t.moveTo(b[0],b[1]),t.bezierCurveTo(b[2],b[3],b[4],b[5],b[6],b[7]),p!==d&&t.lineTo(b[8],b[9]),t.bezierCurveTo(b[10],b[11],b[12],b[13],b[14],b[15]),m!==f&&t.lineTo(b[16],b[17]),t.bezierCurveTo(b[18],b[19],b[20],b[21],b[22],b[23]),p!==d&&t.lineTo(b[24],b[25]),t.bezierCurveTo(b[26],b[27],b[28],b[29],b[30],b[31])}}t.closePath()}o||!s&&!a||(this._setStyles(t,e,i),s&&(t.fill(r.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),a&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var i=new g(this._size).setCenter(0,0),n=this._style,r=e.stroke&&n.hasStroke()&&n.getStrokeWidth();return t&&(i=t._transformBounds(i)),r?i.expand(L._getStrokePadding(r,this._getStrokeMatrix(t,e))):i}},new function(){function t(t,e,i){var n=t._radius;if(!n.isZero())for(var r=t._size.divide(2),s=0;s<4;s++){var a=new c(1&s?1:-1,s>1?1:-1),o=a.multiply(r),h=o.subtract(a.multiply(n)),u=new g(o,h);if((i?u.expand(i):u).contains(e))return h}}function e(t,e,i,n){var r=t.divide(e);return(!n||r.quadrant===n)&&r.subtract(r.normalize()).multiply(e).divide(i).length<=1}return{_contains:function i(e){if("rectangle"===this._type){var n=t(this,e);return n?e.subtract(n).divide(this._radius).getLength()<=1:i.base.call(this,e)}return e.divide(this.size).getLength()<=.5},_hitTestSelf:function n(i,r,s,a){var o=!1,h=this._style,u=r.stroke&&h.hasStroke(),l=r.fill&&h.hasFill();if(u||l){var c=this._type,d=this._radius,f=u?h.getStrokeWidth()/2:0,_=r._tolerancePadding.add(L._getStrokePadding(f,!h.getStrokeScaling()&&a));if("rectangle"===c){var v=_.multiply(2),p=t(this,i,v);if(p)o=e(i.subtract(p),d,_,p.getQuadrant());else{var m=new g(this._size).setCenter(0,0),y=m.expand(v),w=m.expand(v.negate());o=y._containsPoint(i)&&!w._containsPoint(i)}}else o=e(i,d,_)}return o?new M(u?"stroke":"fill",this):n.base.apply(this,arguments)}}},{statics:new function(){function t(t,e,i,n,s){var a=new C(r.getNamed(s));return a._type=t,a._size=i,a._radius=n,a.translate(e)}return{Circle:function(){var e=c.readNamed(arguments,"center"),i=r.readNamed(arguments,"radius");return t("circle",e,new f(2*i),i,arguments)},Rectangle:function(){var e=g.readNamed(arguments,"rectangle"),i=f.min(f.readNamed(arguments,"radius"),e.getSize(!0).divide(2));return t("rectangle",e.getCenter(!0),e.getSize(!0),i,arguments)},Ellipse:function(){var e=C._readEllipse(arguments),i=e.radius;return t("ellipse",e.center,i.multiply(2),i,arguments)},_readEllipse:function(t){var e,i;if(r.hasNamed(t,"radius"))e=c.readNamed(t,"center"),i=f.readNamed(t,"radius");else{var n=g.readNamed(t,"rectangle");e=n.getCenter(!0),i=n.getSize(!0).divide(2)}return{center:e,radius:i}}}}}),S=w.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!1,handle:!1},_serializeFields:{crossOrigin:null,source:null},initialize:function(t,i){if(!this._initialize(t,i!==e&&c.read(arguments,1))){var r="string"==typeof t?n.getElementById(t):t;r?this.setImage(r):this.setSource(t)}this._size||(this._size=new f,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},copyContent:function(t){var e=t._image,i=t._canvas;if(e)this._setImage(e);else if(i){var n=Q.getCanvas(t._size);n.getContext("2d").drawImage(i,0,0),this._setImage(n)}this._crossOrigin=t._crossOrigin},getSize:function(){var t=this._size;return new _(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(){var t=f.read(arguments);if(!t.equals(this._size))if(t.width>0&&t.height>0){var e=this.getElement();this._setImage(Q.getCanvas(t)),e&&this.getContext(!0).drawImage(e,0,0,t.width,t.height)}else this._canvas&&Q.release(this._canvas),this._size=t.clone()},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},getLoaded:function(){return this._loaded},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new c(0,0).transform(t),i=new c(1,0).transform(t).subtract(e),n=new c(0,1).transform(t).subtract(e);return new f(72/i.getLength(),72/n.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(t){function e(t){var e=i.getView(),n=t&&t.type||"load";e&&i.responds(n)&&(paper=e._scope,i.emit(n,new G(t)))}var i=this;this._setImage(t),this._loaded?setTimeout(e,0):t&&Z.add(t,{load:function(n){i._setImage(t),e(n)},error:e})},_setImage:function(t){this._canvas&&Q.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=!!(t&&t.src&&t.complete)),this._size=new f(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(521)},getCanvas:function(){if(!this._canvas){var t=Q.getContext(this._size);try{this._image&&t.drawImage(this._image,0,0),this._canvas=t.canvas}catch(e){Q.release(t)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(513)),this._context},setContext:function(t){this._context=t},getSource:function(){var t=this._image;return t&&t.src||this.toDataURL()},setSource:function(t){var e=new i.Image,n=this._crossOrigin;n&&(e.crossOrigin=n),e.src=t,this.setImage(e)},getCrossOrigin:function(){var t=this._image;return t&&t.crossOrigin||this._crossOrigin||""},setCrossOrigin:function(t){this._crossOrigin=t;var e=this._image;e&&(e.crossOrigin=t)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=g.read(arguments),e=Q.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=g.read(arguments),e=new S(w.NO_INSERT);return e._setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.prepend(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image,e=t&&t.src;if(/^data:/.test(e))return e;var i=this.getCanvas();return i?i.toDataURL.apply(i,arguments):null},drawImage:function(t){var e=c.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){var e,i;if(t?t instanceof A?(i=t,e=t.getBounds()):"object"==typeof t&&("width"in t?e=new g(t):"x"in t&&(e=new g(t.x-.5,t.y-.5,1,1))):e=this.getBounds(),!e)return null;var n=32,s=Math.min(e.width,n),a=Math.min(e.height,n),o=S._sampleContext;o?o.clearRect(0,0,n+1,n+1):o=S._sampleContext=Q.getContext(new f(n)),o.save();var h=(new p).scale(s/e.width,a/e.height).translate(-e.x,-e.y);h.applyToContext(o),i&&i.draw(o,new r({clip:!0,matrices:[h]})),this._matrix.applyToContext(o);var u=this.getElement(),l=this._size;u&&o.drawImage(u,-l.width/2,-l.height/2),o.restore();for(var c=o.getImageData(.5,.5,Math.ceil(s),Math.ceil(a)).data,d=[0,0,0],_=0,v=0,m=c.length;v<m;v+=4){var y=c[v+3];_+=y,y/=255,d[0]+=c[v]*y,d[1]+=c[v+1]*y,d[2]+=c[v+2]*y}for(var v=0;v<3;v++)d[v]/=_;return _?F.read(d):null},getPixel:function(){var t=c.read(arguments),e=this.getContext().getImageData(t.x,t.y,1,1).data;return new F("rgb",[e[0]/255,e[1]/255,e[2]/255],e[3]/255)},setPixel:function(){var t=c.read(arguments),e=F.read(arguments),i=e._convert("rgb"),n=e._alpha,r=this.getContext(!0),s=r.createImageData(1,1),a=s.data;a[0]=255*i[0],a[1]=255*i[1],a[2]=255*i[2],a[3]=null!=n?255*n:255,r.putImageData(s,t.x,t.y)},createImageData:function(){var t=f.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=g.read(arguments);return t.isEmpty()&&(t=new g(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},setImageData:function(t){var e=c.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},_getBounds:function(t,e){var i=new g(this._size).setCenter(0,0);return t?t._transformBounds(i):i},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new M("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t){var e=this.getElement();e&&(t.globalAlpha=this._opacity,t.drawImage(e,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),P=w.extend({_class:"SymbolItem",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!0},_serializeFields:{symbol:null},initialize:function(t,i){this._initialize(t,i!==e&&c.read(arguments,1))||this.setDefinition(t instanceof I?t:new I(t))},_equals:function(t){return this._definition===t._definition},copyContent:function(t){this.setDefinition(t._definition)},getDefinition:function(){return this._definition},setDefinition:function(t){this._definition=t,this._changed(9)},getSymbol:"#getDefinition",setSymbol:"#setDefinition",isEmpty:function(){return this._definition._item.isEmpty()},_getBounds:function(t,e){var i=this._definition._item;return i._getCachedBounds(i._matrix.prepended(t),e)},_hitTestSelf:function(t,e,i,n){var r=this._definition._item._hitTest(t,e,i);return r&&(r.item=this),r},_draw:function(t,e){this._definition._item.draw(t,e)}}),I=r.extend({_class:"SymbolDefinition",initialize:function(t,e){this._id=l.get(),this.project=paper.project,t&&this.setItem(t,e)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._class,this._item],t,!1,e)})},_changed:function(t){8&t&&w._clearBoundsCache(this),1&t&&this.project._changed(t)},getItem:function(){return this._item},setItem:function(t,e){t._symbol&&(t=t.clone()),this._item&&(this._item._symbol=null),this._item=t,t.remove(),t.setSelected(!1),e||t.setPosition(new c),t._symbol=this,this._changed(9)},getDefinition:"#getItem",setDefinition:"#setItem",place:function(t){return new P(this,t)},clone:function(){return new I(this._item.clone(!1))},equals:function(t){return t===this||t&&this._item.equals(t._item)||!1}}),M=r.extend({_class:"HitResult",initialize:function(t,e,i){this.type=t,this.item=e,i&&(i.enumerable=!0,this.inject(i))},statics:{getOptions:function(t){var e=t&&r.read(t);return r.set({type:null,tolerance:paper.settings.hitTolerance,fill:!e,stroke:!e,segments:!e,handles:!1,ends:!1,center:!1,bounds:!1,guides:!1,selected:!1},e)}}}),T=r.extend({_class:"Segment",beans:!0,_selection:0,initialize:function(t,i,n,r,s,a){var o,h,u,l,c=arguments.length;0===c||(1===c?t&&"point"in t?(o=t.point,h=t.handleIn,u=t.handleOut,l=t.selection):o=t:null==t||"object"==typeof t?(o=t,h=i,u=n,l=r):(o=t!==e?[t,i]:null,h=n!==e?[n,r]:null,u=s!==e?[s,a]:null)),new k(o,this,"_point"),new k(h,this,"_handleIn"),new k(u,this,"_handleOut"),l&&this.setSelection(l)},_serialize:function(t,e){var i=this._point,n=this._selection,s=n||this.hasHandles()?[i,this._handleIn,this._handleOut]:i;return n&&s.push(n),r.serialize(s,t,!0,e)},_changed:function(t){var e=this._path;if(e){var i,n=e._curves,r=this._index;n&&(t&&t!==this._point&&t!==this._handleIn||!(i=r>0?n[r-1]:e._closed?n[n.length-1]:null)||i._changed(),t&&t!==this._point&&t!==this._handleOut||!(i=n[r])||i._changed()),e._changed(25)}},getPoint:function(){return this._point},setPoint:function(){var t=c.read(arguments);this._point.set(t.x,t.y)},getHandleIn:function(){return this._handleIn},setHandleIn:function(){var t=c.read(arguments);this._handleIn.set(t.x,t.y)},getHandleOut:function(){return this._handleOut},setHandleOut:function(){var t=c.read(arguments);this._handleOut.set(t.x,t.y)},hasHandles:function(){return!this._handleIn.isZero()||!this._handleOut.isZero()},clearHandles:function(){this._handleIn.set(0,0),this._handleOut.set(0,0)},getSelection:function(){return this._selection},setSelection:function(t){var e=this._selection,i=this._path;this._selection=t=t||0,i&&t!==e&&(i._updateSelection(this,e,t),i._changed(129))},changeSelection:function(t,e){var i=this._selection;this.setSelection(e?i|t:i&~t)},isSelected:function(){return!!(7&this._selection)},setSelected:function(t){this.changeSelection(7,t)},getIndex:function(){return this._index!==e?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(e>0&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new O(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},smooth:function(t,i,n){var r=t||{},s=r.type,a=r.factor,o=this.getPrevious(),h=this.getNext(),u=(o||this)._point,l=this._point,d=(h||this)._point,f=u.getDistance(l),_=l.getDistance(d);if(s&&"catmull-rom"!==s){if("geometric"!==s)throw new Error("Smoothing method '"+s+"' not supported.");if(o&&h){var g=u.subtract(d),v=a===e?.4:a,p=v*f/(f+_);i||this.setHandleIn(g.multiply(p)),n||this.setHandleOut(g.multiply(p-v))}}else{var m=a===e?.5:a,y=Math.pow(f,m),w=y*y,x=Math.pow(_,m),b=x*x;if(!i&&o){var C=2*b+3*x*y+w,S=3*x*(x+y);this.setHandleIn(0!==S?new c((b*u._x+C*l._x-w*d._x)/S-l._x,(b*u._y+C*l._y-w*d._y)/S-l._y):new c)}if(!n&&h){var C=2*w+3*y*x+b,S=3*y*(y+x);this.setHandleOut(0!==S?new c((w*d._x+C*l._x-b*u._x)/S-l._x,(w*d._y+C*l._y-b*u._y)/S-l._y):new c)}}},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._index},isLast:function(){var t=this._path;return t&&this._index===t._segments.length-1||!1},reverse:function(){var t=this._handleIn,e=this._handleOut,i=t._x,n=t._y;t.set(e._x,e._y),e.set(i,n)},reversed:function(){return new T(this._point,this._handleOut,this._handleIn)},remove:function(){return!!this._path&&!!this._path.removeSegment(this._index)},clone:function(){return new T(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,new Array(6),!0),this._changed()},interpolate:function(t,e,i){var n=1-i,r=i,s=t._point,a=e._point,o=t._handleIn,h=e._handleIn,u=e._handleOut,l=t._handleOut;this._point.set(n*s._x+r*a._x,n*s._y+r*a._y,!0),this._handleIn.set(n*o._x+r*h._x,n*o._y+r*h._y,!0),this._handleOut.set(n*l._x+r*u._x,n*l._y+r*u._y,!0),this._changed()},_transformCoordinates:function(t,e,i){var n=this._point,r=i&&this._handleIn.isZero()?null:this._handleIn,s=i&&this._handleOut.isZero()?null:this._handleOut,a=n._x,o=n._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],i?(n._x=a,n._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),k=c.extend({initialize:function(t,i,n){var r,s,a;if(t)if((r=t[0])!==e)s=t[1];else{var o=t;(r=o.x)===e&&(o=c.read(arguments),r=o.x),s=o.y,a=o.selected}else r=s=0;this._x=r,this._y=s,this._owner=i,i[n]=this,a&&this.setSelected(!0)},set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){return u.isZero(this._x)&&u.isZero(this._y)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner.changeSelection(this._getSelection(),t)},_getSelection:function(){var t=this._owner;return this===t._point?1:this===t._handleIn?2:this===t._handleOut?4:0}}),z=r.extend({_class:"Curve",initialize:function(t,e,i,n,r,s,a,o){var h,u,l,c,d,f,_=arguments.length;3===_?(this._path=t,h=e,u=i):0===_?(h=new T,u=new T):1===_?"segment1"in t?(h=new T(t.segment1),u=new T(t.segment2)):"point1"in t?(l=t.point1,d=t.handle1,f=t.handle2,c=t.point2):Array.isArray(t)&&(l=[t[0],t[1]],c=[t[6],t[7]],d=[t[2]-t[0],t[3]-t[1]],f=[t[4]-t[6],t[5]-t[7]]):2===_?(h=new T(t),u=new T(e)):4===_?(l=t,d=e,f=i,c=n):8===_&&(l=[t,e],c=[a,o],d=[i-t,n-e],f=[r-a,s-o]),this._segment1=h||new T(l,null,d),this._segment2=u||new T(c,f,null)},_serialize:function(t,e){return r.serialize(this.hasHandles()?[this.getPoint1(),this.getHandle1(),this.getHandle2(),this.getPoint2()]:[this.getPoint1(),this.getPoint2()],t,!0,e)},_changed:function(){this._length=this._bounds=e},clone:function(){return new z(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},remove:function(){var t=!1;if(this._path){var e=this._segment2,i=e._handleOut;t=e.remove(),t&&this._segment1._handleOut.set(i.x,i.y)}return t},getPoint1:function(){return this._segment1._point},setPoint1:function(){var t=c.read(arguments);this._segment1._point.set(t.x,t.y)},getPoint2:function(){return this._segment2._point},setPoint2:function(){var t=c.read(arguments);this._segment2._point.set(t.x,t.y)},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){var t=c.read(arguments);this._segment1._handleOut.set(t.x,t.y)},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){var t=c.read(arguments);this._segment2._handleIn.set(t.x,t.y)},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._segment1._index},isLast:function(){var t=this._path;return t&&this._segment1._index===t._curves.length-1||!1},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle2().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return z.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],i=0;i<8;i+=2)e.push(new c(t[i],t[i+1]));return e},getLength:function(){return null==this._length&&(this._length=z.getLength(this.getValues(),0,1)),this._length},getArea:function(){return z.getArea(this.getValues())},getLine:function(){return new m(this._segment1._point,this._segment2._point)},getPart:function(t,e){return new z(z.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return z.getLength(this.getValues(),t,e)},getIntersections:function(t){return z._getIntersections(this.getValues(),t&&t!==this?t.getValues():null,this,t,[],{})},divideAt:function(t){return this.divideAtTime(t&&t.curve===this?t.time:t)},divideAtTime:function(t,e){var i=4e-7,n=1-i,r=null;if(t>=i&&t<=n){var s=z.subdivide(this.getValues(),t),a=s[0],o=s[1],h=e||this.hasHandles(),u=this._segment1,l=this._segment2,d=this._path;h&&(u._handleOut.set(a[2]-a[0],a[3]-a[1]),l._handleIn.set(o[4]-o[6],o[5]-o[7]));var f=a[6],_=a[7],g=new T(new c(f,_),h&&new c(a[4]-f,a[5]-_),h&&new c(o[2]-f,o[3]-_));d?(d.insert(u._index+1,g),r=this.getNext()):(this._segment2=g,this._changed(),r=new z(g,l))}return r},splitAt:function(t){return this._path?this._path.splitAt(t):null},splitAtTime:function(t){return this.splitAt(this.getLocationAtTime(t))},divide:function(t,i){return this.divideAtTime(t===e?.5:i?t:this.getTimeAt(t))},split:function(t,i){return this.splitAtTime(t===e?.5:i?t:this.getTimeAt(t))},reversed:function(){return new z(this._segment2.reversed(),this._segment1.reversed())},clearHandles:function(){this._segment1._handleOut.set(0,0),this._segment2._handleIn.set(0,0)},statics:{getValues:function(t,e,i){var n=t._point,r=t._handleOut,s=e._handleIn,a=e._point,o=[n._x,n._y,n._x+r._x,n._y+r._y,a._x+s._x,a._y+s._y,a._x,a._y];return i&&i._transformCoordinates(o,o,4),o},subdivide:function(t,i){var n=t[0],r=t[1],s=t[2],a=t[3],o=t[4],h=t[5],u=t[6],l=t[7];i===e&&(i=.5);var c=1-i,d=c*n+i*s,f=c*r+i*a,_=c*s+i*o,g=c*a+i*h,v=c*o+i*u,p=c*h+i*l,m=c*d+i*_,y=c*f+i*g,w=c*_+i*v,x=c*g+i*p,b=c*m+i*w,C=c*y+i*x;return[[n,r,d,f,m,y,b,C],[b,C,w,x,v,p,u,l]]},solveCubic:function(t,e,i,n,r,s){var a=t[e],o=t[e+2],h=t[e+4],l=t[e+6],c=0;if(!(a<i&&l<i&&o<i&&h<i||a>i&&l>i&&o>i&&h>i)){var d=3*(o-a),f=3*(h-o)-d,_=l-a-d-f;c=u.solveCubic(_,f,d,a-i,n,r,s)}return c},getTimeOf:function(t,e){var i=new c(t[0],t[1]),n=new c(t[6],t[7]),r=1e-12,s=e.isClose(i,r)?0:e.isClose(n,r)?1:null;if(null!==s)return s;for(var a=[e.x,e.y],o=[],h=2e-7,u=0;u<2;u++)for(var l=z.solveCubic(t,u,a[u],o,0,1),d=0;d<l;d++)if(s=o[d],e.isClose(z.getPoint(t,s),h))return s;return e.isClose(i,h)?0:e.isClose(n,h)?1:null},getNearestTime:function(t,e){function i(i){if(i>=0&&i<=1){var n=e.getDistance(z.getPoint(t,i),!0);if(n<f)return f=n,_=i,!0}}if(z.isStraight(t)){var n=t[0],r=t[1],s=t[6],a=t[7],o=s-n,h=a-r,u=o*o+h*h;if(0===u)return 0;var l=((e.x-n)*o+(e.y-r)*h)/u;return l<1e-12?0:l>.999999999999?1:z.getTimeOf(t,new c(n+l*o,r+l*h))}for(var d=100,f=1/0,_=0,g=0;g<=d;g++)i(g/d);for(var v=1/(2*d);v>4e-7;)i(_-v)||i(_+v)||(v/=2);return _},getPart:function(t,e,i){var n=e>i;if(n){var r=e;e=i,i=r}return e>0&&(t=z.subdivide(t,e)[1]),i<1&&(t=z.subdivide(t,(i-e)/(1-e))[0]),n?[t[6],t[7],t[4],t[5],t[2],t[3],t[0],t[1]]:t},isFlatEnough:function(t,e){var i=t[0],n=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=3*r-2*i-h,c=3*s-2*n-u,d=3*a-2*h-i,f=3*o-2*u-n;return Math.max(l*l,d*d)+Math.max(c*c,f*f)<=16*e*e},getArea:function(t){var e=t[0],i=t[1],n=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7];return 3*((h-i)*(n+s)-(o-e)*(r+a)+r*(e-s)-n*(i-a)+h*(s+e/3)-o*(a+i/3))/20},getBounds:function(t){for(var e=t.slice(0,2),i=e.slice(),n=[0,0],r=0;r<2;r++)z._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,i,n);return new g(e[0],e[1],i[0]-e[0],i[1]-e[1])},_addBounds:function(t,e,i,n,r,s,a,o,h){function l(t,e){var i=t-e,n=t+e;i<a[r]&&(a[r]=i),n>o[r]&&(o[r]=n)}s/=2;var c=a[r]-s,d=o[r]+s;if(t<c||e<c||i<c||n<c||t>d||e>d||i>d||n>d)if(e<t!=e<n&&i<t!=i<n)l(t,s),l(n,s);else{var f=3*(e-i)-t+n,_=2*(t+i)-4*e,g=e-t,v=u.solveQuadratic(f,_,g,h),p=4e-7,m=1-p;l(n,0);for(var y=0;y<v;y++){var w=h[y],x=1-w;p<w&&w<m&&l(x*x*x*t+3*x*x*w*e+3*x*w*w*i+w*w*w*n,s)}}}}},r.each(["getBounds","getStrokeBounds","getHandleBounds"],function(t){this[t]=function(){this._bounds||(this._bounds={});var e=this._bounds[t];return e||(e=this._bounds[t]=L[t]([this._segment1,this._segment2],!1,this._path)),e.clone()}},{}),r.each({isStraight:function(t,e,i){if(e.isZero()&&i.isZero())return!0;var n=t.getVector(),r=2e-7;if(n.isZero())return!1;if(t.getDistance(e)<r&&t.getDistance(i)<r){var s=n.dot(n),a=n.dot(e)/s,o=n.dot(i)/s;return a>=0&&a<=1&&o<=0&&o>=-1}return!1},isLinear:function(t,e,i){var n=t.getVector().divide(3);return e.equals(n)&&i.negate().equals(n)}},function(t,e){this[e]=function(){var e=this._segment1,i=this._segment2;return t(new m(e._point,i._point),e._handleOut,i._handleIn)},this.statics[e]=function(e){var i=e[0],n=e[1],r=e[6],s=e[7];return t(new m(i,n,r,s),new c(e[2]-i,e[3]-n),new c(e[4]-r,e[5]-s))}},{statics:{},hasHandles:function(){return!this._segment1._handleOut.isZero()||!this._segment2._handleIn.isZero()},isCollinear:function(t){return t&&this.isStraight()&&t.isStraight()&&this.getLine().isCollinear(t.getLine())},isHorizontal:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).y)<1e-7},isVertical:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).x)<1e-7}}),{beans:!1,getLocationAt:function(t,e){return this.getLocationAtTime(e?t:this.getTimeAt(t))},getLocationAtTime:function(t){return null!=t&&t>=0&&t<=1?new O(this,t):null},getTimeAt:function(t,e){return z.getTimeAt(this.getValues(),t,e)},getParameterAt:"#getTimeAt",getOffsetAtTime:function(t){return this.getPartLength(0,t)},getLocationOf:function(){return this.getLocationAtTime(this.getTimeOf(c.read(arguments)))},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getTimeOf:function(){return z.getTimeOf(this.getValues(),c.read(arguments))},getParameterOf:"#getTimeOf",getNearestLocation:function(){var t=c.read(arguments),e=this.getValues(),i=z.getNearestTime(e,t),n=z.getPoint(e,i);return new O(this,i,n,null,t.getDistance(n))},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t}},new function(){var t=["getPoint","getTangent","getNormal","getWeightedTangent","getWeightedNormal","getCurvature"];return r.each(t,function(t){this[t+"At"]=function(e,i){var n=this.getValues();return z[t](n,i?e:z.getTimeAt(n,e))},this[t+"AtTime"]=function(e){return z[t](this.getValues(),e)}},{statics:{_evaluateMethods:t}})},new function(){function t(t){var e=t[0],i=t[1],n=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],u=9*(n-s)+3*(o-e),l=6*(e+s)-12*n,c=3*(n-e),d=9*(r-a)+3*(h-i),f=6*(i+a)-12*r,_=3*(r-i);return function(t){var e=(u*t+l)*t+c,i=(d*t+f)*t+_;return Math.sqrt(e*e+i*i)}}function i(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}function n(t,e,i,n){if(null==e||e<0||e>1)return null;var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],l=t[5],d=t[6],f=t[7],_=u.isZero;_(a-r)&&_(o-s)&&(a=r,o=s),_(h-d)&&_(l-f)&&(h=d,l=f);var g,v,p=3*(a-r),m=3*(h-a)-p,y=d-r-p-m,w=3*(o-s),x=3*(l-o)-w,b=f-s-w-x;if(0===i)g=0===e?r:1===e?d:((y*e+m)*e+p)*e+r,v=0===e?s:1===e?f:((b*e+x)*e+w)*e+s;else{var C=4e-7,S=1-C;if(e<C?(g=p,v=w):e>S?(g=3*(d-h),v=3*(f-l)):(g=(3*y*e+2*m)*e+p,v=(3*b*e+2*x)*e+w),n){0===g&&0===v&&(e<C||e>S)&&(g=h-a,v=l-o);var P=Math.sqrt(g*g+v*v);P&&(g/=P,v/=P)}if(3===i){var I=6*y*e+2*m,M=6*b*e+2*x,T=Math.pow(g*g+v*v,1.5);g=0!==T?(g*M-v*I)/T:0,v=0}}return 2===i?new c(v,(-g)):new c(g,v)}return{statics:{getLength:function(n,r,s,a){if(r===e&&(r=0),s===e&&(s=1),z.isStraight(n)){var o=n;s<1&&(o=z.subdivide(o,s)[0],r/=s),r>0&&(o=z.subdivide(o,r)[1]);var h=o[6]-o[0],l=o[7]-o[1];return Math.sqrt(h*h+l*l)}return u.integrate(a||t(n),r,s,i(r,s))},getTimeAt:function(n,r,s){function a(t){return p+=u.integrate(f,s,t,i(s,t)),s=t,p-r}if(s===e&&(s=r<0?1:0),0===r)return s;var o=Math.abs,h=1e-12,l=r>0,c=l?s:0,d=l?1:s,f=t(n),_=z.getLength(n,c,d,f),g=o(r)-_;if(o(g)<h)return l?d:c;if(g>h)return null;var v=r/_,p=0;return u.findRoot(a,f,s+v,c,d,32,1e-12)},getPoint:function(t,e){return n(t,e,0,!1)},getTangent:function(t,e){return n(t,e,1,!0)},getWeightedTangent:function(t,e){return n(t,e,1,!1)},getNormal:function(t,e){return n(t,e,2,!0)},getWeightedNormal:function(t,e){return n(t,e,2,!1)},getCurvature:function(t,e){return n(t,e,3,!1).x}}}},new function(){function t(t,e,i,n,r,s,a,o,h,u,l){var c=!l&&e.excludeStart,d=!l&&e.excludeEnd,f=4e-7,_=1-f;if(null==r&&(r=z.getTimeOf(i,s)),null!==r&&r>=(c?f:0)&&r<=(d?_:1)&&(null==h&&(h=z.getTimeOf(a,u)),null!==h&&h>=(d?f:0)&&h<=(c?_:1))){var g=e.renormalize;if(g){
var v=g(r,h);r=v[0],h=v[1]}var p=new O(n,r,s||z.getPoint(i,r),l),m=new O(o,h,u||z.getPoint(a,h),l),y=p.getPath()===m.getPath()&&p.getIndex()>m.getIndex(),w=y?m:p,x=e.include;p._intersection=m,m._intersection=p,x&&!x(w)||O.insert(t,w,!0)}}function e(r,s,a,o,h,u,l,c,d,f,_,g,v){if(++g>=48||++v>4096)return v;var p,y,w=s[0],x=s[1],b=s[6],C=s[7],S=m.getSignedDistance,P=S(w,x,b,C,s[2],s[3]),I=S(w,x,b,C,s[4],s[5]),M=P*I>0?.75:4/9,T=M*Math.min(0,P,I),k=M*Math.max(0,P,I),O=S(w,x,b,C,r[0],r[1]),A=S(w,x,b,C,r[2],r[3]),L=S(w,x,b,C,r[4],r[5]),N=S(w,x,b,C,r[6],r[7]),B=i(O,A,L,N),E=B[0],D=B[1];if(0===P&&0===I&&0===O&&0===A&&0===L&&0===N||null==(p=n(E,D,T,k))||null==(y=n(E.reverse(),D.reverse(),T,k)))return v;var j=l+(c-l)*p,F=l+(c-l)*y;if(Math.max(f-d,F-j)<1e-9){var R=(j+F)/2,q=(d+f)/2;r=a.getValues(),s=o.getValues(),t(h,u,_?s:r,_?o:a,_?q:R,null,_?r:s,_?a:o,_?R:q,null)}else if(r=z.getPart(r,p,y),y-p>.8)if(F-j>f-d){var V=z.subdivide(r,.5),R=(j+F)/2;v=e(s,V[0],o,a,h,u,d,f,j,R,!_,g,v),v=e(s,V[1],o,a,h,u,d,f,R,F,!_,g,v)}else{var V=z.subdivide(s,.5),q=(d+f)/2;v=e(V[0],r,o,a,h,u,d,q,j,F,!_,g,v),v=e(V[1],r,o,a,h,u,q,f,j,F,!_,g,v)}else v=e(s,r,o,a,h,u,d,f,j,F,!_,g,v);return v}function i(t,e,i,n){var r,s=[0,t],a=[1/3,e],o=[2/3,i],h=[1,n],u=e-(2*t+n)/3,l=i-(t+2*n)/3;if(u*l<0)r=[[s,a,h],[s,o,h]];else{var c=u/l;r=[c>=2?[s,a,h]:c<=.5?[s,o,h]:[s,a,o,h],[s,h]]}return(u||l)<0?r.reverse():r}function n(t,e,i,n){return t[0][1]<i?r(t,!0,i):e[0][1]>n?r(e,!1,n):t[0][0]}function r(t,e,i){for(var n=t[0][0],r=t[0][1],s=1,a=t.length;s<a;s++){var o=t[s][0],h=t[s][1];if(e?h>=i:h<=i)return h===i?o:n+(i-r)*(o-n)/(h-r);n=o,r=h}return null}function s(e,i,n,r,s,a){for(var o=z.isStraight(e),h=o?i:e,l=o?e:i,c=l[0],d=l[1],f=l[6],_=l[7],g=f-c,v=_-d,p=Math.atan2(-v,g),m=Math.sin(p),y=Math.cos(p),w=[],x=0;x<8;x+=2){var b=h[x]-c,C=h[x+1]-d;w.push(b*y-C*m,b*m+C*y)}for(var S=[],P=z.solveCubic(w,1,0,S,0,1),x=0;x<P;x++){var I=S[x],M=z.getPoint(h,I),T=z.getTimeOf(l,M);if(null!==T){var k=z.getPoint(l,T),O=o?T:I,A=o?I:T;(!a.excludeEnd||A>u.CURVETIME_EPSILON)&&t(s,a,e,n,O,o?k:M,i,r,A,o?M:k)}}}function a(e,i,n,r,s,a){var o=m.intersect(e[0],e[1],e[6],e[7],i[0],i[1],i[6],i[7]);o&&t(s,a,e,n,null,o,i,r,null,o)}return{statics:{_getIntersections:function(i,n,r,o,h,u){if(!n)return z._getSelfIntersection(i,r,h,u);var l=2e-7,d=i[0],f=i[1],_=i[6],g=i[7],v=n[0],p=n[1],m=n[6],y=n[7],w=(3*i[2]+d)/4,x=(3*i[3]+f)/4,b=(3*i[4]+_)/4,C=(3*i[5]+g)/4,S=(3*n[2]+v)/4,P=(3*n[3]+p)/4,I=(3*n[4]+m)/4,M=(3*n[5]+y)/4,T=Math.min,k=Math.max;if(!(k(d,w,b,_)+l>T(v,S,I,m)&&T(d,w,b,_)-l<k(v,S,I,m)&&k(f,x,C,g)+l>T(p,P,M,y)&&T(f,x,C,g)-l<k(p,P,M,y)))return h;var O=z.getOverlaps(i,n);if(O){for(var A=0;A<2;A++){var L=O[A];t(h,u,i,r,L[0],null,n,o,L[1],null,!0)}return h}var N=z.isStraight(i),B=z.isStraight(n),E=N&&B,D=h.length;if((E?a:N||B?s:e)(i,n,r,o,h,u,0,1,0,1,0,0,0),E&&h.length>D)return h;var j=new c(d,f),F=new c(_,g),R=new c(v,p),q=new c(m,y);return j.isClose(R,l)&&t(h,u,i,r,0,j,n,o,0,R),!u.excludeStart&&j.isClose(q,l)&&t(h,u,i,r,0,j,n,o,1,q),!u.excludeEnd&&F.isClose(R,l)&&t(h,u,i,r,1,F,n,o,0,R),F.isClose(q,l)&&t(h,u,i,r,1,F,n,o,1,q),h},_getSelfIntersection:function(t,e,i,n){var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],l=t[5],d=t[6],f=t[7],_=new m(r,s,d,f,(!1)),g=_.getSide(new c(a,o),!0),v=_.getSide(new c(h,l),!0);if(g===v){var p=(r-h)*(o-f)+(a-d)*(l-s);if(p*g>0)return i}var y=d-3*h+3*a-r,w=h-2*a+r,x=a-r,b=f-3*l+3*o-s,C=l-2*o+s,S=o-s,P=b*x-y*S,I=b*w-y*C,M=C*x-w*S;if(P*P-4*I*M<0){var T,k=[],O=u.solveCubic(y*y+b*b,3*(y*w+b*C),2*(w*w+C*C)+y*x+b*S,w*x+C*S,k,0,1);if(O>0){for(var A=0,L=0;A<O;A++){var N=Math.abs(e.getCurvatureAtTime(k[A]));N>L&&(L=N,T=k[A])}var B=z.subdivide(t,T);n.excludeEnd=!0,n.renormalize=function(t,e){return[t*T,e*(1-T)+T]},z._getIntersections(B[0],B[1],e,e,i,n)}}return i},getOverlaps:function(t,e){function i(t){var e=t[6]-t[0],i=t[7]-t[1];return e*e+i*i}var n=Math.abs,r=4e-7,s=2e-7,a=z.isStraight(t),o=z.isStraight(e),h=a&&o,u=i(t)<i(e),l=u?e:t,d=u?t:e,f=new m(l[0],l[1],l[6],l[7]);if(f.getDistance(new c(d[0],d[1]))<s&&f.getDistance(new c(d[6],d[7]))<s)!h&&f.getDistance(new c(l[2],l[3]))<s&&f.getDistance(new c(l[4],l[5]))<s&&f.getDistance(new c(d[2],d[3]))<s&&f.getDistance(new c(d[4],d[5]))<s&&(a=o=h=!0);else if(h)return null;if(a^o)return null;for(var _=[t,e],g=[],v=0,p=0;v<2&&g.length<2;v+=0===p?0:1,p=1^p){var y=z.getTimeOf(_[1^v],new c(_[v][0===p?0:6],_[v][0===p?1:7]));if(null!=y){var w=0===v?[p,y]:[y,p];(0===g.length||n(w[0]-g[0][0])>r&&n(w[1]-g[0][1])>r)&&g.push(w)}if(1===v&&0===g.length)break}if(2!==g.length)g=null;else if(!h){var x=z.getPart(t,g[0][0],g[1][0]),b=z.getPart(e,g[0][1],g[1][1]);(n(b[2]-x[2])>s||n(b[3]-x[3])>s||n(b[4]-x[4])>s||n(b[5]-x[5])>s)&&(g=null)}return g}}}}),O=r.extend({_class:"CurveLocation",beans:!0,initialize:function(t,e,i,n,r){if(e>.9999996){var s=t.getNext();s&&(e=0,t=s)}this._setCurve(t),this._time=e,this._point=i||t.getPointAtTime(e),this._overlap=n,this._distance=r,this._intersection=this._next=this._previous=null},_setCurve:function(t){var e=t._path;this._path=e,this._version=e?e._version:0,this._curve=t,this._segment=null,this._segment1=t._segment1,this._segment2=t._segment2},_setSegment:function(t){this._setCurve(t.getCurve()),this._segment=t,this._time=t===this._segment1?0:1,this._point=t._point.clone()},getSegment:function(){var t=this.getCurve(),e=this._segment;if(!e){var i=this.getTime();0===i?e=t._segment1:1===i?e=t._segment2:null!=i&&(e=t.getPartLength(0,i)<t.getPartLength(i,1)?t._segment1:t._segment2),this._segment=e}return e},getCurve:function(){function t(t){var e=t&&t.getCurve();if(e&&null!=(i._time=e.getTimeOf(i._point)))return i._setCurve(e),i._segment=t,e}var e=this._path,i=this;return e&&e._version!==this._version&&(this._time=this._curve=this._offset=null),this._curve||t(this._segment)||t(this._segment1)||t(this._segment2.getPrevious())},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getTime:function(){var t=this.getCurve(),e=this._time;return t&&null==e?this._time=t.getTimeOf(this._point):e},getParameter:"#getTime",getPoint:function(){return this._point},getOffset:function(){var t=this._offset;if(null==t){t=0;var e=this.getPath(),i=this.getIndex();if(e&&null!=i)for(var n=e.getCurves(),r=0;r<i;r++)t+=n[r].getLength();this._offset=t+=this.getCurveOffset()}return t},getCurveOffset:function(){var t=this.getCurve(),e=this.getTime();return null!=e&&t&&t.getPartLength(0,e)},getIntersection:function(){return this._intersection},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(),e=null;return t&&(e=t.divideAtTime(this.getTime()),e&&this._setSegment(e._segment1)),e},split:function(){var t=this.getCurve();return t?t.splitAtTime(this.getTime()):null},equals:function(t,e){var i=this===t,n=2e-7;if(!i&&t instanceof O&&this.getPath()===t.getPath()&&this.getPoint().isClose(t.getPoint(),n)){var r=this.getCurve(),s=t.getCurve(),a=Math.abs,o=a((r.isLast()&&s.isFirst()?-1:r.getIndex())+this.getTime()-((s.isLast()&&r.isFirst()?-1:s.getIndex())+t.getTime()));i=(o<4e-7||(o=a(this.getOffset()-t.getOffset()))<n||a(this.getPath().getLength()-o)<n)&&(e||!this._intersection&&!t._intersection||this._intersection&&this._intersection.equals(t._intersection,!0))}return i},toString:function(){var t=[],e=this.getPoint(),i=h.instance;e&&t.push("point: "+e);var n=this.getIndex();null!=n&&t.push("index: "+n);var r=this.getTime();return null!=r&&t.push("time: "+i.number(r)),null!=this._distance&&t.push("distance: "+i.number(this._distance)),"{ "+t.join(", ")+" }"},isTouching:function(){var t=this._intersection;if(t&&this.getTangent().isCollinear(t.getTangent())){var e=this.getCurve(),i=t.getCurve();return!(e.isStraight()&&i.isStraight()&&e.getLine().intersect(i.getLine()))}return!1},isCrossing:function(){function t(t,e,i){return e<i?t>e&&t<i:t>e||t<i}var e=this._intersection;if(!e)return!1;var i=this.getTime(),n=e.getTime(),r=4e-7,s=1-r,a=i>r&&i<s,o=n>r&&n<s;if(a&&o)return!this.isTouching();var h=this.getCurve(),u=i<=r?h.getPrevious():h,l=e.getCurve(),c=n<=r?l.getPrevious():l;if(i>=s&&(h=h.getNext()),n>=s&&(l=l.getNext()),!(u&&h&&c&&l))return!1;var d=[];a||d.push(u.getLength(),h.getLength()),o||d.push(c.getLength(),l.getLength());var f=this.getPoint(),_=Math.min.apply(Math,d)/64,g=a?h.getTangentAtTime(i):h.getPointAt(_).subtract(f),v=a?g.negate():u.getPointAt(-_).subtract(f),p=o?l.getTangentAtTime(n):l.getPointAt(_).subtract(f),m=o?p.negate():c.getPointAt(-_).subtract(f),y=v.getAngle(),w=g.getAngle(),x=m.getAngle(),b=p.getAngle();return!!(a?t(y,x,b)^t(w,x,b)&&t(y,b,x)^t(w,b,x):t(x,y,w)^t(b,y,w)&&t(x,w,y)^t(b,w,y))},hasOverlap:function(){return!!this._overlap}},r.each(z._evaluateMethods,function(t){var e=t+"At";this[t]=function(){var t=this.getCurve(),i=this.getTime();return null!=i&&t&&t[e](i,!0)}},{preserve:!0}),new function(){function t(t,e,i){function n(i,n){for(var s=i+n;s>=-1&&s<=r;s+=n){var a=t[(s%r+r)%r];if(!e.getPoint().isClose(a.getPoint(),2e-7))break;if(e.equals(a))return a}return null}for(var r=t.length,s=0,a=r-1;s<=a;){var o,h=s+a>>>1,u=t[h];if(i&&(o=e.equals(u)?u:n(h,-1)||n(h,1)))return e._overlap&&(o._overlap=o._intersection._overlap=!0),o;var l=e.getPath(),c=u.getPath(),d=l===c?e.getIndex()+e.getTime()-(u.getIndex()+u.getTime()):l._id-c._id;d<0?a=h-1:s=h+1}return t.splice(s,0,e),e}return{statics:{insert:t,expand:function(e){for(var i=e.slice(),n=e.length-1;n>=0;n--)t(i,e[n]._intersection,!1);return i}}}}),A=w.extend({_class:"PathItem",_selectBounds:!1,_canScaleStroke:!0,initialize:function(){},statics:{create:function(t){var e=(t&&t.match(/m/gi)||[]).length>1||/z\s*\S+/i.test(t)?N:L;return new e(t)}},_asPathItem:function(){return this},setPathData:function(t){function e(t,e){var i=+n[t];return o&&(i+=h[e]),i}function i(t){return new c(e(t,"x"),e(t+1,"y"))}var n,r,s,a=t&&t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),o=!1,h=new c,u=new c;this.clear();for(var l=0,d=a&&a.length;l<d;l++){var _=a[l],g=_[0],v=g.toLowerCase();n=_.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g);var p=n&&n.length;switch(o=g===v,"z"!==r||/[mz]/.test(v)||this.moveTo(h=u),v){case"m":case"l":for(var m="m"===v,y=0;y<p;y+=2)this[0===y&&m?"moveTo":"lineTo"](h=i(y));s=h,m&&(u=h);break;case"h":case"v":for(var w="h"===v?"x":"y",y=0;y<p;y++)h[w]=e(y,w),this.lineTo(h);s=h;break;case"c":for(var y=0;y<p;y+=6)this.cubicCurveTo(i(y),s=i(y+2),h=i(y+4));break;case"s":for(var y=0;y<p;y+=4)this.cubicCurveTo(/[cs]/.test(r)?h.multiply(2).subtract(s):h,s=i(y),h=i(y+2)),r=v;break;case"q":for(var y=0;y<p;y+=4)this.quadraticCurveTo(s=i(y),h=i(y+2));break;case"t":for(var y=0;y<p;y+=2)this.quadraticCurveTo(s=/[qt]/.test(r)?h.multiply(2).subtract(s):h,h=i(y)),r=v;break;case"a":for(var y=0;y<p;y+=7)this.arcTo(h=i(y+5),new f((+n[y]),(+n[y+1])),+n[y+2],+n[y+4],+n[y+3]);break;case"z":this.closePath(1e-12)}r=v}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){var e=t.isInside(this.getBounds({internal:!0,handle:!0}))&&this._getWinding(t);return!!("evenodd"===this.getFillRule()?1&e:e)},getIntersections:function(t,e,i,n){var r=this===t||!t,s=this._matrix._orNullIfIdentity(),a=r?s:(i||t._matrix)._orNullIfIdentity();if(!r&&!this.getBounds(s).touches(t.getBounds(a)))return[];for(var o,t,h=this.getCurves(),u=r?h:t.getCurves(),l=h.length,c=r?l:u.length,d=[],f=[],_=0;_<c;_++)d[_]=u[_].getValues(a);for(var _=0;_<l;_++){var g=h[_],v=r?d[_]:g.getValues(s),p=g.getPath();p!==t&&(t=p,o=[],f.push(o)),r&&z._getSelfIntersection(v,g,o,{include:e,excludeStart:1===l&&g.getPoint1().equals(g.getPoint2())});for(var m=r?_+1:0;m<c;m++){if(n&&o.length)return o;var y=u[m];z._getIntersections(v,d[m],g,y,o,{include:e,excludeStart:r&&g.getPrevious()===y,excludeEnd:r&&g.getNext()===y})}}o=[];for(var _=0,w=f.length;_<w;_++)o.push.apply(o,f[_]);return o},getCrossings:function(t){return this.getIntersections(t,function(t){return t._overlap||t.isCrossing()})},getNearestLocation:function(){for(var t=c.read(arguments),e=this.getCurves(),i=1/0,n=null,r=0,s=e.length;r<s;r++){var a=e[r].getNearestLocation(t);a._distance<i&&(i=a._distance,n=a)}return n},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t},interpolate:function(t,e,i){var n=!this._children,r=n?"_segments":"_children",s=t[r],a=e[r],o=this[r];if(!s||!a||s.length!==a.length)throw new Error("Invalid operands in interpolate() call: "+t+", "+e);var h=o.length,u=a.length;if(h<u)for(var l=n?T:L,c=h;c<u;c++)this.add(new l);else h>u&&this[n?"removeSegments":"removeChildren"](u,h);for(var c=0;c<u;c++)o[c].interpolate(s[c],a[c],i);n&&(this.setClosed(t._closed),this._changed(9))}}),L=A.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(t){this._closed=!1,this._segments=[],this._version=0;var i=Array.isArray(t)?"object"==typeof t[0]?t:arguments:!t||t.size!==e||t.x===e&&t.point===e?null:arguments;i&&i.length>0?this.setSegments(i):(this._curves=e,this._segmentSelection=0,i||"string"!=typeof t||(this.setPathData(t),t=null)),this._initialize(!i&&t)},_equals:function(t){return this._closed===t._closed&&r.equals(this._segments,t._segments)},copyContent:function(t){this.setSegments(t._segments),this._closed=t._closed;var i=t._clockwise;i!==e&&(this._clockwise=i)},_changed:function gt(t){if(gt.base.call(this,t),8&t){if(this._length=this._area=this._clockwise=this._monoCurves=e,16&t)this._version++;else if(this._curves)for(var i=0,n=this._curves.length;i<n;i++)this._curves[i]._changed()}else 32&t&&(this._bounds=e)},getStyle:function(){var t=this._parent;return(t instanceof N?t:this)._style},getSegments:function(){return this._segments},setSegments:function(t){var i=this.isFullySelected();this._segments.length=0,this._segmentSelection=0,this._curves=e,t&&t.length>0&&this._add(T.readAll(t)),i&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t){var i=this._countCurves();t=this._curves=new Array(i);for(var n=0;n<i;n++)t[n]=new z(this,e[n],e[n+1]||e[0])}return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){if(this._closed!=(t=!!t)){if(this._closed=t,this._curves){var e=this._curves.length=this._countCurves();t&&(this._curves[e-1]=new z(this,this._segments[e-1],this._segments[0]))}this._changed(25)}}},{beans:!0,getPathData:function(t,e){function i(e,i){e._transformCoordinates(t,g),n=g[0],r=g[1],v?(p.push("M"+_.pair(n,r)),v=!1):(o=g[2],u=g[3],o===n&&u===r&&l===s&&c===a?i||p.push("l"+_.pair(n-s,r-a)):p.push("c"+_.pair(l-s,c-a)+" "+_.pair(o-s,u-a)+" "+_.pair(n-s,r-a))),s=n,a=r,l=g[4],c=g[5]}var n,r,s,a,o,u,l,c,d=this._segments,f=d.length,_=new h(e),g=new Array(6),v=!0,p=[];if(0===f)return"";for(var m=0;m<f;m++)i(d[m]);return this._closed&&f>0&&(i(d[0],!0),p.push("z")),p.join("")},isEmpty:function(){return 0===this._segments.length},_transformContent:function(t){for(var e=this._segments,i=new Array(6),n=0,r=e.length;n<r;n++)e[n]._transformCoordinates(t,i,!0);return!0},_add:function(t,e){for(var i=this._segments,n=this._curves,r=t.length,s=null==e,e=s?i.length:e,a=0;a<r;a++){var o=t[a];o._path&&(o=t[a]=o.clone()),o._path=this,o._index=e+a,o._selection&&this._updateSelection(o,0,o._selection)}if(s)i.push.apply(i,t);else{i.splice.apply(i,[e,0].concat(t));for(var a=e+r,h=i.length;a<h;a++)i[a]._index=a}if(n){var u=this._countCurves(),l=e>0&&e+r-1===u?e-1:e,c=l,d=Math.min(l+r,u);t._curves&&(n.splice.apply(n,[l,0].concat(t._curves)),c+=t._curves.length);for(var a=c;a<d;a++)n.splice(a,0,new z(this,null,null));this._adjustCurves(l,d)}return this._changed(25),t},_adjustCurves:function(t,e){for(var i,n=this._segments,r=this._curves,s=t;s<e;s++)i=r[s],i._path=this,i._segment1=n[s],i._segment2=n[s+1]||n[0],i._changed();(i=r[this._closed&&0===t?n.length-1:t-1])&&(i._segment2=n[t]||n[0],i._changed()),(i=r[e])&&(i._segment1=n[e],i._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&t>0?t-1:t},add:function(t){return arguments.length>1&&"number"!=typeof t?this._add(T.readAll(arguments)):this._add([T.read(arguments)])[0]},insert:function(t,e){return arguments.length>2&&"number"!=typeof e?this._add(T.readAll(arguments,1),t):this._add([T.read(arguments,1)],t)[0]},addSegment:function(){return this._add([T.read(arguments)])[0]},insertSegment:function(t){return this._add([T.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(T.readAll(t))},insertSegments:function(t,e){return this._add(T.readAll(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,e,i){t=t||0,e=r.pick(e,this._segments.length);var n=this._segments,s=this._curves,a=n.length,o=n.splice(t,e-t),h=o.length;if(!h)return o;for(var u=0;u<h;u++){var l=o[u];l._selection&&this._updateSelection(l,l._selection,0),l._index=l._path=null}for(var u=t,c=n.length;u<c;u++)n[u]._index=u;if(s){for(var d=t>0&&e===a+(this._closed?1:0)?t-1:t,s=s.splice(d,h),u=s.length-1;u>=0;u--)s[u]._path=null;i&&(o._curves=s.slice(1)),this._adjustCurves(d,d)}return this._changed(25),o},clear:"#removeSegments",hasHandles:function(){for(var t=this._segments,e=0,i=t.length;e<i;e++)if(t[e].hasHandles())return!0;return!1},clearHandles:function(){for(var t=this._segments,e=0,i=t.length;e<i;e++)t[e].clearHandles()},getLength:function(){if(null==this._length){for(var t=this.getCurves(),e=0,i=0,n=t.length;i<n;i++)e+=t[i].getLength();this._length=e}return this._length},getArea:function(t){var i=t===e,n=this._area;if(!i||null==n){var r=this._segments,s=r.length,a=i?this._closed:t,o=s-1;n=0;for(var h=0,u=a?s:o;h<u;h++)n+=z.getArea(z.getValues(r[h],r[h<o?h+1:0]));i&&(this._area=n)}return n},isClockwise:function(){return this._clockwise!==e?this._clockwise:this.getArea()>=0},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse(),this._clockwise=t},isFullySelected:function(){var t=this._segments.length;return this.isSelected()&&t>0&&this._segmentSelection===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelection:function vt(t){1&t||this._selectSegments(!1),vt.base.call(this,t)},_selectSegments:function(t){var e=this._segments,i=e.length,n=t?7:0;this._segmentSelection=n*i;for(var r=0;r<i;r++)e[r]._selection=n},_updateSelection:function(t,e,i){t._selection=i;var n=this._segmentSelection+=i-e;n>0&&this.setSelected(!0)},splitAt:function(t){var e="number"==typeof t?this.getLocationAt(t):t,i=e&&e.index,n=e&&e.time,r=4e-7,s=1-r;n>=s&&(i++,n=0);var a=this.getCurves();if(i>=0&&i<a.length){n>=r&&a[i++].divideAtTime(n);var o,h=this.removeSegments(i,this._segments.length,!0);return this._closed?(this.setClosed(!1),o=this):(o=new L(w.NO_INSERT),o.insertAbove(this,!0),o.copyAttributes(this)),o._add(h,0),this.addSegment(h[0]),o}return null},split:function(t,i){var n,r=i===e?t:(n=this.getCurves()[t])&&n.getLocationAtTime(i);return null!=r?this.splitAt(r):null},join:function(t,e){var i=e||0;if(t&&t!==this){var n=t._segments,r=this.getLastSegment(),s=t.getLastSegment();if(!s)return this;r&&r._point.isClose(s._point,i)&&t.reverse();var a=t.getFirstSegment();if(r&&r._point.isClose(a._point,i))r.setHandleOut(a._handleOut),this._add(n.slice(1));else{var o=this.getFirstSegment();o&&o._point.isClose(a._point,i)&&t.reverse(),s=t.getLastSegment(),o&&o._point.isClose(s._point,i)?(o.setHandleIn(s._handleIn),this._add(n.slice(0,n.length-1),0)):this._add(n.slice())}t._closed&&this._add([n[0]]),t.remove()}var h=this.getFirstSegment(),u=this.getLastSegment();return h!==u&&h._point.isClose(u._point,i)&&(h.setHandleIn(u._handleIn),u.remove(),this.setClosed(!0)),this},reduce:function(t){for(var e=this.getCurves(),i=t&&t.simplify,n=i?2e-7:0,r=e.length-1;r>=0;r--){var s=e[r];!s.hasHandles()&&(s.getLength()<n||i&&s.isCollinear(s.getNext()))&&s.remove()}return this},reverse:function(){this._segments.reverse();for(var t=0,i=this._segments.length;t<i;t++){var n=this._segments[t],r=n._handleIn;n._handleIn=n._handleOut,n._handleOut=r,n._index=t}this._curves=null,this._clockwise!==e&&(this._clockwise=!this._clockwise),this._changed(9)},flatten:function(t){for(var e=new B(this,t||.25,256,(!0)),i=e.parts,n=i.length,r=[],s=0;s<n;s++)r.push(new T(i[s].curve.slice(0,2)));!this._closed&&n>0&&r.push(new T(i[n-1].curve.slice(6))),this.setSegments(r)},simplify:function(t){var e=new E(this).fit(t||2.5);return e&&this.setSegments(e),!!e},smooth:function(t){function i(t,e){var i=t&&t.index;if(null!=i){var r=t.path;if(r&&r!==n)throw new Error(t._class+" "+i+" of "+r+" is not part of "+n);e&&t instanceof z&&i++}else i="number"==typeof t?t:e;return Math.min(i<0&&h?i%o:i<0?i+o:i,o-1)}var n=this,r=t||{},s=r.type||"asymmetric",a=this._segments,o=a.length,h=this._closed,u=h&&r.from===e&&r.to===e,l=i(r.from,0),c=i(r.to,o-1);if(l>c)if(h)l-=o;else{var d=l;l=c,c=d}if(/^(?:asymmetric|continuous)$/.test(s)){var f="asymmetric"===s,_=Math.min,g=c-l+1,v=g-1,p=u?_(g,4):1,m=p,y=p,w=[];if(h||(m=_(1,l),y=_(1,o-c-1)),v+=m+y,v<=1)return;for(var x=0,b=l-m;x<=v;x++,b++)w[x]=a[(b<0?b+o:b)%o]._point;for(var C=w[0]._x+2*w[1]._x,S=w[0]._y+2*w[1]._y,P=2,I=v-1,M=[C],T=[S],k=[P],O=[],A=[],x=1;x<v;x++){var L=x<I,N=L?1:f?1:2,B=L?4:f?2:7,E=L?4:f?3:8,D=L?2:f?0:1,j=N/P;P=k[x]=B-j,C=M[x]=E*w[x]._x+D*w[x+1]._x-j*C,S=T[x]=E*w[x]._y+D*w[x+1]._y-j*S}O[I]=M[I]/k[I],A[I]=T[I]/k[I];for(var x=v-2;x>=0;x--)O[x]=(M[x]-O[x+1])/k[x],A[x]=(T[x]-A[x+1])/k[x];O[v]=(3*w[v]._x-O[I])/2,A[v]=(3*w[v]._y-A[I])/2;for(var x=m,F=v-y,b=l;x<=F;x++,b++){var R=a[b<0?b+o:b],q=R._point,V=O[x]-q._x,H=A[x]-q._y;(u||x<F)&&R.setHandleOut(V,H),(u||x>m)&&R.setHandleIn(-V,-H)}}else for(var x=l;x<=c;x++)a[x<0?x+o:x].smooth(r,!u&&x===l,!u&&x===c)},toShape:function(t){function i(t,e){var i=c[t],n=i.getNext(),r=c[e],s=r.getNext();return i._handleOut.isZero()&&n._handleIn.isZero()&&r._handleOut.isZero()&&s._handleIn.isZero()&&n._point.subtract(i._point).isCollinear(s._point.subtract(r._point))}function n(t){var e=c[t],i=e.getPrevious(),n=e.getNext();return i._handleOut.isZero()&&e._handleIn.isZero()&&e._handleOut.isZero()&&n._handleIn.isZero()&&e._point.subtract(i._point).isOrthogonal(n._point.subtract(e._point))}function r(t){var e=c[t],i=e.getNext(),n=e._handleOut,r=i._handleIn,s=.5522847498307936;if(n.isOrthogonal(r)){var a=e._point,o=i._point,h=new m(a,n,(!0)).intersect(new m(o,r,(!0)),!0);return h&&u.isZero(n.getLength()/h.subtract(a).getLength()-s)&&u.isZero(r.getLength()/h.subtract(o).getLength()-s)}return!1}function s(t,e){return c[t]._point.getDistance(c[e]._point)}if(!this._closed)return null;var a,o,h,l,c=this._segments;if(!this.hasHandles()&&4===c.length&&i(0,2)&&i(1,3)&&n(1)?(a=C.Rectangle,o=new f(s(0,3),s(0,1)),l=c[1]._point.add(c[2]._point).divide(2)):8===c.length&&r(0)&&r(2)&&r(4)&&r(6)&&i(1,5)&&i(3,7)?(a=C.Rectangle,o=new f(s(1,6),s(0,3)),h=o.subtract(new f(s(0,7),s(1,2))).divide(2),l=c[3]._point.add(c[4]._point).divide(2)):4===c.length&&r(0)&&r(1)&&r(2)&&r(3)&&(u.isZero(s(0,2)-s(1,3))?(a=C.Circle,h=s(0,2)/2):(a=C.Ellipse,h=new f(s(2,0)/2,s(3,1)/2)),l=c[1]._point),a){var d=this.getPosition(!0),_=new a({center:d,size:o,radius:h,insert:!1});return _.copyAttributes(this,!0),_._matrix.prepend(this._matrix),_.rotate(l.subtract(d).getAngle()+90),(t===e||t)&&_.insertAbove(this),_}return null},toPath:"#clone",_hitTestSelf:function(t,e,i,n){function r(e,i){return t.subtract(e).divide(i).length<=1}function s(t,i,n){if(!e.selected||i.isSelected()){var s=t._point;if(i!==s&&(i=i.add(s)),r(i,x))return new M(n,g,{segment:t,point:i})}}function a(t,i){return(i||e.segments)&&s(t,t._point,"segment")||!i&&e.handles&&(s(t,t._handleIn,"handle-in")||s(t,t._handleOut,"handle-out"))}function o(t){d.add(t)}function h(e){if(("round"!==u||"round"!==l)&&(d=new L({internal:!0,closed:!0}),y||e._index>0&&e._index<m-1?"round"!==u&&(e._handleIn.isZero()||e._handleOut.isZero())&&L._addBevelJoin(e,u,P,c,null,n,o,!0):"round"!==l&&L._addSquareCap(e,l,P,null,n,o,!0),!d.isEmpty())){var i;return d.contains(t)||(i=d.getNearestLocation(t))&&r(i.getPoint(),w)}return r(e._point,x)}var u,l,c,d,f,_,g=this,v=this.getStyle(),p=this._segments,m=p.length,y=this._closed,w=e._tolerancePadding,x=w,b=e.stroke&&v.hasStroke(),C=e.fill&&v.hasFill(),S=e.curves,P=b?v.getStrokeWidth()/2:C&&e.tolerance>0||S?0:null;if(null!==P&&(P>0?(u=v.getStrokeJoin(),l=v.getStrokeCap(),c=P*v.getMiterLimit(),x=x.add(L._getStrokePadding(P,n))):u=l="round"),!e.ends||e.segments||y){if(e.segments||e.handles)for(var I=0;I<m;I++)if(_=a(p[I]))return _}else if(_=a(p[0],!0)||a(p[m-1],!0))return _;if(null!==P){if(f=this.getNearestLocation(t)){var T=f.getTime();0===T||1===T&&m>1?h(f.getSegment())||(f=null):r(f.getPoint(),x)||(f=null)}if(!f&&"miter"===u&&m>1)for(var I=0;I<m;I++){var k=p[I];if(t.getDistance(k._point)<=c&&h(k)){f=k.getLocation();break}}}return!f&&C&&this._contains(t)||f&&!b&&!S?new M("fill",this):f?new M(b?"stroke":"curve",this,{location:f,point:f.getPoint()}):null}},r.each(z._evaluateMethods,function(t){this[t+"At"]=function(e){var i=this.getLocationAt(e);return i&&i[t]()}},{beans:!1,getLocationOf:function(){for(var t=c.read(arguments),e=this.getCurves(),i=0,n=e.length;i<n;i++){var r=e[i].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t){for(var e=this.getCurves(),i=0,n=0,r=e.length;n<r;n++){var s=i,a=e[n];if(i+=a.getLength(),i>t)return a.getLocationAt(t-s)}return e.length>0&&t<=this.getLength()?new O(e[e.length-1],1):null}}),new function(){function t(t,e,i,n){function r(e){var i=h[e],n=h[e+1];s==i&&a==n||(t.beginPath(),t.moveTo(s,a),t.lineTo(i,n),t.stroke(),t.beginPath(),t.arc(i,n,o,0,2*Math.PI,!0),t.fill())}for(var s,a,o=n/2,h=new Array(6),u=0,l=e.length;u<l;u++){var c=e[u],d=c._selection;if(c._transformCoordinates(i,h),s=h[0],a=h[1],2&d&&r(2),4&d&&r(4),t.fillRect(s-o,a-o,n,n),!(1&d)){var f=t.fillStyle;t.fillStyle="#ffffff",t.fillRect(s-o+1,a-o+1,n-2,n-2),t.fillStyle=f}}}function e(t,e,i){function n(e){if(i)e._transformCoordinates(i,_),r=_[0],s=_[1];else{var n=e._point;r=n._x,s=n._y}if(g)t.moveTo(r,s),g=!1;else{if(i)h=_[2],u=_[3];else{var d=e._handleIn;h=r+d._x,u=s+d._y}h===r&&u===s&&l===a&&c===o?t.lineTo(r,s):t.bezierCurveTo(l,c,h,u,r,s)}if(a=r,o=s,i)l=_[4],c=_[5];else{var d=e._handleOut;l=a+d._x,c=o+d._y}}for(var r,s,a,o,h,u,l,c,d=e._segments,f=d.length,_=new Array(6),g=!0,v=0;v<f;v++)n(d[v]);e._closed&&f>0&&n(d[0])}return{_draw:function(t,i,n,r){function s(t){return c[(t%d+d)%d]}var a=i.dontStart,o=i.dontFinish||i.clip,h=this.getStyle(),u=h.hasFill(),l=h.hasStroke(),c=h.getDashArray(),d=!paper.support.nativeDash&&l&&c&&c.length;if(a||t.beginPath(),(u||l&&!d||o)&&(e(t,this,r),this._closed&&t.closePath()),!o&&(u||l)&&(this._setStyles(t,i,n),u&&(t.fill(h.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),l)){if(d){a||t.beginPath();var f,_=new B(this,.25,32,(!1),r),g=_.length,v=-h.getDashOffset(),p=0;for(v%=g;v>0;)v-=s(p--)+s(p--);for(;v<g;)f=v+s(p++),(v>0||f>0)&&_.drawPart(t,Math.max(v,0),Math.max(f,0)),v=f+s(p++)}t.stroke()}},_drawSelected:function(i,n){i.beginPath(),e(i,this,n),i.stroke(),t(i,this._segments,n,paper.settings.handleSize)}}},new function(){function t(t){var e=t._segments;if(0===e.length)throw new Error("Use a moveTo() command first");return e[e.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new T(c.read(arguments))])},moveBy:function(){throw new Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new T(c.read(arguments))])},cubicCurveTo:function(){var e=c.read(arguments),i=c.read(arguments),n=c.read(arguments),r=t(this);r.setHandleOut(e.subtract(r._point)),this._add([new T(n,i.subtract(n))])},quadraticCurveTo:function(){var e=c.read(arguments),i=c.read(arguments),n=t(this)._point;this.cubicCurveTo(e.add(n.subtract(e).multiply(1/3)),e.add(i.subtract(e).multiply(1/3)),i)},curveTo:function(){var e=c.read(arguments),i=c.read(arguments),n=r.pick(r.read(arguments),.5),s=1-n,a=t(this)._point,o=e.subtract(a.multiply(s*s)).subtract(i.multiply(n*n)).divide(2*n*s);if(o.isNaN())throw new Error("Cannot put a curve through points with parameter = "+n);this.quadraticCurveTo(o,i)},arcTo:function(){var e,i,n,s,a,o=t(this),h=o._point,l=c.read(arguments),d=r.peek(arguments),_=r.pick(d,!0);if("boolean"==typeof _)var g=h.add(l).divide(2),e=g.add(g.subtract(h).rotate(_?-90:90));else if(r.remain(arguments)<=2)e=l,l=c.read(arguments);else{var v=f.read(arguments),y=u.isZero;if(y(v.width)||y(v.height))return this.lineTo(l);var w=r.read(arguments),_=!!r.read(arguments),x=!!r.read(arguments),g=h.add(l).divide(2),b=h.subtract(g).rotate(-w),C=b.x,S=b.y,P=Math.abs,I=P(v.width),M=P(v.height),k=I*I,z=M*M,O=C*C,A=S*S,L=Math.sqrt(O/k+A/z);if(L>1&&(I*=L,M*=L,k=I*I,z=M*M),L=(k*z-k*A-z*O)/(k*A+z*O),P(L)<1e-12&&(L=0),L<0)throw new Error("Cannot create an arc with the given arguments");i=new c(I*S/M,-M*C/I).multiply((x===_?-1:1)*Math.sqrt(L)).rotate(w).add(g),a=(new p).translate(i).rotate(w).scale(I,M),s=a._inverseTransform(h),n=s.getDirectedAngle(a._inverseTransform(l)),!_&&n>0?n-=360:_&&n<0&&(n+=360)}if(e){var N=new m(h.add(e).divide(2),e.subtract(h).rotate(90),(!0)),B=new m(e.add(l).divide(2),l.subtract(e).rotate(90),(!0)),E=new m(h,l),D=E.getSide(e);if(i=N.intersect(B,!0),!i){if(!D)return this.lineTo(l);throw new Error("Cannot create an arc with the given arguments")}s=h.subtract(i),n=s.getDirectedAngle(l.subtract(i));var j=E.getSide(i);0===j?n=D*Math.abs(n):D===j&&(n+=n<0?360:-360)}for(var F=Math.abs(n),R=F>=360?4:Math.ceil(F/90),q=n/R,V=q*Math.PI/360,H=4/3*Math.sin(V)/(1+Math.cos(V)),Z=[],U=0;U<=R;U++){var b=l,W=null;if(U<R&&(W=s.rotate(90).multiply(H),a?(b=a._transformPoint(s),W=a._transformPoint(s.add(W)).subtract(b)):b=i.add(s)),0===U)o.setHandleOut(W);else{var G=s.rotate(-90).multiply(H);a&&(G=a._transformPoint(s.add(G)).subtract(b)),Z.push(new T(b,G,W))}s=s.rotate(q)}this._add(Z)},lineBy:function(){var e=c.read(arguments),i=t(this)._point;this.lineTo(i.add(e))},curveBy:function(){var e=c.read(arguments),i=c.read(arguments),n=r.read(arguments),s=t(this)._point;this.curveTo(s.add(e),s.add(i),n)},cubicCurveBy:function(){var e=c.read(arguments),i=c.read(arguments),n=c.read(arguments),r=t(this)._point;this.cubicCurveTo(r.add(e),r.add(i),r.add(n))},quadraticCurveBy:function(){var e=c.read(arguments),i=c.read(arguments),n=t(this)._point;this.quadraticCurveTo(n.add(e),n.add(i))},arcBy:function(){var e=t(this)._point,i=e.add(c.read(arguments)),n=r.pick(r.peek(arguments),!0);"boolean"==typeof n?this.arcTo(i,n):this.arcTo(i,e.add(c.read(arguments)))},closePath:function(t){this.setClosed(!0),this.join(this,t)}}},{_getBounds:function(t,e){var i=e.handle?"getHandleBounds":e.stroke?"getStrokeBounds":"getBounds";return L[i](this._segments,this._closed,this,t,e)},statics:{getBounds:function(t,e,i,n,r,s){function a(t){t._transformCoordinates(n,h);for(var e=0;e<2;e++)z._addBounds(u[e],u[e+4],h[e+2],h[e],e,s?s[e]:0,l,c,d);var i=u;u=h,h=i}var o=t[0];if(!o)return new g;for(var h=new Array(6),u=o._transformCoordinates(n,new Array(6)),l=u.slice(0,2),c=l.slice(),d=new Array(2),f=1,_=t.length;f<_;f++)a(t[f]);return e&&a(o),new g(l[0],l[1],c[0]-l[0],c[1]-l[1])},getStrokeBounds:function(t,e,i,n,r){function s(t){v=v.include(t)}function a(t){v=v.unite(x.setCenter(t._point.transform(n)))}function o(t,e){var i=t._handleIn,r=t._handleOut;"round"===e||!i.isZero()&&!r.isZero()&&i.isCollinear(r)?a(t):L._addBevelJoin(t,e,p,w,n,d,s)}function h(t,e){"round"===e?a(t):L._addSquareCap(t,e,p,n,d,s)}var u=i.getStyle(),l=u.hasStroke(),c=u.getStrokeWidth(),d=l&&i._getStrokeMatrix(n,r),_=l&&L._getStrokePadding(c,d),v=L.getBounds(t,e,i,n,r,_);if(!l)return v;for(var p=c/2,m=u.getStrokeJoin(),y=u.getStrokeCap(),w=p*u.getMiterLimit(),x=new g(new f(_)),b=t.length-(e?0:1),C=1;C<b;C++)o(t[C],m);return e?o(t[0],m):b>0&&(h(t[0],y),h(t[t.length-1],y)),v},_getStrokePadding:function(t,e){if(!e)return[t,t];
var i=new c(t,0).transform(e),n=new c(0,t).transform(e),r=i.getAngleInRadians(),s=i.getLength(),a=n.getLength(),o=Math.sin(r),h=Math.cos(r),u=Math.tan(r),l=Math.atan2(a*u,s),d=Math.atan2(a,u*s);return[Math.abs(s*Math.cos(l)*h+a*Math.sin(l)*o),Math.abs(a*Math.sin(d)*h+s*Math.cos(d)*o)]},_addBevelJoin:function(t,e,i,n,r,s,a,o){var h=t.getCurve(),u=h.getPrevious(),l=h.getPointAtTime(0),d=u.getNormalAtTime(1),f=h.getNormalAtTime(0),_=d.getDirectedAngle(f)<0?-i:i;if(d.setLength(_),f.setLength(_),r&&r._transformPoint(l,l),s&&(s._transformPoint(d,d),s._transformPoint(f,f)),o&&(a(l),a(l.add(d))),"miter"===e){var g=new m(l.add(d),new c((-d.y),d.x),(!0)).intersect(new m(l.add(f),new c((-f.y),f.x),(!0)),!0);if(g&&l.getDistance(g)<=n&&(a(g),!o))return}o||a(l.add(d)),a(l.add(f))},_addSquareCap:function(t,e,i,n,r,s,a){var o=t._point,h=t.getLocation(),u=h.getNormal().multiply(i);n&&n._transformPoint(o,o),r&&r._transformPoint(u,u),a&&(s(o.subtract(u)),s(o.add(u))),"square"===e&&(o=o.add(u.rotate(0===h.getTime()?-90:90))),s(o.add(u)),s(o.subtract(u))},getHandleBounds:function(t,e,i,n,r){var s,a,o=i.getStyle(),h=r.stroke&&o.hasStroke();if(h){var u=i._getStrokeMatrix(n,r),l=o.getStrokeWidth()/2,c=l;"miter"===o.getStrokeJoin()&&(c=l*o.getMiterLimit()),"square"===o.getStrokeCap()&&(c=Math.max(c,l*Math.sqrt(2))),s=L._getStrokePadding(l,u),a=L._getStrokePadding(c,u)}for(var d=new Array(6),f=1/0,_=-f,v=f,p=_,m=0,y=t.length;m<y;m++){var w=t[m];w._transformCoordinates(n,d);for(var x=0;x<6;x+=2){var b=0===x?a:s,C=b?b[0]:0,S=b?b[1]:0,P=d[x],I=d[x+1],M=P-C,T=P+C,k=I-S,z=I+S;M<f&&(f=M),T>_&&(_=T),k<v&&(v=k),z>p&&(p=z)}}return new g(f,v,_-f,p-v)}}});L.inject({statics:new function(){function t(t,e,i){var n=r.getNamed(i),s=new L(n&&n.insert===!1&&w.NO_INSERT);return s._add(t),s._closed=e,s.set(n)}function e(e,i,r){for(var s=new Array(4),a=0;a<4;a++){var o=n[a];s[a]=new T(o._point.multiply(i).add(e),o._handleIn.multiply(i),o._handleOut.multiply(i))}return t(s,!0,r)}var i=.5522847498307936,n=[new T([-1,0],[0,i],[0,-i]),new T([0,-1],[-i,0],[i,0]),new T([1,0],[0,-i],[0,i]),new T([0,1],[i,0],[-i,0])];return{Line:function(){return t([new T(c.readNamed(arguments,"from")),new T(c.readNamed(arguments,"to"))],!1,arguments)},Circle:function(){var t=c.readNamed(arguments,"center"),i=r.readNamed(arguments,"radius");return e(t,new f(i),arguments)},Rectangle:function(){var e,n=g.readNamed(arguments,"rectangle"),r=f.readNamed(arguments,"radius",0,{readNull:!0}),s=n.getBottomLeft(!0),a=n.getTopLeft(!0),o=n.getTopRight(!0),h=n.getBottomRight(!0);if(!r||r.isZero())e=[new T(s),new T(a),new T(o),new T(h)];else{r=f.min(r,n.getSize(!0).divide(2));var u=r.width,l=r.height,c=u*i,d=l*i;e=[new T(s.add(u,0),null,[-c,0]),new T(s.subtract(0,l),[0,d]),new T(a.add(0,l),null,[0,-d]),new T(a.add(u,0),[-c,0],null),new T(o.subtract(u,0),null,[c,0]),new T(o.add(0,l),[0,-d],null),new T(h.subtract(0,l),null,[0,d]),new T(h.subtract(u,0),[c,0])]}return t(e,!0,arguments)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=C._readEllipse(arguments);return e(t.center,t.radius,arguments)},Oval:"#Ellipse",Arc:function(){var t=c.readNamed(arguments,"from"),e=c.readNamed(arguments,"through"),i=c.readNamed(arguments,"to"),n=r.getNamed(arguments),s=new L(n&&n.insert===!1&&w.NO_INSERT);return s.moveTo(t),s.arcTo(e,i),s.set(n)},RegularPolygon:function(){for(var e=c.readNamed(arguments,"center"),i=r.readNamed(arguments,"sides"),n=r.readNamed(arguments,"radius"),s=360/i,a=i%3===0,o=new c(0,a?-n:n),h=a?-1:.5,u=new Array(i),l=0;l<i;l++)u[l]=new T(e.add(o.rotate((l+h)*s)));return t(u,!0,arguments)},Star:function(){for(var e=c.readNamed(arguments,"center"),i=2*r.readNamed(arguments,"points"),n=r.readNamed(arguments,"radius1"),s=r.readNamed(arguments,"radius2"),a=360/i,o=new c(0,(-1)),h=new Array(i),u=0;u<i;u++)h[u]=new T(e.add(o.rotate(a*u).multiply(u%2?s:n)));return t(h,!0,arguments)}}}});var N=A.extend({_class:"CompoundPath",_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function pt(t,i,n){for(var r=i.length-1;r>=0;r--){var s=i[r];s instanceof N&&(i=i.slice(),i.splice.apply(i,[r,1].concat(s.removeChildren())),s.remove())}i=pt.base.call(this,t,i,n,L);for(var r=0,a=!n&&i&&i.length;r<a;r++){var s=i[r];s._clockwise===e&&s.setClockwise(0===s._index)}return i},reduce:function mt(t){for(var e=this._children,i=e.length-1;i>=0;i--){var n=e[i].reduce(t);n.isEmpty()&&n.remove()}if(0===e.length){var n=new L(w.NO_INSERT);return n.copyAttributes(this),n.insertAbove(this),this.remove(),n}return mt.base.call(this)},isClockwise:function(){var t=this.getFirstChild();return t&&t.isClockwise()},setClockwise:function(t){this.isClockwise()^!!t&&this.reverse()},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],i=0,n=t.length;i<n;i++)e.push.apply(e,t[i].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getFirstCurve()},getArea:function(){for(var t=this._children,e=0,i=0,n=t.length;i<n;i++)e+=t[i].getArea();return e}},{beans:!0,getPathData:function(t,e){for(var i=this._children,n=[],r=0,s=i.length;r<s;r++){var a=i[r],o=a._matrix;n.push(a.getPathData(t&&!o.isIdentity()?t.appended(o):t,e))}return n.join(" ")}},{_hitTestChildren:function yt(t,e,i){return yt.base.call(this,t,e["class"]===L||"path"===e.type?e:r.set({},e,{fill:!1}),i)},_draw:function(t,e,i,n){var r=this._children;if(0!==r.length){e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var s=0,a=r.length;s<a;s++)r[s].draw(t,e,n);if(!e.clip){this._setStyles(t,e,i);var o=this._style;o.hasFill()&&(t.fill(o.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),o.hasStroke()&&t.stroke()}}},_drawSelected:function(t,e,i){for(var n=this._children,r=0,s=n.length;r<s;r++){var a=n[r],o=a._matrix;i[a._id]||a._drawSelected(t,o.isIdentity()?e:e.appended(o))}}},new function(){function t(t,e){var i=t._children;if(e&&0===i.length)throw new Error("Use a moveTo() command first");return i[i.length-1]}return r.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){this[e]=function(){var i=t(this,!0);i[e].apply(i,arguments)}},{moveTo:function(){var e=t(this),i=e&&e.isEmpty()?e:new L(w.NO_INSERT);i!==e&&this.addChild(i),i.moveTo.apply(i,arguments)},moveBy:function(){var e=t(this,!0),i=e&&e.getLastSegment(),n=c.read(arguments);this.moveTo(i?n.add(i._point):n)},closePath:function(e){t(this,!0).closePath(e)}})},r.each(["reverse","flatten","simplify","smooth"],function(t){this[t]=function(e){for(var i,n=this._children,r=0,s=n.length;r<s;r++)i=n[r][t](e)||i;return i}},{}));A.inject(new function(){function t(t,e){var i=t.clone(!1).reduce({simplify:!0}).transform(null,!0,!0);return e?i.resolveCrossings():i}function e(t,e,i,n,r){var s=new t(w.NO_INSERT);return s.addChildren(e,!0),i&&(s=s.reduce({simplify:!0})),s.insertAbove(r&&n.isSibling(r)&&n.getIndex()<r.getIndex()?r:n),s.copyAttributes(n,!0),s}function i(i,r,s){function o(t){for(var e=0,i=t.length;e<i;e++){var n=t[e];g.push.apply(g,n._segments),v.push.apply(v,n._getMonoCurves()),n._overlapsOnly=n._validOverlapsOnly=!0}}var u=d[s];if(u[s]=!0,!i._children&&!i._closed)return n(i,r,u);var c=t(i,!0),f=r&&i!==r&&t(r,!0);f&&(u.subtract||u.exclude)^(f.isClockwise()^c.isClockwise())&&f.reverse();var _=a(O.expand(c.getCrossings(f))),g=[],v=[];o(c._children||[c]),f&&o(f._children||[f]);for(var p=0,m=_.length;p<m;p++)h(_[p]._segment,c,f,v,u);for(var p=0,m=g.length;p<m;p++){var y=g[p],w=y._intersection;if(null==y._winding&&h(y,c,f,v,u),!w||!w._overlap){var x=y._path;x._overlapsOnly=!1,u[y._winding]&&(x._validOverlapsOnly=!1)}}return e(N,l(g,u),!0,i,r)}function n(i,n,r){function s(t){if(o.contains(t.getPointAt(t.getLength()/2))^u)return l.unshift(t),!0}if(!n||!n._children&&!n._closed||!r.subtract&&!r.intersect)return null;for(var a=t(i,!1),o=t(n,!1),h=a.getCrossings(o),u=r.subtract,l=[],c=h.length-1;c>=0;c--){var d=h[c].split();d&&(s(d)&&d.getFirstSegment().setHandleIn(0,0),a.getLastSegment().setHandleOut(0,0))}return s(a),e(x,l,!1,i,n)}function s(t,e){for(var i=t;i;){if(i===e)return;i=i._previous}for(;t._next&&t._next!==e;)t=t._next;if(!t._next){for(;e._previous;)e=e._previous;t._next=e,e._previous=t}}function a(t,e){for(var i,n,r=e&&[],a=4e-7,o=1-a,h=!1,u=[],l=t.length-1;l>=0;l--){var c=t[l];if(e){if(!e(c))continue;r.unshift(c)}var d,f=c._curve,_=c._time,g=_;if(f!==i?h=!f.hasHandles():n>=a&&n<=o&&(_/=n),_<a)d=f._segment1;else if(_>o)d=f._segment2;else{var v=f.divideAtTime(_,!0);h&&u.push(f,v),d=v._segment1}c._setSegment(d);var p=d._intersection,m=c._intersection;if(p){s(p,m);for(var y=p;y;)s(y._intersection,p),y=y._next}else d._intersection=m;i=f,n=g}for(var l=0,w=u.length;l<w;l++)u[l].clearHandles();return r||t}function o(t,e,i){var n=2e-7,r=t.x,s=t.y,a=0,h=0,u=e.length,l=[],d=Math.abs;if(i){for(var f=-(1/0),_=1/0,g=s-n,v=s+n,p=0;p<u;p++)for(var m=e[p].values,y=z.solveCubic(m,0,r,l,0,1),w=y-1;w>=0;w--){var x=z.getPoint(m,l[w]).y;x<g&&x>f?f=x:x>v&&x<_&&(_=x)}f=(f+s)/2,_=(_+s)/2,f>-(1/0)&&(a=o(new c(r,f),e).winding),_<1/0&&(h=o(new c(r,_),e).winding)}else{for(var b,C,S=r-n,P=r+n,I=0,M=0,T=!1,p=0;p<u;p++){var k=e[p],O=k.winding,m=k.values,A=m[1],L=m[7];if(k.last&&(b=k.last.winding,C=k.last.values[6],T=!1),s>=A&&s<=L||s>=L&&s<=A)if(O){var N=s===A?m[0]:s===L?m[6]:1===z.solveCubic(m,1,s,l,0,1)?z.getPoint(m,l[0]).x:null;null!=N&&(N>=S&&N<=P?T=!0:s===A&&O===b||s===A&&(r-N)*(r-C)<0||(N<S?a+=O:N>P&&(h+=O))),b=O,C=m[6]}else(r-m[0])*(r-m[6])<=0&&(T=!0);T&&(p>=u-1||e[p+1].last)&&(I+=1,M-=1)}0===a&&0===h&&(a=I,h=M)}return{winding:Math.max(d(a),d(h)),contour:!a^!h}}function h(t,e,i,n,r){var s,a=[],h=t,u=0;do{var l=t.getCurve(),c=l.getLength();a.push({segment:t,curve:l,length:c}),u+=c,t=t.getNext()}while(t&&!t._intersection&&t!==h);for(var c=u/2,d=0,f=a.length;d<f;d++){var _=a[d],g=_.length;if(c<=g){var l=_.curve,v=l._path,p=v._parent,m=l.getTimeAt(c),y=l.getPointAtTime(m),w=Math.abs(l.getTangentAtTime(m).y)<1e-7;p instanceof N&&(v=p),s=r.subtract&&i&&(v===e&&i._getWinding(y,w)||v===i&&!e._getWinding(y,w))?{winding:0}:o(y,n,w);break}c-=g}for(var d=a.length-1;d>=0;d--){var x=a[d].segment;x._winding=s.winding,x._contour=s.contour}}function l(t,e){function i(t,i){return!(!t||t._visited||!(!e||e[t._winding]||!i&&e.unite&&t._contour))}function n(t){return t===a||t===o}function s(t,r){if(!t._next)return t;for(;t;){var s=t._segment,a=s.getNext(),o=a&&a._intersection;if(s!==r&&(n(s)||n(a)||!s._visited&&!a._visited&&(!e||i(s)&&(i(a)||o&&i(o._segment)))))return t;t=t._next}return null}for(var a,o,h=[],l=0,c=t.length;l<c;l++){var d,f=null,_=!1,g=t[l],v=g._intersection;if(!g._visited&&g._path._overlapsOnly){var p=g._path,m=v._segment._path,y=p._segments,x=m._segments;if(r.equals(y,x)){(e.unite||e.intersect)&&p.getArea()&&h.push(p.clone(!1));for(var b=0,C=y.length;b<C;b++)y[b]._visited=x[b]._visited=!0}}if(i(g,!0)&&(g._path._validOverlapsOnly||!v||!v._overlap)){for(a=o=null;;){v=v&&s(v,g)||v;var S=v&&v._segment;if(n(g)?_=!0:S&&(n(S)?(_=!0,g=S):i(S,i(g,!0))&&(e&&(e.intersect||e.subtract)&&(g._visited=!0),g=S)),_||g._visited){g._visited=!0;break}if(g._path._validOverlapsOnly&&!i(g))break;f||(f=new L(w.NO_INSERT),a=g,o=S);var P=g.getNext();f.add(new T(g._point,d,P&&g._handleOut)),g._visited=!0,g=P||g._path.getFirstSegment(),d=P&&P._handleIn,v=g._intersection}if(_)f.firstSegment.setHandleIn(d),f.setClosed(!0);else if(f){var I=f.getArea(!0);Math.abs(I)>=2e-7&&console.error("Boolean operation resulted in open path","segments =",f._segments.length,"length =",f.getLength(),"area=",I),f=null}f&&(f._segments.length>8||!u.isZero(f.getArea()))&&(h.push(f),f=null)}}return h}var d={unite:{1:!0},intersect:{2:!0},subtract:{1:!0},exclude:{1:!0}};return{_getWinding:function(t,e){return o(t,this._getMonoCurves(),e).winding},unite:function(t){return i(this,t,"unite")},intersect:function(t){return i(this,t,"intersect")},subtract:function(t){return i(this,t,"subtract")},exclude:function(t){return i(this,t,"exclude")},divide:function(t){return e(x,[this.subtract(t),this.intersect(t)],!0,this,t)},resolveCrossings:function(){function t(t){var e=t&&t._intersection;return e&&e._overlap}var e=this._children,i=e||[this],n=!1,s=!1,o=this.getIntersections(null,function(t){return t._overlap&&(n=!0)||t.isCrossing()&&(s=!0)});if(o=O.expand(o),n)for(var h=a(o,function(t){return t._overlap}),u=h.length-1;u>=0;u--){var c=h[u]._segment,d=c.getPrevious(),f=c.getNext();if(c._path&&t(d)&&t(f)){c.remove(),d._handleOut.set(0,0),f._handleIn.set(0,0);var _=d.getCurve();_.isStraight()&&0===_.getLength()&&d.remove()}}s&&(a(o,n&&function(t){var e=t.getCurve(),i=t._intersection._curve,n=t._segment;return!!(e&&i&&e._path&&i._path)||void(n&&(n._intersection=null))}),i=l(r.each(i,function(t){this.push.apply(this,t._segments)},[])));var g,v=i.length;if(v>1){i=i.slice().sort(function(t,e){return e.getBounds().getArea()-t.getBounds().getArea()});for(var p=i[0],m=[p],y={},x="nonzero"===this.getFillRule(),b=x&&r.each(i,function(t){this.push(t.isClockwise()?1:-1)},[]),u=1;u<v;u++){for(var C=i[u],S=C.getInteriorPoint(),P=!1,I=null,M=!1,T=u-1;T>=0&&!I;T--)if(i[T].contains(S)){if(x&&!P&&(b[u]+=b[T],b[u]&&b[T])){M=y[u]=!0;break}P=!0,I=!y[T]&&i[T]}M||(C.setClockwise(I?!I.isClockwise():p.isClockwise()),m.push(C))}i=m,v=m.length}return v>1&&e?(i!==e&&this.setChildren(i,!0),g=this):1!==v||e||(i[0]!==this&&this.setSegments(i[0].removeSegments()),g=this),g||(g=new N(w.NO_INSERT),g.addChildren(i,!0),g=g.reduce(),g.copyAttributes(this),this.replaceWith(g)),g}}}),L.inject({_getMonoCurves:function(){function t(t){var e=t[1],r=t[7],s=Math.abs((e-r)/(t[0]-t[6]))<2e-7?0:e>r?-1:1,a={values:t,winding:s};n.push(a),s&&(i=a)}function e(e){if(0!==z.getLength(e)){var i=e[1],n=e[3],r=e[5],s=e[7];if(z.isStraight(e)||i>=n==n>=r&&n>=r==r>=s)t(e);else{var a=3*(n-r)-i+s,o=2*(i+r)-4*n,h=n-i,l=4e-7,c=1-l,d=[],f=u.solveQuadratic(a,o,h,d,l,c);if(f<1)t(e);else{d.sort();var _=d[0],g=z.subdivide(e,_);t(g[0]),f>1&&(_=(d[1]-_)/(1-_),g=z.subdivide(g[1],_),t(g[0])),t(g[1])}}}}var i,n=this._monoCurves;if(!n){n=this._monoCurves=[];for(var r=this.getCurves(),s=this._segments,a=0,o=r.length;a<o;a++)e(r[a].getValues());if(!this._closed&&s.length>1){var h=s[s.length-1]._point,l=s[0]._point,c=h._x,d=h._y,f=l._x,_=l._y;e([c,d,c,d,f,_,f,_])}n.length>0&&(n[0].last=i)}return n},getInteriorPoint:function(){var t=this.getBounds(),e=t.getCenter(!0);if(!this.contains(e)){for(var i=this._getMonoCurves(),n=[],r=e.y,s=[],a=0,o=i.length;a<o;a++){var h=i[a].values;if(1===i[a].winding&&r>h[1]&&r<=h[7]||r>=h[7]&&r<h[1])for(var u=z.solveCubic(h,1,r,n,0,1),l=u-1;l>=0;l--)s.push(z.getPoint(h,n[l]).x)}s.sort(function(t,e){return t-e}),e.x=(s[0]+s[1])/2}return e}}),N.inject({_getMonoCurves:function(){for(var t=this._children,e=[],i=0,n=t.length;i<n;i++)e.push.apply(e,t[i]._getMonoCurves());return e}});var B=r.extend({_class:"PathIterator",initialize:function(t,e,i,n,r){function s(t,e){var i=z.getValues(t,e,r);h.push(i),a(i,t._index,0,1)}function a(t,i,r,s){if(!(s-r>c)||n&&z.isStraight(t)||z.isFlatEnough(t,e||.25)){var o=t[6]-t[0],h=t[7]-t[1],d=Math.sqrt(o*o+h*h);d>0&&(l+=d,u.push({offset:l,curve:t,index:i,time:s}))}else{var f=z.subdivide(t,.5),_=(r+s)/2;a(f[0],i,r,_),a(f[1],i,_,s)}}for(var o,h=[],u=[],l=0,c=1/(i||32),d=t._segments,f=d[0],_=1,g=d.length;_<g;_++)o=d[_],s(f,o),f=o;t._closed&&s(o,d[0]),this.curves=h,this.parts=u,this.length=l,this.index=0},_get:function(t){for(var e,i=this.index;e=i,!(0===i||this.parts[--i].offset<t););for(var n=this.parts.length;e<n;e++){var r=this.parts[e];if(r.offset>=t){this.index=e;var s=this.parts[e-1],a=s&&s.index===r.index?s.time:0,o=s?s.offset:0;return{index:r.index,time:a+(r.time-a)*(t-o)/(r.offset-o)}}}var r=this.parts[this.parts.length-1];return{index:r.index,time:1}},drawPart:function(t,e,i){for(var n=this._get(e),r=this._get(i),s=n.index,a=r.index;s<=a;s++){var o=z.getPart(this.curves[s],s===n.index?n.time:0,s===r.index?r.time:1);s===n.index&&t.moveTo(o[0],o[1]),t.bezierCurveTo.apply(t,o.slice(2))}}},r.each(z._evaluateMethods,function(t){this[t+"At"]=function(e){var i=this._get(e);return z[t](this.curves[i.index],i.time)}},{})),E=r.extend({initialize:function(t){for(var e,i=this.points=[],n=t._segments,r=t._closed,s=0,a=n.length;s<a;s++){var o=n[s].point;e&&e.equals(o)||i.push(e=o.clone())}r&&(i.unshift(i[i.length-1]),i.push(i[1])),this.closed=r},fit:function(t){var e=this.points,i=e.length,n=null;return i>0&&(n=[new T(e[0])],i>1&&(this.fitCubic(n,t,0,i-1,e[1].subtract(e[0]),e[i-2].subtract(e[i-1])),this.closed&&(n.shift(),n.pop()))),n},fitCubic:function(t,e,i,n,r,s){var a=this.points;if(n-i===1){var o=a[i],h=a[n],u=o.getDistance(h)/3;return void this.addCurve(t,[o,o.add(r.normalize(u)),h.add(s.normalize(u)),h])}for(var l,c=this.chordLengthParameterize(i,n),d=Math.max(e,e*e),f=!0,_=0;_<=4;_++){var g=this.generateBezier(i,n,c,r,s),v=this.findMaxError(i,n,g,c);if(v.error<e&&f)return void this.addCurve(t,g);if(l=v.index,v.error>=d)break;f=this.reparameterize(i,n,c,g),d=v.error}var p=a[l-1].subtract(a[l+1]);this.fitCubic(t,e,i,l,r,p),this.fitCubic(t,e,l,n,p.negate(),s)},addCurve:function(t,e){var i=t[t.length-1];i.setHandleOut(e[1].subtract(e[0])),t.push(new T(e[3],e[2].subtract(e[3])))},generateBezier:function(t,e,i,n,r){for(var s=1e-12,a=Math.abs,o=this.points,h=o[t],u=o[e],l=[[0,0],[0,0]],c=[0,0],d=0,f=e-t+1;d<f;d++){var _=i[d],g=1-_,v=3*_*g,p=g*g*g,m=v*g,y=v*_,w=_*_*_,x=n.normalize(m),b=r.normalize(y),C=o[t+d].subtract(h.multiply(p+m)).subtract(u.multiply(y+w));l[0][0]+=x.dot(x),l[0][1]+=x.dot(b),l[1][0]=l[0][1],l[1][1]+=b.dot(b),c[0]+=x.dot(C),c[1]+=b.dot(C)}var S,P,I=l[0][0]*l[1][1]-l[1][0]*l[0][1];if(a(I)>s){var M=l[0][0]*c[1]-l[1][0]*c[0],T=c[0]*l[1][1]-c[1]*l[0][1];S=T/I,P=M/I}else{var k=l[0][0]+l[0][1],z=l[1][0]+l[1][1];S=P=a(k)>s?c[0]/k:a(z)>s?c[1]/z:0}var O,A,L=u.getDistance(h),N=s*L;if(S<N||P<N)S=P=L/3;else{var B=u.subtract(h);O=n.normalize(S),A=r.normalize(P),O.dot(B)-A.dot(B)>L*L&&(S=P=L/3,O=A=null)}return[h,h.add(O||n.normalize(S)),u.add(A||r.normalize(P)),u]},reparameterize:function(t,e,i,n){for(var r=t;r<=e;r++)i[r-t]=this.findRoot(n,this.points[r],i[r-t]);for(var r=1,s=i.length;r<s;r++)if(i[r]<=i[r-1])return!1;return!0},findRoot:function(t,e,i){for(var n=[],r=[],s=0;s<=2;s++)n[s]=t[s+1].subtract(t[s]).multiply(3);for(var s=0;s<=1;s++)r[s]=n[s+1].subtract(n[s]).multiply(2);var a=this.evaluate(3,t,i),o=this.evaluate(2,n,i),h=this.evaluate(1,r,i),u=a.subtract(e),l=o.dot(o)+u.dot(h);return Math.abs(l)<1e-6?i:i-u.dot(o)/l},evaluate:function(t,e,i){for(var n=e.slice(),r=1;r<=t;r++)for(var s=0;s<=t-r;s++)n[s]=n[s].multiply(1-i).add(n[s+1].multiply(i));return n[0]},chordLengthParameterize:function(t,e){for(var i=[0],n=t+1;n<=e;n++)i[n-t]=i[n-t-1]+this.points[n].getDistance(this.points[n-1]);for(var n=1,r=e-t;n<=r;n++)i[n]/=i[r];return i},findMaxError:function(t,e,i,n){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;a<e;a++){var o=this.evaluate(3,i,n[a-t]),h=o.subtract(this.points[a]),u=h.x*h.x+h.y*h.y;u>=s&&(s=u,r=a)}return{error:s,index:r}}}),D=w.extend({_class:"TextItem",_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsOptions:{stroke:!1,handle:!1},initialize:function(t){this._content="",this._lines=[];var i=t&&r.isPlainObject(t)&&t.x===e&&t.y===e;this._initialize(i&&t,!i&&c.read(arguments))},_equals:function(t){return this._content===t._content},copyContent:function(t){this.setContent(t._content)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(265)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),j=D.extend({_class:"PointText",initialize:function(){D.apply(this,arguments)},getPoint:function(){var t=this._matrix.getTranslation();return new d(t.x,t.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t,e,i){if(this._content){this._setStyles(t,e,i);var n=this._lines,r=this._style,s=r.hasFill(),a=r.hasStroke(),o=r.getLeading(),h=t.shadowColor;t.font=r.getFontStyle(),t.textAlign=r.getJustification();for(var u=0,l=n.length;u<l;u++){t.shadowColor=h;var c=n[u];s&&(t.fillText(c,0,0),t.shadowColor="rgba(0,0,0,0)"),a&&t.strokeText(c,0,0),t.translate(0,o)}}},_getBounds:function(t,e){var i=this._style,n=this._lines,r=n.length,s=i.getJustification(),a=i.getLeading(),o=this.getView().getTextWidth(i.getFontStyle(),n),h=0;"left"!==s&&(h-=o/("center"===s?2:1));var u=new g(h,r?-.75*a:0,o,r*a);return t?t._transformBounds(u,u):u}}),F=r.extend(new function(){function t(t){var n,r=t.match(/^#(\w{1,2})(\w{1,2})(\w{1,2})$/);if(r){n=[0,0,0];for(var s=0;s<3;s++){var o=r[s+1];n[s]=parseInt(1==o.length?o+o:o,16)/255}}else if(r=t.match(/^rgba?\((.*)\)$/)){n=r[1].split(",");for(var s=0,h=n.length;s<h;s++){var o=+n[s];n[s]=s<3?o/255:o}}else if(i){var u=a[t];if(!u){e||(e=Q.getContext(1,1),e.globalCompositeOperation="copy"),e.fillStyle="rgba(0,0,0,0)",e.fillStyle=t,e.fillRect(0,0,1,1);var l=e.getImageData(0,0,1,1).data;u=a[t]=[l[0]/255,l[1]/255,l[2]/255]}n=u.slice()}else n=[0,0,0];return n}var e,n={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},s={},a={},o=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],u={"rgb-hsb":function(t,e,i){var n=Math.max(t,e,i),r=Math.min(t,e,i),s=n-r,a=0===s?0:60*(n==t?(e-i)/s+(e<i?6:0):n==e?(i-t)/s+2:(t-e)/s+4);return[a,0===n?0:s/n,n]},"hsb-rgb":function(t,e,i){t=(t/60%6+6)%6;var n=Math.floor(t),r=t-n,n=o[n],s=[i,i*(1-e),i*(1-e*r),i*(1-e*(1-r))];return[s[n[0]],s[n[1]],s[n[2]]]},"rgb-hsl":function(t,e,i){var n=Math.max(t,e,i),r=Math.min(t,e,i),s=n-r,a=0===s,o=a?0:60*(n==t?(e-i)/s+(e<i?6:0):n==e?(i-t)/s+2:(t-e)/s+4),h=(n+r)/2,u=a?0:h<.5?s/(n+r):s/(2-n-r);return[o,u,h]},"hsl-rgb":function(t,e,i){if(t=(t/360%1+1)%1,0===e)return[i,i,i];for(var n=[t+1/3,t,t-1/3],r=i<.5?i*(1+e):i+e-i*e,s=2*i-r,a=[],o=0;o<3;o++){var h=n[o];h<0&&(h+=1),h>1&&(h-=1),a[o]=6*h<1?s+6*(r-s)*h:2*h<1?r:3*h<2?s+(r-s)*(2/3-h)*6:s}return a},"rgb-gray":function(t,e,i){return[.2989*t+.587*e+.114*i]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return r.each(n,function(t,e){s[e]=[],r.each(t,function(t,i){var a=r.capitalize(t),o=/^(hue|saturation)$/.test(t),h=s[e][i]="gradient"===t?function(t){var e=this._components[0];return t=R.read(Array.isArray(t)?t:arguments,0,{readNull:!0}),e!==t&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:"gradient"===e?function(){return c.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:t};this["get"+a]=function(){return this._type===e||o&&/^hs[bl]$/.test(this._type)?this._components[i]:this._convert(e)[i]},this["set"+a]=function(t){this._type===e||o&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(e),this._properties=n[e],this._type=e),this._components[i]=h.call(this,t),this._changed()}},this)},{_class:"Color",_readIndex:!0,initialize:function l(e){var i,r,a,o,h=Array.prototype.slice,u=arguments,c=this.__read,d=0;Array.isArray(e)&&(u=e,e=u[0]);var f=null!=e&&typeof e;if("string"===f&&e in n&&(i=e,e=u[1],Array.isArray(e)?(r=e,a=u[2]):(c&&(d=1),u=h.call(u,1),f=typeof e)),!r){if(o="number"===f?u:"object"===f&&null!=e.length?e:null){i||(i=o.length>=3?"rgb":"gray");var _=n[i].length;a=o[_],c&&(d+=o===arguments?_+(null!=a?1:0):1),o.length>_&&(o=h.call(o,0,_))}else if("string"===f)i="rgb",r=t(e),4===r.length&&(a=r[3],r.length--);else if("object"===f)if(e.constructor===l){if(i=e._type,r=e._components.slice(),a=e._alpha,"gradient"===i)for(var g=1,v=r.length;g<v;g++){var p=r[g];p&&(r[g]=p.clone())}}else if(e.constructor===R)i="gradient",o=u;else{i="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var m=n[i],y=s[i];this._components=r=[];for(var g=0,v=m.length;g<v;g++){var w=e[m[g]];null==w&&0===g&&"gradient"===i&&"stops"in e&&(w={stops:e.stops,radial:e.radial}),w=y[g].call(this,w),null!=w&&(r[g]=w)}a=e.alpha}c&&i&&(d=1)}if(this._type=i||"rgb",!r){this._components=r=[];for(var y=s[this._type],g=0,v=y.length;g<v;g++){var w=y[g].call(this,o&&o[g]);null!=w&&(r[g]=w)}}this._components=r,this._properties=n[this._type],this._alpha=a,c&&(this.__read=d)},_set:"#initialize",_serialize:function(t,e){var i=this.getComponents();return r.serialize(/^(gray|rgb)$/.test(this._type)?i:[this._type].concat(i),t,!0,e)},_changed:function(){this._canvasStyle=null,this._owner&&this._owner._changed(65)},_convert:function(t){var e;return this._type===t?this._components.slice():(e=u[this._type+"-"+t])?e.apply(this,this._components):u["rgb-"+t].apply(this,u[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new F(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=n[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var e=r.isPlainValue(t,!0)?F.read(arguments):t;return e===this||e&&this._class===e._class&&this._type===e._type&&this._alpha===e._alpha&&r.equals(this._components,e._components)||!1},toString:function(){for(var t=this._properties,e=[],i="gradient"===this._type,n=h.instance,r=0,s=t.length;r<s;r++){var a=this._components[r];null!=a&&e.push(t[r]+": "+(i?a:n.number(a)))}return null!=this._alpha&&e.push("alpha: "+n.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){function e(t){return Math.round(255*(t<0?0:t>1?1:t))}var i=this._convert("rgb"),n=t||null==this._alpha?1:this._alpha;return i=[e(i[0]),e(i[1]),e(i[2])],n<1&&i.push(n<0?0:n),t?"#"+((1<<24)+(i[0]<<16)+(i[1]<<8)+i[2]).toString(16).slice(1):(4==i.length?"rgba(":"rgb(")+i.join(",")+")"},toCanvasStyle:function(t){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var e,i=this._components,n=i[0],r=n._stops,s=i[1],a=i[2];if(n._radial){var o=a.getDistance(s),h=i[3];if(h){var u=h.subtract(s);u.getLength()>o&&(h=s.add(u.normalize(o-.1)))}var l=h||s;e=t.createRadialGradient(l.x,l.y,0,s.x,s.y,o)}else e=t.createLinearGradient(s.x,s.y,a.x,a.y);for(var c=0,d=r.length;c<d;c++){var f=r[c];e.addColorStop(f._offset||c/(d-1),f._color.toCanvasStyle())}return this._canvasStyle=e},transform:function(t){if("gradient"===this._type){for(var e=this._components,i=1,n=e.length;i<n;i++){var r=e[i];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:n,random:function(){var t=Math.random;return new F(t(),t(),t())}}})},new function(){var t={add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}};return r.each(t,function(t,e){this[e]=function(e){e=F.read(arguments);for(var i=this._type,n=this._components,r=e._convert(i),s=0,a=n.length;s<a;s++)r[s]=t(n[s],r[s]);return new F(i,r,null!=this._alpha?t(this._alpha,e.getAlpha()):null)}},{})}),R=r.extend({_class:"Gradient",initialize:function(t,e){this._id=l.get(),t&&this._set(t)&&(t=e=null),this._stops||this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._stops,this._radial],t,!0,e)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;t<e;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(t){var i=this._owners?this._owners.indexOf(t):-1;i!=-1&&(this._owners.splice(i,1),0===this._owners.length&&(this._owners=e))},clone:function(){for(var t=[],e=0,i=this._stops.length;e<i;e++)t[e]=this._stops[e].clone();return new R(t,this._radial)},getStops:function(){return this._stops},setStops:function(t){if(t.length<2)throw new Error("Gradient stop list needs to contain at least two stops.");var i=this._stops;if(i)for(var n=0,r=i.length;n<r;n++)i[n]._owner=e;i=this._stops=q.readAll(t,0,{clone:!0});for(var n=0,r=i.length;n<r;n++)i[n]._owner=this;this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class){var e=this._stops,i=t._stops,n=e.length;if(n===i.length){for(var r=0;r<n;r++)if(!e[r].equals(i[r]))return!1;return!0}}return!1}}),q=r.extend({_class:"GradientStop",initialize:function(t,i){var n=t,r=i;"object"==typeof t&&i===e&&(Array.isArray(t)&&"number"!=typeof t[0]?(n=t[0],r=t[1]):("color"in t||"offset"in t||"rampPoint"in t)&&(n=t.color,r=t.offset||t.rampPoint||0)),this.setColor(n),this.setOffset(r)},clone:function(){return new q(this._color.clone(),this._offset)},_serialize:function(t,e){var i=this._color,n=this._offset;return r.serialize(null==n?[i]:[i,n],t,!0,e)},_changed:function(){this._owner&&this._owner._changed(65)},getOffset:function(){return this._offset},setOffset:function(t){this._offset=t,this._changed()},getRampPoint:"#getOffset",setRampPoint:"#setOffset",getColor:function(){return this._color},setColor:function(){var t=F.read(arguments,0,{clone:!0});t&&(t._owner=this),this._color=t,this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._offset==t._offset||!1}}),V=r.extend(new function(){var t={fillColor:null,fillRule:"nonzero",strokeColor:null,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],shadowColor:null,shadowBlur:0,shadowOffset:new c,selectedColor:null},i=r.set({},t,{fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,leading:null,justification:"left"}),n=r.set({},i,{fillColor:new F}),s={strokeWidth:97,strokeCap:97,strokeJoin:97,strokeScaling:105,miterLimit:97,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},a={beans:!0},o={_class:"Style",beans:!0,initialize:function(e,r,s){this._values={},this._owner=r,this._project=r&&r._project||s||paper.project,this._defaults=!r||r instanceof x?i:r instanceof D?n:t,e&&this.set(e)}};return r.each(i,function(t,i){var n=/Color$/.test(i),h="shadowOffset"===i,u=r.capitalize(i),l=s[i],d="set"+u,f="get"+u;o[d]=function(t){var r=this._owner,s=r&&r._children;if(s&&s.length>0&&!(r instanceof N))for(var a=0,o=s.length;a<o;a++)s[a]._style[d](t);else if(i in this._defaults){var h=this._values[i];h!==t&&(n&&(h&&h._owner!==e&&(h._owner=e),t&&t.constructor===F&&(t._owner&&(t=t.clone()),t._owner=r)),this._values[i]=t,r&&r._changed(l||65))}},o[f]=function(t){var s,a=this._owner,o=a&&a._children;if(i in this._defaults&&(!o||0===o.length||t||a instanceof N)){var s=this._values[i];if(s===e)s=this._defaults[i],s&&s.clone&&(s=s.clone());else{var u=n?F:h?c:null;!u||s&&s.constructor===u||(this._values[i]=s=u.read([s],0,{readNull:!0,clone:!0}),s&&n&&(s._owner=a))}}else if(o)for(var l=0,d=o.length;l<d;l++){var _=o[l]._style[f]();if(0===l)s=_;else if(!r.equals(s,_))return e}return s},a[f]=function(t){return this._style[f](t)},a[d]=function(t){this._style[d](t)}}),r.each({Font:"FontFamily",WindingRule:"FillRule"},function(t,e){var i="get"+e,n="set"+e;o[i]=a[i]="#get"+t,o[n]=a[n]="#set"+t}),w.inject(a),o},{set:function(t){var e=t instanceof V,i=e?t._values:t;if(i)for(var n in i)if(n in this._defaults){var r=i[n];
this[n]=r&&e&&r.clone?r.clone():r}},equals:function(t){return t===this||t&&this._class===t._class&&r.equals(this._values,t._values)||!1},hasFill:function(){var t=this.getFillColor();return!!t&&t.alpha>0},hasStroke:function(){var t=this.getStrokeColor();return!!t&&t.alpha>0&&this.getStrokeWidth()>0},hasShadow:function(){var t=this.getShadowColor();return!!t&&t.alpha>0&&(this.getShadowBlur()>0||!this.getShadowOffset().isZero())},getView:function(){return this._project._view},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function wt(){var t=wt.base.call(this),e=this.getFontSize();return/pt|em|%|px/.test(e)&&(e=this.getView().getPixelSize(e)),null!=t?t:1.2*e}}),H=new function(){function t(t,e,i,n){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;a<6;a++){var o=r[a],h=o?o+s:e;if(h in t){if(!i)return t[h];t[h]=n;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,i=e&&e.defaultView;return i&&i.getComputedStyle(t,"")},getBounds:function(t,e){var i,n=t.ownerDocument,r=n.body,s=n.documentElement;try{i=t.getBoundingClientRect()}catch(a){i={left:0,top:0,width:0,height:0}}var o=i.left-(s.clientLeft||r.clientLeft||0),h=i.top-(s.clientTop||r.clientTop||0);if(!e){var u=n.defaultView;o+=u.pageXOffset||s.scrollLeft||r.scrollLeft,h+=u.pageYOffset||s.scrollTop||r.scrollTop}return new g(o,h,i.width,i.height)},getViewportBounds:function(t){var e=t.ownerDocument,i=e.defaultView,n=e.documentElement;return new g(0,0,i.innerWidth||n.clientWidth,i.innerHeight||n.clientHeight)},getOffset:function(t,e){return H.getBounds(t,e).getPoint()},getSize:function(t){return H.getBounds(t,!0).getSize()},isInvisible:function(t){return H.getSize(t).equals(new f(0,0))},isInView:function(t){return!H.isInvisible(t)&&H.getViewportBounds(t).intersects(H.getBounds(t,!0))},isInserted:function(t){return n.body.contains(t)},getPrefixed:function(e,i){return e&&t(e,i)},setPrefixed:function(e,i,n){if("object"==typeof i)for(var r in i)t(e,r,!0,i[r]);else t(e,i,!0,n)}}},Z={add:function(t,e){if(t)for(var i in e)for(var n=e[i],r=i.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.addEventListener(r[s],n,!1)},remove:function(t,e){if(t)for(var i in e)for(var n=e[i],r=i.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.removeEventListener(r[s],n,!1)},getPoint:function(t){var e=t.targetTouches?t.targetTouches.length?t.targetTouches[0]:t.changedTouches[0]:t;return new c(e.pageX||e.clientX+n.documentElement.scrollLeft,e.pageY||e.clientY+n.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return Z.getPoint(t).subtract(H.getOffset(e||Z.getTarget(t)))}};Z.requestAnimationFrame=new function(){function t(){var e=s;s=[];for(var i=0,a=e.length;i<a;i++)e[i]();r=n&&s.length,r&&n(t)}var e,n=H.getPrefixed(i,"requestAnimationFrame"),r=!1,s=[];return function(i){s.push(i),n?r||(n(t),r=!0):e||(e=setInterval(t,1e3/60))}};var U=r.extend(s,{_class:"View",initialize:function xt(t,e){function r(t){return e[t]||parseInt(e.getAttribute(t),10)}function s(){var t=H.getSize(e);return t.isNaN()||t.isZero()?new f(r("width"),r("height")):t}var o;if(i&&e){this._id=e.getAttribute("id"),null==this._id&&e.setAttribute("id",this._id="view-"+xt._id++),Z.add(e,this._viewEvents);var h="none";if(H.setPrefixed(e.style,{userDrag:h,userSelect:h,touchCallout:h,contentZooming:h,tapHighlightColor:"rgba(0,0,0,0)"}),a.hasAttribute(e,"resize")){var u=this;Z.add(i,this._windowEvents={resize:function(){u.setViewSize(s())}})}if(o=s(),a.hasAttribute(e,"stats")&&"undefined"!=typeof Stats){this._stats=new Stats;var l=this._stats.domElement,c=l.style,d=H.getOffset(e);c.position="absolute",c.left=d.x+"px",c.top=d.y+"px",n.body.appendChild(l)}}else o=new f(e),e=null;this._project=t,this._scope=t._scope,this._element=e,this._pixelRatio||(this._pixelRatio=i&&i.devicePixelRatio||1),this._setElementSize(o.width,o.height),this._viewSize=o,xt._views.push(this),xt._viewsById[this._id]=this,(this._matrix=new p)._owner=this,this._zoom=1,xt._focused||(xt._focused=this),this._frameItems={},this._frameItemCount=0,this._itemEvents={"native":{},virtual:{}},this._autoUpdate=!paper.agent.node,this._needsUpdate=!1},remove:function(){if(!this._project)return!1;U._focused===this&&(U._focused=null),U._views.splice(U._views.indexOf(this),1),delete U._viewsById[this._id];var t=this._project;return t._view===this&&(t._view=null),Z.remove(this._element,this._viewEvents),Z.remove(i,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0},_events:r.each(w._itemHandlers.concat(["onResize","onKeyDown","onKeyUp"]),function(t){this[t]={}},{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}}}),_animate:!1,_time:0,_count:0,getAutoUpdate:function(){return this._autoUpdate},setAutoUpdate:function(t){this._autoUpdate=t,t&&this.requestUpdate()},update:function(){},draw:function(){this.update()},requestUpdate:function(){if(!this._requested){var t=this;Z.requestAnimationFrame(function(){if(t._requested=!1,t._animate){t.requestUpdate();var e=t._element;H.getPrefixed(n,"hidden")&&"true"!==a.getAttribute(e,"keepalive")||!H.isInView(e)||t._handleFrame()}t._autoUpdate&&t.update()}),this._requested=!0}},play:function(){this._animate=!0,this.requestUpdate()},pause:function(){this._animate=!1},_handleFrame:function(){paper=this._scope;var t=Date.now()/1e3,e=this._last?t-this._last:0;this._last=t,this.emit("frame",new r({delta:e,time:this._time+=e,count:this._count++})),this._stats&&this._stats.update()},_animateItem:function(t,e){var i=this._frameItems;e?(i[t._id]={item:t,time:0,count:0},1===++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete i[t._id],0===--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var e in this._frameItems){var i=this._frameItems[e];i.item.emit("frame",new r(t,{time:i.time+=t.delta,count:i.count++}))}},_changed:function(){this._project._changed(2049),this._bounds=null},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new _(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=f.read(arguments),e=t.width,i=t.height,n=t.subtract(this._viewSize);n.isZero()||(this._setElementSize(e,i),this._viewSize.set(e,i),this.emit("resize",{size:t,delta:n}),this._changed(),this._autoUpdate&&this.requestUpdate())},_setElementSize:function(t,e){var i=this._element;i&&(i.width!==t&&(i.width=t),i.height!==e&&(i.height=e))},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new g(new c,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=c.read(arguments);this.translate(this.getCenter().subtract(t))},getZoom:function(){return this._zoom},setZoom:function(t){this.transform((new p).scale(t/this._zoom,this.getCenter())),this._zoom=t},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},isVisible:function(){return H.isInView(this._element)},isInserted:function(){return H.isInserted(this._element)},getPixelSize:function(t){var e,i=this._element;if(i){var r=i.parentNode,s=n.createElement("div");s.style.fontSize=t,r.appendChild(s),e=parseFloat(H.getStyles(s).fontSize),r.removeChild(s)}else e=parseFloat(e);return e},getTextWidth:function(t,e){return 0}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var i=(e?r:c).read(arguments),n=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](i,n||this.getCenter(!0)))}},{translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},transform:function(t){this._matrix.append(t)},scrollBy:function(){this.translate(c.read(arguments).negate())}}),{projectToView:function(){return this._matrix._transformPoint(c.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(c.read(arguments))},getEventPoint:function(t){return this.viewToProject(Z.getOffset(t,this._element))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){n&&"string"==typeof e&&(e=n.getElementById(e));var r=i?W:U;return new r(t,e)}}},new function(){function t(t){var e=Z.getTarget(t);return e.getAttribute&&U._viewsById[e.getAttribute("id")]}function e(){var t=U._focused;if(!t||!t.isVisible())for(var e=0,i=U._views.length;e<i;e++)if((t=U._views[e]).isVisible()){U._focused=h=t;break}}function r(t,e,i){t._handleMouseEvent("mousemove",e,i)}function s(t,e,i,n,r,s,a){function o(t,i){if(t.responds(i)){if(h||(h=new Y(i,n,r,e||t,s?r.subtract(s):null)),t.emit(i,h)&&(I=!0,h.prevented&&(M=!0),h.stopped))return u=!0}else{var a=T[i];if(a)return o(t,a)}}for(var h,u=!1;t&&t!==a&&!o(t,i);)t=t._parent;return u}function a(t,e,i,n,r,a){return t._project.removeOn(i),M=I=!1,b&&s(b,null,i,n,r,a)||e&&e!==b&&!e.isDescendant(b)&&s(e,null,T[i]||i,n,r,a,b)||s(t,b||e||t,i,n,r,a)}if(i){var o,h,u,l,c,d=!1,f=!1,_=i.navigator;_.pointerEnabled||_.msPointerEnabled?(u="pointerdown MSPointerDown",l="pointermove MSPointerMove",c="pointerup pointercancel MSPointerUp MSPointerCancel"):(u="touchstart",l="touchmove",c="touchend touchcancel","ontouchstart"in i&&_.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(u+=" mousedown",l+=" mousemove",c+=" mouseup"));var g={},v={mouseout:function(t){var e=U._focused,i=Z.getRelatedTarget(t);if(e&&(!i||"HTML"===i.nodeName)){var n=Z.getOffset(t,e._element),s=n.x,a=Math.abs,o=a(s),h=1<<25,u=o-h;n.x=a(u)<o?u*(s<0?-1:1):s,r(e,t,e.viewToProject(n))}},scroll:e};g[u]=function(e){var i=U._focused=t(e);d||(d=!0,i._handleMouseEvent("mousedown",e))},v[l]=function(i){var n=U._focused;if(!f){var s=t(i);s?n!==s&&(n&&r(n,i),o||(o=n),n=U._focused=h=s):h&&h===n&&(o&&!o.isInserted()&&(o=null),n=U._focused=o,o=null,e())}n&&r(n,i)},v[u]=function(){f=!0},v[c]=function(t){var e=U._focused;e&&d&&e._handleMouseEvent("mouseup",t),f=d=!1},Z.add(n,v),Z.add(i,{load:e});var p,m,y,w,x,b,C,S,P,I=!1,M=!1,T={doubleclick:"click",mousedrag:"mousemove"},k=!1,z={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}};return{_viewEvents:g,_handleMouseEvent:function(t,e,i){function n(t){return r.virtual[t]||l.responds(t)||u&&u.responds(t)}var r=this._itemEvents,o=r["native"][t],h="mousemove"===t,u=this._scope.tool,l=this;h&&d&&n("mousedrag")&&(t="mousedrag"),i||(i=this.getEventPoint(e));var c=this.getBounds().contains(i),f=o&&c&&l._project.hitTest(i,{tolerance:0,fill:!0,stroke:!0}),_=f&&f.item||null,g=!1,v={};v[t.substr(5)]=!0,o&&_!==x&&(x&&s(x,null,"mouseleave",e,i),_&&s(_,null,"mouseenter",e,i),x=_),k^c&&(s(this,null,c?"mouseenter":"mouseleave",e,i),p=c?this:null,g=!0),!c&&!v.drag||i.equals(y)||(a(this,_,h?t:"mousemove",e,i,y),g=!0),k=c,(v.down&&c||v.up&&m)&&(a(this,_,t,e,i,m),v.down?(P=_===C&&Date.now()-S<300,w=C=_,b=!M&&_,m=i):v.up&&(M||_!==w||(S=Date.now(),a(this,_,P?"doubleclick":"click",e,i,m),P=!1),w=b=null),k=!1,g=!0),y=i,g&&u&&(I=u._handleMouseEvent(t,e,i,v)||I),(I&&!v.move||v.down&&n("mouseup"))&&e.preventDefault()},_handleKeyEvent:function(t,e,i,n){function r(r){r.responds(t)&&(paper=a,r.emit(t,s=s||new J(t,e,i,n)))}var s,a=this._scope,o=a.tool;this.isVisible()&&(r(this),o&&o.responds(t)&&r(o))},_countItemEvent:function(t,e){var i=this._itemEvents,n=i["native"],r=i.virtual;for(var s in z)n[s]=(n[s]||0)+(z[s][t]||0)*e;r[t]=(r[t]||0)+e},statics:{updateFocus:e}}}}),W=U.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof i.HTMLCanvasElement)){var n=f.read(arguments,1);if(n.isZero())throw new Error("Cannot create CanvasView with the provided argument: "+[].slice.call(arguments,1));e=Q.getCanvas(n)}var r=this._context=e.getContext("2d");if(r.save(),this._pixelRatio=1,!/^off|false$/.test(a.getAttribute(e,"hidpi"))){var s=i.devicePixelRatio||1,o=H.getPrefixed(r,"backingStorePixelRatio")||1;this._pixelRatio=s/o}U.call(this,t,e),this._needsUpdate=!0},remove:function bt(){return this._context.restore(),bt.base.call(this)},_setElementSize:function Ct(t,e){var i=this._pixelRatio;if(Ct.base.call(this,t*i,e*i),1!==i){var n=this._element,r=this._context;if(!a.hasAttribute(n,"resize")){var s=n.style;s.width=t+"px",s.height=e+"px"}r.restore(),r.save(),r.scale(i,i)}},getPixelSize:function St(t){var e,i=paper.agent;if(i&&i.firefox)e=St.base.call(this,t);else{var n=this._context,r=n.font;n.font=t+" serif",e=parseFloat(n.font),n.font=r}return e},getTextWidth:function(t,e){var i=this._context,n=i.font,r=0;i.font=t;for(var s=0,a=e.length;s<a;s++)r=Math.max(r,i.measureText(e[s]).width);return i.font=n,r},update:function(){if(!this._needsUpdate)return!1;var t=this._project,e=this._context,i=this._viewSize;return e.clearRect(0,0,i.width+1,i.height+1),t&&t.draw(e,this._matrix,this._pixelRatio),this._needsUpdate=!1,!0}}),G=r.extend({_class:"Event",initialize:function(t){this.event=t,this.type=t&&t.type},prevented:!1,stopped:!1,preventDefault:function(){this.prevented=!0,this.event.preventDefault()},stopPropagation:function(){this.stopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getTimeStamp:function(){return this.event.timeStamp},getModifiers:function(){return X.modifiers}}),J=G.extend({_class:"KeyEvent",initialize:function(t,e,i,n){this.type=t,this.event=e,this.key=i,this.character=n},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),X=new function(){function t(t){var e=t.key||t.keyIdentifier;return e=/^U\+/.test(e)?String.fromCharCode(parseInt(e.substr(2),16)):/^Arrow[A-Z]/.test(e)?e.substr(5):"Unidentified"===e?String.fromCharCode(t.keyCode):e,o[e]||(e.length>1?r.hyphenate(e):e.toLowerCase())}function e(t,i,n,a){var o,h=U._focused;if(u[i]=t,t?l[i]=n:delete l[i],i.length>1&&(o=r.camelize(i))in c){c[o]=t;var d=paper&&paper.agent;if("meta"===o&&d&&d.mac)if(t)s={};else{for(var f in s)f in l&&e(!1,f,s[f],a);s=null}}else t&&s&&(s[i]=n);h&&h._handleKeyEvent(t?"keydown":"keyup",a,i,n)}var s,a,o={"\t":"tab"," ":"space","\b":"backspace","\x7f":"delete",Spacebar:"space",Del:"delete",Win:"meta",Esc:"escape"},h={tab:"\t",space:" ",enter:"\r"},u={},l={},c=new r({shift:!1,control:!1,alt:!1,meta:!1,capsLock:!1,space:!1}).inject({option:{get:function(){return this.alt}},command:{get:function(){var t=paper&&paper.agent;return t&&t.mac?this.meta:this.control}}});return Z.add(n,{keydown:function(i){var n=t(i),r=paper&&paper.agent;n.length>1||r&&r.chrome&&(i.altKey||r.mac&&i.metaKey||!r.mac&&i.ctrlKey)?e(!0,n,h[n]||(n.length>1?"":n),i):a=n},keypress:function(i){if(a){var n=t(i),r=i.charCode,s=r>=32?String.fromCharCode(r):n.length>1?"":n;n!==a&&(n=s.toLowerCase()),e(!0,n,s,i),a=null}},keyup:function(i){var n=t(i);n in l&&e(!1,n,l[n],i)}}),Z.add(i,{blur:function(t){for(var i in l)e(!1,i,l[i],t)}}),{modifiers:c,isDown:function(t){return!!u[t]}}},Y=G.extend({_class:"MouseEvent",initialize:function(t,e,i,n,r){this.type=t,this.event=e,this.point=i,this.target=n,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),$=G.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,i){this.tool=t,this.type=e,this.event=i},_choosePoint:function(t,e){return t?t:e?e.clone():null},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return this.tool[/^mouse(down|up)$/.test(this.type)?"_downCount":"_moveCount"]},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,i=e._parent;/^(Group|CompoundPath)$/.test(i._class);)e=i,i=i._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"}}),K=(o.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onActivate","onDeactivate","onEditOptions","onKeyDown","onKeyUp"],initialize:function(t){o.call(this),this._moveCount=-1,this._downCount=-1,this._set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){this._minDistance=t,null!=t&&null!=this._maxDistance&&t>this._maxDistance&&(this._maxDistance=t)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=t&&t<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=this._maxDistance=t},_handleMouseEvent:function(t,e,i,n){function r(t,e){var r=i,s=a?c._point:c._downPoint||r;if(a){if(c._moveCount&&r.equals(s))return!1;if(s&&(null!=t||null!=e)){var o=r.subtract(s),h=o.getLength();if(h<(t||0))return!1;e&&(r=s.add(o.normalize(Math.min(h,e))))}c._moveCount++}return c._point=r,c._lastPoint=s||r,n.down&&(c._moveCount=-1,c._downPoint=r,c._downCount++),!0}function s(){o&&(l=c.emit(t,new $(c,t,e))||l)}paper=this._scope,n.drag&&!this.responds(t)&&(t="mousemove");var a=n.move||n.drag,o=this.responds(t),h=this.minDistance,u=this.maxDistance,l=!1,c=this;if(n.down)r(),s();else if(n.up)r(null,u),s();else if(o)for(;r(h,u);)s();return l}}),{request:function(t){var e=new i.XMLHttpRequest;return e.open((t.method||"get").toUpperCase(),t.url,r.pick(t.async,!0)),t.mimeType&&e.overrideMimeType(t.mimeType),e.onload=function(){var i=e.status;0===i||200===i?t.onLoad&&t.onLoad.call(e,e.responseText):e.onerror()},e.onerror=function(){var i=e.status,n='Could not load "'+t.url+'" (Status: '+i+")";if(!t.onError)throw new Error(n);t.onError(n,i)},e.send(null)}}),Q={canvases:[],getCanvas:function(t,e){if(!i)return null;var r,s=!0;"object"==typeof t&&(e=t.height,t=t.width),this.canvases.length?r=this.canvases.pop():(r=n.createElement("canvas"),s=!1);var a=r.getContext("2d");if(!a)throw new Error("Canvas "+r+" is unable toprovide a 2D context.");return r.width===t&&r.height===e?s&&a.clearRect(0,0,t+1,e+1):(r.width=t,r.height=e),a.save(),r},getContext:function(t,e){var i=this.getCanvas(t,e);return i?i.getContext("2d"):null},release:function(t){var e=t&&t.canvas?t.canvas:t;e&&e.getContext&&(e.getContext("2d").restore(),this.canvases.push(e))}},tt=new function(){function t(t,e,i){return.2989*t+.587*e+.114*i}function e(e,i,n,r){var s=r-t(e,i,n);f=e+s,_=i+s,g=n+s;var r=t(f,_,g),a=v(f,_,g),o=p(f,_,g);if(a<0){var h=r-a;f=r+(f-r)*r/h,_=r+(_-r)*r/h,g=r+(g-r)*r/h}if(o>255){var u=255-r,l=o-r;f=r+(f-r)*u/l,_=r+(_-r)*u/l,g=r+(g-r)*u/l}}function i(t,e,i){return p(t,e,i)-v(t,e,i)}function n(t,e,i,n){var r,s=[t,e,i],a=p(t,e,i),o=v(t,e,i);o=o===t?0:o===e?1:2,a=a===t?0:a===e?1:2,r=0===v(o,a)?1===p(o,a)?2:1:0,s[a]>s[o]?(s[r]=(s[r]-s[o])*n/(s[a]-s[o]),s[a]=n):s[r]=s[a]=0,s[o]=0,f=s[0],_=s[1],g=s[2]}var s,a,o,h,u,l,c,d,f,_,g,v=Math.min,p=Math.max,m=Math.abs,y={multiply:function(){f=u*s/255,_=l*a/255,g=c*o/255},screen:function(){f=u+s-u*s/255,_=l+a-l*a/255,g=c+o-c*o/255},overlay:function(){f=u<128?2*u*s/255:255-2*(255-u)*(255-s)/255,_=l<128?2*l*a/255:255-2*(255-l)*(255-a)/255,g=c<128?2*c*o/255:255-2*(255-c)*(255-o)/255},"soft-light":function(){var t=s*u/255;f=t+u*(255-(255-u)*(255-s)/255-t)/255,t=a*l/255,_=t+l*(255-(255-l)*(255-a)/255-t)/255,t=o*c/255,g=t+c*(255-(255-c)*(255-o)/255-t)/255},"hard-light":function(){f=s<128?2*s*u/255:255-2*(255-s)*(255-u)/255,_=a<128?2*a*l/255:255-2*(255-a)*(255-l)/255,g=o<128?2*o*c/255:255-2*(255-o)*(255-c)/255},"color-dodge":function(){f=0===u?0:255===s?255:v(255,255*u/(255-s)),_=0===l?0:255===a?255:v(255,255*l/(255-a)),g=0===c?0:255===o?255:v(255,255*c/(255-o))},"color-burn":function(){f=255===u?255:0===s?0:p(0,255-255*(255-u)/s),_=255===l?255:0===a?0:p(0,255-255*(255-l)/a),g=255===c?255:0===o?0:p(0,255-255*(255-c)/o)},darken:function(){f=u<s?u:s,_=l<a?l:a,g=c<o?c:o},lighten:function(){f=u>s?u:s,_=l>a?l:a,g=c>o?c:o},difference:function(){f=u-s,f<0&&(f=-f),_=l-a,_<0&&(_=-_),g=c-o,g<0&&(g=-g)},exclusion:function(){f=u+s*(255-u-u)/255,_=l+a*(255-l-l)/255,g=c+o*(255-c-c)/255},hue:function(){n(s,a,o,i(u,l,c)),e(f,_,g,t(u,l,c))},saturation:function(){n(u,l,c,i(s,a,o)),e(f,_,g,t(u,l,c))},luminosity:function(){e(u,l,c,t(s,a,o))},color:function(){e(s,a,o,t(u,l,c))},add:function(){f=v(u+s,255),_=v(l+a,255),g=v(c+o,255)},subtract:function(){f=p(u-s,0),_=p(l-a,0),g=p(c-o,0)},average:function(){f=(u+s)/2,_=(l+a)/2,g=(c+o)/2},negation:function(){f=255-m(255-s-u),_=255-m(255-a-l),g=255-m(255-o-c)}},w=this.nativeModes=r.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),x=Q.getContext(1,1);x&&(r.each(y,function(t,e){var i="darken"===e,n=!1;x.save();try{x.fillStyle=i?"#300":"#a00",x.fillRect(0,0,1,1),x.globalCompositeOperation=e,x.globalCompositeOperation===e&&(x.fillStyle=i?"#a00":"#300",x.fillRect(0,0,1,1),n=x.getImageData(0,0,1,1).data[0]!==i?170:51)}catch(r){}x.restore(),w[e]=n}),Q.release(x)),this.process=function(t,e,i,n,r){var v=e.canvas,p="normal"===t;if(p||w[t])i.save(),i.setTransform(1,0,0,1,0,0),i.globalAlpha=n,p||(i.globalCompositeOperation=t),i.drawImage(v,r.x,r.y),i.restore();else{var m=y[t];if(!m)return;for(var x=i.getImageData(r.x,r.y,v.width,v.height),b=x.data,C=e.getImageData(0,0,v.width,v.height).data,S=0,P=b.length;S<P;S+=4){s=C[S],u=b[S],a=C[S+1],l=b[S+1],o=C[S+2],c=b[S+2],h=C[S+3],d=b[S+3],m();var I=h*n/255,M=1-I;b[S]=I*f+M*u,b[S+1]=I*_+M*l,b[S+2]=I*g+M*c,b[S+3]=h*n+M*d}i.putImageData(x,r.x,r.y)}}},et=new function(){function t(t,e,s){return i(n.createElementNS(r,t),e,s)}function e(t,e){var i=o[e],n=i?t.getAttributeNS(i,e):t.getAttribute(e);return"null"===n?null:n}function i(t,e,i){for(var n in e){var r=e[n],s=o[n];"number"==typeof r&&i&&(r=i.number(r)),s?t.setAttributeNS(s,n,r):t.setAttribute(n,r)}return t}var r="http://www.w3.org/2000/svg",s="http://www.w3.org/2000/xmlns",a="http://www.w3.org/1999/xlink",o={href:a,xlink:s,xmlns:s+"/","xmlns:xlink":s+"/"};return{svg:r,xmlns:s,xlink:a,create:t,get:e,set:i}},it=r.each({fillColor:["fill","color"],fillRule:["fill-rule","string"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{"true":"none","false":"non-scaling-stroke"},function(t,e){return!e&&(t instanceof A||t instanceof C||t instanceof D)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","style"]},function(t,e){var i=r.capitalize(e),n=t[2];this[e]={type:t[1],property:e,attribute:t[0],toSVG:n,fromSVG:n&&r.each(n,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+i,set:"set"+i}},{});return new function(){function t(t,e,i){var n=new r,s=t.getTranslation();if(e){t=t._shiftless();var a=t._inverseTransform(s);n[i?"cx":"x"]=a.x,n[i?"cy":"y"]=a.y,s=null}if(!t.isIdentity()){var o=t.decompose();if(o){var h=[],l=o.rotation,c=o.scaling,d=o.skewing;s&&!s.isZero()&&h.push("translate("+S.point(s)+")"),l&&h.push("rotate("+S.number(l)+")"),u.isZero(c.x-1)&&u.isZero(c.y-1)||h.push("scale("+S.point(c)+")"),d&&d.x&&h.push("skewX("+S.number(d.x)+")"),d&&d.y&&h.push("skewY("+S.number(d.y)+")"),n.transform=h.join(" ")}else n.transform="matrix("+t.getValues().join(",")+")"}return n}function e(e,i){for(var n=t(e._matrix),r=e._children,s=et.create("g",n,S),a=0,o=r.length;a<o;a++){var h=r[a],u=b(h,i);if(u)if(h.isClipMask()){var l=et.create("clipPath");l.appendChild(u),m(h,l,"clip"),et.set(s,{"clip-path":"url(#"+l.id+")"})}else s.appendChild(u)}return s}function n(e,i){var n=t(e._matrix,!0),r=e.getSize(),s=e.getImage();return n.x-=r.width/2,n.y-=r.height/2,n.width=r.width,n.height=r.height,n.href=i.embedImages===!1&&s&&s.src||e.toDataURL(),et.create("image",n,S)}function s(e,i){var n=i.matchShapes;if(n){var r=e.toShape(!1);if(r)return a(r,i)}var s,o=e._segments,h=o.length,u=t(e._matrix);if(n&&h>=2&&!e.hasHandles())if(h>2){s=e._closed?"polygon":"polyline";for(var l=[],c=0;c<h;c++)l.push(S.point(o[c]._point));u.points=l.join(" ")}else{s="line";var d=o[0]._point,f=o[1]._point;u.set({x1:d.x,y1:d.y,x2:f.x,y2:f.y})}else s="path",u.d=e.getPathData(null,i.precision);return et.create(s,u,S)}function a(e){var i=e._type,n=e._radius,r=t(e._matrix,!0,"rectangle"!==i);if("rectangle"===i){i="rect";var s=e._size,a=s.width,o=s.height;r.x-=a/2,r.y-=o/2,r.width=a,r.height=o,n.isZero()&&(n=null)}return n&&("circle"===i?r.r=n:(r.rx=n.width,r.ry=n.height)),et.create(i,r,S)}function o(e,i){var n=t(e._matrix),r=e.getPathData(null,i.precision);return r&&(n.d=r),et.create("path",n,S)}function c(e,i){var n=t(e._matrix,!0),r=e._definition,s=v(r,"symbol"),a=r._item,o=a.getBounds();return s||(s=et.create("symbol",{viewBox:S.rectangle(o)}),s.appendChild(b(a,i)),m(r,s,"symbol")),n.href="#"+s.id,n.x+=o.x,n.y+=o.y,n.width=o.width,n.height=o.height,n.overflow="visible",et.create("use",n,S)}function d(t){var e=v(t,"color");if(!e){var i,n=t.getGradient(),r=n._radial,s=t.getOrigin(),a=t.getDestination();if(r){i={cx:s.x,cy:s.y,r:s.getDistance(a)};var o=t.getHighlight();o&&(i.fx=o.x,i.fy=o.y)}else i={x1:s.x,y1:s.y,x2:a.x,y2:a.y};i.gradientUnits="userSpaceOnUse",e=et.create((r?"radial":"linear")+"Gradient",i,S);for(var h=n._stops,u=0,l=h.length;u<l;u++){var c=h[u],d=c._color,f=d.getAlpha();i={offset:c._offset||u/(l-1)},d&&(i["stop-color"]=d.toCSS(!0)),f<1&&(i["stop-opacity"]=f),e.appendChild(et.create("stop",i,S))}m(t,e,"color")}return"url(#"+e.id+")"}function f(e){var i=et.create("text",t(e._matrix,!0),S);return i.textContent=e._content,i}function _(t,e,i){var n={},s=!i&&t.getParent(),a=[];return null!=t._name&&(n.id=t._name),r.each(it,function(e){var i=e.get,o=e.type,h=t[i]();if(e.exportFilter?e.exportFilter(t,h):!s||!r.equals(s[i](),h)){if("color"===o&&null!=h){var u=h.getAlpha();u<1&&(n[e.attribute+"-opacity"]=u)}"style"===o?a.push(e.attribute+": "+h):n[e.attribute]=null==h?"none":"color"===o?h.gradient?d(h,t):h.toCSS(!0):"array"===o?h.join(","):"lookup"===o?e.toSVG[h]:h}}),a.length&&(n.style=a.join(";")),1===n.opacity&&delete n.opacity,t._visible||(n.visibility="hidden"),et.set(e,n,S)}function v(t,e){P||(P={ids:{},svgs:{}});var i=t._id||t.__id||(t.__id=l.get("svg"));return t&&P.svgs[e+"-"+i]}function m(t,e,i){P||v();var n=P.ids[i]=(P.ids[i]||0)+1;e.id=i+"-"+n,P.svgs[i+"-"+(t._id||t.__id)]=e}function x(t,e){var n=t,r=null;if(P){n="svg"===t.nodeName.toLowerCase()&&t;for(var s in P.svgs)r||(n||(n=et.create("svg"),n.appendChild(t)),r=n.insertBefore(et.create("defs"),n.firstChild)),r.appendChild(P.svgs[s]);P=null}return e.asString?(new i.XMLSerializer).serializeToString(n):n}function b(t,e,i){var n=I[t._class],r=n&&n(t,e);if(r){var s=e.onExport;s&&(r=s(t,r,e)||r);var a=JSON.stringify(t._data);a&&"{}"!==a&&"null"!==a&&r.setAttribute("data-paper-data",a)}return r&&_(t,r,i)}function C(t){return t||(t={}),S=new h(t.precision),t}var S,P,I={Group:e,Layer:e,Raster:n,Path:s,Shape:a,CompoundPath:o,SymbolItem:c,PointText:f};w.inject({exportSVG:function(t){return t=C(t),x(b(this,t,!0),t)}}),y.inject({exportSVG:function(e){e=C(e);var i=this._children,n=this.getView(),s=r.pick(e.bounds,"view"),a=e.matrix||"view"===s&&n._matrix,o=a&&p.read([a]),h="view"===s?new g([0,0],n.getViewSize()):"content"===s?w._getBounds(i,o,{stroke:!0}):g.read([s],0,{readNull:!0}),u={version:"1.1",xmlns:et.svg,"xmlns:xlink":et.xlink};h&&(u.width=h.width,u.height=h.height,(h.x||h.y)&&(u.viewBox=S.rectangle(h)));var l=et.create("svg",u,S),c=l;o&&!o.isIdentity()&&(c=l.appendChild(et.create("g",t(o),S)));for(var d=0,f=i.length;d<f;d++)c.appendChild(b(i[d],e,!0));return x(l,e)}})},new function(){function t(t,e,i,n,r){var s=et.get(t,e),a=null==s?n?null:i?"":0:i?s:parseFloat(s);return/%\s*$/.test(s)?a/100*(r?1:k[/x|^width/.test(e)?"width":"height"]):a}function s(e,i,n,r,s){return i=t(e,i||"x",!1,r,s),n=t(e,n||"y",!1,r,s),!r||null!=i&&null!=n?new c(i,n):null}function a(e,i,n,r,s){return i=t(e,i||"width",!1,r,s),n=t(e,n||"height",!1,r,s),!r||null!=i&&null!=n?new f(i,n):null}function o(t,e,i){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?P(t)||t:"lookup"===e?i[t]:t}function h(t,e,i,n){var r=t.childNodes,s="clippath"===e,a="defs"===e,o=new x,h=o._project,u=h._currentStyle,l=[];if(s||a||(o=b(o,t,n),h._currentStyle=o._style.clone()),n)for(var c=t.querySelectorAll("defs"),d=0,f=c.length;d<f;d++)M(c[d],i,!1);for(var d=0,f=r.length;d<f;d++){var _,g=r[d];1!==g.nodeType||/^defs$/i.test(g.nodeName)||!(_=M(g,i,!1))||_ instanceof I||l.push(_)}return o.addChildren(l),s&&(o=b(o.reduce(),t,n)),h._currentStyle=u,(s||a)&&(o.remove(),o=null),o}function u(t,e){for(var i=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),n=[],r=0,s=i.length;r<s;r+=2)n.push(new c(parseFloat(i[r]),parseFloat(i[r+1])));var a=new L(n);return"polygon"===e&&a.closePath(),a}function l(t){return A.create(t.getAttribute("d"))}function d(e,i){var n,r=(t(e,"href",!0)||"").substring(1),a="radialgradient"===i;if(r)n=z[r].getGradient(),n._radial^a&&(n=n.clone(),n._radial=a);else{for(var o=e.childNodes,h=[],u=0,l=o.length;u<l;u++){var c=o[u];1===c.nodeType&&h.push(b(new q,c))}n=new R(h,a)}var d,f,_,g="userSpaceOnUse"!==t(e,"gradientUnits",!0);a?(d=s(e,"cx","cy",!1,g),f=d.add(t(e,"r",!1,!1,g),0),_=s(e,"fx","fy",!0,g)):(d=s(e,"x1","y1",!1,g),f=s(e,"x2","y2",!1,g));var v=b(new F(n,d,f,_),e);return v._scaleToBounds=g,null}function _(t,e,i,n){if(t.transform){for(var r=(n.getAttribute(i)||"").split(/\)\s*/g),s=new p,a=0,o=r.length;a<o;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),l=u[0],c=u[1].split(/[\s,]+/g),d=0,f=c.length;d<f;d++)c[d]=parseFloat(c[d]);switch(l){case"matrix":s.append(new p(c[0],c[1],c[2],c[3],c[4],c[5]));break;case"rotate":s.rotate(c[0],c[1],c[2]);break;case"translate":s.translate(c[0],c[1]);break;case"scale":s.scale(c);break;case"skewX":s.skew(c[0],0);break;case"skewY":s.skew(0,c[0])}}t.transform(s)}}function v(t,e,i){var n="fill-opacity"===i?"getFillColor":"getStrokeColor",r=t[n]&&t[n]();r&&r.setAlpha(parseFloat(e))}function m(t,i,n){var s=t.attributes[i],a=s&&s.value;if(!a){var o=r.camelize(i);a=t.style[o],a||n.node[o]===n.parent[o]||(a=n.node[o])}return a?"none"===a?null:a:e}function b(t,i,n){var s=i.parentNode,a={node:H.getStyles(i)||{},parent:!n&&!/^defs$/i.test(s.tagName)&&H.getStyles(s)||{}};return r.each(N,function(n,r){var s=m(i,r,a);t=s!==e&&n(t,s,r,i,a)||t;
}),t}function P(t){var e=t&&t.match(/\((?:["'#]*)([^"')]+)/),n=e&&z[e[1].replace(i.location.href.split("#")[0]+"#","")];return n&&n._scaleToBounds&&(n=n.clone(),n._scaleToBounds=!0),n}function M(t,e,i){var s,o,h,u=t.nodeName.toLowerCase(),l="#document"!==u,c=n.body;i&&l&&(k=a(t,null,null,!0)||paper.getView().getSize(),s=et.create("svg",{style:"stroke-width: 1px; stroke-miterlimit: 10"}),o=t.parentNode,h=t.nextSibling,s.appendChild(t),c.appendChild(s));var d=paper.settings,f=d.applyMatrix,_=d.insertItems;d.applyMatrix=!1,d.insertItems=!1;var g=O[u],v=g&&g(t,u,e,i)||null;if(d.insertItems=_,d.applyMatrix=f,v){!l||v instanceof x||(v=b(v,t,i));var p=e.onImport,m=l&&t.getAttribute("data-paper-data");p&&(v=p(t,v,e)||v),e.expandShapes&&v instanceof C&&(v.remove(),v=v.toPath()),m&&(v._data=JSON.parse(m))}return s&&(c.removeChild(s),o&&(h?o.insertBefore(t,h):o.appendChild(t))),i&&(z={},v&&r.pick(e.applyMatrix,f)&&v.matrix.apply(!0,!0)),v}function T(t,r,s){function a(n){try{var a="object"==typeof n?n:(new i.DOMParser).parseFromString(n,"image/svg+xml");if(!a.nodeName)throw a=null,new Error("Unsupported SVG source: "+t);paper=h,u=M(a,r,!0),r&&r.insert===!1||s._insertItem(e,u);var l=r.onLoad;l&&l(u,n)}catch(c){o(c)}}function o(t,e){var i=r.onError;if(!i)throw new Error(t);i(t,e)}if(!t)return null;r="function"==typeof r?{onLoad:r}:r||{};var h=paper,u=null;if("string"!=typeof t||/^.*</.test(t)){if("undefined"!=typeof File&&t instanceof File){var l=new FileReader;return l.onload=function(){a(l.result)},l.onerror=function(){o(l.error)},l.readAsText(t)}a(t)}else{var c=n.getElementById(t);c?a(c):K.request({url:t,async:!0,onLoad:a,onError:o})}return u}var k,z={},O={"#document":function(t,e,i,n){for(var r=t.childNodes,s=0,a=r.length;s<a;s++){var o=r[s];if(1===o.nodeType)return M(o,i,n)}},g:h,svg:h,clippath:h,polygon:u,polyline:u,path:l,lineargradient:d,radialgradient:d,image:function(e){var i=new S(t(e,"href",!0));return i.on("load",function(){var t=a(e);this.setSize(t);var i=this._matrix._transformPoint(s(e).add(t.divide(2)));this.translate(i)}),i},symbol:function(t,e,i,n){return new I(h(t,e,i,n),(!0))},defs:h,use:function(e){var i=(t(e,"href",!0)||"").substring(1),n=z[i],r=s(e);return n?n instanceof I?n.place(r):n.clone().translate(r):null},circle:function(e){return new C.Circle(s(e,"cx","cy"),t(e,"r"))},ellipse:function(t){return new C.Ellipse({center:s(t,"cx","cy"),radius:a(t,"rx","ry")})},rect:function(t){return new C.Rectangle(new g(s(t),a(t)),a(t,"rx","ry"))},line:function(t){return new L.Line(s(t,"x1","y1"),s(t,"x2","y2"))},text:function(t){var e=new j(s(t).add(s(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e}},N=r.set(r.each(it,function(t){this[t.attribute]=function(e,i){if(e[t.set]&&(e[t.set](o(i,t.type,t.fromSVG)),"color"===t.type)){var n=e[t.get]();if(n){if(n._scaleToBounds){var r=e.getBounds();n.transform((new p).translate(r.getPoint()).scale(r.getSize()))}e instanceof C&&n.transform((new p).translate(e.getPosition(!0).negate()))}}}},{}),{id:function(t,e){z[e]=t,t.setName&&t.setName(e)},"clip-path":function(t,e){var i=P(e);if(i){if(i=i.clone(),i.setClipMask(!0),!(t instanceof x))return new x(i,t);t.insertChild(0,i)}},gradientTransform:_,transform:_,"fill-opacity":v,"stroke-opacity":v,visibility:function(t,e){t.setVisible&&t.setVisible("visible"===e)},display:function(t,e){t.setVisible&&t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){if(t.setOffset){var i=e.match(/(.*)%$/);t.setOffset(i?i[1]/100:parseFloat(e))}},viewBox:function(t,e,i,n,r){var s,h,u=new g(o(e,"array")),l=a(n,null,null,!0);if(t instanceof x){var c=l?l.divide(u.getSize()):1,h=(new p).scale(c).translate(u.getPoint().negate());s=t}else t instanceof I&&(l&&u.setSize(l),s=t._item);if(s){if("visible"!==m(n,"overflow",r)){var d=new C.Rectangle(u);d.setClipMask(!0),s.addChild(d)}h&&s.transform(h)}}});w.inject({importSVG:function(t,e){return T(t,e,this)}}),y.inject({importSVG:function(t,e){return this.activate(),T(t,e,this)}})},paper=new(a.inject(r.exports,{enumerable:!0,Base:r,Numerical:u,Key:X,DomEvent:Z,DomElement:H,document:n,window:i,Symbol:I,PlacedSymbol:P})),paper.agent.node&&require("./node/extend")(paper),"function"==typeof define&&define.amd?define("paper",paper):"object"==typeof module&&module&&(module.exports=paper),paper}.call(this,"object"==typeof self?self:null);